/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.lm.app.DBPApplicationLicensed;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.update.VersionUpdateDialog;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMProductRelease;
import org.osgi.framework.Version;

public class EnterpriseVersionUpdateDialog
extends VersionUpdateDialog {
    private static final Log log = Log.getLog(EnterpriseVersionUpdateDialog.class);

    public EnterpriseVersionUpdateDialog(Shell parentShell, @NotNull Version currentVersion, @NotNull VersionDescriptor newVersion, boolean autoCheck) {
        super(parentShell, currentVersion, newVersion, autoCheck);
    }

    protected void createBottomArea(Composite composite) {
        String buyURL;
        VersionDescriptor newVersionDescriptor = this.getNewVersion();
        boolean hasValidLicense = false;
        DBPApplicationLicensed licensedApplication = DBPApplicationLicensed.getLicensedApplication();
        LMProduct product = licensedApplication.getLicenseProduct();
        LMProductRelease newRelease = new LMProductRelease(product.getId(), newVersionDescriptor.getPlainVersion(), newVersionDescriptor.getVersionReleaseTimestamp(), null);
        try {
            LMLicense[] licenses;
            LMLicense[] lMLicenseArray = licenses = licensedApplication.getLicenseService().getAllProductLicenses();
            int n = licenses.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    LMLicense license = lMLicenseArray[n2];
                    try {
                        if (!license.isValidFor(product, newRelease, true)) break block7;
                        hasValidLicense = true;
                        break;
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                ++n2;
            }
        }
        catch (LMException e) {
            log.error((Object)e);
        }
        String licenseInfo = hasValidLicense ? "Your current license is valid for version " + newVersionDescriptor.getPlainVersion() : "Your license won't work in " + product.getName() + " " + newVersionDescriptor.getPlainVersion() + ".\nIf you want to upgrade version you will need to upgrade your license as well.";
        Group propGroup = UIUtils.createControlGroup((Composite)composite, (String)"License", (int)1, (int)1808, (int)0);
        Label licenseInfoLabel = new Label((Composite)propGroup, 0);
        if (!hasValidLicense) {
            licenseInfoLabel.setFont(this.getBoldFont());
            licenseInfoLabel.setForeground(JFaceColors.getErrorText((Display)licenseInfoLabel.getDisplay()));
        }
        licenseInfoLabel.setText(licenseInfo);
        licenseInfoLabel.setLayoutData((Object)new GridData(1808));
        if (!hasValidLicense && (buyURL = Platform.getProduct().getProperty("productPurchaseURL")) != null) {
            Link buyLink = new Link((Composite)propGroup, 0);
            buyLink.setText("<a>Purchase license ...</a>");
            buyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.openWebBrowser((String)buyURL);
                }
            });
            buyLink.setLayoutData((Object)new GridData(896));
        }
    }
}

