/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.ui.views;

import com.dbeaver.db.redshift.RedshiftConstants;
import com.dbeaver.db.redshift.auth.RedshiftAuthFSPlugin;
import com.dbeaver.net.auth.aws.AWSAuthType;
import com.dbeaver.ui.auth.aws.AuthModelAWSConfigurator;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class AuthModelAWSRedshiftConfigurator
extends AuthModelAWSConfigurator {
    private static final Log log = Log.getLog(AuthModelAWSRedshiftConfigurator.class);
    private Label fsPluginNameLabel;
    private Combo fsPluginNameCombo;
    private Control fsPluginFiller;
    private Label fsIdpTenantLabel;
    private Text fsIdpTenantText;
    private Control fsIdpTenantFiller;
    private Label fsClientIdLabel;
    private Text fsClientIdText;
    private Control fsClientIdFiller;
    private Label fsClientSecretLabel;
    private Text fsClientSecretText;
    private Control fsClientSecretFiller;
    private Label fsIdpHostLabel;
    private Text fsIdpHostText;
    private Label fsIdpPortLabel;
    private Text fsIdpPortText;
    private Label fsIdpPreferredRoleLabel;
    private Text fsIdpPreferredRoleText;
    private Control fsIdpPreferredRoleFiller;
    private Label fsIdpAppIdLabel;
    private Text fsIdpAppIdText;
    private Control fsIdpAppIdFiller;

    protected AWSAuthType[] getSupportedAuthTypes() {
        return new AWSAuthType[]{AWSAuthType.DEFAULT, AWSAuthType.PROFILE, AWSAuthType.KEY, RedshiftConstants.AUTH_TYPE_FS_PLUGIN};
    }

    protected boolean isPasswordApplicable() {
        if (this.curConfigType == RedshiftConstants.AUTH_TYPE_FS_PLUGIN) {
            RedshiftAuthFSPlugin selectedPlugin = this.getSelectedPlugin();
            return selectedPlugin != null && selectedPlugin.needsCredentials();
        }
        return false;
    }

    protected boolean isSavePasswordLocally() {
        RedshiftAuthFSPlugin selectedPlugin;
        if (this.curConfigType == RedshiftConstants.AUTH_TYPE_FS_PLUGIN && (selectedPlugin = this.getSelectedPlugin()) != null && !selectedPlugin.needsCredentials() && selectedPlugin.supportsCredentials()) {
            return false;
        }
        return super.isSavePasswordLocally();
    }

    protected void createExtraIAMAuthSelectors(Composite iamGroup, final Runnable propertyChangeListener, boolean isWide) {
        this.fsPluginNameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)"FS Plugin");
        this.fsPluginNameCombo = new Combo(iamGroup, 12);
        GridData gd = new GridData(32);
        this.fsPluginNameCombo.setLayoutData((Object)gd);
        this.fsPluginNameCombo.setToolTipText("AWS federated service plugin");
        RedshiftAuthFSPlugin[] redshiftAuthFSPluginArray = RedshiftAuthFSPlugin.values();
        int n = redshiftAuthFSPluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            RedshiftAuthFSPlugin plugin = redshiftAuthFSPluginArray[n2];
            this.fsPluginNameCombo.add(plugin.getTitle());
            ++n2;
        }
        SelectionAdapter selChangelistener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyChangeListener.run();
                AuthModelAWSRedshiftConfigurator.this.updateIAMSettingsVisibility();
            }
        };
        this.fsPluginNameCombo.addSelectionListener((SelectionListener)selChangelistener);
        if (isWide) {
            this.fsPluginFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
    }

    private RedshiftAuthFSPlugin getSelectedPlugin() {
        int pIndex = this.fsPluginNameCombo.getSelectionIndex();
        if (pIndex < 0) {
            return null;
        }
        return (RedshiftAuthFSPlugin)CommonUtils.fromOrdinal(RedshiftAuthFSPlugin.class, (int)pIndex);
    }

    protected void createExtraIAMAuthControls(Composite iamGroup, Runnable propertyChangeListener, boolean isWide) {
        this.fsIdpTenantLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)"Tenant ID");
        this.fsIdpTenantText = new Text(iamGroup, 2048);
        this.fsIdpTenantText.setLayoutData((Object)new GridData(768));
        if (isWide) {
            this.fsIdpTenantFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
        this.fsClientIdLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)"Client ID");
        this.fsClientIdText = new Text(iamGroup, 2048);
        this.fsClientIdText.setLayoutData((Object)new GridData(768));
        if (isWide) {
            this.fsClientIdFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
        this.fsClientSecretLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)"Client Secret");
        this.fsClientSecretText = new Text(iamGroup, 0x400800);
        this.fsClientSecretText.setLayoutData((Object)new GridData(768));
        if (isWide) {
            this.fsClientSecretFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
        this.fsIdpHostLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)"IDP Host");
        this.fsIdpHostText = new Text(iamGroup, 2048);
        this.fsIdpHostText.setLayoutData((Object)new GridData(768));
        this.fsIdpPortLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)"IDP Port");
        this.fsIdpPortText = new Text(iamGroup, 2048);
        this.fsIdpPortText.setLayoutData((Object)new GridData(768));
        this.fsIdpPortText.setText(String.valueOf(443));
        this.fsIdpPreferredRoleLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)"Preferred Role");
        this.fsIdpPreferredRoleText = new Text(iamGroup, 2048);
        this.fsIdpPreferredRoleText.setLayoutData((Object)new GridData(768));
        if (isWide) {
            this.fsIdpPreferredRoleFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
        this.fsIdpAppIdLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)"Application");
        this.fsIdpAppIdText = new Text(iamGroup, 2048);
        this.fsIdpAppIdText.setLayoutData((Object)new GridData(768));
        if (isWide) {
            this.fsIdpAppIdFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
    }

    protected void updateExtraIAMSettingsVisibility() {
        boolean pluginVisible = !this.isCloudProvided && this.curConfigType == RedshiftConstants.AUTH_TYPE_FS_PLUGIN;
        UIUtils.setControlVisible((Control)this.fsPluginNameLabel, (boolean)pluginVisible);
        UIUtils.setControlVisible((Control)this.fsPluginNameCombo, (boolean)pluginVisible);
        if (this.fsPluginFiller != null) {
            UIUtils.setControlVisible((Control)this.fsPluginFiller, (boolean)pluginVisible);
        }
        RedshiftAuthFSPlugin selectedPlugin = null;
        if (pluginVisible) {
            selectedPlugin = this.getSelectedPlugin();
        }
        boolean tennantVisible = selectedPlugin != null && selectedPlugin.supportsProperty("idp_tenant");
        UIUtils.setControlVisible((Control)this.fsIdpTenantLabel, (boolean)tennantVisible);
        UIUtils.setControlVisible((Control)this.fsIdpTenantText, (boolean)tennantVisible);
        if (this.fsIdpTenantFiller != null) {
            UIUtils.setControlVisible((Control)this.fsIdpTenantFiller, (boolean)tennantVisible);
        }
        boolean clientIdVisible = selectedPlugin != null && selectedPlugin.supportsProperty("client_id");
        UIUtils.setControlVisible((Control)this.fsClientIdLabel, (boolean)clientIdVisible);
        UIUtils.setControlVisible((Control)this.fsClientIdText, (boolean)clientIdVisible);
        if (this.fsClientIdFiller != null) {
            UIUtils.setControlVisible((Control)this.fsClientIdFiller, (boolean)clientIdVisible);
        }
        boolean clientSecretVisible = selectedPlugin != null && selectedPlugin.supportsProperty("client_secret");
        UIUtils.setControlVisible((Control)this.fsClientSecretLabel, (boolean)clientSecretVisible);
        UIUtils.setControlVisible((Control)this.fsClientSecretText, (boolean)clientSecretVisible);
        if (this.fsClientSecretFiller != null) {
            UIUtils.setControlVisible((Control)this.fsClientSecretFiller, (boolean)clientSecretVisible);
        }
        boolean idpHostVisible = selectedPlugin != null && selectedPlugin.supportsProperty("idp_host");
        UIUtils.setControlVisible((Control)this.fsIdpHostLabel, (boolean)idpHostVisible);
        UIUtils.setControlVisible((Control)this.fsIdpHostText, (boolean)idpHostVisible);
        boolean idpPortVisible = selectedPlugin != null && selectedPlugin.supportsProperty("idp_port");
        UIUtils.setControlVisible((Control)this.fsIdpPortLabel, (boolean)idpPortVisible);
        UIUtils.setControlVisible((Control)this.fsIdpPortText, (boolean)idpPortVisible);
        boolean prefRoleVisible = selectedPlugin != null && selectedPlugin.supportsProperty("preferred_role");
        UIUtils.setControlVisible((Control)this.fsIdpPreferredRoleLabel, (boolean)prefRoleVisible);
        UIUtils.setControlVisible((Control)this.fsIdpPreferredRoleText, (boolean)prefRoleVisible);
        if (this.fsIdpPreferredRoleFiller != null) {
            UIUtils.setControlVisible((Control)this.fsIdpPreferredRoleFiller, (boolean)prefRoleVisible);
        }
        boolean appIdVisible = selectedPlugin != null && selectedPlugin.supportsProperty("app_id");
        UIUtils.setControlVisible((Control)this.fsIdpAppIdLabel, (boolean)appIdVisible);
        UIUtils.setControlVisible((Control)this.fsIdpAppIdText, (boolean)appIdVisible);
        if (this.fsIdpAppIdFiller != null) {
            UIUtils.setControlVisible((Control)this.fsIdpAppIdFiller, (boolean)appIdVisible);
        }
    }

    public void loadIAMAuthSettings(Map<String, String> authProperties) {
        super.loadIAMAuthSettings(authProperties);
        String pluginId = CommonUtils.toString((Object)authProperties.get("redshift.fs_plugin_name"));
        if (!CommonUtils.isEmpty((String)pluginId)) {
            this.curConfigType = RedshiftConstants.AUTH_TYPE_FS_PLUGIN;
            RedshiftAuthFSPlugin rap = RedshiftAuthFSPlugin.getById((String)pluginId);
            if (rap == null) {
                log.error((Object)("Invalid Redshift authentication plugin '" + pluginId + "'"));
            } else {
                this.fsPluginNameCombo.setText(rap.getTitle());
            }
            this.fsIdpTenantText.setText(CommonUtils.toString((Object)authProperties.get("idp_tenant")));
            this.fsClientIdText.setText(CommonUtils.toString((Object)authProperties.get("client_id")));
            this.fsClientSecretText.setText(CommonUtils.toString((Object)authProperties.get("client_secret")));
            this.fsIdpHostText.setText(CommonUtils.toString((Object)authProperties.get("idp_host")));
            this.fsIdpPortText.setText(CommonUtils.toString((Object)authProperties.get("idp_port"), (String)String.valueOf(443)));
            this.fsIdpPreferredRoleText.setText(CommonUtils.toString((Object)authProperties.get("preferred_role")));
            this.fsIdpAppIdText.setText(CommonUtils.toString((Object)authProperties.get("app_id")));
        }
    }

    public void saveIAMAuthSettings(Map<String, String> props) {
        super.saveIAMAuthSettings(props);
        if (this.curConfigType == RedshiftConstants.AUTH_TYPE_FS_PLUGIN) {
            RedshiftAuthFSPlugin selectedPlugin = this.getSelectedPlugin();
            if (selectedPlugin != null) {
                props.put("redshift.fs_plugin_name", selectedPlugin.getId());
            }
            props.put("idp_tenant", this.fsIdpTenantText.getText());
            props.put("client_id", this.fsClientIdText.getText());
            props.put("client_secret", this.fsClientSecretText.getText());
            props.put("idp_host", this.fsIdpHostText.getText());
            props.put("idp_port", this.fsIdpPortText.getText());
            props.put("preferred_role", this.fsIdpPreferredRoleText.getText());
            props.put("app_id", this.fsIdpAppIdText.getText());
        } else {
            props.remove("redshift.fs_plugin_name");
            props.remove("idp_tenant");
            props.remove("client_id");
            props.remove("client_secret");
        }
    }

    public boolean isComplete() {
        if (this.curConfigType == RedshiftConstants.AUTH_TYPE_FS_PLUGIN) {
            return this.fsPluginNameCombo.getSelectionIndex() >= 0;
        }
        return super.isComplete();
    }
}

