/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.couchbase.client.java.manager.user.Role;
import com.couchbase.client.java.manager.user.User;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CouchbaseUser
implements DBAUser {
    private static final Log log = Log.getLog(CouchbaseUser.class);
    private final CouchbaseDataSource dataSource;
    private final User user;

    public CouchbaseUser(CouchbaseDataSource dataSource, User user) {
        this.dataSource = dataSource;
        this.user = user;
    }

    @NotNull
    public CouchbaseDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.user.displayName();
    }

    @Property(viewable=true, editable=true, order=2)
    public String getUserId() {
        return this.user.username();
    }

    @Property(viewable=true, editable=true, order=3)
    public Set<String> getGroups() {
        return this.user.groups();
    }

    @Property(viewable=true, editable=true, order=4)
    public List<String> getRoles() {
        ArrayList<String> roleList = new ArrayList<String>();
        for (Role role : this.user.roles()) {
            if (role.bucket().isEmpty()) {
                roleList.add(role.name());
                continue;
            }
            roleList.add(String.valueOf(role.name()) + "@" + role.bucket());
        }
        return roleList;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return true;
    }
}

