/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.exec;

import com.couchbase.client.core.error.IndexFailureException;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.query.QueryResult;
import com.dbeaver.db.couchbase3.exec.CouchbaseAbstractStatement;
import com.dbeaver.db.couchbase3.exec.CouchbaseResultSet;
import com.dbeaver.db.couchbase3.exec.CouchbaseSession;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class CouchbaseQueryStatement
extends CouchbaseAbstractStatement {
    private static final Log log = Log.getLog(CouchbaseQueryStatement.class);
    private final Cluster cluster;
    private final String queryText;
    private long offset;
    private long limit;
    private CouchbaseResultSet resultSet;

    public CouchbaseQueryStatement(CouchbaseSession session, Cluster cluster, String queryText) {
        super(session);
        this.cluster = cluster;
        this.queryText = queryText;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public String getQueryString() {
        return this.queryText;
    }

    public boolean executeStatement() throws DBCException {
        if (((CouchbaseSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        Exception executeError = null;
        try {
            QueryResult query = this.cluster.query(this.queryText);
            this.resultSet = new CouchbaseResultSet(this, query, this.getLimit());
            return true;
        }
        catch (IndexFailureException e) {
            log.warn((Object)e);
            return false;
        }
        catch (Exception e) {
            executeError = e;
            throw new DBCException(GeneralUtils.getRootCause((Throwable)e), (DBCExecutionContext)((CouchbaseSession)this.getSession()).getExecutionContext());
        }
        finally {
            if (((CouchbaseSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), (Throwable)executeError);
            }
        }
    }

    public void addToBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public CouchbaseResultSet openResultSet() throws DBCException {
        return this.resultSet;
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public long getUpdateRowCount() {
        return -1L;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
        if (((CouchbaseSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread != null) {
            blockThread.interrupt();
        } else if (this.cluster != null) {
            this.cluster.disconnect();
        }
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public String getEntityName() {
        return this.cluster.diagnostics().id();
    }
}

