/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.utils.IOUtils;

public class StaticTLSUtils {
    private static final Log log = Log.getLog(StaticTLSUtils.class);

    public static Path getStaticCertFile(DBRProgressMonitor monitor, Class<?> bundleClass, String localCacheFolder, String remoteURL) {
        Path caCertFile;
        URL url;
        Path caCertFolder = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(localCacheFolder);
        if (!Files.exists(caCertFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(caCertFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.warn((Object)("Can't create local cache folder '" + caCertFolder.toAbsolutePath() + "'"), (Throwable)e);
                return null;
            }
        }
        try {
            url = new URL(remoteURL);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Invalid remote TLS URL", (Throwable)e);
            return null;
        }
        String remoteFileName = url.getFile();
        int divPos = remoteFileName.lastIndexOf("/");
        if (divPos != -1) {
            remoteFileName = remoteFileName.substring(divPos + 1);
        }
        if (!Files.exists(caCertFile = caCertFolder.resolve(remoteFileName), new LinkOption[0])) {
            try {
                WebUtils.downloadRemoteFile((DBRProgressMonitor)monitor, (String)"Download remote TLS certificate", (String)remoteURL, (Path)caCertFile, null);
            }
            catch (Exception e) {
                log.warn((Object)"Error downloading remote TLS certificate", (Throwable)e);
            }
        }
        if (!Files.exists(caCertFile, new LinkOption[0])) {
            try {
                Throwable e = null;
                Object var10_15 = null;
                try (OutputStream certStream = Files.newOutputStream(caCertFile, new OpenOption[0]);){
                    IOUtils.copyStream((InputStream)bundleClass.getClassLoader().getResourceAsStream("tls/" + remoteFileName), (OutputStream)certStream);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error extracting SSL CA certificate", (Throwable)e);
                return null;
            }
        }
        return caCertFile;
    }
}

