/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.secret;

import com.dbeaver.model.secret.DBSSecretControllerAuthorized;
import com.dbeaver.model.secret.SecretControllerDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.secret.DBSSecretController;

public class SecretControllerRegistry {
    public static final String EXTENSION_ID = "com.dbeaver.secretController";
    private static SecretControllerRegistry instance = null;
    private Map<String, SecretControllerDescriptor> secretControllers = new LinkedHashMap<String, SecretControllerDescriptor>();

    public static synchronized SecretControllerRegistry getInstance() {
        if (instance == null) {
            instance = new SecretControllerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SecretControllerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("controller".equals(ext.getName())) {
                SecretControllerDescriptor sc = new SecretControllerDescriptor(ext);
                this.secretControllers.put(sc.getId(), sc);
            }
            ++n2;
        }
    }

    public DBSSecretController getAuthorizedSecretController(String id, SMCredentialsProvider credentialsProvider) throws DBException {
        SecretControllerDescriptor descriptor = this.getSecretController(id);
        if (descriptor == null) {
            throw new DBException("Secret controller '" + id + "' not found");
        }
        DBSSecretControllerAuthorized instance = descriptor.createInstance(DBSSecretControllerAuthorized.class);
        instance.authorize(credentialsProvider);
        return instance;
    }

    SecretControllerDescriptor getSecretController(String id) {
        return this.secretControllers.get(id);
    }
}

