/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.spanner.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.spanner.v1.SpannerRequest;
import com.google.api.services.spanner.v1.SpannerRequestInitializer;
import com.google.api.services.spanner.v1.model.Backup;
import com.google.api.services.spanner.v1.model.BatchCreateSessionsRequest;
import com.google.api.services.spanner.v1.model.BatchCreateSessionsResponse;
import com.google.api.services.spanner.v1.model.BeginTransactionRequest;
import com.google.api.services.spanner.v1.model.CommitRequest;
import com.google.api.services.spanner.v1.model.CommitResponse;
import com.google.api.services.spanner.v1.model.CreateDatabaseRequest;
import com.google.api.services.spanner.v1.model.CreateInstanceRequest;
import com.google.api.services.spanner.v1.model.CreateSessionRequest;
import com.google.api.services.spanner.v1.model.Database;
import com.google.api.services.spanner.v1.model.Empty;
import com.google.api.services.spanner.v1.model.ExecuteBatchDmlRequest;
import com.google.api.services.spanner.v1.model.ExecuteBatchDmlResponse;
import com.google.api.services.spanner.v1.model.ExecuteSqlRequest;
import com.google.api.services.spanner.v1.model.GetDatabaseDdlResponse;
import com.google.api.services.spanner.v1.model.GetIamPolicyRequest;
import com.google.api.services.spanner.v1.model.Instance;
import com.google.api.services.spanner.v1.model.InstanceConfig;
import com.google.api.services.spanner.v1.model.ListBackupOperationsResponse;
import com.google.api.services.spanner.v1.model.ListBackupsResponse;
import com.google.api.services.spanner.v1.model.ListDatabaseOperationsResponse;
import com.google.api.services.spanner.v1.model.ListDatabasesResponse;
import com.google.api.services.spanner.v1.model.ListInstanceConfigsResponse;
import com.google.api.services.spanner.v1.model.ListInstancesResponse;
import com.google.api.services.spanner.v1.model.ListOperationsResponse;
import com.google.api.services.spanner.v1.model.ListScansResponse;
import com.google.api.services.spanner.v1.model.ListSessionsResponse;
import com.google.api.services.spanner.v1.model.Operation;
import com.google.api.services.spanner.v1.model.PartialResultSet;
import com.google.api.services.spanner.v1.model.PartitionQueryRequest;
import com.google.api.services.spanner.v1.model.PartitionReadRequest;
import com.google.api.services.spanner.v1.model.PartitionResponse;
import com.google.api.services.spanner.v1.model.Policy;
import com.google.api.services.spanner.v1.model.ReadRequest;
import com.google.api.services.spanner.v1.model.RestoreDatabaseRequest;
import com.google.api.services.spanner.v1.model.ResultSet;
import com.google.api.services.spanner.v1.model.RollbackRequest;
import com.google.api.services.spanner.v1.model.Scan;
import com.google.api.services.spanner.v1.model.Session;
import com.google.api.services.spanner.v1.model.SetIamPolicyRequest;
import com.google.api.services.spanner.v1.model.TestIamPermissionsRequest;
import com.google.api.services.spanner.v1.model.TestIamPermissionsResponse;
import com.google.api.services.spanner.v1.model.Transaction;
import com.google.api.services.spanner.v1.model.UpdateDatabaseDdlRequest;
import com.google.api.services.spanner.v1.model.UpdateInstanceRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class Spanner
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://spanner.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://spanner.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://spanner.googleapis.com/";

    public Spanner(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Spanner(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    public Scans scans() {
        return new Scans();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Cloud Spanner API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Spanner.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://spanner.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Spanner.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Spanner.DEFAULT_BATCH_PATH);
        }

        public Spanner build() {
            return new Spanner(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setSpannerRequestInitializer(SpannerRequestInitializer spannerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)spannerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Scans {
        public List list(String parent) throws IOException {
            List result = new List(parent);
            Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends SpannerRequest<ListScansResponse> {
            private static final String REST_PATH = "v1/{+parent}";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String view;

            protected List(String parent) {
                super(Spanner.this, "GET", REST_PATH, null, ListScansResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^scans$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Spanner.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^scans$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!Spanner.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^scans$");
                }
                this.parent = parent;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public InstanceConfigs instanceConfigs() {
            return new InstanceConfigs();
        }

        public Instances instances() {
            return new Instances();
        }

        public class Instances {
            public Create create(String parent, CreateInstanceRequest content) throws IOException {
                Create result = new Create(parent, content);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource, content);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, UpdateInstanceRequest content) throws IOException {
                Patch result = new Patch(name, content);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BackupOperations backupOperations() {
                return new BackupOperations();
            }

            public Backups backups() {
                return new Backups();
            }

            public DatabaseOperations databaseOperations() {
                return new DatabaseOperations();
            }

            public Databases databases() {
                return new Databases();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name) throws IOException {
                    Cancel result = new Cancel(name);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends SpannerRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(Spanner.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/operations$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/operations$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/operations$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends SpannerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Spanner.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends SpannerRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Spanner.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends SpannerRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name) {
                        super(Spanner.this, "POST", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Databases {
                public Create create(String parent, CreateDatabaseRequest content) throws IOException {
                    Create result = new Create(parent, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public DropDatabase dropDatabase(String database) throws IOException {
                    DropDatabase result = new DropDatabase(database);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetDdl getDdl(String database) throws IOException {
                    GetDdl result = new GetDdl(database);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetScans getScans(String name) throws IOException {
                    GetScans result = new GetScans(name);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Restore restore(String parent, RestoreDatabaseRequest content) throws IOException {
                    Restore result = new Restore(parent, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public UpdateDdl updateDdl(String database, UpdateDatabaseDdlRequest content) throws IOException {
                    UpdateDdl result = new UpdateDdl(database, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Operations operations() {
                    return new Operations();
                }

                public Sessions sessions() {
                    return new Sessions();
                }

                public class Sessions {
                    public BatchCreate batchCreate(String database, BatchCreateSessionsRequest content) throws IOException {
                        BatchCreate result = new BatchCreate(database, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public BeginTransaction beginTransaction(String session, BeginTransactionRequest content) throws IOException {
                        BeginTransaction result = new BeginTransaction(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Commit commit(String session, CommitRequest content) throws IOException {
                        Commit result = new Commit(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Create create(String database, CreateSessionRequest content) throws IOException {
                        Create result = new Create(database, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public ExecuteBatchDml executeBatchDml(String session, ExecuteBatchDmlRequest content) throws IOException {
                        ExecuteBatchDml result = new ExecuteBatchDml(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public ExecuteSql executeSql(String session, ExecuteSqlRequest content) throws IOException {
                        ExecuteSql result = new ExecuteSql(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public ExecuteStreamingSql executeStreamingSql(String session, ExecuteSqlRequest content) throws IOException {
                        ExecuteStreamingSql result = new ExecuteStreamingSql(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String database) throws IOException {
                        List result = new List(database);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public PartitionQuery partitionQuery(String session, PartitionQueryRequest content) throws IOException {
                        PartitionQuery result = new PartitionQuery(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public PartitionRead partitionRead(String session, PartitionReadRequest content) throws IOException {
                        PartitionRead result = new PartitionRead(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Read read(String session, ReadRequest content) throws IOException {
                        Read result = new Read(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Rollback rollback(String session, RollbackRequest content) throws IOException {
                        Rollback result = new Rollback(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public StreamingRead streamingRead(String session, ReadRequest content) throws IOException {
                        StreamingRead result = new StreamingRead(session, content);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class StreamingRead
                    extends SpannerRequest<PartialResultSet> {
                        private static final String REST_PATH = "v1/{+session}:streamingRead";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected StreamingRead(String session, ReadRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, PartialResultSet.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public StreamingRead set$Xgafv(String $Xgafv) {
                            return (StreamingRead)super.set$Xgafv($Xgafv);
                        }

                        public StreamingRead setAccessToken(String accessToken) {
                            return (StreamingRead)super.setAccessToken(accessToken);
                        }

                        public StreamingRead setAlt(String alt) {
                            return (StreamingRead)super.setAlt(alt);
                        }

                        public StreamingRead setCallback(String callback) {
                            return (StreamingRead)super.setCallback(callback);
                        }

                        public StreamingRead setFields(String fields) {
                            return (StreamingRead)super.setFields(fields);
                        }

                        public StreamingRead setKey(String key) {
                            return (StreamingRead)super.setKey(key);
                        }

                        public StreamingRead setOauthToken(String oauthToken) {
                            return (StreamingRead)super.setOauthToken(oauthToken);
                        }

                        public StreamingRead setPrettyPrint(Boolean prettyPrint) {
                            return (StreamingRead)super.setPrettyPrint(prettyPrint);
                        }

                        public StreamingRead setQuotaUser(String quotaUser) {
                            return (StreamingRead)super.setQuotaUser(quotaUser);
                        }

                        public StreamingRead setUploadType(String uploadType) {
                            return (StreamingRead)super.setUploadType(uploadType);
                        }

                        public StreamingRead setUploadProtocol(String uploadProtocol) {
                            return (StreamingRead)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public StreamingRead setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public StreamingRead set(String parameterName, Object value) {
                            return (StreamingRead)super.set(parameterName, value);
                        }
                    }

                    public class Rollback
                    extends SpannerRequest<Empty> {
                        private static final String REST_PATH = "v1/{+session}:rollback";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected Rollback(String session, RollbackRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, Empty.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public Rollback set$Xgafv(String $Xgafv) {
                            return (Rollback)super.set$Xgafv($Xgafv);
                        }

                        public Rollback setAccessToken(String accessToken) {
                            return (Rollback)super.setAccessToken(accessToken);
                        }

                        public Rollback setAlt(String alt) {
                            return (Rollback)super.setAlt(alt);
                        }

                        public Rollback setCallback(String callback) {
                            return (Rollback)super.setCallback(callback);
                        }

                        public Rollback setFields(String fields) {
                            return (Rollback)super.setFields(fields);
                        }

                        public Rollback setKey(String key) {
                            return (Rollback)super.setKey(key);
                        }

                        public Rollback setOauthToken(String oauthToken) {
                            return (Rollback)super.setOauthToken(oauthToken);
                        }

                        public Rollback setPrettyPrint(Boolean prettyPrint) {
                            return (Rollback)super.setPrettyPrint(prettyPrint);
                        }

                        public Rollback setQuotaUser(String quotaUser) {
                            return (Rollback)super.setQuotaUser(quotaUser);
                        }

                        public Rollback setUploadType(String uploadType) {
                            return (Rollback)super.setUploadType(uploadType);
                        }

                        public Rollback setUploadProtocol(String uploadProtocol) {
                            return (Rollback)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public Rollback setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public Rollback set(String parameterName, Object value) {
                            return (Rollback)super.set(parameterName, value);
                        }
                    }

                    public class Read
                    extends SpannerRequest<ResultSet> {
                        private static final String REST_PATH = "v1/{+session}:read";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected Read(String session, ReadRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, ResultSet.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public Read set$Xgafv(String $Xgafv) {
                            return (Read)super.set$Xgafv($Xgafv);
                        }

                        public Read setAccessToken(String accessToken) {
                            return (Read)super.setAccessToken(accessToken);
                        }

                        public Read setAlt(String alt) {
                            return (Read)super.setAlt(alt);
                        }

                        public Read setCallback(String callback) {
                            return (Read)super.setCallback(callback);
                        }

                        public Read setFields(String fields) {
                            return (Read)super.setFields(fields);
                        }

                        public Read setKey(String key) {
                            return (Read)super.setKey(key);
                        }

                        public Read setOauthToken(String oauthToken) {
                            return (Read)super.setOauthToken(oauthToken);
                        }

                        public Read setPrettyPrint(Boolean prettyPrint) {
                            return (Read)super.setPrettyPrint(prettyPrint);
                        }

                        public Read setQuotaUser(String quotaUser) {
                            return (Read)super.setQuotaUser(quotaUser);
                        }

                        public Read setUploadType(String uploadType) {
                            return (Read)super.setUploadType(uploadType);
                        }

                        public Read setUploadProtocol(String uploadProtocol) {
                            return (Read)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public Read setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public Read set(String parameterName, Object value) {
                            return (Read)super.set(parameterName, value);
                        }
                    }

                    public class PartitionRead
                    extends SpannerRequest<PartitionResponse> {
                        private static final String REST_PATH = "v1/{+session}:partitionRead";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected PartitionRead(String session, PartitionReadRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, PartitionResponse.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public PartitionRead set$Xgafv(String $Xgafv) {
                            return (PartitionRead)super.set$Xgafv($Xgafv);
                        }

                        public PartitionRead setAccessToken(String accessToken) {
                            return (PartitionRead)super.setAccessToken(accessToken);
                        }

                        public PartitionRead setAlt(String alt) {
                            return (PartitionRead)super.setAlt(alt);
                        }

                        public PartitionRead setCallback(String callback) {
                            return (PartitionRead)super.setCallback(callback);
                        }

                        public PartitionRead setFields(String fields) {
                            return (PartitionRead)super.setFields(fields);
                        }

                        public PartitionRead setKey(String key) {
                            return (PartitionRead)super.setKey(key);
                        }

                        public PartitionRead setOauthToken(String oauthToken) {
                            return (PartitionRead)super.setOauthToken(oauthToken);
                        }

                        public PartitionRead setPrettyPrint(Boolean prettyPrint) {
                            return (PartitionRead)super.setPrettyPrint(prettyPrint);
                        }

                        public PartitionRead setQuotaUser(String quotaUser) {
                            return (PartitionRead)super.setQuotaUser(quotaUser);
                        }

                        public PartitionRead setUploadType(String uploadType) {
                            return (PartitionRead)super.setUploadType(uploadType);
                        }

                        public PartitionRead setUploadProtocol(String uploadProtocol) {
                            return (PartitionRead)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public PartitionRead setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public PartitionRead set(String parameterName, Object value) {
                            return (PartitionRead)super.set(parameterName, value);
                        }
                    }

                    public class PartitionQuery
                    extends SpannerRequest<PartitionResponse> {
                        private static final String REST_PATH = "v1/{+session}:partitionQuery";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected PartitionQuery(String session, PartitionQueryRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, PartitionResponse.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public PartitionQuery set$Xgafv(String $Xgafv) {
                            return (PartitionQuery)super.set$Xgafv($Xgafv);
                        }

                        public PartitionQuery setAccessToken(String accessToken) {
                            return (PartitionQuery)super.setAccessToken(accessToken);
                        }

                        public PartitionQuery setAlt(String alt) {
                            return (PartitionQuery)super.setAlt(alt);
                        }

                        public PartitionQuery setCallback(String callback) {
                            return (PartitionQuery)super.setCallback(callback);
                        }

                        public PartitionQuery setFields(String fields) {
                            return (PartitionQuery)super.setFields(fields);
                        }

                        public PartitionQuery setKey(String key) {
                            return (PartitionQuery)super.setKey(key);
                        }

                        public PartitionQuery setOauthToken(String oauthToken) {
                            return (PartitionQuery)super.setOauthToken(oauthToken);
                        }

                        public PartitionQuery setPrettyPrint(Boolean prettyPrint) {
                            return (PartitionQuery)super.setPrettyPrint(prettyPrint);
                        }

                        public PartitionQuery setQuotaUser(String quotaUser) {
                            return (PartitionQuery)super.setQuotaUser(quotaUser);
                        }

                        public PartitionQuery setUploadType(String uploadType) {
                            return (PartitionQuery)super.setUploadType(uploadType);
                        }

                        public PartitionQuery setUploadProtocol(String uploadProtocol) {
                            return (PartitionQuery)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public PartitionQuery setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public PartitionQuery set(String parameterName, Object value) {
                            return (PartitionQuery)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends SpannerRequest<ListSessionsResponse> {
                        private static final String REST_PATH = "v1/{+database}/sessions";
                        private final Pattern DATABASE_PATTERN;
                        @Key
                        private String database;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String database) {
                            super(Spanner.this, "GET", REST_PATH, null, ListSessionsResponse.class);
                            this.DATABASE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getDatabase() {
                            return this.database;
                        }

                        public List setDatabase(String database) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            }
                            this.database = database;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends SpannerRequest<Session> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Spanner.this, "GET", REST_PATH, null, Session.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class ExecuteStreamingSql
                    extends SpannerRequest<PartialResultSet> {
                        private static final String REST_PATH = "v1/{+session}:executeStreamingSql";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected ExecuteStreamingSql(String session, ExecuteSqlRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, PartialResultSet.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public ExecuteStreamingSql set$Xgafv(String $Xgafv) {
                            return (ExecuteStreamingSql)super.set$Xgafv($Xgafv);
                        }

                        public ExecuteStreamingSql setAccessToken(String accessToken) {
                            return (ExecuteStreamingSql)super.setAccessToken(accessToken);
                        }

                        public ExecuteStreamingSql setAlt(String alt) {
                            return (ExecuteStreamingSql)super.setAlt(alt);
                        }

                        public ExecuteStreamingSql setCallback(String callback) {
                            return (ExecuteStreamingSql)super.setCallback(callback);
                        }

                        public ExecuteStreamingSql setFields(String fields) {
                            return (ExecuteStreamingSql)super.setFields(fields);
                        }

                        public ExecuteStreamingSql setKey(String key) {
                            return (ExecuteStreamingSql)super.setKey(key);
                        }

                        public ExecuteStreamingSql setOauthToken(String oauthToken) {
                            return (ExecuteStreamingSql)super.setOauthToken(oauthToken);
                        }

                        public ExecuteStreamingSql setPrettyPrint(Boolean prettyPrint) {
                            return (ExecuteStreamingSql)super.setPrettyPrint(prettyPrint);
                        }

                        public ExecuteStreamingSql setQuotaUser(String quotaUser) {
                            return (ExecuteStreamingSql)super.setQuotaUser(quotaUser);
                        }

                        public ExecuteStreamingSql setUploadType(String uploadType) {
                            return (ExecuteStreamingSql)super.setUploadType(uploadType);
                        }

                        public ExecuteStreamingSql setUploadProtocol(String uploadProtocol) {
                            return (ExecuteStreamingSql)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public ExecuteStreamingSql setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public ExecuteStreamingSql set(String parameterName, Object value) {
                            return (ExecuteStreamingSql)super.set(parameterName, value);
                        }
                    }

                    public class ExecuteSql
                    extends SpannerRequest<ResultSet> {
                        private static final String REST_PATH = "v1/{+session}:executeSql";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected ExecuteSql(String session, ExecuteSqlRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, ResultSet.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public ExecuteSql set$Xgafv(String $Xgafv) {
                            return (ExecuteSql)super.set$Xgafv($Xgafv);
                        }

                        public ExecuteSql setAccessToken(String accessToken) {
                            return (ExecuteSql)super.setAccessToken(accessToken);
                        }

                        public ExecuteSql setAlt(String alt) {
                            return (ExecuteSql)super.setAlt(alt);
                        }

                        public ExecuteSql setCallback(String callback) {
                            return (ExecuteSql)super.setCallback(callback);
                        }

                        public ExecuteSql setFields(String fields) {
                            return (ExecuteSql)super.setFields(fields);
                        }

                        public ExecuteSql setKey(String key) {
                            return (ExecuteSql)super.setKey(key);
                        }

                        public ExecuteSql setOauthToken(String oauthToken) {
                            return (ExecuteSql)super.setOauthToken(oauthToken);
                        }

                        public ExecuteSql setPrettyPrint(Boolean prettyPrint) {
                            return (ExecuteSql)super.setPrettyPrint(prettyPrint);
                        }

                        public ExecuteSql setQuotaUser(String quotaUser) {
                            return (ExecuteSql)super.setQuotaUser(quotaUser);
                        }

                        public ExecuteSql setUploadType(String uploadType) {
                            return (ExecuteSql)super.setUploadType(uploadType);
                        }

                        public ExecuteSql setUploadProtocol(String uploadProtocol) {
                            return (ExecuteSql)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public ExecuteSql setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public ExecuteSql set(String parameterName, Object value) {
                            return (ExecuteSql)super.set(parameterName, value);
                        }
                    }

                    public class ExecuteBatchDml
                    extends SpannerRequest<ExecuteBatchDmlResponse> {
                        private static final String REST_PATH = "v1/{+session}:executeBatchDml";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected ExecuteBatchDml(String session, ExecuteBatchDmlRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, ExecuteBatchDmlResponse.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public ExecuteBatchDml set$Xgafv(String $Xgafv) {
                            return (ExecuteBatchDml)super.set$Xgafv($Xgafv);
                        }

                        public ExecuteBatchDml setAccessToken(String accessToken) {
                            return (ExecuteBatchDml)super.setAccessToken(accessToken);
                        }

                        public ExecuteBatchDml setAlt(String alt) {
                            return (ExecuteBatchDml)super.setAlt(alt);
                        }

                        public ExecuteBatchDml setCallback(String callback) {
                            return (ExecuteBatchDml)super.setCallback(callback);
                        }

                        public ExecuteBatchDml setFields(String fields) {
                            return (ExecuteBatchDml)super.setFields(fields);
                        }

                        public ExecuteBatchDml setKey(String key) {
                            return (ExecuteBatchDml)super.setKey(key);
                        }

                        public ExecuteBatchDml setOauthToken(String oauthToken) {
                            return (ExecuteBatchDml)super.setOauthToken(oauthToken);
                        }

                        public ExecuteBatchDml setPrettyPrint(Boolean prettyPrint) {
                            return (ExecuteBatchDml)super.setPrettyPrint(prettyPrint);
                        }

                        public ExecuteBatchDml setQuotaUser(String quotaUser) {
                            return (ExecuteBatchDml)super.setQuotaUser(quotaUser);
                        }

                        public ExecuteBatchDml setUploadType(String uploadType) {
                            return (ExecuteBatchDml)super.setUploadType(uploadType);
                        }

                        public ExecuteBatchDml setUploadProtocol(String uploadProtocol) {
                            return (ExecuteBatchDml)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public ExecuteBatchDml setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public ExecuteBatchDml set(String parameterName, Object value) {
                            return (ExecuteBatchDml)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends SpannerRequest<Empty> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Spanner.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends SpannerRequest<Session> {
                        private static final String REST_PATH = "v1/{+database}/sessions";
                        private final Pattern DATABASE_PATTERN;
                        @Key
                        private String database;

                        protected Create(String database, CreateSessionRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, Session.class);
                            this.DATABASE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getDatabase() {
                            return this.database;
                        }

                        public Create setDatabase(String database) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            }
                            this.database = database;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }

                    public class Commit
                    extends SpannerRequest<CommitResponse> {
                        private static final String REST_PATH = "v1/{+session}:commit";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected Commit(String session, CommitRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, CommitResponse.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public Commit set$Xgafv(String $Xgafv) {
                            return (Commit)super.set$Xgafv($Xgafv);
                        }

                        public Commit setAccessToken(String accessToken) {
                            return (Commit)super.setAccessToken(accessToken);
                        }

                        public Commit setAlt(String alt) {
                            return (Commit)super.setAlt(alt);
                        }

                        public Commit setCallback(String callback) {
                            return (Commit)super.setCallback(callback);
                        }

                        public Commit setFields(String fields) {
                            return (Commit)super.setFields(fields);
                        }

                        public Commit setKey(String key) {
                            return (Commit)super.setKey(key);
                        }

                        public Commit setOauthToken(String oauthToken) {
                            return (Commit)super.setOauthToken(oauthToken);
                        }

                        public Commit setPrettyPrint(Boolean prettyPrint) {
                            return (Commit)super.setPrettyPrint(prettyPrint);
                        }

                        public Commit setQuotaUser(String quotaUser) {
                            return (Commit)super.setQuotaUser(quotaUser);
                        }

                        public Commit setUploadType(String uploadType) {
                            return (Commit)super.setUploadType(uploadType);
                        }

                        public Commit setUploadProtocol(String uploadProtocol) {
                            return (Commit)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public Commit setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public Commit set(String parameterName, Object value) {
                            return (Commit)super.set(parameterName, value);
                        }
                    }

                    public class BeginTransaction
                    extends SpannerRequest<Transaction> {
                        private static final String REST_PATH = "v1/{+session}:beginTransaction";
                        private final Pattern SESSION_PATTERN;
                        @Key
                        private String session;

                        protected BeginTransaction(String session, BeginTransactionRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, Transaction.class);
                            this.SESSION_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"Required parameter session must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                        }

                        public BeginTransaction set$Xgafv(String $Xgafv) {
                            return (BeginTransaction)super.set$Xgafv($Xgafv);
                        }

                        public BeginTransaction setAccessToken(String accessToken) {
                            return (BeginTransaction)super.setAccessToken(accessToken);
                        }

                        public BeginTransaction setAlt(String alt) {
                            return (BeginTransaction)super.setAlt(alt);
                        }

                        public BeginTransaction setCallback(String callback) {
                            return (BeginTransaction)super.setCallback(callback);
                        }

                        public BeginTransaction setFields(String fields) {
                            return (BeginTransaction)super.setFields(fields);
                        }

                        public BeginTransaction setKey(String key) {
                            return (BeginTransaction)super.setKey(key);
                        }

                        public BeginTransaction setOauthToken(String oauthToken) {
                            return (BeginTransaction)super.setOauthToken(oauthToken);
                        }

                        public BeginTransaction setPrettyPrint(Boolean prettyPrint) {
                            return (BeginTransaction)super.setPrettyPrint(prettyPrint);
                        }

                        public BeginTransaction setQuotaUser(String quotaUser) {
                            return (BeginTransaction)super.setQuotaUser(quotaUser);
                        }

                        public BeginTransaction setUploadType(String uploadType) {
                            return (BeginTransaction)super.setUploadType(uploadType);
                        }

                        public BeginTransaction setUploadProtocol(String uploadProtocol) {
                            return (BeginTransaction)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSession() {
                            return this.session;
                        }

                        public BeginTransaction setSession(String session) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SESSION_PATTERN.matcher(session).matches(), (Object)"Parameter session must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/sessions/[^/]+$");
                            }
                            this.session = session;
                            return this;
                        }

                        @Override
                        public BeginTransaction set(String parameterName, Object value) {
                            return (BeginTransaction)super.set(parameterName, value);
                        }
                    }

                    public class BatchCreate
                    extends SpannerRequest<BatchCreateSessionsResponse> {
                        private static final String REST_PATH = "v1/{+database}/sessions:batchCreate";
                        private final Pattern DATABASE_PATTERN;
                        @Key
                        private String database;

                        protected BatchCreate(String database, BatchCreateSessionsRequest content) {
                            super(Spanner.this, "POST", REST_PATH, (Object)content, BatchCreateSessionsResponse.class);
                            this.DATABASE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            }
                        }

                        public BatchCreate set$Xgafv(String $Xgafv) {
                            return (BatchCreate)super.set$Xgafv($Xgafv);
                        }

                        public BatchCreate setAccessToken(String accessToken) {
                            return (BatchCreate)super.setAccessToken(accessToken);
                        }

                        public BatchCreate setAlt(String alt) {
                            return (BatchCreate)super.setAlt(alt);
                        }

                        public BatchCreate setCallback(String callback) {
                            return (BatchCreate)super.setCallback(callback);
                        }

                        public BatchCreate setFields(String fields) {
                            return (BatchCreate)super.setFields(fields);
                        }

                        public BatchCreate setKey(String key) {
                            return (BatchCreate)super.setKey(key);
                        }

                        public BatchCreate setOauthToken(String oauthToken) {
                            return (BatchCreate)super.setOauthToken(oauthToken);
                        }

                        public BatchCreate setPrettyPrint(Boolean prettyPrint) {
                            return (BatchCreate)super.setPrettyPrint(prettyPrint);
                        }

                        public BatchCreate setQuotaUser(String quotaUser) {
                            return (BatchCreate)super.setQuotaUser(quotaUser);
                        }

                        public BatchCreate setUploadType(String uploadType) {
                            return (BatchCreate)super.setUploadType(uploadType);
                        }

                        public BatchCreate setUploadProtocol(String uploadProtocol) {
                            return (BatchCreate)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getDatabase() {
                            return this.database;
                        }

                        public BatchCreate setDatabase(String database) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                            }
                            this.database = database;
                            return this;
                        }

                        @Override
                        public BatchCreate set(String parameterName, Object value) {
                            return (BatchCreate)super.set(parameterName, value);
                        }
                    }
                }

                public class Operations {
                    public Cancel cancel(String name) throws IOException {
                        Cancel result = new Cancel(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String name) throws IOException {
                        List result = new List(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends SpannerRequest<ListOperationsResponse> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String name) {
                            super(Spanner.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public List setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends SpannerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Spanner.this, "GET", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends SpannerRequest<Empty> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Spanner.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Cancel
                    extends SpannerRequest<Empty> {
                        private static final String REST_PATH = "v1/{+name}:cancel";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Cancel(String name) {
                            super(Spanner.this, "POST", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            }
                        }

                        public Cancel set$Xgafv(String $Xgafv) {
                            return (Cancel)super.set$Xgafv($Xgafv);
                        }

                        public Cancel setAccessToken(String accessToken) {
                            return (Cancel)super.setAccessToken(accessToken);
                        }

                        public Cancel setAlt(String alt) {
                            return (Cancel)super.setAlt(alt);
                        }

                        public Cancel setCallback(String callback) {
                            return (Cancel)super.setCallback(callback);
                        }

                        public Cancel setFields(String fields) {
                            return (Cancel)super.setFields(fields);
                        }

                        public Cancel setKey(String key) {
                            return (Cancel)super.setKey(key);
                        }

                        public Cancel setOauthToken(String oauthToken) {
                            return (Cancel)super.setOauthToken(oauthToken);
                        }

                        public Cancel setPrettyPrint(Boolean prettyPrint) {
                            return (Cancel)super.setPrettyPrint(prettyPrint);
                        }

                        public Cancel setQuotaUser(String quotaUser) {
                            return (Cancel)super.setQuotaUser(quotaUser);
                        }

                        public Cancel setUploadType(String uploadType) {
                            return (Cancel)super.setUploadType(uploadType);
                        }

                        public Cancel setUploadProtocol(String uploadProtocol) {
                            return (Cancel)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Cancel setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Cancel set(String parameterName, Object value) {
                            return (Cancel)super.set(parameterName, value);
                        }
                    }
                }

                public class UpdateDdl
                extends SpannerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+database}/ddl";
                    private final Pattern DATABASE_PATTERN;
                    @Key
                    private String database;

                    protected UpdateDdl(String database, UpdateDatabaseDdlRequest content) {
                        super(Spanner.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.DATABASE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                    }

                    public UpdateDdl set$Xgafv(String $Xgafv) {
                        return (UpdateDdl)super.set$Xgafv($Xgafv);
                    }

                    public UpdateDdl setAccessToken(String accessToken) {
                        return (UpdateDdl)super.setAccessToken(accessToken);
                    }

                    public UpdateDdl setAlt(String alt) {
                        return (UpdateDdl)super.setAlt(alt);
                    }

                    public UpdateDdl setCallback(String callback) {
                        return (UpdateDdl)super.setCallback(callback);
                    }

                    public UpdateDdl setFields(String fields) {
                        return (UpdateDdl)super.setFields(fields);
                    }

                    public UpdateDdl setKey(String key) {
                        return (UpdateDdl)super.setKey(key);
                    }

                    public UpdateDdl setOauthToken(String oauthToken) {
                        return (UpdateDdl)super.setOauthToken(oauthToken);
                    }

                    public UpdateDdl setPrettyPrint(Boolean prettyPrint) {
                        return (UpdateDdl)super.setPrettyPrint(prettyPrint);
                    }

                    public UpdateDdl setQuotaUser(String quotaUser) {
                        return (UpdateDdl)super.setQuotaUser(quotaUser);
                    }

                    public UpdateDdl setUploadType(String uploadType) {
                        return (UpdateDdl)super.setUploadType(uploadType);
                    }

                    public UpdateDdl setUploadProtocol(String uploadProtocol) {
                        return (UpdateDdl)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDatabase() {
                        return this.database;
                    }

                    public UpdateDdl setDatabase(String database) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                        this.database = database;
                        return this;
                    }

                    @Override
                    public UpdateDdl set(String parameterName, Object value) {
                        return (UpdateDdl)super.set(parameterName, value);
                    }
                }

                public class TestIamPermissions
                extends SpannerRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends SpannerRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Restore
                extends SpannerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/databases:restore";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Restore(String parent, RestoreDatabaseRequest content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Restore set$Xgafv(String $Xgafv) {
                        return (Restore)super.set$Xgafv($Xgafv);
                    }

                    public Restore setAccessToken(String accessToken) {
                        return (Restore)super.setAccessToken(accessToken);
                    }

                    public Restore setAlt(String alt) {
                        return (Restore)super.setAlt(alt);
                    }

                    public Restore setCallback(String callback) {
                        return (Restore)super.setCallback(callback);
                    }

                    public Restore setFields(String fields) {
                        return (Restore)super.setFields(fields);
                    }

                    public Restore setKey(String key) {
                        return (Restore)super.setKey(key);
                    }

                    public Restore setOauthToken(String oauthToken) {
                        return (Restore)super.setOauthToken(oauthToken);
                    }

                    public Restore setPrettyPrint(Boolean prettyPrint) {
                        return (Restore)super.setPrettyPrint(prettyPrint);
                    }

                    public Restore setQuotaUser(String quotaUser) {
                        return (Restore)super.setQuotaUser(quotaUser);
                    }

                    public Restore setUploadType(String uploadType) {
                        return (Restore)super.setUploadType(uploadType);
                    }

                    public Restore setUploadProtocol(String uploadProtocol) {
                        return (Restore)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Restore setParent(String parent) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Restore set(String parameterName, Object value) {
                        return (Restore)super.set(parameterName, value);
                    }
                }

                public class List
                extends SpannerRequest<ListDatabasesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/databases";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Spanner.this, "GET", REST_PATH, null, ListDatabasesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetScans
                extends SpannerRequest<Scan> {
                    private static final String REST_PATH = "v1/{+name}/scans";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String endTime;
                    @Key
                    private String startTime;
                    @Key
                    private String view;

                    protected GetScans(String name) {
                        super(Spanner.this, "GET", REST_PATH, null, Scan.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetScans set$Xgafv(String $Xgafv) {
                        return (GetScans)super.set$Xgafv($Xgafv);
                    }

                    public GetScans setAccessToken(String accessToken) {
                        return (GetScans)super.setAccessToken(accessToken);
                    }

                    public GetScans setAlt(String alt) {
                        return (GetScans)super.setAlt(alt);
                    }

                    public GetScans setCallback(String callback) {
                        return (GetScans)super.setCallback(callback);
                    }

                    public GetScans setFields(String fields) {
                        return (GetScans)super.setFields(fields);
                    }

                    public GetScans setKey(String key) {
                        return (GetScans)super.setKey(key);
                    }

                    public GetScans setOauthToken(String oauthToken) {
                        return (GetScans)super.setOauthToken(oauthToken);
                    }

                    public GetScans setPrettyPrint(Boolean prettyPrint) {
                        return (GetScans)super.setPrettyPrint(prettyPrint);
                    }

                    public GetScans setQuotaUser(String quotaUser) {
                        return (GetScans)super.setQuotaUser(quotaUser);
                    }

                    public GetScans setUploadType(String uploadType) {
                        return (GetScans)super.setUploadType(uploadType);
                    }

                    public GetScans setUploadProtocol(String uploadProtocol) {
                        return (GetScans)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public GetScans setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getEndTime() {
                        return this.endTime;
                    }

                    public GetScans setEndTime(String endTime) {
                        this.endTime = endTime;
                        return this;
                    }

                    public String getStartTime() {
                        return this.startTime;
                    }

                    public GetScans setStartTime(String startTime) {
                        this.startTime = startTime;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public GetScans setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public GetScans set(String parameterName, Object value) {
                        return (GetScans)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends SpannerRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class GetDdl
                extends SpannerRequest<GetDatabaseDdlResponse> {
                    private static final String REST_PATH = "v1/{+database}/ddl";
                    private final Pattern DATABASE_PATTERN;
                    @Key
                    private String database;

                    protected GetDdl(String database) {
                        super(Spanner.this, "GET", REST_PATH, null, GetDatabaseDdlResponse.class);
                        this.DATABASE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetDdl set$Xgafv(String $Xgafv) {
                        return (GetDdl)super.set$Xgafv($Xgafv);
                    }

                    public GetDdl setAccessToken(String accessToken) {
                        return (GetDdl)super.setAccessToken(accessToken);
                    }

                    public GetDdl setAlt(String alt) {
                        return (GetDdl)super.setAlt(alt);
                    }

                    public GetDdl setCallback(String callback) {
                        return (GetDdl)super.setCallback(callback);
                    }

                    public GetDdl setFields(String fields) {
                        return (GetDdl)super.setFields(fields);
                    }

                    public GetDdl setKey(String key) {
                        return (GetDdl)super.setKey(key);
                    }

                    public GetDdl setOauthToken(String oauthToken) {
                        return (GetDdl)super.setOauthToken(oauthToken);
                    }

                    public GetDdl setPrettyPrint(Boolean prettyPrint) {
                        return (GetDdl)super.setPrettyPrint(prettyPrint);
                    }

                    public GetDdl setQuotaUser(String quotaUser) {
                        return (GetDdl)super.setQuotaUser(quotaUser);
                    }

                    public GetDdl setUploadType(String uploadType) {
                        return (GetDdl)super.setUploadType(uploadType);
                    }

                    public GetDdl setUploadProtocol(String uploadProtocol) {
                        return (GetDdl)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDatabase() {
                        return this.database;
                    }

                    public GetDdl setDatabase(String database) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                        this.database = database;
                        return this;
                    }

                    @Override
                    public GetDdl set(String parameterName, Object value) {
                        return (GetDdl)super.set(parameterName, value);
                    }
                }

                public class Get
                extends SpannerRequest<Database> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Spanner.this, "GET", REST_PATH, null, Database.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class DropDatabase
                extends SpannerRequest<Empty> {
                    private static final String REST_PATH = "v1/{+database}";
                    private final Pattern DATABASE_PATTERN;
                    @Key
                    private String database;

                    protected DropDatabase(String database) {
                        super(Spanner.this, "DELETE", REST_PATH, null, Empty.class);
                        this.DATABASE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Required parameter database must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                    }

                    public DropDatabase set$Xgafv(String $Xgafv) {
                        return (DropDatabase)super.set$Xgafv($Xgafv);
                    }

                    public DropDatabase setAccessToken(String accessToken) {
                        return (DropDatabase)super.setAccessToken(accessToken);
                    }

                    public DropDatabase setAlt(String alt) {
                        return (DropDatabase)super.setAlt(alt);
                    }

                    public DropDatabase setCallback(String callback) {
                        return (DropDatabase)super.setCallback(callback);
                    }

                    public DropDatabase setFields(String fields) {
                        return (DropDatabase)super.setFields(fields);
                    }

                    public DropDatabase setKey(String key) {
                        return (DropDatabase)super.setKey(key);
                    }

                    public DropDatabase setOauthToken(String oauthToken) {
                        return (DropDatabase)super.setOauthToken(oauthToken);
                    }

                    public DropDatabase setPrettyPrint(Boolean prettyPrint) {
                        return (DropDatabase)super.setPrettyPrint(prettyPrint);
                    }

                    public DropDatabase setQuotaUser(String quotaUser) {
                        return (DropDatabase)super.setQuotaUser(quotaUser);
                    }

                    public DropDatabase setUploadType(String uploadType) {
                        return (DropDatabase)super.setUploadType(uploadType);
                    }

                    public DropDatabase setUploadProtocol(String uploadProtocol) {
                        return (DropDatabase)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDatabase() {
                        return this.database;
                    }

                    public DropDatabase setDatabase(String database) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.DATABASE_PATTERN.matcher(database).matches(), (Object)"Parameter database must conform to the pattern ^projects/[^/]+/instances/[^/]+/databases/[^/]+$");
                        }
                        this.database = database;
                        return this;
                    }

                    @Override
                    public DropDatabase set(String parameterName, Object value) {
                        return (DropDatabase)super.set(parameterName, value);
                    }
                }

                public class Create
                extends SpannerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/databases";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, CreateDatabaseRequest content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class DatabaseOperations {
                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends SpannerRequest<ListDatabaseOperationsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/databaseOperations";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Spanner.this, "GET", REST_PATH, null, ListDatabaseOperationsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class Backups {
                public Create create(String parent, Backup content) throws IOException {
                    Create result = new Create(parent, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Backup content) throws IOException {
                    Patch result = new Patch(name, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Operations operations() {
                    return new Operations();
                }

                public class Operations {
                    public Cancel cancel(String name) throws IOException {
                        Cancel result = new Cancel(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String name) throws IOException {
                        List result = new List(name);
                        Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends SpannerRequest<ListOperationsResponse> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String name) {
                            super(Spanner.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public List setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends SpannerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Spanner.this, "GET", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends SpannerRequest<Empty> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Spanner.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Cancel
                    extends SpannerRequest<Empty> {
                        private static final String REST_PATH = "v1/{+name}:cancel";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Cancel(String name) {
                            super(Spanner.this, "POST", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            }
                        }

                        public Cancel set$Xgafv(String $Xgafv) {
                            return (Cancel)super.set$Xgafv($Xgafv);
                        }

                        public Cancel setAccessToken(String accessToken) {
                            return (Cancel)super.setAccessToken(accessToken);
                        }

                        public Cancel setAlt(String alt) {
                            return (Cancel)super.setAlt(alt);
                        }

                        public Cancel setCallback(String callback) {
                            return (Cancel)super.setCallback(callback);
                        }

                        public Cancel setFields(String fields) {
                            return (Cancel)super.setFields(fields);
                        }

                        public Cancel setKey(String key) {
                            return (Cancel)super.setKey(key);
                        }

                        public Cancel setOauthToken(String oauthToken) {
                            return (Cancel)super.setOauthToken(oauthToken);
                        }

                        public Cancel setPrettyPrint(Boolean prettyPrint) {
                            return (Cancel)super.setPrettyPrint(prettyPrint);
                        }

                        public Cancel setQuotaUser(String quotaUser) {
                            return (Cancel)super.setQuotaUser(quotaUser);
                        }

                        public Cancel setUploadType(String uploadType) {
                            return (Cancel)super.setUploadType(uploadType);
                        }

                        public Cancel setUploadProtocol(String uploadProtocol) {
                            return (Cancel)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Cancel setName(String name) {
                            if (!Spanner.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Cancel set(String parameterName, Object value) {
                            return (Cancel)super.set(parameterName, value);
                        }
                    }
                }

                public class TestIamPermissions
                extends SpannerRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends SpannerRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends SpannerRequest<Backup> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, Backup content) {
                        super(Spanner.this, "PATCH", REST_PATH, (Object)content, Backup.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends SpannerRequest<ListBackupsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/backups";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Spanner.this, "GET", REST_PATH, null, ListBackupsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends SpannerRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends SpannerRequest<Backup> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Spanner.this, "GET", REST_PATH, null, Backup.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends SpannerRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Spanner.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/backups/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends SpannerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/backups";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String backupId;
                    @Key(value="encryptionConfig.encryptionType")
                    private String encryptionConfigEncryptionType;
                    @Key(value="encryptionConfig.kmsKeyName")
                    private String encryptionConfigKmsKeyName;

                    protected Create(String parent, Backup content) {
                        super(Spanner.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getBackupId() {
                        return this.backupId;
                    }

                    public Create setBackupId(String backupId) {
                        this.backupId = backupId;
                        return this;
                    }

                    public String getEncryptionConfigEncryptionType() {
                        return this.encryptionConfigEncryptionType;
                    }

                    public Create setEncryptionConfigEncryptionType(String encryptionConfigEncryptionType) {
                        this.encryptionConfigEncryptionType = encryptionConfigEncryptionType;
                        return this;
                    }

                    public String getEncryptionConfigKmsKeyName() {
                        return this.encryptionConfigKmsKeyName;
                    }

                    public Create setEncryptionConfigKmsKeyName(String encryptionConfigKmsKeyName) {
                        this.encryptionConfigKmsKeyName = encryptionConfigKmsKeyName;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class BackupOperations {
                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends SpannerRequest<ListBackupOperationsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/backupOperations";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Spanner.this, "GET", REST_PATH, null, ListBackupOperationsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Spanner.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class TestIamPermissions
            extends SpannerRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(Spanner.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends SpannerRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(Spanner.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Patch
            extends SpannerRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String name, UpdateInstanceRequest content) {
                    super(Spanner.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends SpannerRequest<ListInstancesResponse> {
                private static final String REST_PATH = "v1/{+parent}/instances";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private String instanceDeadline;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Spanner.this, "GET", REST_PATH, null, ListInstancesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getInstanceDeadline() {
                    return this.instanceDeadline;
                }

                public List setInstanceDeadline(String instanceDeadline) {
                    this.instanceDeadline = instanceDeadline;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends SpannerRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                    super(Spanner.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Get
            extends SpannerRequest<Instance> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String fieldMask;

                protected Get(String name) {
                    super(Spanner.this, "GET", REST_PATH, null, Instance.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFieldMask() {
                    return this.fieldMask;
                }

                public Get setFieldMask(String fieldMask) {
                    this.fieldMask = fieldMask;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends SpannerRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Spanner.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends SpannerRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/instances";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, CreateInstanceRequest content) {
                    super(Spanner.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class InstanceConfigs {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Spanner.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends SpannerRequest<ListInstanceConfigsResponse> {
                private static final String REST_PATH = "v1/{+parent}/instanceConfigs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Spanner.this, "GET", REST_PATH, null, ListInstanceConfigsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends SpannerRequest<InstanceConfig> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Spanner.this, "GET", REST_PATH, null, InstanceConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instanceConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instanceConfigs/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Spanner.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instanceConfigs/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }
}

