/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql.query.parser;

import org.netezza.internal.NzQuery;
import org.netezza.internal.ParseException;
import org.netezza.sql.NzConnection;
import org.netezza.sql.query.NzCallableQuery;
import org.netezza.sql.query.parser.QueryParser;

public abstract class SimpleQueryParser
implements QueryParser {
    protected final NzQuery nzQuery;
    protected final int queryLength;
    protected final String queryString;
    protected StringBuilder nativeQueryToken = new StringBuilder();
    protected StringBuilder parameterizedQueryToken = new StringBuilder();
    protected int curPos;
    protected NzConnection connection;

    public SimpleQueryParser(NzConnection connection, NzQuery nzQuery, String queryString, int queryLength) {
        this.connection = connection;
        this.nzQuery = nzQuery;
        this.queryLength = queryLength;
        this.queryString = queryString;
    }

    @Override
    public abstract NzCallableQuery parse() throws ParseException;

    @Override
    public int removeWhiteSpaces() {
        while (Character.isWhitespace(this.queryString.charAt(this.curPos))) {
            ++this.curPos;
        }
        return this.curPos;
    }

    @Override
    public int processEscapedFunctionCalls(char c) throws ParseException {
        String method = "getBigDecimal";
        this.connection.LOGGER.entry(this.getClass(), method, Character.valueOf(c));
        StringBuilder buffer = new StringBuilder();
        buffer = new StringBuilder();
        buffer.append(c);
        int curlyBraceCounter = 1;
        char quoteInEscape = '\u0000';
        do {
            if (this.curPos >= this.queryLength) {
                ParseException ex = new ParseException("Syntax Error");
                this.connection.LOGGER.fatal(this.getClass(), method, ex);
                throw ex;
            }
            c = this.queryString.charAt(this.curPos++);
            if (quoteInEscape == '\u0000') {
                switch (c) {
                    case '{': {
                        curlyBraceCounter = (byte)(curlyBraceCounter + 1);
                        break;
                    }
                    case '}': {
                        curlyBraceCounter = (byte)(curlyBraceCounter - 1);
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        quoteInEscape = c;
                        break;
                    }
                }
            } else if (c == quoteInEscape) {
                quoteInEscape = '\u0000';
            }
            buffer.append(c);
        } while (curlyBraceCounter != 0);
        StringBuilder escapeBuilder = new StringBuilder();
        int val = this.nzQuery.parseEscapeSequence(buffer.toString(), escapeBuilder);
        if (val == -2) {
            this.nativeQueryToken.append(escapeBuilder + " ");
            this.parameterizedQueryToken.append(escapeBuilder + " ");
        } else if (val == -1) {
            ParseException ex = new ParseException("Syntax Error");
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
        return this.curPos;
    }

    @Override
    public int processSingleLineComment() {
        char nextChar;
        if ((nextChar = this.queryString.charAt(this.curPos++)) == '-') {
            do {
                this.nativeQueryToken.append(nextChar);
                this.parameterizedQueryToken.append(nextChar);
            } while (this.curPos < this.queryLength && (nextChar = this.queryString.charAt(this.curPos++)) != '\n');
            if (nextChar == '\n') {
                this.nativeQueryToken.append(nextChar);
                this.parameterizedQueryToken.append(nextChar);
            }
        } else {
            this.nativeQueryToken.append(nextChar);
            this.parameterizedQueryToken.append(nextChar);
        }
        return this.curPos;
    }

    @Override
    public int processMultiLineComment() {
        char nextChar = this.queryString.charAt(this.curPos++);
        this.nativeQueryToken.append(nextChar);
        this.parameterizedQueryToken.append(nextChar);
        if (nextChar == '*') {
            while (this.curPos < this.queryLength) {
                nextChar = this.queryString.charAt(this.curPos++);
                this.nativeQueryToken.append(nextChar);
                this.parameterizedQueryToken.append(nextChar);
                if (nextChar != '*' || this.curPos >= this.queryLength || (nextChar = this.queryString.charAt(this.curPos++)) != '/') continue;
                this.nativeQueryToken.append(nextChar);
                this.parameterizedQueryToken.append(nextChar);
                break;
            }
        }
        return this.curPos;
    }

    @Override
    public int processStringLiterals(char currentChar) {
        char quote = currentChar;
        this.nativeQueryToken.append(currentChar);
        this.parameterizedQueryToken.append(currentChar);
        while (this.curPos < this.queryLength) {
            currentChar = this.queryString.charAt(this.curPos++);
            this.nativeQueryToken.append(currentChar);
            this.parameterizedQueryToken.append(currentChar);
            if (currentChar != quote) continue;
            break;
        }
        return this.curPos;
    }
}

