/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.jalapeno.tools.objects.PersistentPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class GenericsProcessor {
    public static Class getCollectionElementType(PropertyDescriptor propertyDescriptor, boolean bl) {
        Class<?> clazz;
        String string;
        Type type;
        if (PersistentPropertyDescriptor.hasField(propertyDescriptor)) {
            Field field = PersistentPropertyDescriptor.getField(propertyDescriptor);
            type = field.getGenericType();
            string = field.toGenericString();
            clazz = field.getType();
        } else if (PersistentPropertyDescriptor.hasGetter(propertyDescriptor)) {
            Method method = propertyDescriptor.getReadMethod();
            type = method.getGenericReturnType();
            string = method.toGenericString();
            clazz = method.getReturnType();
        } else if (PersistentPropertyDescriptor.hasSetter(propertyDescriptor)) {
            Method method = propertyDescriptor.getWriteMethod();
            type = method.getGenericParameterTypes()[0];
            string = method.toGenericString();
            clazz = method.getReturnType();
        } else {
            throw new IllegalArgumentException("Unknown Property Descriptor type " + propertyDescriptor.getClass().getName());
        }
        return GenericsProcessor.getElementType(type, clazz, string, bl);
    }

    public static Class getCollectionElementType(Field field) {
        Type type = field.getGenericType();
        String string = field.toGenericString();
        Class<?> clazz = field.getType();
        return GenericsProcessor.getElementType(type, clazz, string, true);
    }

    public static Class getCollectionElementType(Method method) {
        Class<?> clazz;
        String string;
        Type type;
        if (method.getName().startsWith("set")) {
            type = method.getGenericParameterTypes()[0];
            string = method.toGenericString();
            clazz = method.getReturnType();
        } else {
            type = method.getGenericReturnType();
            string = method.toGenericString();
            clazz = method.getReturnType();
        }
        return GenericsProcessor.getElementType(type, clazz, string, true);
    }

    private static Class getElementType(Type type, Class clazz, String string, boolean bl) {
        if (type instanceof Class) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            if (typeArray.length == 0) {
                return null;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                if (typeArray.length != 1) {
                    throw new IllegalArgumentException("Field " + string + " is not a valid collection.");
                }
                if (!(typeArray[0] instanceof Class)) {
                    return GenericsProcessor.handleNestedGenerics(bl, type, string);
                }
                return (Class)typeArray[0];
            }
            if (Map.class.isAssignableFrom(clazz)) {
                if (typeArray.length != 2) {
                    throw new IllegalArgumentException("Field " + string + " is not a valid collection.");
                }
                if (!(typeArray[1] instanceof Class)) {
                    return GenericsProcessor.handleNestedGenerics(bl, type, string);
                }
                return (Class)typeArray[1];
            }
            throw new IllegalArgumentException("Field " + string + " is not a valid collection.");
        }
        throw new IllegalArgumentException("Failed to process field " + string + ". Type " + type.toString() + " is not supported.");
    }

    private static Class handleNestedGenerics(boolean bl, Type type, String string) {
        if (bl) {
            return null;
        }
        throw new IllegalArgumentException("Failed to process field " + string + ". Nested generics: " + type.toString() + " are not supported.");
    }

    public static void main(String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName("bank.Customer");
        Field field = clazz.getField("name");
        Field field2 = clazz.getField("accounts");
        Field field3 = clazz.getField("addresses");
        PersistentPropertyDescriptor persistentPropertyDescriptor = new PersistentPropertyDescriptor(clazz, field);
        PersistentPropertyDescriptor persistentPropertyDescriptor2 = new PersistentPropertyDescriptor(clazz, field2);
        PersistentPropertyDescriptor persistentPropertyDescriptor3 = new PersistentPropertyDescriptor(clazz, field3);
        System.out.println(field.toString() + ": " + GenericsProcessor.getCollectionElementType(persistentPropertyDescriptor, false));
        System.out.println(field2.toString() + ": " + GenericsProcessor.getCollectionElementType(persistentPropertyDescriptor2, false));
        System.out.println(field3.toString() + ": " + GenericsProcessor.getCollectionElementType(persistentPropertyDescriptor3, false));
    }
}

