/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.classes.BinaryStream;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheIOException;
import com.intersys.objects.IntegerHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class CacheInputStream
extends InputStream
implements Serializable {
    private BinaryStream mStream;
    private long mMark;
    private long mCurPos;
    private static final int MAX_READ_LEN = 32000;

    public CacheInputStream(BinaryStream binaryStream) throws CacheException {
        this.mStream = binaryStream;
        this.mMark = -1L;
        this.mCurPos = 0L;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        byte[] byArray2 = this.read(n2);
        if ((n2 = byArray2.length) > 0) {
            System.arraycopy(byArray2, 0, byArray, n, n2);
        }
        if (n2 == 0) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = this.read(1);
        if (byArray.length == 1) {
            return byArray[0];
        }
        return -1;
    }

    public void rewind() throws CacheException {
        this.mStream._rewind();
        this.mCurPos = 0L;
    }

    public synchronized long tell() {
        return this.mCurPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int n) {
        this.mMark = this.mCurPos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.seek(this.mMark);
    }

    public synchronized void seek(long l) throws IOException {
        if (l > this.mCurPos) {
            this.skip(l - this.mCurPos);
        } else if (l < this.mCurPos) {
            try {
                this.rewind();
            }
            catch (CacheException cacheException) {
                throw new CacheIOException(cacheException);
            }
            this.skip(l);
        }
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l > 0L) {
            int n = (int)(l > 32000L ? 32000L : l);
            int n2 = this.read(n).length;
            l2 += (long)n2;
            l -= (long)n2;
            if (n2 >= n) continue;
            break;
        }
        return l2;
    }

    public synchronized byte[] read(int n) throws IOException {
        try {
            IntegerHolder integerHolder = new IntegerHolder(new Integer(n));
            byte[] byArray = this.mStream._read(integerHolder);
            n = integerHolder.value;
            if (n <= 0) {
                return new byte[0];
            }
            this.mCurPos += (long)n;
            if (n == 1 && byArray.length == 0) {
                byArray = new byte[]{0};
            }
            if (n != byArray.length) {
                throw new IOException("Inconsistent data reading  Cache Stream: " + n + "/" + byArray.length);
            }
            return byArray;
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    @Override
    public int available() throws IOException {
        try {
            int n = this.mStream._sizeGet();
            return (int)((long)n - this.mCurPos);
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.rewind();
        }
        catch (CacheException cacheException) {
            throw new IOException(cacheException.toString());
        }
    }
}

