/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.mds.internal;

import com.intersys.xep.annotations.Serialized;
import java.io.Serializable;

public class MDSTypeInfo
implements Serializable {
    public String name;
    public String declaredClassName;
    public String concreteClassName;
    public int typeCode;
    public int arrayDimensions = 0;
    @Serialized
    public MDSTypeInfo[] fields;

    public MDSTypeInfo() {
        this.name = null;
        this.typeCode = 0;
        this.declaredClassName = null;
        this.concreteClassName = null;
        this.fields = null;
    }

    public MDSTypeInfo(String string, int n) {
        this.name = string;
        this.typeCode = n;
        this.declaredClassName = null;
        this.concreteClassName = null;
        this.fields = null;
    }

    public boolean matches(MDSTypeInfo mDSTypeInfo) {
        if (mDSTypeInfo.typeCode == 51) {
            return this.typeCode == 51 || this.typeCode == 41;
        }
        if (mDSTypeInfo.typeCode == 19) {
            return this.typeCode == 19 || this.typeCode == 9;
        }
        if (!(this.name == null && mDSTypeInfo.name == null || this.name.equals(mDSTypeInfo.name))) {
            return false;
        }
        if (!(this.declaredClassName == null && mDSTypeInfo.declaredClassName == null || this.declaredClassName.equals(mDSTypeInfo.declaredClassName))) {
            return false;
        }
        if (!(this.concreteClassName == null && mDSTypeInfo.concreteClassName == null || this.concreteClassName.equals(mDSTypeInfo.concreteClassName))) {
            return false;
        }
        if (this.typeCode != mDSTypeInfo.typeCode) {
            return false;
        }
        if (this.arrayDimensions != mDSTypeInfo.arrayDimensions) {
            return false;
        }
        if ((this.fields != null || mDSTypeInfo.fields != null) && this.fields.length != mDSTypeInfo.fields.length) {
            return false;
        }
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].matches(mDSTypeInfo.fields[i])) continue;
                return false;
            }
        }
        return true;
    }

    public void dump(int n) {
        if (this.name != null) {
            this.dumpPad(n);
            System.out.println("name: " + this.name);
        }
        if (this.declaredClassName != null) {
            this.dumpPad(n);
            System.out.println("declaredClassName: " + this.declaredClassName);
        }
        if (this.concreteClassName != null) {
            this.dumpPad(n);
            System.out.println("concreteClassName: " + this.concreteClassName);
        }
        this.dumpPad(n);
        System.out.println("typeCode: " + this.typeCode);
        this.dumpPad(n);
        System.out.println("arrayDimensions: " + this.arrayDimensions);
        if ((this.typeCode == 9 || this.typeCode == 41 || this.typeCode == 528 || this.typeCode == 529 || this.typeCode == 530 || this.typeCode == 560 || this.typeCode == 561 || this.typeCode == 562) && this.fields != null) {
            this.dumpPad(n);
            System.out.println("Number of fields: " + this.fields.length);
            for (int i = 0; i < this.fields.length; ++i) {
                this.dumpPad(n);
                System.out.println("Field " + i + ":");
                if (this.fields[i] != null) {
                    this.fields[i].dump(n + 4);
                    continue;
                }
                this.dumpPad(n + 4);
                System.out.println("<NULL>");
            }
        }
    }

    private void dumpPad(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
    }
}

