/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jsp;

import com.intersys.jsp.DBHelper;
import com.intersys.jsp.HistoryFrame;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheQuery;
import com.intersys.objects.Database;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class RuntimeEnvironment
implements HttpSessionBindingListener {
    private static final String ROOT_FRAME_NAME = "ROOT";
    private Database mDB = null;
    private int mHistoryFrame = 0;
    private int mMaxHistoryFrame = 0;
    private Map mTableCache = new HashMap();
    private String mID;
    private Vector mHistory = new Vector();
    private Map mContexts = new HashMap();
    private int mDebugLevel;
    private PreparedStatement mTableInfo;

    public RuntimeEnvironment(PageContext pageContext) throws JspException {
        this.registerContext(pageContext, null, null);
        this.registerView(0, null, null, pageContext);
    }

    public String getID() {
        return this.mID;
    }

    public String mangleViewName(String string, int n) {
        String string2 = this.getID();
        if (string2.length() > 10) {
            string2 = string2.substring(string2.length() - 10);
        }
        return string + '_' + string2 + '_' + n;
    }

    public final void registerView(int n, String string, String string2, PageContext pageContext) throws JspException {
        if (n + 1 > this.mHistory.size()) {
            this.mHistory.setSize(n + 1);
        }
        HistoryFrame historyFrame = null;
        int n2 = -1;
        if (n == 0) {
            historyFrame = this.getRootFrame(pageContext, string2);
            n2 = historyFrame.getCount();
        } else {
            HistoryFrame historyFrame2;
            HistoryFrameWithContext historyFrameWithContext = (HistoryFrameWithContext)this.mHistory.get(this.getHistoryFrame(pageContext));
            if (historyFrameWithContext.context.name != null && string2 != null && !string2.equals(historyFrameWithContext.context.name)) {
                throw new JspException("Context " + string2 + "does not match parent context " + historyFrameWithContext.context.name);
            }
            if (historyFrameWithContext.context.name == null && string2 != null) {
                HistoryFrameContext historyFrameContext = this.getContext(string2);
                if (historyFrameContext == null) {
                    throw new JspException("Context " + string2 + " is not registered");
                }
                historyFrame2 = historyFrameContext.root;
            } else {
                string2 = historyFrameWithContext.context.name;
                historyFrame2 = historyFrameWithContext.frame;
            }
            historyFrame = HistoryFrame.createChild(n, string, historyFrame2);
        }
        if (string != null && n2 < 0) {
            historyFrame.setCount(this.getCountSQL(string));
        }
        this.mHistory.set(n, new HistoryFrameWithContext(string2, historyFrame));
        this.setHistoryFrame(n, pageContext);
    }

    private HistoryFrame getRootFrame(PageContext pageContext, String string) throws JspException {
        HistoryFrameContext historyFrameContext;
        String string2 = DBHelper.getURI(pageContext);
        String string3 = string2 + "." + ROOT_FRAME_NAME;
        HashMap<String, Integer> hashMap = (HashMap<String, Integer>)pageContext.getAttribute(string3, 4);
        if (hashMap == null) {
            hashMap = new HashMap<String, Integer>();
            pageContext.setAttribute(string3, hashMap, 4);
        }
        if ((historyFrameContext = this.getContext(string)) == null) {
            throw new JspException("Context " + string + " is not registered");
        }
        HistoryFrame historyFrame = HistoryFrame.createRoot(hashMap, historyFrameContext.table);
        if (historyFrameContext.table != null) {
            int n;
            String string4 = historyFrameContext.table + ".Count";
            Integer n2 = (Integer)hashMap.get(string4);
            if (n2 == null) {
                n = this.getCountSQL(historyFrameContext.table);
                hashMap.put(string4, new Integer(n));
            } else {
                n = n2;
            }
            historyFrame.setCount(n);
        }
        return historyFrame;
    }

    public void registerContext(PageContext pageContext, String string, String string2) throws JspException {
        HistoryFrame historyFrame;
        if (this.getContext(string) != null) {
            return;
        }
        HistoryFrameContext historyFrameContext = new HistoryFrameContext(string, string2);
        this.mContexts.put(string, historyFrameContext);
        historyFrameContext.root = historyFrame = this.getRootFrame(pageContext, string);
    }

    private HistoryFrameContext getContext(String string) {
        return (HistoryFrameContext)this.mContexts.get(string);
    }

    public HistoryFrame getHistoryFrame(int n) {
        HistoryFrameWithContext historyFrameWithContext = (HistoryFrameWithContext)this.mHistory.get(n);
        return historyFrameWithContext.frame;
    }

    public int getHistoryFrame(PageContext pageContext) throws JspException {
        int n = DBHelper.getHistoryFromRequest(pageContext);
        if (n >= 0) {
            if (this.mDebugLevel > 0 && this.mHistoryFrame != n) {
                System.out.println("History frame was set to " + n);
            }
            this.mHistoryFrame = n;
        }
        return this.mHistoryFrame;
    }

    public void setHistoryFrame(int n, PageContext pageContext) throws JspException {
        if (n > this.mMaxHistoryFrame) {
            this.mMaxHistoryFrame = n;
        }
        this.mHistoryFrame = n;
        DBHelper.setHistoryInRequest(pageContext, n);
    }

    public int getMaxHistoryFrame() {
        return this.mMaxHistoryFrame;
    }

    public void setMaxHistoryFrame(int n) {
        this.mMaxHistoryFrame = n;
    }

    public Database getDBConnection() {
        return this.mDB;
    }

    public void setDBConnection(Database database) {
        this.mDB = database;
    }

    public int getTableCount(String string) throws Exception {
        TableInfo tableInfo = this.getTableInfo(string);
        int n = tableInfo.getCount();
        if (n < 0) {
            n = this.getCountSQL(string);
            tableInfo.setCount(n);
        }
        return n;
    }

    public int getCountSQL(String string) throws JspException {
        try {
            String string2 = "SELECT COUNT(distinct ID) FROM " + string;
            if (this.mDebugLevel > 0) {
                System.out.print("count: SQL: " + string2);
            }
            CacheQuery cacheQuery = new CacheQuery(this.mDB, string2);
            long l = System.currentTimeMillis();
            ResultSet resultSet = cacheQuery.execute();
            long l2 = System.currentTimeMillis();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                if (this.mDebugLevel > 0) {
                    System.out.println(" = " + n);
                    System.out.println("Time spent: " + (l2 - l));
                }
                return n;
            }
        }
        catch (Exception exception) {
            throw new JspException("Failed to count elements in table " + string, (Throwable)exception);
        }
        throw new JspException("No result counting records in " + string);
    }

    public boolean validateProperty(String string, String string2) throws JspException {
        TableInfo tableInfo = this.getTableInfo(string);
        if (string2.startsWith(string)) {
            string2 = string2.substring(string.length());
            int n = string2.indexOf(46);
            string2 = string2.substring(n + 1);
        }
        return tableInfo.hasProperty(string2);
    }

    public String isChildTable(String string, String string2) throws JspException {
        try {
            CacheClass cacheClass = this.mDB.getCacheClass(string);
            CacheField cacheField = cacheClass.getField(string2);
            if (cacheField == null) {
                return null;
            }
            String string3 = string + '_' + string2;
            TableInfo tableInfo = this.getTableInfo(string3);
            if (tableInfo.isEmpty()) {
                return null;
            }
            return string3;
        }
        catch (CacheException cacheException) {
            System.out.println("Exception occured: " + cacheException.getMessage());
            return null;
        }
    }

    public boolean validateChildTableProperty(String string, String string2, String string3) throws JspException {
        TableInfo tableInfo = this.getTableInfo(string2);
        int n = string.lastIndexOf(46);
        String string4 = n > 0 ? string.substring(n + 1) : string;
        return tableInfo.hasProperty(string4) && tableInfo.hasProperty(string3);
    }

    public TableInfo getTableInfo(String string) throws JspException {
        TableInfo tableInfo = (TableInfo)this.mTableCache.get(string);
        if (tableInfo == null) {
            try {
                tableInfo = new TableInfo(string);
            }
            catch (Exception exception) {
                System.out.println("Failed to get info for table " + string);
                exception.printStackTrace();
                throw new JspException((Throwable)exception);
            }
            this.mTableCache.put(string, tableInfo);
        }
        return tableInfo;
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        HttpSession httpSession = httpSessionBindingEvent.getSession();
        this.mID = httpSession.getId();
        this.mDebugLevel = DBHelper.getDebugLevel(httpSession);
        if (this.mDebugLevel > 0) {
            System.out.println("Runtime environment bound to session " + this.mID);
        }
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        HttpSession httpSession = httpSessionBindingEvent.getSession();
        if (this.mDB == null) {
            return;
        }
        if (this.mDebugLevel > 0) {
            System.out.println("Unbinding environment from session " + this.mID);
        }
        try {
            for (int i = this.mHistory.size() - 1; i >= 0; --i) {
                HistoryFrame historyFrame = this.getHistoryFrame(i);
                if (historyFrame.getId() <= 0) continue;
                this.dropView(historyFrame.getViewName());
            }
            this.mDB.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void dropView(String string) throws Exception {
        if (this.mDebugLevel > 0) {
            System.out.println("Dropping view " + string);
        }
        PreparedStatement preparedStatement = this.mDB.prepareStatement("DROP VIEW " + string);
        preparedStatement.execute();
    }

    private static class HistoryFrameContext {
        public String name;
        public String table;
        public HistoryFrame root;

        public HistoryFrameContext(String string, String string2) {
            this.name = string;
            this.table = string2;
        }
    }

    private class HistoryFrameWithContext {
        public HistoryFrame frame;
        public HistoryFrameContext context;

        public HistoryFrameWithContext(String string, HistoryFrame historyFrame) {
            this.frame = historyFrame;
            this.context = RuntimeEnvironment.this.getContext(string);
        }
    }

    private class TableInfo {
        private Set mProperties;
        int mCount = -1;

        public TableInfo(String string) throws Exception {
            if (RuntimeEnvironment.this.mTableInfo == null) {
                RuntimeEnvironment.this.mTableInfo = RuntimeEnvironment.this.mDB.prepareCall("{ call %Library.SQLCatalog_SQLFields ( ? ) }");
            }
            RuntimeEnvironment.this.mTableInfo.setString(1, string);
            ResultSet resultSet = RuntimeEnvironment.this.mTableInfo.executeQuery();
            this.mProperties = new HashSet();
            while (resultSet.next()) {
                String string2 = resultSet.getString("FIELD_NAME");
                this.mProperties.add(string2);
            }
            resultSet.close();
        }

        public boolean hasProperty(String string) {
            return this.mProperties.contains(string);
        }

        public boolean isEmpty() {
            return this.mProperties.isEmpty();
        }

        public int getCount() {
            return this.mCount;
        }

        protected void setCount(int n) {
            this.mCount = n;
        }
    }
}

