/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.model;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisExecutionContext;
import com.dbeaver.db.redis.model.RedisDataSourceInfo;
import com.dbeaver.db.redis.model.RedisDatabase;
import com.dbeaver.db.redis.model.RedisSQLDialect;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.AbstractSimpleDataSource;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.commands.ProtocolCommand;

public class RedisDataSource
extends AbstractSimpleDataSource<RedisExecutionContext>
implements DBPRefreshableObject,
DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(RedisDataSource.class);
    private static final int CLUSTER_MAX_ATTEMPTS = 5;
    @NotNull
    private UnifiedJedis jedisClient;
    private boolean useCluster;
    private List<RedisDatabase> databases;
    private RedisDataSourceInfo info;
    private TPRuleBasedScanner commandRuleManager;
    private Map<String, Method[]> commandMethods = new HashMap<String, Method[]>();
    private final Set<String> supportedCommands = new HashSet<String>();
    private RedisSQLDialect dialect;
    private Jedis jedis;

    public RedisDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBCException {
        super(container);
        try {
            this.initializeConnection(monitor, container);
        }
        catch (Exception e) {
            throw new DBCException("Error connection to Redis database", (Throwable)e);
        }
    }

    private void initializeConnection(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBCException {
        String userPassword;
        DBPConnectionConfiguration connectionInfo = container.getActualConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        String hostPort = connectionInfo.getHostPort();
        String url = null;
        if (connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL) {
            url = connectionInfo.getUrl();
        }
        int connectTimeout = CommonUtils.toInt((Object)connectionInfo.getProviderProperty("@dbeaver-redis.timeout.connect"), (int)10000);
        int socketTimeout = CommonUtils.toInt((Object)connectionInfo.getProviderProperty("@dbeaver-redis.timeout.socket"), (int)100000);
        String userName = connectionInfo.getUserName();
        if (CommonUtils.isEmpty((String)userName)) {
            userName = null;
        }
        if (CommonUtils.isEmpty((String)(userPassword = connectionInfo.getUserPassword()))) {
            userPassword = null;
        }
        boolean useSSL = false;
        SSLSocketFactory sslFactory = null;
        SSLParameters sslParameters = null;
        HostnameVerifier hostVerifier = null;
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("redis_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            useSSL = true;
            boolean skipHostValidation = sslConfig.getBooleanProperty("@dbeaver-redis.ssl.skipHostValidation");
            if (skipHostValidation) {
                hostVerifier = (s, sslSession) -> true;
            }
            try {
                SSLHandlerTrustStoreImpl.initializeTrustStore((DBRProgressMonitor)monitor, (DBPDataSource)this, (DBWHandlerConfiguration)sslConfig);
                sslFactory = SSLHandlerTrustStoreImpl.createTrustStoreSslSocketFactory((DBPDataSource)this, (DBWHandlerConfiguration)sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error initializing SSL trust store", (Throwable)e);
            }
            sslParameters = new SSLParameters();
        }
        this.useCluster = CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("redis.use.cluster"));
        boolean useClientName = CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("redis.set.client"));
        String clientName = useClientName ? Platform.getProduct().getId() : null;
        DefaultJedisClientConfig.Builder configBuilder = DefaultJedisClientConfig.builder().timeoutMillis(socketTimeout).connectionTimeoutMillis(connectTimeout).user(userName).password(userPassword).clientName(clientName).ssl(useSSL);
        if (sslFactory != null) {
            configBuilder.sslSocketFactory(sslFactory);
        }
        if (sslParameters != null) {
            configBuilder.sslParameters(sslParameters);
        }
        if (hostVerifier != null) {
            configBuilder.hostnameVerifier(hostVerifier);
        }
        DefaultJedisClientConfig config = configBuilder.build();
        ConnectionPoolConfig poolConfig = new ConnectionPoolConfig();
        HostAndPort hostAndPort = null;
        URI serviceURI = null;
        if (CommonUtils.isEmpty((String)url)) {
            hostAndPort = new HostAndPort(hostName, CommonUtils.toInt((Object)hostPort));
        } else {
            try {
                int divPos;
                serviceURI = new URI(url);
                if (CommonUtils.isEmpty((String)serviceURI.getUserInfo()) && !CommonUtils.isEmpty((String)userName) && (divPos = url.indexOf("://")) != -1) {
                    String userInfo = String.valueOf(userName) + ":" + CommonUtils.notEmpty((String)userPassword);
                    String urlWithAuth = String.valueOf(url.substring(0, divPos + 3)) + userInfo + "@" + url.substring(divPos + 3);
                    serviceURI = new URI(urlWithAuth);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new DBCException("Invalid Redis URI: " + url);
            }
        }
        this.jedisClient = this.useCluster ? new JedisCluster(hostAndPort, (JedisClientConfig)config, 5, (GenericObjectPoolConfig)poolConfig) : (CommonUtils.isEmpty((String)url) ? new JedisPooled((GenericObjectPoolConfig)poolConfig, hostAndPort, (JedisClientConfig)config) : new JedisPooled((GenericObjectPoolConfig)poolConfig, serviceURI, connectTimeout, socketTimeout));
        this.jedis = CommonUtils.isEmpty((String)url) ? new Jedis(hostAndPort, (JedisClientConfig)config) : new Jedis(serviceURI, (JedisClientConfig)config);
        this.executionContext = new RedisExecutionContext(this, "Main Redis Connection", null);
        ((RedisExecutionContext)this.executionContext).connect(monitor);
        this.initSQLDialect();
    }

    private void initSQLDialect() {
        this.initClientMethods();
        this.dialect = new RedisSQLDialect(this);
        SQLSyntaxManager commandSyntaxManager = new SQLSyntaxManager();
        commandSyntaxManager.init((SQLDialect)this.getSQLDialect(), this.getContainer().getPreferenceStore());
        SQLRuleManager ruleManager = new SQLRuleManager(commandSyntaxManager);
        ruleManager.loadRules((DBPDataSource)this, false);
        this.commandRuleManager = new TPRuleBasedScanner();
        this.commandRuleManager.setRules(ruleManager.getAllRules());
    }

    public Set<String> getSupportedCommands() {
        return this.supportedCommands;
    }

    @Deprecated
    public Map<String, Method[]> getCommandMethods() {
        return this.commandMethods;
    }

    @Deprecated
    public Method[] getCommandMethods(String command) {
        return this.commandMethods.get(command);
    }

    private void initClientMethods() {
        Method[] jedisMethods;
        Class clientClass = this.useCluster ? JedisCluster.class : Jedis.class;
        Protocol.Command[] commandArray = Protocol.Command.values();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            Protocol.Command pc = commandArray[n2];
            this.supportedCommands.add(pc.name());
            ++n2;
        }
        this.supportedCommands.addAll(Arrays.asList("JSON", "MGET", "TYPE", "STRAPPEND", "STRLEN", "ARRAPPEND", "ARRINDEX", "ARRINSERT", "ARRLEN", "ARRPOP", "ARRTRIM", "NUMINCRBY", "NUMMULTBY", "OBJKEYS", "OBJLEN"));
        Method[] methodArray = jedisMethods = clientClass.getMethods();
        int n3 = jedisMethods.length;
        n = 0;
        while (n < n3) {
            Method method = methodArray[n];
            if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !method.isAnnotationPresent(Deprecated.class) && method.getReturnType() != byte[].class) {
                boolean hasBadParams = false;
                Class<?>[] classArray = method.getParameterTypes();
                int n4 = classArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Class<?> paramType = classArray[n5];
                    if (paramType.isArray() && paramType.getComponentType() != String.class) {
                        hasBadParams = true;
                        break;
                    }
                    ++n5;
                }
                if (!hasBadParams) {
                    String commandName = method.getName().toLowerCase(Locale.ENGLISH);
                    Object[] methods = this.commandMethods.get(commandName);
                    methods = methods == null ? new Method[]{method} : (Method[])ArrayUtils.add(Method.class, (Object[])methods, (Object)method);
                    this.commandMethods.put(commandName, (Method[])methods);
                }
            }
            ++n;
        }
    }

    public boolean isCommand(String command) {
        return this.supportedCommands.contains(command.toUpperCase(Locale.ENGLISH));
    }

    public UnifiedJedis getClient() {
        return this.jedisClient;
    }

    public Jedis getJedis() {
        return this.jedis;
    }

    public boolean isUseCluster() {
        return this.useCluster;
    }

    @NotNull
    public <T> T acquireCommands(@NotNull Class<T> cmdClass) {
        try {
            return cmdClass.cast(this.jedisClient);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Can't cast Jedis to command interface " + cmdClass.getName());
        }
    }

    public RedisSQLDialect getSQLDialect() {
        return this.dialect;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new RedisDataSourceInfo(this);
        try {
            this.readDatabases();
            int defDatabase = CommonUtils.toInt((Object)this.getContainer().getConnectionConfiguration().getDatabaseName());
            if (defDatabase > 0 && defDatabase < 16) {
                RedisDatabase database = this.getDatabase(defDatabase);
                if (database == null) {
                    database = this.addDatabase(defDatabase);
                }
                if (database != null) {
                    ((RedisExecutionContext)this.executionContext).setDefaultCatalog(monitor, database, (DBSSchema)null);
                }
            }
        }
        catch (Exception e) {
            throw new DBException("Error initializing Redis connection", (Throwable)e);
        }
    }

    private void readDatabases() {
        this.databases = new ArrayList<RedisDatabase>();
        if (this.isUseCluster()) {
            RedisDatabase clusterDatabase = new RedisDatabase(this, "cluster", -1L);
            this.databases.add(clusterDatabase);
            ((RedisExecutionContext)this.executionContext).setDefaultDatabase(0);
        } else {
            Object keySpaceInfo = this.getClient().sendCommand((ProtocolCommand)Protocol.Command.INFO, new String[]{"keyspace"});
            if (keySpaceInfo instanceof byte[]) {
                keySpaceInfo = new String((byte[])keySpaceInfo);
            }
            if (this.databases.isEmpty()) {
                Map<String, Object> dbMap = RedisUtils.parseInfo((String)keySpaceInfo);
                for (Map.Entry<String, Object> db : dbMap.entrySet()) {
                    String keys;
                    int divPos;
                    long keyNumber = -1L;
                    Optional<String> keysParam = Arrays.stream(CommonUtils.toString((Object)db.getValue()).split(",")).filter(s -> s.startsWith("keys=")).findFirst();
                    if (keysParam.isPresent() && (divPos = (keys = keysParam.get()).indexOf("=")) != -1) {
                        keyNumber = CommonUtils.toLong((Object)keys.substring(divPos + 1));
                    }
                    RedisDatabase database = new RedisDatabase(this, db.getKey(), keyNumber);
                    this.databases.add(database);
                }
            }
        }
    }

    @NotNull
    public RedisExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        RedisExecutionContext context = new RedisExecutionContext(this, purpose, initFrom instanceof RedisExecutionContext ? ((RedisExecutionContext)initFrom).getDefaultDatabase() : ((RedisExecutionContext)this.executionContext).getDefaultDatabase());
        context.connect(monitor);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        RedisDataSource redisDataSource = this;
        synchronized (redisDataSource) {
            if (this.jedisClient != null) {
                this.jedisClient.close();
            }
            if (this.jedis != null) {
                this.jedis.close();
            }
        }
    }

    @Association
    public List<RedisDatabase> getDatabases() {
        return this.databases;
    }

    public RedisDatabase getDatabase(int dbNum) {
        for (RedisDatabase db : this.databases) {
            if (db.getId() != dbNum) continue;
            return db;
        }
        return null;
    }

    public RedisDatabase addDatabase(int dbNum) {
        RedisDatabase newDatabase = new RedisDatabase(this, "db" + dbNum, dbNum);
        this.databases.add(newDatabase);
        DBUtils.fireObjectAdd((DBSObject)newDatabase, Collections.emptyMap());
        return newDatabase;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) {
        return this.databases;
    }

    public RedisDatabase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) {
        return (RedisDatabase)DBUtils.findObject(this.databases, (String)childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return RedisDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) {
    }

    public String getKeyDivider() {
        String delimiter = this.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-redis.key.divider");
        if (!CommonUtils.isEmpty((String)delimiter)) {
            return delimiter;
        }
        return ":";
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.readDatabases();
        return this;
    }

    public synchronized String[] parseCommand(String query) {
        Document document = new Document(query);
        this.commandRuleManager.setRange((IDocument)document, 0, query.length());
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder part = new StringBuilder();
        while (true) {
            TPToken token;
            if ((token = this.commandRuleManager.nextToken()).isEOF() || token.isWhitespace()) {
                if (part.length() > 0) {
                    parts.add(part.toString());
                    part.setLength(0);
                }
                if (!token.isEOF()) continue;
                break;
            }
            try {
                String tokenText = document.get(this.commandRuleManager.getTokenOffset(), this.commandRuleManager.getTokenLength());
                part.append(tokenText);
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
            }
        }
        return parts.toArray(new String[0]);
    }

    public boolean isStatisticsCollected() {
        return true;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
    }
}

