/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseCore;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.cluster.DisconnectRequest;
import com.couchbase.client.core.message.cluster.DisconnectResponse;
import com.couchbase.client.core.message.cluster.OpenBucketRequest;
import com.couchbase.client.core.message.cluster.OpenBucketResponse;
import com.couchbase.client.core.message.cluster.SeedNodesRequest;
import com.couchbase.client.core.message.internal.DiagnosticsReport;
import com.couchbase.client.core.message.internal.DiagnosticsRequest;
import com.couchbase.client.core.message.internal.DiagnosticsResponse;
import com.couchbase.client.core.utils.ConnectionString;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.auth.Authenticator;
import com.couchbase.client.java.auth.CertAuthenticator;
import com.couchbase.client.java.auth.Credential;
import com.couchbase.client.java.auth.CredentialContext;
import com.couchbase.client.java.auth.PasswordAuthenticator;
import com.couchbase.client.java.cluster.AsyncClusterManager;
import com.couchbase.client.java.cluster.DefaultAsyncClusterManager;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.error.AuthenticationException;
import com.couchbase.client.java.error.AuthenticatorException;
import com.couchbase.client.java.error.BucketDoesNotExistException;
import com.couchbase.client.java.error.InvalidPasswordException;
import com.couchbase.client.java.error.MixedAuthenticationException;
import com.couchbase.client.java.query.AsyncN1qlQueryResult;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.util.Bootstrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public class CouchbaseAsyncCluster
implements AsyncCluster {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseAsyncCluster.class);
    public static final String DEFAULT_BUCKET = "default";
    public static final String DEFAULT_HOST = "127.0.0.1";
    private final ClusterFacade core;
    private final CouchbaseEnvironment environment;
    private final ConnectionString connectionString;
    private final Map<String, AsyncBucket> bucketCache;
    private final boolean sharedEnvironment;
    private Authenticator authenticator;

    public static CouchbaseAsyncCluster create() {
        return CouchbaseAsyncCluster.create(DEFAULT_HOST);
    }

    public static CouchbaseAsyncCluster create(CouchbaseEnvironment environment) {
        return CouchbaseAsyncCluster.create(environment, DEFAULT_HOST);
    }

    public static CouchbaseAsyncCluster create(String ... nodes) {
        return CouchbaseAsyncCluster.create(Arrays.asList(nodes));
    }

    public static CouchbaseAsyncCluster create(List<String> nodes) {
        return new CouchbaseAsyncCluster(DefaultCouchbaseEnvironment.create(), ConnectionString.fromHostnames(nodes), false);
    }

    public static CouchbaseAsyncCluster create(CouchbaseEnvironment environment, String ... nodes) {
        return CouchbaseAsyncCluster.create(environment, Arrays.asList(nodes));
    }

    public static CouchbaseAsyncCluster create(CouchbaseEnvironment environment, List<String> nodes) {
        return new CouchbaseAsyncCluster(environment, ConnectionString.fromHostnames(nodes), true);
    }

    public static CouchbaseAsyncCluster fromConnectionString(String connectionString) {
        return new CouchbaseAsyncCluster(DefaultCouchbaseEnvironment.create(), ConnectionString.create((String)connectionString), false);
    }

    public static CouchbaseAsyncCluster fromConnectionString(CouchbaseEnvironment environment, String connectionString) {
        return new CouchbaseAsyncCluster(environment, ConnectionString.create((String)connectionString), true);
    }

    CouchbaseAsyncCluster(CouchbaseEnvironment environment, ConnectionString connectionString, boolean sharedEnvironment) {
        this.sharedEnvironment = sharedEnvironment;
        if (connectionString.username() != null && !connectionString.username().equals("")) {
            this.authenticator = new PasswordAuthenticator(connectionString.username(), "");
        }
        this.core = new CouchbaseCore((CoreEnvironment)environment);
        SeedNodesRequest request = new SeedNodesRequest(CouchbaseAsyncCluster.assembleSeedNodes(connectionString, environment));
        this.core.send((CouchbaseRequest)request).toBlocking().single();
        this.environment = environment;
        this.connectionString = connectionString;
        this.bucketCache = new ConcurrentHashMap<String, AsyncBucket>();
    }

    private static List<String> assembleSeedNodes(ConnectionString connectionString, CouchbaseEnvironment environment) {
        ArrayList<String> seedNodes = new ArrayList<String>();
        if (environment.dnsSrvEnabled()) {
            CouchbaseAsyncCluster.seedNodesViaDnsSrv(connectionString, environment, seedNodes);
        } else {
            for (ConnectionString.UnresolvedSocket node : connectionString.hosts()) {
                seedNodes.add(node.hostname());
            }
        }
        if (seedNodes.isEmpty()) {
            seedNodes.add(DEFAULT_HOST);
        }
        return seedNodes;
    }

    private static void seedNodesViaDnsSrv(ConnectionString connectionString, CouchbaseEnvironment environment, List<String> seedNodes) {
        if (connectionString.hosts().size() == 1) {
            ConnectionString.UnresolvedSocket lookupNode = (ConnectionString.UnresolvedSocket)connectionString.hosts().get(0);
            LOGGER.debug("Attempting to load DNS SRV records from {}.", connectionString.allHosts().get(0));
            try {
                List<String> foundNodes = Bootstrap.fromDnsSrv(lookupNode.hostname(), false, environment.sslEnabled());
                if (foundNodes.isEmpty()) {
                    throw new IllegalStateException("DNS SRV list is empty.");
                }
                seedNodes.addAll(foundNodes);
                LOGGER.info("Loaded seed nodes from DNS SRV {}.", (Object)RedactableArgument.system(foundNodes));
            }
            catch (Exception ex) {
                LOGGER.warn("DNS SRV lookup failed, proceeding with normal bootstrap.", (Throwable)ex);
                seedNodes.add(lookupNode.hostname());
            }
        } else {
            LOGGER.info("DNS SRV enabled, but less or more than one seed node given. Proceeding with normal bootstrap.");
            for (ConnectionString.UnresolvedSocket node : connectionString.hosts()) {
                seedNodes.add(node.hostname());
            }
        }
    }

    @Override
    public Observable<AsyncBucket> openBucket() {
        return this.openBucket(DEFAULT_BUCKET, null, null);
    }

    @Override
    public Observable<AsyncBucket> openBucket(String name) {
        return this.openBucket(name, new ArrayList());
    }

    @Override
    public Observable<AsyncBucket> openBucket(String name, List<Transcoder<? extends Document, ?>> transcoders) {
        Credential cred;
        block2: {
            cred = new Credential(name, null);
            try {
                cred = this.getSingleCredential(CredentialContext.BUCKET_KV, name);
            }
            catch (AuthenticatorException e) {
                if (e.foundCredentials() <= 1) break block2;
                return Observable.error((Throwable)((Object)e));
            }
        }
        return this.openBucketInternal(name, cred.login(), cred.password(), transcoders);
    }

    @Override
    public Observable<AsyncBucket> openBucket(String name, String password) {
        return this.openBucket(name, password, null);
    }

    @Override
    public Observable<AsyncBucket> openBucket(String name, String password, List<Transcoder<? extends Document, ?>> transcoders) {
        if (this.authenticator instanceof PasswordAuthenticator || this.authenticator instanceof CertAuthenticator) {
            return Observable.error((Throwable)((Object)new MixedAuthenticationException("Mixed mode authentication not allowed, use Bucket credentials, User credentials (rbac) or Certificate auth")));
        }
        return this.openBucketInternal(name, name, password, transcoders);
    }

    private Observable<AsyncBucket> openBucketInternal(final String name, final String username, String password, List<Transcoder<? extends Document, ?>> transcoders) {
        if (this.environment.certAuthEnabled() && !(this.authenticator instanceof CertAuthenticator)) {
            return Observable.error((Throwable)((Object)new AuthenticationException("CertAuthenticator must be used when certAuthEnabled on the Environment")));
        }
        if (name == null || name.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException("Bucket name is not allowed to be null or empty."));
        }
        AsyncBucket cachedBucket = this.getCachedBucket(name);
        if (cachedBucket != null) {
            return Observable.just((Object)cachedBucket);
        }
        final String pass = password == null ? "" : password;
        final ArrayList trans = transcoders == null ? new ArrayList() : transcoders;
        return Observable.defer((Func0)new Func0<Observable<OpenBucketResponse>>(){

            public Observable<OpenBucketResponse> call() {
                return CouchbaseAsyncCluster.this.core.send((CouchbaseRequest)new OpenBucketRequest(name, username, pass));
            }
        }).map((Func1)new Func1<CouchbaseResponse, AsyncBucket>(){

            public AsyncBucket call(CouchbaseResponse response) {
                if (response.status() != ResponseStatus.SUCCESS) {
                    throw new CouchbaseException("Could not open bucket.");
                }
                CouchbaseAsyncBucket bucket = new CouchbaseAsyncBucket(CouchbaseAsyncCluster.this.core, CouchbaseAsyncCluster.this.environment, name, username, pass, trans);
                CouchbaseAsyncCluster.this.bucketCache.put(name, bucket);
                return bucket;
            }
        }).onErrorResumeNext((Func1)new OpenBucketErrorHandler(name));
    }

    private AsyncBucket getCachedBucket(String name) {
        AsyncBucket cachedBucket = this.bucketCache.get(name);
        if (cachedBucket != null) {
            if (cachedBucket.isClosed()) {
                LOGGER.debug("Not returning cached async bucket \"{}\", because it is closed.", (Object)name);
                this.bucketCache.remove(name);
            } else {
                LOGGER.debug("Returning still open, cached async bucket \"{}\"", (Object)name);
                return cachedBucket;
            }
        }
        return null;
    }

    @Override
    public Observable<Boolean> disconnect() {
        return this.core.send((CouchbaseRequest)new DisconnectRequest()).flatMap((Func1)new Func1<DisconnectResponse, Observable<Boolean>>(){

            public Observable<Boolean> call(DisconnectResponse disconnectResponse) {
                return CouchbaseAsyncCluster.this.sharedEnvironment ? Observable.just((Object)true) : CouchbaseAsyncCluster.this.environment.shutdownAsync();
            }
        }).doOnNext((Action1)new Action1<Boolean>(){

            public void call(Boolean aBoolean) {
                CouchbaseAsyncCluster.this.bucketCache.clear();
            }
        });
    }

    @Override
    public Observable<AsyncClusterManager> clusterManager(String username, String password) {
        return Observable.just((Object)DefaultAsyncClusterManager.create(username, password, this.connectionString, this.environment, this.core));
    }

    protected Credential getSingleCredential(CredentialContext context, String specific) {
        if (this.authenticator == null || this.authenticator.isEmpty()) {
            throw new AuthenticatorException("Attempted an authenticated operation with no Authenticator, or an empty Authenticator", context, specific, 0);
        }
        List<Credential> creds = this.authenticator.getCredentials(context, specific);
        if (creds == null || creds.isEmpty()) {
            throw new AuthenticatorException("Authenticator doesn't contain a credential for this operation, expected 1", context, specific, 0);
        }
        if (creds.size() != 1) {
            throw new AuthenticatorException("Authenticator returned more than 1 credentials for this operation, expected 1", context, specific, creds.size());
        }
        Credential cred = creds.get(0);
        return cred;
    }

    @Override
    public Observable<AsyncClusterManager> clusterManager() {
        try {
            Credential cred = this.getSingleCredential(CredentialContext.CLUSTER_MANAGEMENT, null);
            return this.clusterManager(cred.login(), cred.password());
        }
        catch (AuthenticatorException e) {
            return Observable.error((Throwable)((Object)e));
        }
    }

    @Override
    public Observable<ClusterFacade> core() {
        return Observable.just((Object)this.core);
    }

    @Override
    public CouchbaseAsyncCluster authenticate(Authenticator auth) {
        if (auth == null) {
            LOGGER.trace("Authenticator was set to null, ignored");
            return this;
        }
        if (this.authenticator != null && this.authenticator.getClass() != auth.getClass()) {
            throw new MixedAuthenticationException("Mixed mode authentication not allowed, use either ClassicAuthenticator , PasswordAuthenticator or CertAuthenticator");
        }
        if (this.authenticator instanceof PasswordAuthenticator) {
            PasswordAuthenticator pa = (PasswordAuthenticator)this.authenticator;
            PasswordAuthenticator newPa = (PasswordAuthenticator)auth;
            if (newPa.username() == null) {
                auth = new PasswordAuthenticator(pa.username(), newPa.password());
            }
        }
        if (auth instanceof CertAuthenticator) {
            if (!this.environment.certAuthEnabled()) {
                throw new AuthenticationException("CertAuthenticator used, but certAuthEnabled not enabled on the Environment");
            }
            if (this.environment.sslKeystore() == null && this.environment.sslTruststore() == null && (this.environment.sslKeystoreFile() == null || this.environment.sslKeystoreFile().isEmpty()) && (this.environment.sslTruststoreFile() == null || this.environment.sslTruststoreFile().isEmpty())) {
                throw new AuthenticationException("CertAuthenticator used, but neither keystore nor truststore configured");
            }
        } else if (this.environment.certAuthEnabled()) {
            throw new AuthenticationException("Only CertAuthenticator can be used when certAuthEnabled on the Environment");
        }
        this.authenticator = auth;
        if (!this.bucketCache.isEmpty()) {
            LOGGER.warn("Authenticator was switched while {} buckets are still open. Operations on these buckets will continue using the old Authenticator until you close and reopen them", (Object)this.bucketCache.size());
        }
        return this;
    }

    @Override
    public AsyncCluster authenticate(String username, String password) {
        return this.authenticate(new PasswordAuthenticator(username, password));
    }

    @InterfaceStability.Uncommitted
    @InterfaceAudience.Private
    public Authenticator authenticator() {
        return this.authenticator;
    }

    @Override
    public Observable<AsyncN1qlQueryResult> query(N1qlQuery query) {
        AsyncBucket delegateBucket = null;
        for (AsyncBucket asyncBucket : this.bucketCache.values()) {
            if (asyncBucket.isClosed()) continue;
            delegateBucket = asyncBucket;
            break;
        }
        if (delegateBucket == null) {
            return Observable.error((Throwable)new UnsupportedOperationException("Cluster level querying is only available when at least 1 bucket is opened"));
        }
        if (this.authenticator == null) {
            throw new IllegalStateException("An Authenticator is required to perform cluster level querying");
        }
        try {
            List<Credential> creds = this.authenticator.getCredentials(CredentialContext.CLUSTER_N1QL, null);
            if (creds.isEmpty()) {
                throw new IllegalStateException("CLUSTER_N1QL credentials are required in the Authenticator for cluster level querying");
            }
            query.params().withCredentials(creds);
            LOGGER.trace("Added {} credentials to a cluster-level N1qlQuery", (Object)creds.size());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Couldn't retrieve credentials for cluster level querying from Authenticator", e);
        }
        return delegateBucket.query(query);
    }

    @Override
    public Observable<DiagnosticsReport> diagnostics(String reportId) {
        return this.core.send((CouchbaseRequest)new DiagnosticsRequest(reportId)).map((Func1)new Func1<DiagnosticsResponse, DiagnosticsReport>(){

            public DiagnosticsReport call(DiagnosticsResponse response) {
                return response.diagnosticsReport();
            }
        });
    }

    @Override
    public Observable<DiagnosticsReport> diagnostics() {
        return this.diagnostics(null);
    }

    static class OpenBucketErrorHandler
    implements Func1<Throwable, Observable<AsyncBucket>> {
        private final String name;

        public OpenBucketErrorHandler(String name) {
            this.name = name;
        }

        public Observable<AsyncBucket> call(Throwable throwable) {
            if (throwable instanceof ConfigurationException) {
                if (throwable.getCause() instanceof IllegalStateException && throwable.getCause().getMessage().contains("NOT_EXISTS")) {
                    return Observable.error((Throwable)((Object)new BucketDoesNotExistException("Bucket \"" + this.name + "\" does not exist.")));
                }
                if (throwable.getCause() instanceof IllegalStateException && throwable.getCause().getMessage().contains("Unauthorized")) {
                    return Observable.error((Throwable)((Object)new InvalidPasswordException("Passwords for bucket \"" + this.name + "\" do not match.")));
                }
                return Observable.error((Throwable)throwable);
            }
            if (throwable instanceof CouchbaseException) {
                return Observable.error((Throwable)throwable);
            }
            return Observable.error((Throwable)new CouchbaseException(throwable));
        }
    }
}

