/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.jgssp2tdnego.TdnegoContext;
import com.teradata.tdgss.jgssp2tdnego.TdnegoCredential;
import com.teradata.tdgss.jgssp2tdnego.TdnegoMinorStatus;
import com.teradata.tdgss.jgssp2tdnego.TdnegoName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class TdnegoMechanism
implements GSSMechanism {
    private final TdgssLogger logger;
    private static Oid mechOid;
    static final Oid MECH_OID;
    private Vector mechImplementations;
    private TdgssConfigApi confApi;
    protected static short servicesAvailable;
    static /* synthetic */ Class class$com$teradata$tdgss$jtdgss$TdgssLogger;

    public TdnegoMechanism(TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        servicesAvailable = 0;
        this.mechImplementations = new Vector();
        this.confApi = TdgssConfigApi.getInstance();
        if (this.confApi != null) {
            String[] stringArray = this.confApi.getEnabledNegMech(MECH_OID);
            for (int i = 0; i < stringArray.length; ++i) {
                GSSMechanism gSSMechanism = this.createObject(stringArray[i], this.logger);
                if (gSSMechanism == null) continue;
                this.mechImplementations.addElement(gSSMechanism);
                servicesAvailable = (short)(servicesAvailable | gSSMechanism.getServices());
            }
        }
    }

    private GSSMechanism createObject(String string, TdgssLogger tdgssLogger) {
        GSSMechanism gSSMechanism = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(class$com$teradata$tdgss$jtdgss$TdgssLogger == null ? (class$com$teradata$tdgss$jtdgss$TdgssLogger = TdnegoMechanism.class$("com.teradata.tdgss.jtdgss.TdgssLogger")) : class$com$teradata$tdgss$jtdgss$TdgssLogger);
            gSSMechanism = (GSSMechanism)constructor.newInstance(tdgssLogger);
        }
        catch (InstantiationException instantiationException) {
            tdgssLogger.error(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            tdgssLogger.error(illegalAccessException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            tdgssLogger.error(classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            tdgssLogger.error("Constructor for " + string + " does not exist", noSuchMethodException);
        }
        catch (SecurityException securityException) {
            tdgssLogger.error("No access to constructor for " + string, securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            tdgssLogger.error("Programming error: argument passed to the constructor for class " + string + " is incorrect", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            tdgssLogger.error("Constructor for class " + string + " threw an exception", invocationTargetException);
        }
        return gSSMechanism;
    }

    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            GSSMechanism gSSMechanism = (GSSMechanism)this.mechImplementations.get(i);
            Oid oid = gSSMechanism.getMech();
            Object object2 = ((TdnegoCredential)gSSCredential).getCredForMech(oid);
            if (!(object2 instanceof GSSCredential) || !gSSMechanism.acceptable(object, (GSSCredential)object2, objectArray)) continue;
            return true;
        }
        return false;
    }

    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForAccept ");
        }
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10, TdnegoMinorStatus.TDNEGO_ERR_INVALID_TOKEN);
        }
        return new TdnegoContext((TdnegoCredential)gSSCredential, objectArray, this.mechImplementations, this.logger);
    }

    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForInit ");
        }
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s = (short)(s & servicesAvailable))) {
            throw new TdgssException(10, TdnegoMinorStatus.TDNEGO_ERR_INVALID_TOKEN);
        }
        return new TdnegoContext((TdnegoCredential)gSSCredential, (TdnegoName)gSSName, n, objectArray, s, this.mechImplementations, this.logger);
    }

    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof TdnegoCredential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIAL: must be a credential created by this mech");
            }
            return false;
        }
        if (gSSName != null && !(gSSName instanceof TdnegoName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("must be a name created by this mech");
            }
            return false;
        }
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            GSSMechanism gSSMechanism = (GSSMechanism)this.mechImplementations.get(i);
            Object object = null;
            Oid oid = gSSMechanism.getMech();
            if (gSSCredential != null) {
                object = ((TdnegoCredential)gSSCredential).getCredForMech(oid);
            }
            Object object2 = null;
            if (gSSName != null) {
                object2 = ((TdnegoName)gSSName).getNameForMech(oid);
            }
            if (!(object instanceof GSSCredential) || !gSSMechanism.initable((GSSCredential)object, (GSSName)object2, n, objectArray, s)) continue;
            return true;
        }
        return false;
    }

    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return null;
        }
        return new TdnegoCredential((TdnegoName)gSSName, n, n2, this.mechImplementations, this.logger);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return null;
        }
        return new TdnegoName(byArray, oid, this.mechImplementations, this.logger);
    }

    public Oid[] getNames() {
        ArrayList<Oid> arrayList = new ArrayList<Oid>();
        if (this.mechImplementations == null || this.mechImplementations.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            GSSMechanism gSSMechanism = (GSSMechanism)this.mechImplementations.get(i);
            Oid[] oidArray = gSSMechanism.getNames();
            for (int j = 0; j < oidArray.length; ++j) {
                Oid oid = oidArray[j];
                if (arrayList.contains(oid)) continue;
                arrayList.add(oid);
            }
        }
        Oid[] oidArray = new Oid[arrayList.size()];
        for (int i = 0; i < oidArray.length; ++i) {
            oidArray[i] = (Oid)arrayList.get(i);
        }
        return oidArray;
    }

    public Oid getMech() {
        return MECH_OID;
    }

    public short getServices() {
        return servicesAvailable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            mechOid = new Oid("1.3.6.1.4.1.28698.4.302.1.3");
        }
        catch (GSSException gSSException) {
            ExceptionInInitializerError exceptionInInitializerError = new ExceptionInInitializerError("Oid string is incorrectly formatted");
            exceptionInInitializerError.initCause(gSSException);
            throw exceptionInInitializerError;
        }
        MECH_OID = mechOid;
    }
}

