/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.logging.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CertChecker {
    public static void checkCert(TDNetworkIOIF tDNetworkIOIF, TDNetworkIOIF.ConnectThread connectThread, String[] stringArray) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object;
        X509Certificate[] x509CertificateArray;
        SSLSession sSLSession = ((SSLSocket)connectThread.m_socket).getSession();
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("SSLSession.getProtocol=" + sSLSession.getProtocol() + " getCipherSuite=" + sSLSession.getCipherSuite());
        }
        List<String> list = tDNetworkIOIF.m_con.getURLParameters().getSSLCA() != null ? Collections.singletonList(tDNetworkIOIF.m_con.getURLParameters().getSSLCA()) : null;
        String string = tDNetworkIOIF.m_con.getURLParameters().getSSLCAPath();
        String string2 = tDNetworkIOIF.m_con.getURLParameters().getSSLTrustStore();
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug(">>>>> createTrustManagerFromPEMFiles(" + list + ")");
        }
        X509TrustManager x509TrustManager = CertChecker.createTrustManagerFromPEMFiles(list, tDNetworkIOIF.log);
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("<<<<< createTrustManagerFromPEMFiles(" + list + ") returned " + x509TrustManager);
        }
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug(">>>>> createTrustManagerFromPEMDirectory(" + string + ")");
        }
        X509TrustManager x509TrustManager2 = CertChecker.createTrustManagerFromPEMDirectory(string, tDNetworkIOIF.log);
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("<<<<< createTrustManagerFromPEMDirectory(" + string + ") returned " + x509TrustManager2);
        }
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug(">>>>> createTrustManagerFromTrustStoreFile(" + string2 + ")");
        }
        X509TrustManager x509TrustManager3 = CertChecker.createTrustManagerFromTrustStoreFile(string2);
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("<<<<< createTrustManagerFromTrustStoreFile(" + string2 + ") returned " + x509TrustManager3);
        }
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug(">>>>> getDefaultTrustManager");
        }
        X509TrustManager x509TrustManager4 = CertChecker.getDefaultTrustManager(tDNetworkIOIF.log);
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("<<<<< getDefaultTrustManager returned " + x509TrustManager4);
        }
        Certificate[] certificateArray = null;
        try {
            certificateArray = sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            tDNetworkIOIF.log.error("getPeerCertificates failed for connection to " + connectThread.m_isa, sSLPeerUnverifiedException);
        }
        X509Certificate[] x509CertificateArray2 = x509CertificateArray = certificateArray instanceof X509Certificate[] ? (X509Certificate[])certificateArray : null;
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            for (int i = 0; certificateArray != null && i < certificateArray.length; ++i) {
                object = x509CertificateArray != null ? x509CertificateArray[i] : null;
                tDNetworkIOIF.log.info("getPeerCertificates returned certificate " + (i + 1) + " of " + certificateArray.length + (i == 0 ? " which is the peer certificate" : "") + "\n  Certificate " + (object != null ? "is" : "is not") + " an X509Certificate" + "\n  Certificate date range is " + CertChecker.formatDateRange((X509Certificate)object) + "\n  Certificate " + CertChecker.formatValidity((X509Certificate)object) + "\n  Certificate purpose is " + CertChecker.formatCertPurpose((X509Certificate)object) + "\n  Subject Distinguished Name (DN) is " + CertChecker.formatDN((X509Certificate)object) + "\n  Subject Common Name (CN) is " + CertChecker.formatCN((X509Certificate)object) + "\n  Subject Alternative Names (SANs) are " + CertChecker.formatSANs((X509Certificate)object) + "\n" + CertChecker.formatCert(certificateArray[i]));
            }
        }
        List list2 = CertChecker.getValidityProblems(x509CertificateArray);
        object = CertChecker.getServerCertProblems(x509TrustManager, x509CertificateArray, stringArray[0], "SSLCA=" + CertChecker.formatList(list, null, null));
        List list3 = CertChecker.getServerCertProblems(x509TrustManager2, x509CertificateArray, stringArray[0], "SSLCAPATH=" + string);
        List list4 = CertChecker.getServerCertProblems(x509TrustManager3, x509CertificateArray, stringArray[0], "SSLTRUSTSTORE=" + string2);
        List list5 = CertChecker.getServerCertProblems(x509TrustManager4, x509CertificateArray, stringArray[0], "Default Java");
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            tDNetworkIOIF.log.info("getValidityProblems " + (list2.isEmpty() ? "accepted certificate" : "found " + list2.size() + " certificate problem(s): " + CertChecker.formatList(list2, ", ", null)));
            tDNetworkIOIF.log.info("createTrustManagerFromPEMFiles(" + list + ") " + (x509TrustManager == null ? "is not available" : (object.isEmpty() ? "accepted certificate" : "found " + object.size() + " certificate problem(s): " + CertChecker.formatList((List)object, ", ", null))));
            tDNetworkIOIF.log.info("createTrustManagerFromPEMDirectory(" + string + ") " + (x509TrustManager2 == null ? "is not available" : (list3.isEmpty() ? "accepted certificate" : "found " + list3.size() + " certificate problem(s): " + CertChecker.formatList(list3, ", ", null))));
            tDNetworkIOIF.log.info("createTrustManagerFromTrustStoreFile(" + string2 + ") " + (x509TrustManager3 == null ? "is not available" : (list4.isEmpty() ? "accepted certificate" : "found " + list4.size() + " certificate problem(s): " + CertChecker.formatList(list4, ", ", null))));
            tDNetworkIOIF.log.info("getDefaultTrustManager " + (x509TrustManager4 == null ? "is not available" : (list5.isEmpty() ? "accepted certificate" : "found " + list5.size() + " certificate problem(s): " + CertChecker.formatList(list5, ", ", null))));
        }
        boolean bl4 = x509TrustManager != null || x509TrustManager2 != null || x509TrustManager3 != null || x509TrustManager4 != null;
        boolean bl5 = x509TrustManager != null && object.isEmpty();
        boolean bl6 = x509TrustManager2 != null && list3.isEmpty();
        boolean bl7 = x509TrustManager3 != null && list4.isEmpty();
        boolean bl8 = x509TrustManager4 != null && list5.isEmpty();
        boolean bl9 = bl5 || bl6 || bl7 || bl8;
        boolean bl10 = bl3 = list2.isEmpty() && bl4 && bl9;
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            tDNetworkIOIF.log.info("SSLMODE=VERIFY-CA would " + (bl3 ? "accept" : "reject") + " this connection");
        }
        X509Certificate x509Certificate = x509CertificateArray != null ? x509CertificateArray[0] : null;
        String[] stringArray2 = connectThread.m_isa.getAddress().toString().split("/");
        boolean bl11 = stringArray2[0].length() == 0;
        String string3 = bl11 ? null : tDNetworkIOIF.getOriginalHostName();
        String string4 = bl11 ? null : stringArray2[0];
        String string5 = stringArray2[1];
        List list6 = CertChecker.getCertHostNameProblems(x509Certificate, "Hostname", string3, tDNetworkIOIF.log);
        List list7 = CertChecker.getCertHostNameProblems(x509Certificate, "Resolved", string4, tDNetworkIOIF.log);
        List list8 = CertChecker.getCertHostNameProblems(x509Certificate, "IP Address", string5, tDNetworkIOIF.log);
        boolean bl12 = list6.isEmpty();
        boolean bl13 = list7.isEmpty();
        boolean bl14 = list8.isEmpty();
        boolean bl15 = bl2 = bl3 && (bl12 || bl14);
        if (tDNetworkIOIF.log.isInfoEnabled()) {
            tDNetworkIOIF.log.info("SSLMODE=VERIFY-FULL would " + (bl2 ? "accept" : "reject") + " this connection");
        }
        connectThread.m_sCertStatus = (list2.isEmpty() ? "V" : "I") + ",P" + (x509TrustManager == null ? "U" : (bl5 ? "A" : "R")) + ",D" + (x509TrustManager2 == null ? "U" : (bl6 ? "A" : "R")) + ",T" + (x509TrustManager3 == null ? "U" : (bl7 ? "A" : "R")) + ",J" + (x509TrustManager4 == null ? "U" : (bl8 ? "A" : "R")) + ",C" + (bl3 ? "Y" : "N") + ",H" + (bl11 ? "U" : (bl12 ? "Y" : "N")) + ",R" + (bl11 ? "U" : (bl13 ? "Y" : "N")) + ",I" + (bl14 ? "Y" : "N") + ",F" + (bl2 ? "Y" : "N");
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("checkCert: t.m_sCertStatus=" + connectThread.m_sCertStatus);
        }
        boolean bl16 = tDNetworkIOIF.m_con.getURLParameters().getSSLModeLevel() == 5 && !bl3;
        boolean bl17 = bl = tDNetworkIOIF.m_con.getURLParameters().getSSLModeLevel() == 6 && !bl2;
        if (bl16 || bl) {
            ArrayList<CertificateException> arrayList = new ArrayList<CertificateException>(list2);
            if (!bl4) {
                arrayList.add(new CertificateException("No TrustManager available to verify certificate"));
            } else if (!bl9) {
                arrayList.addAll((Collection<CertificateException>)object);
                arrayList.addAll(list3);
                arrayList.addAll(list4);
                arrayList.addAll(list5);
            }
            if (bl) {
                arrayList.addAll(list6);
                arrayList.addAll(list8);
            }
            String string6 = CertChecker.formatList(arrayList, ", ", tDNetworkIOIF.m_con.getURLParameters().getSSLMode() + " error");
            tDNetworkIOIF.log.error(string6);
            throw new IOException(string6);
        }
    }

    private static List getCertHostNameProblems(X509Certificate x509Certificate, String string, String string2, Log log) {
        ArrayList<CertificateException> arrayList = new ArrayList<CertificateException>();
        if (string2 == null) {
            arrayList.add(new CertificateException(string + " is not available to match Subject CN or SANs"));
        } else {
            boolean bl;
            String string3 = CertChecker.extractCNfromCert(x509Certificate);
            boolean bl2 = bl = string3 != null && string2.matches(CertChecker.convertHostNamePatternToRegexPattern(string3));
            if (log.isInfoEnabled()) {
                log.info(string + " " + string2 + " " + (bl ? "matches" : "does not match") + " Subject CN" + (string3 != null ? " " + string3 : ""));
            }
            ExtractedSANs extractedSANs = CertChecker.extractSANsFromCert(x509Certificate);
            if (extractedSANs.ex != null && log.isInfoEnabled()) {
                log.info(string + " " + string2 + " extractSANsFromCert: " + extractedSANs.ex);
            }
            List list = CertChecker.findMatchingPatterns(string2, CertChecker.convertHostNamePatternsToRegexPatterns(extractedSANs.list));
            if (log.isInfoEnabled()) {
                log.info(string + " " + string2 + " " + (list.isEmpty() ? "does not match any SANs" : "matches SANs " + CertChecker.formatList(list, ", ", null)));
            }
            if (!bl && list.isEmpty()) {
                if (!bl) {
                    arrayList.add(new CertificateException(string + " " + string2 + (string3 != null ? " does not match Subject CN " + string3 : " cannnot match missing Subject CN")));
                }
                if (extractedSANs.ex != null) {
                    arrayList.add(extractedSANs.ex);
                }
                if (list.isEmpty()) {
                    arrayList.add(new CertificateException(string + " " + string2 + " does not match any SANs from certificate: " + extractedSANs.list));
                }
            }
        }
        return arrayList;
    }

    private static String convertHostNamePatternToRegexPattern(String string) {
        return string.replaceAll("[\\W]", "\\\\$0").replaceAll("\\\\\\*", "[^.]*");
    }

    private static List convertHostNamePatternsToRegexPatterns(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(CertChecker.convertHostNamePatternToRegexPattern((String)iterator.next()));
            }
        }
        return arrayList;
    }

    private static List findMatchingPatterns(String string, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string.matches(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static X509TrustManager getDefaultTrustManager(Log log) {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            log.error("Could not obtain default TrustManagerFactory: " + generalSecurityException);
            return null;
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length != 1 || !(trustManagerArray[0] instanceof X509TrustManager)) {
            log.error("Could not obtain default X509TrustManager");
            return null;
        }
        return (X509TrustManager)trustManagerArray[0];
    }

    private static X509TrustManager createTrustManagerFromPEMFiles(List list, Log log) {
        TrustManagerFactory trustManagerFactory;
        Object object;
        TrustManager[] trustManagerArray;
        CertificateFactory certificateFactory;
        KeyStore keyStore;
        if (list == null) {
            return null;
        }
        String[] stringArray = list.toArray(new String[0]);
        String string = KeyStore.getDefaultType();
        try {
            keyStore = KeyStore.getInstance(string);
        }
        catch (KeyStoreException keyStoreException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not obtain " + string + " key store");
            illegalArgumentException.initCause(keyStoreException);
            throw illegalArgumentException;
        }
        try {
            keyStore.load(null, null);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not load " + string + " key store");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not obtain X.509 certificate factory");
            illegalArgumentException.initCause(certificateException);
            throw illegalArgumentException;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Collection<? extends Certificate> collection;
            Certificate[] certificateArray;
            trustManagerArray = stringArray[i];
            try {
                object = new FileInputStream((String)trustManagerArray);
            }
            catch (Exception exception) {
                certificateArray = new IllegalArgumentException("Could not access server certificate file " + (String)trustManagerArray);
                certificateArray.initCause(exception);
                throw certificateArray;
            }
            try {
                collection = certificateFactory.generateCertificates((InputStream)object);
            }
            catch (CertificateException certificateException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not obtain server certificate from file " + (String)trustManagerArray);
                illegalArgumentException.initCause(certificateException);
                throw illegalArgumentException;
            }
            finally {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("No server certificate found in file " + (String)trustManagerArray);
            }
            certificateArray = collection.toArray(new Certificate[0]);
            for (int j = 0; j < certificateArray.length; ++j) {
                String string2 = (String)trustManagerArray + "[" + j + "]";
                if (log.isDebugEnabled()) {
                    log.debug(string2);
                }
                try {
                    keyStore.setCertificateEntry(string2, certificateArray[j]);
                    continue;
                }
                catch (Exception exception) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not set " + string + " key store server certificate from file " + (String)trustManagerArray);
                    illegalArgumentException.initCause(exception);
                    throw illegalArgumentException;
                }
            }
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            object = new IllegalArgumentException("Could not obtain TrustManagerFactory");
            ((Throwable)object).initCause(generalSecurityException);
            throw object;
        }
        trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length != 1 || !(trustManagerArray[0] instanceof X509TrustManager)) {
            throw new IllegalArgumentException("Could not obtain X509TrustManager for " + string + " key store");
        }
        return (X509TrustManager)trustManagerArray[0];
    }

    private static X509TrustManager createTrustManagerFromPEMDirectory(String string, Log log) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(string + " is not a directory");
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".pem");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            throw new IllegalArgumentException("Unable to access directory " + string);
        }
        if (fileArray.length == 0) {
            throw new IllegalArgumentException("No .pem files found in directory " + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i].toString());
        }
        return CertChecker.createTrustManagerFromPEMFiles(arrayList, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509TrustManager createTrustManagerFromTrustStoreFile(String string) {
        TrustManagerFactory trustManagerFactory;
        KeyStore keyStore;
        FileInputStream fileInputStream;
        if (string == null) {
            return null;
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not access TrustStore file " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        String string2 = KeyStore.getDefaultType();
        try {
            try {
                keyStore = KeyStore.getInstance(string2);
            }
            catch (KeyStoreException keyStoreException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not obtain " + string2 + " key store");
                illegalArgumentException.initCause(keyStoreException);
                throw illegalArgumentException;
            }
            try {
                keyStore.load(fileInputStream, null);
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not load " + string2 + " TrustStore file " + string);
                illegalArgumentException.initCause(exception);
                throw illegalArgumentException;
            }
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not obtain TrustManagerFactory");
            illegalArgumentException.initCause(generalSecurityException);
            throw illegalArgumentException;
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length != 1 || !(trustManagerArray[0] instanceof X509TrustManager)) {
            throw new IllegalArgumentException("Could not obtain X509TrustManager for " + string2 + " key store");
        }
        return (X509TrustManager)trustManagerArray[0];
    }

    private static String formatDateRange(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "not available";
        }
        return x509Certificate.getNotBefore() + " to " + x509Certificate.getNotAfter();
    }

    private static List getValidityProblems(X509Certificate[] x509CertificateArray) {
        ArrayList<CertificateException> arrayList = new ArrayList<CertificateException>();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            arrayList.add(new CertificateException("Cannot check server certificate validity because server certificate is missing"));
        } else {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                try {
                    x509CertificateArray[i].checkValidity();
                    continue;
                }
                catch (CertificateException certificateException) {
                    arrayList.add(certificateException);
                }
            }
        }
        return arrayList;
    }

    private static String formatValidity(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "validity is not available";
        }
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateException certificateException) {
            return "is invalid due to " + certificateException;
        }
        return "is valid";
    }

    private static String formatCertPurpose(X509Certificate x509Certificate) {
        boolean[] blArray;
        boolean[] blArray2 = blArray = x509Certificate != null ? x509Certificate.getKeyUsage() : null;
        if (blArray == null) {
            return "not available";
        }
        String[] stringArray = new String[]{"digitalSignature(0)", "nonRepudiation(1)", "keyEncipherment(2)", "dataEncipherment(3)", "keyAgreement(4)", "keyCertSign(5)", "cRLSign(6)", "encipherOnly(7)", "decipherOnly(8)"};
        String string = "";
        for (int i = 0; i < blArray.length; ++i) {
            string = string + (!blArray[i] ? "" : (string.length() > 0 ? ", " : "") + (i < stringArray.length ? stringArray[i] : "unknown(" + i + ")"));
        }
        return string;
    }

    private static String formatDN(X509Certificate x509Certificate) {
        Principal principal = x509Certificate != null ? x509Certificate.getSubjectDN() : null;
        String string = principal != null ? principal.getName() : null;
        return string != null ? string : "not available";
    }

    private static String extractCNfromDN(String string) {
        return string == null ? null : string.replaceAll("\\\\\\\\", "\u0019").replaceAll("\\\\,", "\u001c").replaceAll("\\\\;", "\u001d").replaceAll("\\\\\"", "\u001e").replaceAll("\\\\=", "\u001f").replaceAll("\"([^\"]*)\"", "\u0017$1\u0018").replaceAll("(\u0017[^\u0018]*)C(N\\s*=)", "$1\u0016$2").replaceFirst("(?s)(?:^|^.*[,;]\\s*)CN\\s*=\\s*(\u0017[^\u0018]*\u0018|[^,;]*).*", "$1").replaceFirst("\\s+$", "").replaceAll("\u0018", "").replaceAll("\u0016", "C").replaceAll("\u0017", "").replaceAll("\u001f", "=").replaceAll("\u001e", "\"").replaceAll("\u001d", ";").replaceAll("\u001c", ",").replaceAll("\\\\", "").replaceAll("\u0019", "\\");
    }

    private static String extractCNfromCert(X509Certificate x509Certificate) {
        Principal principal = x509Certificate != null ? x509Certificate.getSubjectDN() : null;
        String string = principal != null ? principal.getName() : null;
        return CertChecker.extractCNfromDN(string);
    }

    private static String formatCN(X509Certificate x509Certificate) {
        String string = CertChecker.extractCNfromCert(x509Certificate);
        return string != null ? string : "not available";
    }

    private static ExtractedSANs extractSANsFromCert(X509Certificate x509Certificate) {
        ExtractedSANs extractedSANs = new ExtractedSANs();
        Collection<List<?>> collection = null;
        if (x509Certificate != null) {
            try {
                collection = x509Certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {
                extractedSANs.ex = certificateParsingException;
            }
        }
        if (collection != null) {
            extractedSANs.list = new ArrayList();
            List<Object> list = Arrays.asList(new Integer(2), new Integer(7));
            Iterator<List<?>> iterator = collection.iterator();
            while (iterator.hasNext()) {
                List<?> list2 = iterator.next();
                if (list2.size() < 2 || !list.contains(list2.get(0)) || !(list2.get(1) instanceof String)) continue;
                extractedSANs.list.add(list2.get(1));
            }
        }
        return extractedSANs;
    }

    private static String formatList(List list, String string, String string2) {
        if (list == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string != null && stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            if (string2 != null) {
                stringBuffer.append(string2).append(" " + n + " of " + list.size() + ": ");
            }
            stringBuffer.append(String.valueOf(iterator.next()));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String formatSANs(X509Certificate x509Certificate) {
        ExtractedSANs extractedSANs = CertChecker.extractSANsFromCert(x509Certificate);
        if (extractedSANs.ex != null) {
            return "not available: " + extractedSANs.ex;
        }
        if (extractedSANs.list == null) {
            return "not present";
        }
        return CertChecker.formatList(extractedSANs.list, ", ", null);
    }

    private static String formatCert(Certificate certificate) {
        return "  ----------------------------------------------\n  |  " + String.valueOf(certificate).trim().replaceAll("\n", "\n  |  ") + "\n" + "  ----------------------------------------------";
    }

    private static List getServerCertProblems(X509TrustManager x509TrustManager, X509Certificate[] x509CertificateArray, String string, String string2) {
        ArrayList<CertificateException> arrayList = new ArrayList<CertificateException>();
        if (x509TrustManager != null && x509CertificateArray != null && string != null && string.length() > 0) {
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                arrayList.add(new CertificateException(string2 + " TrustManager rejected certificate"));
                arrayList.add(certificateException);
            }
        }
        return arrayList;
    }

    private static Set setMinus(Collection collection, Collection collection2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(collection);
        linkedHashSet.removeAll(collection2);
        return linkedHashSet;
    }

    private static class ExtractedSANs {
        public List list = null;
        public CertificateParsingException ex = null;
    }
}

