/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm;

import com.dbeaver.ee.qm.db.impl.QMEmbeddedService;
import com.dbeaver.model.DBPApplicationExtended;
import com.dbeaver.model.QMService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.qm.QMDisposable;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class QMEventListener
implements QMMetaListener {
    private static final Log log = Log.getLog(QMEventListener.class);
    private final QMService qmService;

    public QMEventListener() {
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        this.qmService = application instanceof DBPApplicationExtended ? ((DBPApplicationExtended)application).getQueryManagerService() : new QMEmbeddedService();
    }

    public void dispose() {
        if (QMDisposable.class.isAssignableFrom(this.qmService.getClass())) {
            ((QMDisposable)this.qmService).dispose();
        }
    }

    public synchronized void metaInfoChanged(@NotNull DBRProgressMonitor monitor, @NotNull List<QMMetaEvent> events) {
        events = new ArrayList<QMMetaEvent>(events);
        events.removeIf(e -> e.getAction() == QMEventAction.UPDATE);
        Collections.reverse(events);
        monitor.beginTask("Persist events", events.size());
        try {
            try {
                monitor.subTask("Persisting QM events");
                this.qmService.saveEvents(monitor, events);
                monitor.worked(events.size());
            }
            catch (Exception e2) {
                log.debug((Object)"Error saving QM events", (Throwable)e2);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

