/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.net.auth.krb5;

import com.dbeaver.net.auth.krb5.AuthModelKerberos;
import com.dbeaver.net.auth.krb5.AuthModelKerberosCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OracleAuthModelKerberos
extends AuthModelKerberos {
    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelKerberosCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
        String realm = credentials.getKrbRealmName();
        boolean kinit = credentials.isUseKinit();
        String ccFilePath = credentials.getCacheFilePath();
        connProperties.setProperty("oracle.net.authentication_services", "(KERBEROS5)");
        connProperties.setProperty("oracle.net.kerberos5_mutual_authentication", "true");
        if (!kinit) {
            connProperties.setProperty("oracle.net.kerberos5_cc_name", ccFilePath);
        }
        connProperties.setProperty("oracle.net.KerberosRealm", realm);
        return credentials;
    }
}

