/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.model.data.spatial;

import com.dbeaver.db.oracle.model.data.spatial.CoordinateAccess;
import com.dbeaver.db.oracle.model.data.spatial.CoordinateAccessFactory;
import com.dbeaver.db.oracle.model.data.spatial.SDOAttributeList;
import com.dbeaver.db.oracle.model.data.spatial.SDOCoordinates;
import com.dbeaver.db.oracle.model.data.spatial.SDOOrdinateList;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public final class SDOUtils {
    private static final Log LOGGER = Log.getLog(SDOUtils.class);
    public static final int SRID_NULL = -1;

    public static int gType(Geometry geom) {
        int d = SDOUtils.D(geom) * 1000;
        int l = SDOUtils.L(geom) * 100;
        int tt = SDOUtils.TT(geom);
        return d + l + tt;
    }

    public static int D(Geometry geom) {
        CoordinateSequenceFactory f;
        CoordinateSequenceFactory coordinateSequenceFactory = f = geom != null ? geom.getFactory().getCoordinateSequenceFactory() : null;
        if (f instanceof CoordinateAccessFactory) {
            return ((CoordinateAccessFactory)f).getDimension();
        }
        if (geom == null || geom.getCoordinate() == null || geom.isEmpty()) {
            return 2;
        }
        return Double.isNaN(geom.getCoordinate().getZ()) ? 2 : 3;
    }

    public static int L(Geometry geom) {
        CoordinateSequenceFactory f = geom.getFactory().getCoordinateSequenceFactory();
        if (f instanceof CoordinateAccessFactory) {
            return ((CoordinateAccessFactory)f).getDimension();
        }
        return 0;
    }

    public static int TT(Geometry geom) {
        if (geom == null) {
            return 0;
        }
        if (geom instanceof Point) {
            return 1;
        }
        if (geom instanceof LineString) {
            return 2;
        }
        if (geom instanceof Polygon) {
            return 3;
        }
        if (geom instanceof MultiPoint) {
            return 5;
        }
        if (geom instanceof MultiLineString) {
            return 6;
        }
        if (geom instanceof MultiPolygon) {
            return 7;
        }
        if (geom instanceof GeometryCollection) {
            return 4;
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geom.getGeometryType() + " as SDO_GTYPE " + "(Limitied to Point, Line, Polygon, GeometryCollection, MultiPoint," + " MultiLineString and MultiPolygon)");
    }

    public static int SRID(Geometry geom) {
        return geom.getSRID();
    }

    public static double[] point(Geometry geom) {
        if (geom instanceof Point && SDOUtils.L(geom) == 0) {
            Point point = (Point)geom;
            Coordinate coord = point.getCoordinate();
            return new double[]{coord.x, coord.y, coord.getZ()};
        }
        return null;
    }

    public static int[] elemInfo(Geometry geom) {
        return SDOUtils.elemInfo(geom, SDOUtils.gType(geom));
    }

    public static int[] elemInfo(Geometry geom, int GTYPE) {
        LinkedList list = new LinkedList();
        SDOUtils.elemInfo(list, geom, 1, GTYPE);
        return SDOUtils.intArray(list);
    }

    private static void elemInfo(List elemInfoList, Geometry geom, int STARTING_OFFSET, int GTYPE) {
        int tt = SDOUtils.TT(geom);
        switch (tt) {
            case 1: {
                SDOUtils.addElemInfo(elemInfoList, (Point)geom, STARTING_OFFSET);
                return;
            }
            case 2: {
                SDOUtils.addElemInfo(elemInfoList, (LineString)geom, STARTING_OFFSET);
                return;
            }
            case 3: {
                SDOUtils.addElemInfo(elemInfoList, (Polygon)geom, STARTING_OFFSET, GTYPE);
                return;
            }
            case 5: {
                SDOUtils.addElemInfo(elemInfoList, (MultiPoint)geom, STARTING_OFFSET);
                return;
            }
            case 6: {
                SDOUtils.addElemInfo(elemInfoList, (MultiLineString)geom, STARTING_OFFSET, GTYPE);
                return;
            }
            case 7: {
                SDOUtils.addElemInfo(elemInfoList, (MultiPolygon)geom, STARTING_OFFSET, GTYPE);
                return;
            }
            case 4: {
                SDOUtils.addElemInfo(elemInfoList, (GeometryCollection)geom, STARTING_OFFSET, GTYPE);
                return;
            }
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geom.getGeometryType() + " as SDO_ELEM_INFO " + "(Limitied to Point, Line, Polygon, GeometryCollection, MultiPoint," + " MultiLineString and MultiPolygon)");
    }

    private static void addElemInfo(List elemInfoList, Point point, int STARTING_OFFSET) {
        SDOUtils.addInt(elemInfoList, STARTING_OFFSET);
        SDOUtils.addInt(elemInfoList, 1);
        SDOUtils.addInt(elemInfoList, 1);
    }

    private static void addElemInfo(List elemInfoList, LineString line, int STARTING_OFFSET) {
        SDOUtils.addInt(elemInfoList, STARTING_OFFSET);
        SDOUtils.addInt(elemInfoList, 2);
        SDOUtils.addInt(elemInfoList, 1);
    }

    private static void addElemInfo(List elemInfoList, Polygon polygon, int STARTING_OFFSET, int GTYPE) {
        int HOLES = polygon.getNumInteriorRing();
        if (HOLES == 0) {
            SDOUtils.addInt(elemInfoList, STARTING_OFFSET);
            SDOUtils.addInt(elemInfoList, SDOUtils.elemInfoEType((Geometry)polygon));
            SDOUtils.addInt(elemInfoList, SDOUtils.elemInfoInterpretation((Geometry)polygon, 1003));
            return;
        }
        int LEN = SDOUtils.D(GTYPE) + SDOUtils.L(GTYPE);
        int offset = STARTING_OFFSET;
        LinearRing ring = polygon.getExteriorRing();
        SDOUtils.addInt(elemInfoList, offset);
        SDOUtils.addInt(elemInfoList, SDOUtils.elemInfoEType((Geometry)polygon));
        SDOUtils.addInt(elemInfoList, SDOUtils.elemInfoInterpretation((Geometry)polygon, 1003));
        offset += ring.getNumPoints() * LEN;
        int i = 1;
        while (i <= HOLES) {
            ring = polygon.getInteriorRingN(i - 1);
            SDOUtils.addInt(elemInfoList, offset);
            SDOUtils.addInt(elemInfoList, 2003);
            SDOUtils.addInt(elemInfoList, SDOUtils.elemInfoInterpretation((Geometry)ring, 2003));
            offset += ring.getNumPoints() * LEN;
            ++i;
        }
    }

    private static void addElemInfo(List elemInfoList, MultiPoint points, int STARTING_OFFSET) {
        SDOUtils.addInt(elemInfoList, STARTING_OFFSET);
        SDOUtils.addInt(elemInfoList, 1);
        SDOUtils.addInt(elemInfoList, SDOUtils.elemInfoInterpretation((Geometry)points, 1));
    }

    private static void addElemInfo(List elemInfoList, MultiLineString lines, int STARTING_OFFSET, int GTYPE) {
        int offset = STARTING_OFFSET;
        int LEN = SDOUtils.D(GTYPE) + SDOUtils.L(GTYPE);
        int i = 0;
        while (i < lines.getNumGeometries()) {
            LineString line = (LineString)lines.getGeometryN(i);
            SDOUtils.addElemInfo(elemInfoList, line, offset);
            offset += line.getNumPoints() * LEN;
            ++i;
        }
    }

    private static void addElemInfo(List elemInfoList, MultiPolygon polys, int STARTING_OFFSET, int GTYPE) {
        int offset = STARTING_OFFSET;
        int LEN = SDOUtils.D(GTYPE) + SDOUtils.L(GTYPE);
        int i = 0;
        while (i < polys.getNumGeometries()) {
            Polygon poly = (Polygon)polys.getGeometryN(i);
            if (poly != null && !poly.isEmpty()) {
                SDOUtils.addElemInfo(elemInfoList, poly, offset, GTYPE);
                offset = SDOUtils.isRectangle(poly) ? (offset += 2 * LEN) : (offset += poly.getNumPoints() * LEN);
            }
            ++i;
        }
    }

    private static void addElemInfo(List elemInfoList, GeometryCollection geoms, int STARTING_OFFSET, int GTYPE) {
        int offset = STARTING_OFFSET;
        int LEN = SDOUtils.D(GTYPE) + SDOUtils.L(GTYPE);
        int i = 0;
        while (i < geoms.getNumGeometries()) {
            Geometry geom = geoms.getGeometryN(i);
            SDOUtils.elemInfo(elemInfoList, geom, offset, GTYPE);
            offset = geom instanceof Polygon && SDOUtils.isRectangle((Polygon)geom) ? (offset += 2 * LEN) : (offset += geom.getNumPoints() * LEN);
            ++i;
        }
    }

    private static void addInt(List list, int i) {
        list.add(i);
    }

    private static int[] intArray(List list) {
        int[] array = new int[list.size()];
        int offset = 0;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            array[offset] = ((Number)i.next()).intValue();
            ++offset;
        }
        return array;
    }

    public static int elemInfoStartingOffset(Geometry geom) {
        return 1;
    }

    protected static int elemInfoEType(Geometry geom) {
        switch (SDOUtils.TT(geom)) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return SDOUtils.isExterior((Polygon)geom) ? 1003 : 2003;
            }
        }
        throw new IllegalArgumentException("Unknown encoding of SDO_GTYPE");
    }

    public static int elemInfoInterpretation(Geometry geom) {
        return SDOUtils.elemInfoInterpretation(geom, SDOUtils.elemInfoEType(geom));
    }

    public static int elemInfoInterpretation(Geometry geom, int etype) {
        switch (etype) {
            case 0: {
                break;
            }
            case 1: {
                if (geom instanceof Point) {
                    return 1;
                }
                if (!(geom instanceof MultiPoint)) break;
                return ((MultiPoint)geom).getNumGeometries();
            }
            case 2: {
                if (SDOUtils.isCurve((LineString)geom)) {
                    return 2;
                }
                return 1;
            }
            case 3: 
            case 1003: 
            case 2003: {
                if (geom instanceof Polygon) {
                    Polygon polygon = (Polygon)geom;
                    if (SDOUtils.isCurve(polygon)) {
                        return 2;
                    }
                    if (SDOUtils.isRectangle(polygon)) {
                        return 3;
                    }
                    if (SDOUtils.isCircle(polygon)) {
                        return 4;
                    }
                }
                return 1;
            }
            case 4: {
                throw new IllegalArgumentException("JTS LineStrings are not composed of curves and lines.");
            }
            case 5: 
            case 1005: 
            case 2005: {
                throw new IllegalArgumentException("JTS Polygons are not composed of curves and lines.");
            }
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geom.getGeometryType() + " as " + "SDO_INTERPRETATION (Limitied to Point, Line, Polygon, " + "GeometryCollection, MultiPoint, MultiLineString and MultiPolygon)");
    }

    public static double[] ordinates(Geometry geom) {
        ArrayList list = new ArrayList();
        SDOUtils.coordinates(list, geom);
        return SDOUtils.ordinates(list, geom);
    }

    public static CoordinateSequence getCS(Geometry geom) {
        CoordinateSequence cs = null;
        switch (SDOUtils.TT(geom)) {
            case 0: {
                break;
            }
            case 1: {
                return cs;
            }
            case 2: {
                cs = SDOUtils.getLineStringCS((LineString)geom);
                return cs;
            }
            case 3: {
                return cs;
            }
            case 4: {
                return cs;
            }
            case 5: {
                return cs;
            }
            case 6: {
                return cs;
            }
            case 7: {
                return cs;
            }
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geom.getGeometryType() + " as " + "SDO_ORDINATRES (Limitied to Point, Line, Polygon, " + "GeometryCollection, MultiPoint, MultiLineString and MultiPolygon)");
    }

    private static CoordinateSequence getLineStringCS(LineString ls) {
        if (ls.getCoordinateSequence() instanceof CoordinateAccess) {
            CoordinateAccess ca = (CoordinateAccess)ls.getCoordinateSequence();
            return ca;
        }
        return null;
    }

    public static void coordinates(List list, Geometry geom) {
        switch (SDOUtils.TT(geom)) {
            case 0: {
                break;
            }
            case 1: {
                SDOUtils.addCoordinates(list, (Point)geom);
                return;
            }
            case 2: {
                SDOUtils.addCoordinates(list, (LineString)geom);
                return;
            }
            case 3: {
                SDOUtils.addCoordinates(list, (Polygon)geom);
                return;
            }
            case 4: {
                SDOUtils.addCoordinates(list, (GeometryCollection)geom);
                return;
            }
            case 5: {
                SDOUtils.addCoordinates(list, (MultiPoint)geom);
                return;
            }
            case 6: {
                SDOUtils.addCoordinates(list, (MultiLineString)geom);
                return;
            }
            case 7: {
                SDOUtils.addCoordinates(list, (MultiPolygon)geom);
                return;
            }
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geom.getGeometryType() + " as " + "SDO_ORDINATRES (Limitied to Point, Line, Polygon, " + "GeometryCollection, MultiPoint, MultiLineString and MultiPolygon)");
    }

    private static void addCoordinates(List list, CoordinateSequence sequence) {
        if (sequence instanceof CoordinateAccess) {
            CoordinateAccess access = (CoordinateAccess)sequence;
            int i = 0;
            while (i < access.size()) {
                list.add(SDOUtils.ordinateArray(access, i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < sequence.size()) {
                list.add(SDOUtils.ordinateArray(sequence.getCoordinate(i)));
                ++i;
            }
        }
    }

    private static double[] ordinateArray(Coordinate coord) {
        return new double[]{coord.x, coord.y, coord.getZ()};
    }

    private static double[] ordinateArray(CoordinateAccess access, int index) {
        int D = access.getDimension();
        int L = access.getNumAttributes();
        int LEN = D + L;
        double[] ords = new double[LEN];
        int i = 0;
        while (i < LEN) {
            ords[i] = access.getOrdinate(index, i);
            ++i;
        }
        return ords;
    }

    private static void addCoordinates(List list, Point point) {
        SDOUtils.addCoordinates(list, point.getCoordinateSequence());
    }

    private static void addCoordinates(List list, LineString line) {
        SDOUtils.addCoordinates(list, line.getCoordinateSequence());
    }

    private static void addCoordinates(List list, Polygon polygon) {
        switch (SDOUtils.elemInfoInterpretation((Geometry)polygon)) {
            case 4: {
                break;
            }
            case 3: {
                SDOUtils.addCoordinatesInterpretation3(list, polygon);
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                SDOUtils.addCoordinatesInterpretation1(list, polygon);
            }
        }
    }

    private static void addCoordinatesInterpretation3(List list, Polygon poly) {
        Envelope e = poly.getEnvelopeInternal();
        list.add(new double[]{e.getMinX(), e.getMinY()});
        list.add(new double[]{e.getMaxX(), e.getMaxY()});
    }

    private static void addCoordinatesInterpretation1(List list, Polygon polygon) {
        int holes = polygon.getNumInteriorRing();
        if (!polygon.isEmpty()) {
            SDOUtils.addCoordinates(list, SDOUtils.counterClockWise(polygon.getFactory().getCoordinateSequenceFactory(), polygon.getExteriorRing().getCoordinateSequence()));
            int i = 0;
            while (i < holes) {
                SDOUtils.addCoordinates(list, SDOUtils.clockWise(polygon.getFactory().getCoordinateSequenceFactory(), polygon.getInteriorRingN(i).getCoordinateSequence()));
                ++i;
            }
        }
    }

    private static void addCoordinates(List list, MultiPoint points) {
        int i = 0;
        while (i < points.getNumGeometries()) {
            Geometry geometryN = points.getGeometryN(i);
            if (geometryN != null && !geometryN.isEmpty()) {
                SDOUtils.addCoordinates(list, (Point)geometryN);
            }
            ++i;
        }
    }

    private static void addCoordinates(List list, MultiLineString lines) {
        int i = 0;
        while (i < lines.getNumGeometries()) {
            Geometry geometryN = lines.getGeometryN(i);
            if (geometryN != null && !geometryN.isEmpty()) {
                SDOUtils.addCoordinates(list, (LineString)geometryN);
            }
            ++i;
        }
    }

    private static void addCoordinates(List list, MultiPolygon polys) {
        int i = 0;
        while (i < polys.getNumGeometries()) {
            Geometry geometryN = polys.getGeometryN(i);
            if (geometryN != null && !geometryN.isEmpty()) {
                SDOUtils.addCoordinates(list, (Polygon)geometryN);
            }
            ++i;
        }
    }

    private static void addCoordinates(List list, GeometryCollection geoms) {
        int i = 0;
        while (i < geoms.getNumGeometries()) {
            Geometry geom = geoms.getGeometryN(i);
            if (geom != null && !geom.isEmpty()) {
                if (geom instanceof Point) {
                    SDOUtils.addCoordinates(list, (Point)geom);
                } else if (geom instanceof LineString) {
                    SDOUtils.addCoordinates(list, (LineString)geom);
                } else if (geom instanceof Polygon) {
                    SDOUtils.addCoordinates(list, (Polygon)geom);
                } else if (geom instanceof MultiPoint) {
                    SDOUtils.addCoordinates(list, (MultiPoint)geom);
                } else if (geom instanceof MultiLineString) {
                    SDOUtils.addCoordinates(list, (MultiLineString)geom);
                } else if (geom instanceof MultiPolygon) {
                    SDOUtils.addCoordinates(list, (MultiPolygon)geom);
                } else if (geom instanceof GeometryCollection) {
                    SDOUtils.addCoordinates(list, (GeometryCollection)geom);
                }
            }
            ++i;
        }
    }

    public static double[] ordinateArray(CoordinateSequence coords, int ordinate) {
        if (coords instanceof CoordinateAccess) {
            CoordinateAccess access = (CoordinateAccess)coords;
            return access.toOrdinateArray(ordinate);
        }
        int LENGTH = coords.size();
        double[] array = new double[LENGTH];
        if (ordinate == 0) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = coords.getCoordinate(i);
                array[i] = c != null ? c.x : Double.NaN;
                ++i;
            }
        } else if (ordinate == 1) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = coords.getCoordinate(i);
                array[i] = c != null ? c.y : Double.NaN;
                ++i;
            }
        } else if (ordinate == 2) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = coords.getCoordinate(i);
                array[i] = c != null ? c.getZ() : Double.NaN;
                ++i;
            }
        } else {
            int i = 0;
            while (i < LENGTH) {
                array[i] = Double.NaN;
                ++i;
            }
        }
        return array;
    }

    public static double[] ordinateArray(Coordinate[] array, int ordinate) {
        if (array == null) {
            return null;
        }
        int LENGTH = array.length;
        double[] ords = new double[LENGTH];
        if (ordinate == 0) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = array[i];
                ords[i] = c != null ? c.x : Double.NaN;
                ++i;
            }
        } else if (ordinate == 1) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = array[i];
                ords[i] = c != null ? c.y : Double.NaN;
                ++i;
            }
        } else if (ordinate == 2) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = array[i];
                ords[i] = c != null ? c.getZ() : Double.NaN;
                ++i;
            }
        } else {
            int i = 0;
            while (i < LENGTH) {
                ords[i] = Double.NaN;
                ++i;
            }
        }
        return ords;
    }

    public static double[] ordinateArray(List list, int ordinate) {
        if (list == null) {
            return null;
        }
        int LENGTH = list.size();
        double[] ords = new double[LENGTH];
        if (ordinate == 0) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = (Coordinate)list.get(i);
                ords[i] = c != null ? c.x : Double.NaN;
                ++i;
            }
        } else if (ordinate == 1) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = (Coordinate)list.get(i);
                ords[i] = c != null ? c.y : Double.NaN;
                ++i;
            }
        } else if (ordinate == 2) {
            int i = 0;
            while (i < LENGTH) {
                Coordinate c = (Coordinate)list.get(i);
                ords[i] = c != null ? c.getZ() : Double.NaN;
                ++i;
            }
        } else {
            int i = 0;
            while (i < LENGTH) {
                ords[i] = Double.NaN;
                ++i;
            }
        }
        return ords;
    }

    public static double[] ordinates(List list, Geometry geom) {
        if (SDOUtils.D(geom) == 3) {
            return SDOUtils.ordinates3d(list, SDOUtils.L(geom));
        }
        return SDOUtils.ordinates2d(list, SDOUtils.L(geom));
    }

    public static double[] ordinates2d(List list) {
        int NUMBER = list.size();
        double[] array = new double[NUMBER * 2];
        int offset = 0;
        int i = 0;
        while (i < NUMBER) {
            double[] ords = (double[])list.get(i);
            if (ords != null) {
                array[offset++] = ords[0];
                array[offset++] = ords[1];
            } else {
                array[offset++] = Double.NaN;
                array[offset++] = Double.NaN;
            }
            ++i;
        }
        return array;
    }

    public static double[] ordinates3d(List list) {
        int NUMBER = list.size();
        double[] array = new double[NUMBER * 3];
        int offset = 0;
        int i = 0;
        while (i < NUMBER) {
            double[] ords = (double[])list.get(i);
            if (ords != null) {
                array[offset++] = ords[0];
                array[offset++] = ords[1];
                array[offset++] = ords[2];
            } else {
                array[offset++] = Double.NaN;
                array[offset++] = Double.NaN;
                array[offset++] = Double.NaN;
            }
            ++i;
        }
        return array;
    }

    public static double[] ordinates2d(List list, int L) {
        if (L == 0) {
            return SDOUtils.ordinates2d(list);
        }
        int NUMBER = list.size();
        int LEN = 2 + L;
        double[] array = new double[NUMBER * LEN];
        int i = 0;
        while (i < NUMBER) {
            double[] ords = (double[])list.get(i);
            int j = 0;
            while (j < LEN) {
                array[i * LEN + j] = ords[j];
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static double[] ordinates3d(List list, int L) {
        if (L == 0) {
            return SDOUtils.ordinates3d(list);
        }
        int NUMBER = list.size();
        int LEN = 3 + L;
        double[] array = new double[NUMBER * LEN];
        int i = 0;
        while (i < NUMBER) {
            double[] ords = (double[])list.get(i);
            int j = 0;
            while (j < LEN) {
                array[i * LEN + j] = ords[j];
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static CoordinateSequence counterClockWise(CoordinateSequenceFactory factory, CoordinateSequence ring) {
        if (Orientation.isCCW((Coordinate[])ring.toCoordinateArray())) {
            return ring;
        }
        return SDOCoordinates.reverse(factory, ring);
    }

    private static CoordinateSequence clockWise(CoordinateSequenceFactory factory, CoordinateSequence ring) {
        if (!Orientation.isCCW((Coordinate[])ring.toCoordinateArray())) {
            return ring;
        }
        return SDOCoordinates.reverse(factory, ring);
    }

    private static boolean isExterior(Polygon poly) {
        return true;
    }

    private static boolean isCircle(Polygon polygon) {
        return false;
    }

    private static boolean isRectangle(Polygon polygon) {
        if (polygon.getFactory().getSRID() != -1) {
            return false;
        }
        if (SDOUtils.L((Geometry)polygon) != 0) {
            return false;
        }
        Coordinate[] coords = polygon.getCoordinates();
        if (coords.length != 5) {
            return false;
        }
        if (coords[0] == null || coords[1] == null || coords[2] == null || coords[3] == null) {
            return false;
        }
        if (!coords[0].equals2D(coords[4])) {
            return false;
        }
        double x1 = coords[0].x;
        double y1 = coords[0].y;
        double x2 = coords[1].x;
        double y2 = coords[1].y;
        double x3 = coords[2].x;
        double y3 = coords[2].y;
        double x4 = coords[3].x;
        double y4 = coords[3].y;
        if (x1 == x4 && y1 == y2 && x3 == x2 && y3 == y4) {
            return true;
        }
        return x1 == x2 && y1 == y4 && x3 == x4 && y3 == y2;
    }

    private static boolean isCurve(Polygon polygon) {
        return false;
    }

    private static boolean isCurve(LineString lineString) {
        return false;
    }

    private static CoordinateSequence subList(CoordinateSequenceFactory factory, CoordinateSequence coords, int GTYPE, int[] elemInfo, int triplet, boolean compoundElement) {
        int STARTING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, triplet);
        int ENDING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, triplet + 1);
        int LEN = SDOUtils.D(GTYPE);
        if (ENDING_OFFSET != -1 && compoundElement) {
            ENDING_OFFSET += LEN;
        }
        if (STARTING_OFFSET == 1 && ENDING_OFFSET == -1) {
            return coords;
        }
        int start = (STARTING_OFFSET - 1) / LEN;
        int end = ENDING_OFFSET != -1 ? (ENDING_OFFSET - 1) / LEN : coords.size();
        return SDOUtils.subList(factory, coords, start, end);
    }

    private static CoordinateSequence subList(CoordinateSequenceFactory factory, CoordinateSequence coords, int start, int end) {
        if (start == 0 && end == coords.size()) {
            return coords;
        }
        return SDOCoordinates.subList(factory, coords, start, end);
    }

    private static LinearRing[] toInteriorRingArray(List list) {
        return (LinearRing[])SDOUtils.toArray(list, LinearRing.class);
    }

    private static LineString[] toLineStringArray(List list) {
        return (LineString[])SDOUtils.toArray(list, LineString.class);
    }

    private static Polygon[] toPolygonArray(List list) {
        return (Polygon[])SDOUtils.toArray(list, Polygon.class);
    }

    private static Geometry[] toGeometryArray(List list) {
        return (Geometry[])SDOUtils.toArray(list, Geometry.class);
    }

    private static Object toArray(List<?> list, Class<?> type) {
        if (list == null) {
            return null;
        }
        Object array = Array.newInstance(type, list.size());
        int index = 0;
        Iterator<?> i = list.iterator();
        while (i.hasNext()) {
            Array.set(array, index, i.next());
            ++index;
        }
        return array;
    }

    public static int D(int GTYPE) {
        return GTYPE / 1000;
    }

    public static int L(int GTYPE) {
        return (GTYPE - SDOUtils.D(GTYPE) * 1000) / 100;
    }

    public static int TT(int GTYPE) {
        return GTYPE - SDOUtils.D(GTYPE) * 1000 - SDOUtils.L(GTYPE) * 100;
    }

    private static int STARTING_OFFSET(int[] elemInfo, int triplet) {
        if (triplet * 3 + 0 >= elemInfo.length) {
            return -1;
        }
        return elemInfo[triplet * 3 + 0];
    }

    private static void ensure(String condition, int min, int actual, int max) {
        if (min > actual || actual > max) {
            String msg = MessageFormat.format(condition, min, actual, max);
            throw new IllegalArgumentException(msg);
        }
    }

    private static void ensure(String condition, int actual, int[] set) {
        if (set == null) {
            return;
        }
        int i = 0;
        while (i < set.length) {
            if (set[i] == actual) {
                return;
            }
            ++i;
        }
        StringBuffer array = new StringBuffer();
        int i2 = 0;
        while (i2 < set.length) {
            array.append(set[i2]);
            if (i2 < set.length) {
                array.append(",");
            }
            ++i2;
        }
        String msg = MessageFormat.format(condition, actual, array);
        throw new IllegalArgumentException(msg);
    }

    private static int ordinateSize(CoordinateSequence coords, int GTYPE) {
        if (coords == null) {
            return 0;
        }
        return coords.size() * SDOUtils.D(GTYPE);
    }

    private static int ETYPE(int[] elemInfo, int triplet) {
        if (triplet * 3 + 1 >= elemInfo.length) {
            return -1;
        }
        return elemInfo[triplet * 3 + 1];
    }

    private static int INTERPRETATION(int[] elemInfo, int triplet) {
        if (triplet * 3 + 2 >= elemInfo.length) {
            return -1;
        }
        return elemInfo[triplet * 3 + 2];
    }

    public static Coordinate[] asCoordinates(double[] ordinates) {
        return SDOUtils.asCoordinates(ordinates, 2);
    }

    public static Coordinate[] asCoordinates(double[] ordinates, int d) {
        int length = ordinates.length / d;
        Coordinate[] coords = new Coordinate[length];
        int i = 0;
        while (i < length) {
            coords[i] = new Coordinate(ordinates[i * d], ordinates[i * d + 1]);
            ++i;
        }
        return coords;
    }

    public static CoordinateSequence coordinates(CoordinateSequenceFactory f, int GTYPE, double[] ordinates) {
        if (ordinates == null || ordinates.length == 0) {
            return f.create(new Coordinate[0]);
        }
        int D = SDOUtils.D(GTYPE);
        int L = SDOUtils.L(GTYPE);
        int TT = SDOUtils.TT(GTYPE);
        if (D == 2 && L == 0 && TT == 1) {
            CoordinateSequence cs = SDOCoordinates.createCS(f, 1, 2);
            int i = 0;
            while (i < 2) {
                cs.setOrdinate(0, i, ordinates[i]);
                ++i;
            }
            return cs;
        }
        int LEN = D;
        if (ordinates.length % LEN != 0) {
            throw new IllegalArgumentException("Dimension D:" + D + " denote SDOCoordinates " + "of " + LEN + " ordinates. This cannot be resolved with" + "an ordinate array of length " + ordinates.length);
        }
        if (L != 0 && L > D) {
            throw new IllegalArgumentException("Dimension D:" + D + " and LRS with L: " + L + " is not supported at a position > D");
        }
        SDOOrdinateList x = new SDOOrdinateList(ordinates, 0, LEN);
        SDOOrdinateList y = new SDOOrdinateList(ordinates, 1, LEN);
        SDOOrdinateList z = null;
        if (D >= 3 && L != 3) {
            z = new SDOOrdinateList(ordinates, 2, LEN);
        }
        if (L != 0) {
            SDOOrdinateList m = new SDOOrdinateList(ordinates, L - 1, LEN);
            return SDOUtils.coordiantes(f, x, y, z, m);
        }
        return SDOUtils.coordiantes(f, x, y, z);
    }

    public static CoordinateSequence coordiantes(CoordinateSequenceFactory f, SDOOrdinateList x, SDOOrdinateList y, SDOOrdinateList z) {
        int LENGTH = x.size();
        CoordinateSequence cs = SDOCoordinates.createCS(f, LENGTH, z == null ? 2 : 3);
        if (z != null) {
            int i = 0;
            while (i < LENGTH) {
                cs.setOrdinate(i, 0, x.getDouble(i));
                cs.setOrdinate(i, 1, y.getDouble(i));
                cs.setOrdinate(i, 2, z.getDouble(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < LENGTH) {
                cs.setOrdinate(i, 0, x.getDouble(i));
                cs.setOrdinate(i, 1, y.getDouble(i));
                ++i;
            }
        }
        return cs;
    }

    public static CoordinateSequence coordiantes(CoordinateSequenceFactory f, SDOAttributeList x, SDOAttributeList y, SDOAttributeList z) {
        int LENGTH = x.size();
        Coordinate[] array = new Coordinate[LENGTH];
        if (z != null) {
            int i = 0;
            while (i < LENGTH) {
                array[i] = new Coordinate(x.getDouble(i), y.getDouble(i), z.getDouble(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < LENGTH) {
                array[i] = new Coordinate(x.getDouble(i), y.getDouble(i));
                ++i;
            }
        }
        return f.create(array);
    }

    public static CoordinateSequence coordiantes(CoordinateSequenceFactory f, SDOOrdinateList x, SDOOrdinateList y, SDOOrdinateList z, SDOOrdinateList m) {
        int LENGTH = x.size();
        CoordinateSequence cs = SDOCoordinates.createCS(f, LENGTH, z == null ? 2 : 3);
        if (z != null) {
            int i = 0;
            while (i < LENGTH) {
                cs.setOrdinate(i, 0, x.getDouble(i));
                cs.setOrdinate(i, 1, y.getDouble(i));
                cs.setOrdinate(i, 2, z.getDouble(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < LENGTH) {
                cs.setOrdinate(i, 0, x.getDouble(i));
                cs.setOrdinate(i, 1, y.getDouble(i));
                ++i;
            }
        }
        return cs;
    }

    @Deprecated
    public static CoordinateSequence coordiantes(CoordinateSequenceFactory f, SDOOrdinateList x, SDOOrdinateList y, SDOOrdinateList z, SDOOrdinateList[] m) {
        int L;
        int D = z != null ? 3 : 2;
        int n = L = m != null ? m.length : 0;
        if (f instanceof CoordinateAccess && L != 0) {
            CoordinateAccessFactory factory = (CoordinateAccessFactory)f;
            double[][] xyz = new double[D][];
            double[][] measures = new double[L][];
            xyz[0] = x.toDoubleArray();
            xyz[1] = y.toDoubleArray();
            if (D == 3) {
                xyz[2] = z.toDoubleArray();
            }
            int i = 0;
            while (i < L) {
                measures[i] = m[i].toDoubleArray();
                ++i;
            }
            return factory.create(xyz, (Object[])measures);
        }
        return SDOUtils.coordiantes(f, x, y, z);
    }

    @Deprecated
    public static CoordinateSequence coordiantes(CoordinateSequenceFactory f, SDOAttributeList x, SDOAttributeList y, SDOAttributeList z, SDOAttributeList[] m) {
        int L;
        int D = z != null ? 3 : 2;
        int n = L = m != null ? m.length : 0;
        if (f instanceof CoordinateAccess && L != 0) {
            CoordinateAccessFactory factory = (CoordinateAccessFactory)f;
            double[][] xyz = new double[D][];
            Object[] measures = new Object[L];
            xyz[0] = x.toDoubleArray();
            xyz[1] = y.toDoubleArray();
            if (D == 3) {
                xyz[2] = z.toDoubleArray();
            }
            int i = 0;
            while (i < L) {
                measures[i] = m[i].toObjectArray();
                ++i;
            }
            return factory.create(xyz, measures);
        }
        return SDOUtils.coordiantes(f, x, y, z);
    }

    public static Geometry create(GeometryFactory gf, int GTYPE, int SRID, double[] point, int[] elemInfo, double[] ordinates) {
        CoordinateSequence coords;
        int L = SDOUtils.L(GTYPE);
        int TT = SDOUtils.TT(GTYPE);
        if (L == 0 && TT == 1 && point != null && elemInfo == null) {
            coords = SDOUtils.coordinates(gf.getCoordinateSequenceFactory(), GTYPE, point);
            elemInfo = new int[]{1, 1, 1};
        } else {
            int element = 0;
            int etype = SDOUtils.ETYPE(elemInfo, element);
            if (etype == 0) {
                int startpointCoordinates = 0;
                while (etype == 0) {
                    etype = SDOUtils.ETYPE(elemInfo, ++element);
                    startpointCoordinates = SDOUtils.STARTING_OFFSET(elemInfo, element);
                }
                if (etype != -1) {
                    int ol = ordinates.length;
                    int elemsToCopy = ol - (startpointCoordinates - 1);
                    double[] newOrdinates = new double[elemsToCopy];
                    System.arraycopy(ordinates, startpointCoordinates - 1, newOrdinates, 0, elemsToCopy);
                    elemInfo = new int[]{1, etype, SDOUtils.INTERPRETATION(elemInfo, element)};
                    ordinates = newOrdinates;
                }
            }
            coords = SDOUtils.coordinates(gf.getCoordinateSequenceFactory(), GTYPE, ordinates);
        }
        return SDOUtils.create(gf, GTYPE, SRID, elemInfo, 0, coords, -1);
    }

    public static Geometry create(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int triplet, CoordinateSequence coords, int N) {
        GeometryFactory curvedFactory = gf;
        switch (SDOUtils.TT(GTYPE)) {
            case 1: {
                return SDOUtils.createPoint(curvedFactory, GTYPE, SRID, elemInfo, triplet, coords);
            }
            case 2: {
                return SDOUtils.createLine(curvedFactory, GTYPE, SRID, elemInfo, triplet, coords, false);
            }
            case 3: {
                return SDOUtils.createPolygon(curvedFactory, GTYPE, SRID, elemInfo, triplet, coords);
            }
            case 5: {
                return SDOUtils.createMultiPoint(curvedFactory, GTYPE, SRID, elemInfo, triplet, coords);
            }
            case 6: {
                return SDOUtils.createMultiLine(curvedFactory, GTYPE, SRID, elemInfo, triplet, coords, N);
            }
            case 7: {
                return SDOUtils.createMultiPolygon(curvedFactory, GTYPE, SRID, elemInfo, triplet, coords, N, false);
            }
            case 4: {
                return SDOUtils.createCollection(curvedFactory, GTYPE, SRID, elemInfo, triplet, coords, N);
            }
            case 8: {
                return SDOUtils.createMultiPolygon(curvedFactory, GTYPE, SRID, elemInfo, triplet, coords, N, true);
            }
        }
        LOGGER.warn((Object)("Cannot represent provided SDOUtils STRUCT (GTYPE =" + GTYPE + ") using JTS Geometry"));
        return null;
    }

    private static Point createPoint(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int element, CoordinateSequence coords) {
        int STARTING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, element);
        int etype = SDOUtils.ETYPE(elemInfo, element);
        int INTERPRETATION = SDOUtils.INTERPRETATION(elemInfo, element);
        int LENGTH = coords.size() * SDOUtils.D(GTYPE);
        if (STARTING_OFFSET < 1 || STARTING_OFFSET > LENGTH) {
            throw new IllegalArgumentException("Invalid ELEM_INFO STARTING_OFFSET ");
        }
        if (etype != 1) {
            throw new IllegalArgumentException("SDOGeometryEType " + etype + " inconsistent with expected POINT");
        }
        if (INTERPRETATION != 1) {
            LOGGER.warn((Object)("Could not create JTS Point with INTERPRETATION " + INTERPRETATION + " - we only expect 1 for a single point"));
            return null;
        }
        Point point = gf.createPoint(SDOUtils.subList(gf.getCoordinateSequenceFactory(), coords, GTYPE, elemInfo, element, false));
        point.setSRID(SRID);
        return point;
    }

    private static Geometry createLine(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int triplet, CoordinateSequence coords, boolean compoundElement) {
        LineString result;
        int etype = SDOUtils.ETYPE(elemInfo, triplet);
        int INTERPRETATION = SDOUtils.INTERPRETATION(elemInfo, triplet);
        if (etype != 2 && etype != 4) {
            return null;
        }
        if (etype == 2 && INTERPRETATION == 1) {
            CoordinateSequence subList = SDOUtils.subList(gf.getCoordinateSequenceFactory(), coords, GTYPE, elemInfo, triplet, compoundElement);
            result = gf.createLineString(subList);
        } else if (etype == 2 && INTERPRETATION == 2) {
            CoordinateSequence subList = SDOUtils.subList(gf.getCoordinateSequenceFactory(), coords, GTYPE, elemInfo, triplet, compoundElement);
            result = gf.createLinearRing(subList);
        } else if (etype == 4) {
            int triplets = INTERPRETATION;
            ArrayList<LineString> components = new ArrayList<LineString>(triplets);
            int i = 1;
            while (i <= triplets) {
                LineString component = (LineString)SDOUtils.createLine(gf, GTYPE, SRID, elemInfo, triplet + i, coords, true);
                components.add(component);
                ++i;
            }
            result = gf.createMultiLineString(components.toArray(new LineString[0]));
        } else {
            throw new IllegalArgumentException("ELEM_INFO SDOGeometryEType " + etype + " with INTERPRETAION " + INTERPRETATION + " not supported by this decoder");
        }
        result.setSRID(SRID);
        return result;
    }

    private static Polygon createPolygon(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int triplet, CoordinateSequence coords) throws IllegalArgumentException {
        int etype;
        int STARTING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, triplet);
        int eTYPE = SDOUtils.ETYPE(elemInfo, triplet);
        int INTERPRETATION = SDOUtils.INTERPRETATION(elemInfo, triplet);
        SDOUtils.ensure("ELEM_INFO STARTING_OFFSET {1} must be in the range {0}..{1} of COORDINATES", 1, STARTING_OFFSET, SDOUtils.ordinateSize(coords, GTYPE));
        if (1 > STARTING_OFFSET || STARTING_OFFSET > SDOUtils.ordinateSize(coords, GTYPE)) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + STARTING_OFFSET + "inconsistent with COORDINATES length " + SDOUtils.ordinateSize(coords, GTYPE));
        }
        SDOUtils.ensure("SDOGeometryEType {0} must be expected POLYGON or POLYGON_EXTERIOR (one of {1})", eTYPE, new int[]{1005, 5, 3, 1003, 1007});
        if (eTYPE != 1005 && eTYPE != 5 && (INTERPRETATION < 1 || INTERPRETATION > 4)) {
            LOGGER.warn((Object)("Could not create JTS Polygon with INTERPRETATION " + INTERPRETATION + " " + "- we can only support 1 for straight edges, 2 for circular ones, " + "3 for rectangle and 4 for circles"));
            return null;
        }
        LinearRing exteriorRing = SDOUtils.createLinearRing(gf, GTYPE, SRID, elemInfo, triplet, coords);
        if (eTYPE == 1005) {
            triplet += elemInfo[2];
        }
        LinkedList<LinearRing> rings = new LinkedList<LinearRing>();
        int i = triplet + 1;
        while ((etype = SDOUtils.ETYPE(elemInfo, i)) != -1) {
            LinearRing ring;
            if (etype == 2003) {
                rings.add(SDOUtils.createLinearRing(gf, GTYPE, SRID, elemInfo, i, coords));
                ++i;
                continue;
            }
            if (etype == 2005) {
                int subelements = SDOUtils.INTERPRETATION(elemInfo, i);
                rings.add(SDOUtils.createLinearRing(gf, GTYPE, SRID, elemInfo, i, coords));
                i = i + subelements + 1;
                continue;
            }
            if (etype != 3 || !Orientation.isCCW((Coordinate[])(ring = SDOUtils.createLinearRing(gf, GTYPE, SRID, elemInfo, i, coords)).getCoordinates())) break;
            rings.add(ring);
            ++i;
        }
        Polygon poly = gf.createPolygon(exteriorRing, SDOUtils.toInteriorRingArray(rings));
        poly.setSRID(SRID);
        return poly;
    }

    private static LinearRing createLinearRing(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int triplet, CoordinateSequence coords) {
        LinearRing ring;
        int STARTING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, triplet);
        int eTYPE = SDOUtils.ETYPE(elemInfo, triplet);
        int INTERPRETATION = SDOUtils.INTERPRETATION(elemInfo, triplet);
        int LENGTH = coords.size() * SDOUtils.D(GTYPE);
        if (STARTING_OFFSET < 1 || STARTING_OFFSET > LENGTH) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + STARTING_OFFSET + " inconsistent with ORDINATES length " + coords.size());
        }
        SDOUtils.ensure("SDOGeometryEType {0} must be expected POLYGON or POLYGON_EXTERIOR (one of {1})", eTYPE, new int[]{5, 1005, 2005, 3, 1003, 2003, 1007});
        if (eTYPE != 1005 && eTYPE != 5 && eTYPE != 2005 && (INTERPRETATION < 1 || INTERPRETATION > 4)) {
            LOGGER.warn((Object)("Could not create LinearRing with INTERPRETATION " + INTERPRETATION + " - we can only support 1, 2, 3 and 4"));
            return null;
        }
        if (eTYPE == 1005 || eTYPE == 2005) {
            int triplets = INTERPRETATION;
            new ArrayList(triplets);
            CoordinateSequence coordSeq = SDOUtils.subList(gf.getCoordinateSequenceFactory(), coords, GTYPE, elemInfo, triplet, false);
            coordSeq = CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)gf.getCoordinateSequenceFactory(), (CoordinateSequence)coordSeq);
            ring = gf.createLinearRing(coordSeq);
        } else if (INTERPRETATION == 1) {
            CoordinateSequence coordSeq = SDOUtils.subList(gf.getCoordinateSequenceFactory(), coords, GTYPE, elemInfo, triplet, false);
            coordSeq = CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)gf.getCoordinateSequenceFactory(), (CoordinateSequence)coordSeq);
            ring = gf.createLinearRing(coordSeq);
        } else if (INTERPRETATION == 2) {
            CoordinateSequence coordSeq = SDOUtils.subList(gf.getCoordinateSequenceFactory(), coords, GTYPE, elemInfo, triplet, false);
            ring = gf.createLinearRing(coordSeq);
        } else if (INTERPRETATION == 3) {
            CoordinateSequence ext = SDOUtils.subList(gf.getCoordinateSequenceFactory(), coords, GTYPE, elemInfo, triplet, false);
            Coordinate min = ext.getCoordinate(0);
            Coordinate max = ext.getCoordinate(1);
            ring = gf.createLinearRing(new Coordinate[]{min, new Coordinate(max.x, min.y), max, new Coordinate(min.x, max.y), min});
        } else {
            throw new IllegalArgumentException("ELEM_INFO INTERPRETAION " + elemInfo[2] + " not supported" + "for JTS Polygon Linear Rings." + "ELEM_INFO INTERPRETATION 1,2 and 3 are supported");
        }
        ring.setSRID(SRID);
        return ring;
    }

    private static MultiPoint createMultiPoint(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int triplet, CoordinateSequence coords) {
        int STARTING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, triplet);
        int eTYPE = SDOUtils.ETYPE(elemInfo, triplet);
        int INTERPRETATION = SDOUtils.INTERPRETATION(elemInfo, triplet);
        int LENGTH = coords.size() * SDOUtils.D(GTYPE);
        if (STARTING_OFFSET < 1 || STARTING_OFFSET > LENGTH) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + STARTING_OFFSET + " inconsistent with ORDINATES length " + coords.size());
        }
        if (eTYPE != 1) {
            throw new IllegalArgumentException("SDOGeometryEType " + eTYPE + " inconsistent with expected POINT");
        }
        if (INTERPRETATION < 1) {
            LOGGER.warn((Object)("Could not create MultiPoint with INTERPRETATION " + INTERPRETATION + " - representing the number of points"));
            return null;
        }
        int LEN = SDOUtils.D(GTYPE);
        int start = (STARTING_OFFSET - 1) / LEN;
        int end = start + INTERPRETATION;
        MultiPoint points = gf.createMultiPoint(SDOUtils.subList(gf.getCoordinateSequenceFactory(), coords, start, end));
        points.setSRID(SRID);
        return points;
    }

    private static MultiLineString createMultiLine(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int triplet, CoordinateSequence coords, int N) {
        int etype;
        int STARTING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, triplet);
        int eTYPE = SDOUtils.ETYPE(elemInfo, triplet);
        int INTERPRETATION = SDOUtils.INTERPRETATION(elemInfo, triplet);
        int LENGTH = coords.size() * SDOUtils.D(GTYPE);
        if (STARTING_OFFSET < 1 || STARTING_OFFSET > LENGTH) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + STARTING_OFFSET + " inconsistent with ORDINATES length " + coords.size());
        }
        if (eTYPE != 2) {
            throw new IllegalArgumentException("SDOGeometryEType " + eTYPE + " inconsistent with expected LINE");
        }
        if (INTERPRETATION != 1) {
            LOGGER.warn((Object)("Could not create MultiLineString with INTERPRETATION " + INTERPRETATION + " - we can only represent 1 for straight edges"));
            return null;
        }
        int endTriplet = N != -1 ? triplet + N : elemInfo.length / 3;
        LinkedList<Geometry> list = new LinkedList<Geometry>();
        int i = triplet;
        while (i < endTriplet && (etype = SDOUtils.ETYPE(elemInfo, i)) != -1) {
            if (etype != 2) break;
            list.add(SDOUtils.createLine(gf, GTYPE, SRID, elemInfo, i, coords, false));
            ++i;
        }
        MultiLineString lines = gf.createMultiLineString(SDOUtils.toLineStringArray(list));
        lines.setSRID(SRID);
        return lines;
    }

    private static MultiPolygon createMultiPolygon(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int triplet, CoordinateSequence coords, int N, boolean threeDimensional) {
        int etype;
        int STARTING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, triplet);
        int eTYPE = SDOUtils.ETYPE(elemInfo, triplet);
        int INTERPRETATION = SDOUtils.INTERPRETATION(elemInfo, triplet);
        int LENGTH = coords.size() * SDOUtils.D(GTYPE);
        if (STARTING_OFFSET < 1 || STARTING_OFFSET > LENGTH) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + STARTING_OFFSET + " inconsistent with ORDINATES length " + coords.size());
        }
        if (eTYPE != 3 && eTYPE != 1003 && eTYPE != 1007 && eTYPE != 2006 && eTYPE != 5 && eTYPE != 1005) {
            throw new IllegalArgumentException("SDOGeometryEType " + eTYPE + " inconsistent with expected POLYGON or POLYGON_EXTERIOR");
        }
        if (eTYPE != 5 && eTYPE != 1005 && INTERPRETATION != 1 && INTERPRETATION != 3) {
            LOGGER.warn((Object)("Could not create MultiPolygon with INTERPRETATION " + INTERPRETATION + " - we can only represent 1 for straight edges, or 3 for rectangle"));
            return null;
        }
        int endTriplet = N != -1 ? triplet + N : elemInfo.length / 3 + 1;
        LinkedList<Polygon> list = new LinkedList<Polygon>();
        int i = triplet;
        while (i < endTriplet && (etype = SDOUtils.ETYPE(elemInfo, i)) != -1) {
            Polygon poly;
            if (etype == 3 || etype == 1003 || etype == 1007 || etype == 2006) {
                poly = SDOUtils.createPolygon(gf, GTYPE, SRID, elemInfo, i, coords);
                i += poly.getNumInteriorRing();
                list.add(poly);
            } else {
                if (etype != 1005 && etype != 5) break;
                poly = SDOUtils.createPolygon(gf, GTYPE, SRID, elemInfo, i, coords);
                int curvilinearElementsCount = SDOUtils.getCurvilinearElementsCount(poly);
                i += curvilinearElementsCount - 1;
                list.add(poly);
            }
            ++i;
        }
        MultiPolygon polys = gf.createMultiPolygon(SDOUtils.toPolygonArray(list));
        polys.setSRID(SRID);
        return polys;
    }

    private static int getCurvilinearElementsCount(Polygon poly) {
        int sum = SDOUtils.getCurvilinearElementsCount((LineString)poly.getExteriorRing());
        int i = 0;
        while (i < poly.getNumInteriorRing()) {
            sum += SDOUtils.getCurvilinearElementsCount((LineString)poly.getInteriorRingN(i));
            ++i;
        }
        return sum;
    }

    private static int getCurvilinearElementsCount(LineString ls) {
        return 1;
    }

    private static GeometryCollection createCollection(GeometryFactory gf, int GTYPE, int SRID, int[] elemInfo, int triplet, CoordinateSequence coords, int N) {
        int STARTING_OFFSET = SDOUtils.STARTING_OFFSET(elemInfo, triplet);
        int LENGTH = coords.size() * SDOUtils.D(GTYPE);
        if (STARTING_OFFSET < 1 || STARTING_OFFSET > LENGTH) {
            throw new IllegalArgumentException("ELEM_INFO STARTING_OFFSET " + STARTING_OFFSET + " inconsistent with ORDINATES length " + coords.size());
        }
        int endTriplet = N != -1 ? triplet + N : elemInfo.length / 3 + 1;
        LinkedList<Polygon> list = new LinkedList<Polygon>();
        int i = triplet;
        block7: while (i < endTriplet) {
            Polygon geom;
            int etype = SDOUtils.ETYPE(elemInfo, i);
            int interpretation = SDOUtils.INTERPRETATION(elemInfo, i);
            switch (etype) {
                case -1: {
                    break block7;
                }
                case 1: {
                    if (interpretation == 1) {
                        geom = SDOUtils.createPoint(gf, GTYPE, SRID, elemInfo, i, coords);
                        break;
                    }
                    if (interpretation > 1) {
                        geom = SDOUtils.createMultiPoint(gf, GTYPE, SRID, elemInfo, i, coords);
                        break;
                    }
                    throw new IllegalArgumentException("SDOGeometryEType.POINT requires INTERPRETATION >= 1");
                }
                case 2: {
                    geom = SDOUtils.createLine(gf, GTYPE, SRID, elemInfo, i, coords, false);
                    break;
                }
                case 3: 
                case 1003: {
                    geom = SDOUtils.createPolygon(gf, GTYPE, SRID, elemInfo, i, coords);
                    i += geom.getNumInteriorRing();
                    break;
                }
                case 2003: {
                    throw new IllegalArgumentException("SDOGeometryEType 2003 (Polygon Interior) no expected in a GeometryCollection(2003 is used to represent polygon holes, in a 1003 polygon exterior)");
                }
                default: {
                    throw new IllegalArgumentException("SDOGeometryEType " + etype + " not representable as a JTS Geometry." + "(Custom and Compound Straight and Curved Geometries not supported)");
                }
            }
            list.add(geom);
            ++i;
        }
        GeometryCollection geoms = gf.createGeometryCollection(SDOUtils.toGeometryArray(list));
        geoms.setSRID(SRID);
        return geoms;
    }
}

