/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.timestream;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AWSTimestreamDataSourceProvider
extends GenericDataSourceProvider {
    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return super.openDataSource(monitor, container);
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String sessionToken;
        String secretKey;
        StringBuilder url = new StringBuilder("jdbc:timestream://");
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("Region", connectionInfo.getHostName());
        String accessKey = connectionInfo.getAuthProperty("iam.aws_access_key");
        if (!CommonUtils.isEmpty((String)accessKey)) {
            props.put("AccessKeyId", accessKey);
        }
        if (!CommonUtils.isEmpty((String)(secretKey = connectionInfo.getAuthProperty("iam.aws_secret_key")))) {
            props.put("SecretAccessKey", secretKey);
        }
        if (!CommonUtils.isEmpty((String)(sessionToken = connectionInfo.getAuthProperty("iam.aws_session_token")))) {
            props.put("SessionToken", sessionToken);
        }
        props.putAll(connectionInfo.getProperties());
        for (Map.Entry prop : props.entrySet()) {
            url.append((String)prop.getKey()).append("=").append((String)prop.getValue()).append(";");
        }
        return url.toString();
    }
}

