/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DateTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import java.sql.SQLException;

public class UnicodeInternalDateTranslator
extends DateTranslator {
    public UnicodeInternalDateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected int parseYear(byte[] raw) {
        int year = (raw[1] - 48) * 1000;
        year += (raw[3] - 48) * 100;
        year += (raw[5] - 48) * 10;
        return year += raw[7] - 48;
    }

    protected int parseMonth(byte[] raw) {
        int month = (raw[9] - 48) * 10;
        return month += raw[11] - 48;
    }

    protected int parseDay(byte[] raw) {
        int day = (raw[13] - 48) * 10;
        return day += raw[15] - 48;
    }

    protected byte[] formatDate(int year, int month, int day) {
        byte[] formattedDate = new byte[16];
        formattedDate[1] = (byte)(48 + year / 1000);
        formattedDate[3] = (byte)(48 + (year %= 1000) / 100);
        formattedDate[5] = (byte)(48 + (year %= 100) / 10);
        formattedDate[7] = (byte)(48 + (year %= 10));
        formattedDate[9] = HighTime_C[month];
        formattedDate[11] = LowTime_C[month];
        formattedDate[13] = HighTime_C[day];
        formattedDate[15] = LowTime_C[day];
        return formattedDate;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            byte[] tmpArr = new byte[]{raw[1], raw[3], raw[5], raw[7], 45, raw[9], raw[11], 45, raw[13], raw[15]};
            result = new String(tmpArr);
        }
        return result;
    }
}

