/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.CallableStatementSapDB;
import com.sap.dbtech.jdbc.ColumnInfo;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.ResultSetMetaDataSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class UpdatableResultSetSapDB
extends ResultSetSapDB
implements ResultSet {
    private String tableName;
    private CallableStatementSapDB insertCmd;
    private CallableStatementSapDB updateCmd;
    private CallableStatementSapDB deleteCmd;
    private CallableStatementSapDB currentChangeCmd;
    private int[] updateColMapping;
    private int savedCurrentRow;
    private int savedPositionState;
    private static final int MODE_READ = 0;
    private static final int MODE_INSERT = 1;
    private static final int MODE_UPDATE = 2;
    private int currentMode = 0;

    UpdatableResultSetSapDB(ConnectionSapDB connection, FetchInfo fetchInfo, StatementSapDB producer, int fetchSize, int maxRow, String tableName, int cursorType, ReplyPacket reply) throws SQLException {
        super(connection, fetchInfo, producer, fetchSize, maxRow, cursorType, reply);
        this.tableName = tableName;
    }

    UpdatableResultSetSapDB(ConnectionSapDB connection, String cursorName, DBTechTranslator[] infos, ColumnInfo[] colNames, StatementSapDB producer, int fetchSize, int maxRow, String tableName, int cursorType, ReplyPacket reply) throws SQLException {
        super(connection, cursorName, infos, colNames, producer, fetchSize, maxRow, cursorType, reply);
        this.tableName = tableName;
    }

    public boolean absolute(int row) throws SQLException {
        this.internalCancelRowUpdates();
        return super.absolute(row);
    }

    public void afterLast() throws SQLException {
        this.internalCancelRowUpdates();
        super.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.internalCancelRowUpdates();
        super.beforeFirst();
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.currentMode == 1) {
            throw SQLExceptionSapDB.generateSQLException("error.cancelupdates.insertrow");
        }
        this.internalCancelRowUpdates();
    }

    private void internalCancelRowUpdates() throws SQLException {
        if (this.currentChangeCmd != null) {
            this.currentChangeCmd.clearParameters();
        }
        this.currentMode = 0;
    }

    public void deleteRow() throws SQLException {
        this.assertNotClosed();
        if (this.currentMode == 1) {
            throw SQLExceptionSapDB.generateSQLException("error.deleterow.insertrow");
        }
        int i = this.getRow();
        if (i == 0) {
            throw SQLExceptionSapDB.generateSQLException("error.deleterow.norow");
        }
        if (this.deleteCmd == null) {
            String cmdString = "DELETE FROM " + this.tableName + " WHERE POS OF \"" + this.getCursorName() + "\" IS ? ";
            this.deleteCmd = (CallableStatementSapDB)this.connection.prepareStatement(cmdString);
        }
        this.deleteCmd.setInt(1, i);
        this.deleteCmd.execute();
        this.initializeFields();
        this.absolute(i);
    }

    private int findUpdateColumn(int colIndex) throws SQLException {
        this.assertNotClosed();
        this.prepareUpdate();
        int result = 0;
        boolean outOfBoundExceptionCatched = false;
        try {
            result = this.updateColMapping[colIndex];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            outOfBoundExceptionCatched = true;
        }
        if (result == 0 || outOfBoundExceptionCatched) {
            if (colIndex > 0 && colIndex < this.getColInfo().length) {
                throw SQLExceptionSapDB.generateSQLException("error.updaterow.columnnotupdatable", this.getColInfo()[colIndex - 1].getColumnName());
            }
            throw SQLExceptionSapDB.generateSQLException("error.invalidcolumnindex", Integer.toString(colIndex));
        }
        return result;
    }

    private int findUpdateColumn(String colName) throws SQLException {
        int index = this.findColumnInfo(colName).getColIndex();
        return this.findUpdateColumn(index + 1);
    }

    public boolean first() throws SQLException {
        this.internalCancelRowUpdates();
        return super.first();
    }

    public int getConcurrency() throws SQLException {
        this.assertNotClosed();
        return 1008;
    }

    public void insertRow() throws SQLException {
        if (this.currentMode != 1) {
            throw new SQLException(MessageTranslator.translate("error.insertrow.insertrow"));
        }
        this.insertCmd.executeUpdate();
        this.currentMode = 1;
    }

    public boolean last() throws SQLException {
        this.internalCancelRowUpdates();
        return super.last();
    }

    public void moveToInsertRow() throws SQLException {
        this.assertNotClosed();
        switch (this.currentMode) {
            case 1: {
                break;
            }
            case 2: {
                this.internalCancelRowUpdates();
            }
            case 0: {
                if (this.insertCmd == null) {
                    this.insertCmd = this.prepareHelper(1);
                }
                this.savedPositionState = this.positionState;
                this.savedCurrentRow = this.getRow();
                this.currentChangeCmd = this.insertCmd;
                this.currentMode = 1;
            }
        }
    }

    public void moveToCurrentRow() throws SQLException {
        this.assertNotClosed();
        if (this.currentMode == 1) {
            if (this.currentChangeCmd != null) {
                this.currentChangeCmd.clearParameters();
            }
            this.currentMode = 0;
            switch (this.savedPositionState) {
                case 1: {
                    this.beforeFirst();
                    break;
                }
                case 3: {
                    this.afterLast();
                    break;
                }
                default: {
                    if (this.savedPositionState != 0) {
                        this.absolute(this.savedCurrentRow);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            return;
        }
    }

    private CallableStatementSapDB prepareHelper(int mode) throws SQLException {
        String finale;
        String prelude;
        switch (mode) {
            case 2: {
                prelude = "UPDATE " + this.tableName + " SET \"";
                finale = "\" = ? WHERE POS OF \"" + this.getCursorName() + "\" IS ? ";
                break;
            }
            case 1: {
                prelude = "INSERT INTO " + this.tableName + " SET \"";
                finale = "\" = ?";
                break;
            }
            default: {
                return null;
            }
        }
        CallableStatementSapDB result = null;
        DBTechTranslator[] colInfo = this.getColInfo();
        int colinfo_length = colInfo.length;
        Vector<String> validColumns = new Vector<String>(colinfo_length);
        for (int i = 0; i < colinfo_length; ++i) {
            validColumns.addElement(colInfo[i].getColumnName());
        }
        for (int colcount = colinfo_length; result == null && validColumns.size() > 0 && colcount > 0; --colcount) {
            String columns = StringUtil.join(validColumns.elements(), "\" = ?, \"");
            String sqlCmd = prelude + columns + finale;
            try {
                result = (CallableStatementSapDB)this.getConnection().prepareCall(sqlCmd);
                result.statementType = 2;
                continue;
            }
            catch (SQLException sqlExc) {
                if (sqlExc.getErrorCode() == -7032) {
                    throw sqlExc;
                }
                try {
                    Method getPosMeth = sqlExc.getClass().getMethod("getErrorPos", new Class[0]);
                    Integer err = (Integer)getPosMeth.invoke((Object)sqlExc, new Object[0]);
                    int errPos = err - 1;
                    if (errPos < prelude.length()) {
                        throw SQLExceptionSapDB.generateSQLException("error.internal.preparehelper", sqlExc);
                    }
                    int endCol = sqlCmd.indexOf(34, errPos);
                    String colName = sqlCmd.substring(errPos, endCol);
                    validColumns.removeElement(colName);
                    continue;
                }
                catch (Throwable e) {
                    throw SQLExceptionSapDB.generateSQLException("error.internal.preparehelper", sqlExc);
                }
            }
        }
        if (result == null) {
            throw SQLExceptionSapDB.generateSQLException("error.nocolumns.updatable");
        }
        int count = validColumns.size();
        this.updateColMapping = new int[colinfo_length + 1];
        boolean useDefaultValue = DriverSapDB.getBooleanProperty(this.connection.getConnectProperties(), "useDefaultValueForUpdatableRS", false);
        for (int i = 0; i < count; ++i) {
            DBTechTranslator current = this.findColumnInfo((String)validColumns.elementAt(i));
            current.allowWrites();
            this.updateColMapping[current.getColIndex() + 1] = i + 1;
            if (mode != 1) continue;
            if (useDefaultValue) {
                result.setDefault(i + 1);
                continue;
            }
            result.setNull(i + 1, 1111);
        }
        return result;
    }

    private void prepareUpdate() throws SQLException {
        if (this.currentMode == 0) {
            if (this.updateCmd == null) {
                this.updateCmd = this.prepareHelper(2);
            }
            this.currentChangeCmd = this.updateCmd;
            this.currentMode = 2;
        }
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setAsciiStream(updIndex, x, length);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setAsciiStream(updIndex, x, length);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBigDecimal(updIndex, x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBigDecimal(updIndex, x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBinaryStream(updIndex, x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBinaryStream(updIndex, x, length);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBoolean(updIndex, x);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBoolean(updIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setByte(updIndex, x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setByte(updIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBytes(updIndex, x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBytes(updIndex, x);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setCharacterStream(updIndex, x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setCharacterStream(updIndex, reader, length);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setDate(updIndex, x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setDate(updIndex, x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setDouble(updIndex, x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setDouble(updIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setFloat(updIndex, x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setFloat(updIndex, x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setInt(updIndex, x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setInt(updIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setLong(updIndex, x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setLong(updIndex, x);
    }

    public void updateNull(int columnIndex) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setNull(updIndex, 0);
    }

    public void updateNull(String columnName) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setNull(updIndex, 0);
    }

    public void updateDefault(String columnName) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setDefault(updIndex);
    }

    public void updateDefault(int columnIndex) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setDefault(updIndex);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setObject(updIndex, x);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setObject(updIndex, x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setObject(updIndex, x);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setObject(updIndex, x, scale);
    }

    private CallableStatementSapDB generatePartialUpdateStatement() throws SQLException {
        StringBuffer tmpStmtString = new StringBuffer("UPDATE " + this.tableName + " SET \"");
        Object[] args = this.updateCmd.getInputArgs();
        DBTechTranslator[] colInfo = this.getColInfo();
        String delimiter = "";
        for (int i = 1; i < this.updateColMapping.length; ++i) {
            int colind = this.updateColMapping[i];
            if (colind == 0 || !this.updateCmd.isParameterSet(colind)) continue;
            tmpStmtString.append(delimiter);
            tmpStmtString.append(colInfo[i - 1].getColumnName());
            delimiter = "\" = ?, \"";
        }
        tmpStmtString.append("\" = ? WHERE POS OF \"" + this.getCursorName() + "\" IS ? ");
        CallableStatementSapDB updCmd = null;
        try {
            updCmd = (CallableStatementSapDB)this.connection.prepareCall(tmpStmtString.toString());
        }
        catch (SQLException sql) {
            throw SQLExceptionSapDB.generateSQLException("error.internal.preparehelper", sql);
        }
        Object[] newargs = updCmd.getInputArgs();
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            if (!this.updateCmd.isParameterSet(i + 1)) continue;
            newargs[j++] = args[i];
        }
        return updCmd;
    }

    public void updateRow() throws SQLException {
        CallableStatementSapDB updCmd = this.updateCmd;
        int safeCurrentMode = this.currentMode;
        CallableStatementSapDB saveCurrentChangeCmd = this.currentChangeCmd;
        this.currentChangeCmd = null;
        int internal = this.getRow();
        this.currentMode = safeCurrentMode;
        this.currentChangeCmd = saveCurrentChangeCmd;
        if (internal == 0) {
            throw SQLExceptionSapDB.generateSQLException("error.updaterow.norow");
        }
        if (this.currentMode == 2) {
            Object[] args = this.updateCmd.getInputArgs();
            boolean needPartialUpdate = false;
            for (int i = 1; i < args.length; ++i) {
                if (this.updateCmd.isParameterSet(i)) continue;
                needPartialUpdate = true;
                break;
            }
            if (needPartialUpdate) {
                this.currentChangeCmd = updCmd = this.generatePartialUpdateStatement();
            }
            updCmd.setInt(updCmd.parseinfo.inputCount, internal);
            updCmd.executeUpdate();
            if (needPartialUpdate) {
                this.currentChangeCmd = saveCurrentChangeCmd;
            }
            this.absolute(internal);
            this.currentMode = 0;
            this.modifiedKernelPos = internal;
        } else if (this.currentMode == 1) {
            throw SQLExceptionSapDB.generateSQLException("error.updaterow.insertrow");
        }
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setShort(updIndex, x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setShort(updIndex, x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setString(updIndex, x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setString(updIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setTime(updIndex, x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setTime(updIndex, x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setTimestamp(updIndex, x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setTimestamp(updIndex, x);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBlob(updIndex, x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBlob(updIndex, x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setClob(updIndex, x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setClob(updIndex, x);
    }

    public void cancel() throws SQLException {
        this.currentChangeCmd.cancel();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.assertNotClosed();
        return new ResultSetMetaDataSapDB(this.fetchInfo.getColInfo(), this.tableName);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setAsciiStream(updIndex, x, length);
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setAsciiStream(updIndex, x);
    }

    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setAsciiStream(updIndex, x, length);
    }

    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setAsciiStream(updIndex, x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBinaryStream(updIndex, x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBinaryStream(updIndex, x);
    }

    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBinaryStream(updIndex, x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBinaryStream(updIndex, x);
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBinaryStream(updIndex, inputStream, length);
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setBinaryStream(updIndex, inputStream);
    }

    public void updateBlob(String columnName, InputStream inputStream, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBinaryStream(updIndex, inputStream);
    }

    public void updateBlob(String columnName, InputStream inputStream) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setBinaryStream(updIndex, inputStream);
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setCharacterStream(updIndex, x, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setCharacterStream(updIndex, x);
    }

    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setCharacterStream(updIndex, reader, length);
    }

    public void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setCharacterStream(updIndex, reader);
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setCharacterStream(updIndex, reader, length);
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        int updIndex = this.findUpdateColumn(columnIndex);
        this.currentChangeCmd.setCharacterStream(updIndex, reader);
    }

    public void updateClob(String columnName, Reader reader, long length) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setCharacterStream(updIndex, reader, length);
    }

    public void updateClob(String columnName, Reader reader) throws SQLException {
        int updIndex = this.findUpdateColumn(columnName);
        this.currentChangeCmd.setCharacterStream(updIndex, reader);
    }
}

