/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.utilities.MetadataColumn;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.OrderType;
import com.vertica.dsi.dataengine.utilities.Searchable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.GeneralException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MetadataColumnFactory {
    public static ArrayList<MetadataColumn> createMetadataColumns(IStatement statement, MetadataSourceID metadataSourceId) throws ErrorException {
        LogUtilities.logFunctionEntrance(statement.getLog(), new Object[]{statement, metadataSourceId});
        switch (metadataSourceId) {
            case COLUMN_PRIVILEGES: {
                return MetadataColumnFactory.createColumnPrivilegesMetadata(statement);
            }
            case COLUMNS: {
                return MetadataColumnFactory.createColumnsMetadata(statement);
            }
            case FOREIGN_KEYS: {
                return MetadataColumnFactory.createForeignKeysMetadata(statement);
            }
            case FUNCTIONS_JDBC4: {
                return MetadataColumnFactory.createFunctionMetadata(statement);
            }
            case FUNCTION_COLUMNS_JDBC4: {
                return MetadataColumnFactory.createFunctionColumnsMetadata(statement);
            }
            case PRIMARY_KEYS: {
                return MetadataColumnFactory.createPrimaryKeysMetadata(statement);
            }
            case PROCEDURE_COLUMNS: {
                return MetadataColumnFactory.createProcedureColumnsMetadata(statement);
            }
            case PROCEDURES: {
                return MetadataColumnFactory.createProceduresMetadata(statement);
            }
            case PSEUDO_COLUMNS_JDBC41: {
                return MetadataColumnFactory.createPseudoColumnsMetadata(statement);
            }
            case SPECIAL_COLUMNS: {
                return MetadataColumnFactory.createSpecialColumnsMetadata(statement);
            }
            case STATISTICS: {
                return MetadataColumnFactory.createStatisticsMetadata(statement);
            }
            case TABLE_PRIVILEGES: {
                return MetadataColumnFactory.createTablePrivilegesMetadata(statement);
            }
            case CATALOG_ONLY: 
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: 
            case TABLES: 
            case TABLETYPE_ONLY: {
                return MetadataColumnFactory.createTablesMetadata(statement, metadataSourceId);
            }
            case TYPE_INFO: {
                return MetadataColumnFactory.createTypeInfoMetadata();
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), metadataSourceId.toString(), ExceptionType.DEFAULT);
    }

    public static List<MetadataSourceColumnTag> getSortOrder(ILogger logger, MetadataSourceID metadataSourceId, List<IFilter> filters, OrderType orderType) throws ErrorException {
        LogUtilities.logFunctionEntrance(logger, new Object[]{metadataSourceId});
        switch (metadataSourceId) {
            case COLUMN_PRIVILEGES: {
                return MetadataColumnFactory.getColumnPrivilegesMetadataSortOrder(orderType);
            }
            case COLUMNS: {
                return MetadataColumnFactory.getColumnsMetadataSortOrder(orderType);
            }
            case FOREIGN_KEYS: {
                return MetadataColumnFactory.getForeignKeysMetadataSortOrder(filters);
            }
            case FUNCTIONS_JDBC4: {
                return MetadataColumnFactory.getFunctionMetadataSortOrder();
            }
            case FUNCTION_COLUMNS_JDBC4: {
                return MetadataColumnFactory.getFunctionColumnsMetadataSortOrder();
            }
            case PSEUDO_COLUMNS_JDBC41: {
                return MetadataColumnFactory.getPseudoColumnsMetadataSortOrder();
            }
            case PRIMARY_KEYS: {
                return MetadataColumnFactory.getPrimaryKeysMetadataSortOrder(orderType);
            }
            case PROCEDURE_COLUMNS: {
                return MetadataColumnFactory.getProcedureColumnsMetadataSortOrder(orderType);
            }
            case PROCEDURES: {
                return MetadataColumnFactory.getProceduresMetadataSortOrder(orderType);
            }
            case SPECIAL_COLUMNS: {
                return MetadataColumnFactory.getBestRowIdentifierMetadataSortOrder(filters);
            }
            case STATISTICS: {
                return MetadataColumnFactory.getStatisticsMetadataSortOrder(orderType);
            }
            case TABLE_PRIVILEGES: {
                return MetadataColumnFactory.getTablePrivilegesMetadataSortOrder(orderType);
            }
            case CATALOG_SCHEMA_ONLY: {
                return MetadataColumnFactory.getCatalogSchemaOnlyMetadataSortOrder(orderType);
            }
            case CATALOG_ONLY: {
                return MetadataColumnFactory.getCatalogOnlyMetadataSortOrder();
            }
            case TABLES: 
            case TABLETYPE_ONLY: {
                return MetadataColumnFactory.getTablesMetadataSortOrder(orderType);
            }
            case SCHEMA_ONLY: {
                return MetadataColumnFactory.getSchemasMetadataSortOrder(orderType);
            }
            case TYPE_INFO: {
                return MetadataColumnFactory.getTypeInfoMetadataSortOrder();
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), metadataSourceId.toString(), ExceptionType.DEFAULT);
    }

    private static ArrayList<MetadataColumn> createColumnPrivilegesMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxTableNameLen = MetadataColumnFactory.getMaxLength(connection, 83);
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            int maxUserNameLen = MetadataColumnFactory.getMaxLength(connection, 85);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.GRANTOR);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("GRANTOR");
            column.setName(column.getLabel());
            column.setColumnLength(maxUserNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.GRANTEE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("GRANTEE");
            column.setName(column.getLabel());
            column.setColumnLength(maxUserNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIVILEGE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PRIVILEGE");
            column.setName(column.getLabel());
            column.setColumnLength(32L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.ISGRANTABLE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_GRANTABLE");
            column.setName(column.getLabel());
            column.setColumnLength(3L);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createColumnsMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxTableNameLen = MetadataColumnFactory.getMaxLength(connection, 83);
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TYPE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(128L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_SIZE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.BUFFER_LENGTH);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("BUFFER_LENGTH");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DECIMAL_DIGITS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DECIMAL_DIGITS");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NUM_PREC_RADIX);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NUM_PREC_RADIX");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NULLABLE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NULLABLE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("REMARKS");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_DEF);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_DEF");
            column.setName(column.getLabel());
            column.setColumnLength(4000L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATA_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SQL_DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATETIME_SUB);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SQL_DATETIME_SUB");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.CHAR_OCTET_LENGTH);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("CHAR_OCTET_LENGTH");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.ORDINAL_POSITION);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("ORDINAL_POSITION");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.IS_NULLABLE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_NULLABLE");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.IS_AUTOINCREMENT);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_AUTOINCREMENT");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("USER_DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.IS_GENERATEDCOLUMN);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_GENERATEDCOLUMN");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createFunctionMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxProcedureNameLen = MetadataColumnFactory.getMaxLength(connection, 78);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FUNCTION_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FUNCTION_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PROCEDURE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FUNCTION_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxProcedureNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("REMARKS");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.PROCEDURE_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PROCEDURE_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SPECIFIC_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SPECIFIC_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxProcedureNameLen);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createFunctionColumnsMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxProcedureNameLen = MetadataColumnFactory.getMaxLength(connection, 78);
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FUNCTION_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FUNCTION_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PROCEDURE_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FUNCTION_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxProcedureNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.PROCEDURE_COLUMN_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TYPE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(128L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_SIZE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.BUFFER_LENGTH);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("BUFFER_LENGTH");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DECIMAL_DIGITS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DECIMAL_DIGITS");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NUM_PREC_RADIX);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NUM_PREC_RADIX");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NULLABLE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NULLABLE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("REMARKS");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.CHAR_OCTET_LENGTH);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("CHAR_OCTET_LENGTH");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.ORDINAL_POSITION);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("ORDINAL_POSITION");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.IS_NULLABLE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_NULLABLE");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SPECIFIC_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SPECIFIC_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxProcedureNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("USER_DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createForeignKeysMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxTableNameLen = MetadataColumnFactory.getMaxLength(connection, 83);
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PKTABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PKTABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PKTABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PKCOLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FKTABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FKTABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FKTABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FKCOLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.KEY_SEQ);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("KEY_SEQ");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.FOREIGN_KEY_UPDATE_RULE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("UPDATE_RULE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.FOREIGN_KEY_DELETE_RULE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DELETE_RULE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.FOREIGN_KEY_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FK_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PK_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DEFERRABILITY);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DEFERRABILITY");
            column.setName(column.getLabel());
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createPrimaryKeysMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxTableNameLen = MetadataColumnFactory.getMaxLength(connection, 83);
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.KEY_SEQ);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("KEY_SEQ");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIMARY_KEY_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PK_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createProcedureColumnsMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxProcedureNameLen = MetadataColumnFactory.getMaxLength(connection, 78);
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PROCEDURE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PROCEDURE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PROCEDURE_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PROCEDURE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxProcedureNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.PROCEDURE_COLUMN_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TYPE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(128L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_SIZE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.BUFFER_LENGTH);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("BUFFER_LENGTH");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DECIMAL_DIGITS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DECIMAL_DIGITS");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NUM_PREC_RADIX);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NUM_PREC_RADIX");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NULLABLE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NULLABLE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("REMARKS");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_DEF);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_DEF");
            column.setName(column.getLabel());
            column.setColumnLength(4000L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATA_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SQL_DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATETIME_SUB);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SQL_DATETIME_SUB");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.CHAR_OCTET_LENGTH);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("CHAR_OCTET_LENGTH");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.ORDINAL_POSITION);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("ORDINAL_POSITION");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.IS_NULLABLE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_NULLABLE");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SPECIFIC_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SPECIFIC_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxProcedureNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.IS_RESULT_SET);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_RESULT_SET_COLUMN");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("USER_DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createProceduresMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxProcedureNameLen = MetadataColumnFactory.getMaxLength(connection, 78);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PROCEDURE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PROCEDURE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PROCEDURE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PROCEDURE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxProcedureNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.NUM_INPUT_PARAMS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NUM_INPUT_PARAMS");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.NUM_OUTPUT_PARAMS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NUM_OUTPUT_PARAMS");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.NUM_RESULT_SETS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NUM_RESULT_SETS");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("REMARKS");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.PROCEDURE_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PROCEDURE_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SPECIFIC_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SPECIFIC_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxProcedureNameLen);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createPseudoColumnsMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxTableNameLen = MetadataColumnFactory.getMaxLength(connection, 83);
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_SIZE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DECIMAL_DIGITS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DECIMAL_DIGITS");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NUM_PREC_RADIX);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NUM_PREC_RADIX");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_USAGE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_USAGE");
            column.setColumnLength(254L);
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("REMARKS");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.CHAR_OCTET_LENGTH);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("CHAR_OCTET_LENGTH");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.IS_NULLABLE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_NULLABLE");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createSpecialColumnsMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SCOPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SCOPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TYPE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(128L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_SIZE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.BUFFER_LENGTH);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("BUFFER_LENGTH");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DECIMAL_DIGITS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DECIMAL_DIGITS");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.PSEUDO);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PSEUDO_COLUMN");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("USER_DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createStatisticsMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxTableNameLen = MetadataColumnFactory.getMaxLength(connection, 83);
            int maxColumnNameLen = MetadataColumnFactory.getMaxLength(connection, 68);
            int maxIdentifierNameLen = MetadataColumnFactory.getMaxLength(connection, 76);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NON_UNIQUE_INDEX);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NON_UNIQUE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.INDEX_QUALIFIER);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("INDEX_QUALIFIER");
            column.setName(column.getLabel());
            column.setColumnLength(maxIdentifierNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.INDEX_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("INDEX_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.INDEX_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.ORDINAL_POSITION);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("ORDINAL_POSITION");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.COLUMN_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(1), MetadataSourceColumnTag.INDEX_SORT_SEQUENCE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("ASC_OR_DESC");
            column.setName(column.getLabel());
            column.setColumnLength(1L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.INDEX_CARDINALITY);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("CARDINALITY");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.INDEX_PAGES);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PAGES");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.INDEX_FILTER_CONDITION);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FILTER_CONDITION");
            column.setName(column.getLabel());
            column.setColumnLength(maxColumnNameLen);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createTablePrivilegesMetadata(IStatement statement) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxTableNameLen = MetadataColumnFactory.getMaxLength(connection, 83);
            int maxUserNameLen = MetadataColumnFactory.getMaxLength(connection, 85);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.GRANTOR);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("GRANTOR");
            column.setName(column.getLabel());
            column.setColumnLength(maxUserNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.GRANTEE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("GRANTEE");
            column.setName(column.getLabel());
            column.setColumnLength(maxUserNameLen);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.PRIVILEGE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("PRIVILEGE");
            column.setName(column.getLabel());
            column.setColumnLength(32L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.ISGRANTABLE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("IS_GRANTABLE");
            column.setName(column.getLabel());
            column.setColumnLength(3L);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createTablesMetadata(IStatement statement, MetadataSourceID metadataSourceID) throws ErrorException {
        IConnection connection = statement.getParentConnection();
        try {
            int maxCatalogNameLen = MetadataColumnFactory.getMaxLength(connection, 66);
            int maxSchemaNameLen = MetadataColumnFactory.getMaxLength(connection, 81);
            int maxTableNameLen = MetadataColumnFactory.getMaxLength(connection, 83);
            ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CATALOG_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_CAT");
            column.setName(column.getLabel());
            column.setColumnLength(maxCatalogNameLen);
            column.setNullColumn(MetadataSourceID.TABLES != metadataSourceID && MetadataSourceID.CATALOG_ONLY != metadataSourceID && MetadataSourceID.CATALOG_SCHEMA_ONLY != metadataSourceID);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.SCHEMA_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_SCHEM");
            column.setName(column.getLabel());
            column.setColumnLength(maxSchemaNameLen);
            column.setNullColumn(MetadataSourceID.TABLES != metadataSourceID && MetadataSourceID.SCHEMA_ONLY != metadataSourceID && MetadataSourceID.CATALOG_SCHEMA_ONLY != metadataSourceID);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(maxTableNameLen);
            column.setNullColumn(MetadataSourceID.TABLES != metadataSourceID);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.TABLE_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TABLE_TYPE");
            column.setName(column.getLabel());
            column.setColumnLength(32L);
            column.setNullColumn(MetadataSourceID.TABLES != metadataSourceID && MetadataSourceID.TABLETYPE_ONLY != metadataSourceID);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.REMARKS);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("REMARKS");
            column.setName(column.getLabel());
            column.setColumnLength(254L);
            column.setNullColumn(MetadataSourceID.TABLES != metadataSourceID);
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static ArrayList<MetadataColumn> createTypeInfoMetadata() throws ErrorException {
        ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
        try {
            MetadataColumn column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.DATA_TYPE_NAME);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("TYPE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(128L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.DATA_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.COLUMN_SIZE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("COLUMN_SIZE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.LITERAL_PREFIX);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("LITERAL_PREFIX");
            column.setName(column.getLabel());
            column.setColumnLength(32L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.LITERAL_SUFFIX);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("LITERAL_SUFFIX");
            column.setName(column.getLabel());
            column.setColumnLength(32L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.CREATE_PARAM);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("CREATE_PARAMS");
            column.setName(column.getLabel());
            column.setColumnLength(32L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.NULLABLE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NULLABLE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.CASE_SENSITIVE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("CASE_SENSITIVE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SEARCHABLE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SEARCHABLE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.UNSIGNED_ATTRIBUTE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("UNSIGNED_ATTRIBUTE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.FIXED_PREC_SCALE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("FIXED_PREC_SCALE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.AUTO_UNIQUE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("AUTO_UNIQUE_VALUE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(12), MetadataSourceColumnTag.LOCAL_TYPE_NAME);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("LOCAL_TYPE_NAME");
            column.setName(column.getLabel());
            column.setColumnLength(128L);
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.MINIMUM_SCALE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("MINIMUM_SCALE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.MAXIMUM_SCALE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("MAXIMUM_SCALE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATA_TYPE);
            column.setNullable(Nullable.NO_NULLS);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SQL_DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.SQL_DATETIME_SUB);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("SQL_DATETIME_SUB");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(4, true), MetadataSourceColumnTag.NUM_PREC_RADIX);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("NUM_PREC_RADIX");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, true), MetadataSourceColumnTag.INTERVAL_PRECISION);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("INTERVAL_PRECISION");
            column.setName(column.getLabel());
            columns.add(column);
            column = new MetadataColumn(TypeMetadata.createTypeMetadata(5, false), MetadataSourceColumnTag.USER_DATA_TYPE);
            column.setNullable(Nullable.NULLABLE);
            column.setSearchable(Searchable.PREDICATE_NONE);
            column.setUpdatable(Updatable.READ_ONLY);
            column.setLabel("USER_DATA_TYPE");
            column.setName(column.getLabel());
            columns.add(column);
            return columns;
        }
        catch (ErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralException(e.getLocalizedMessage(), 0);
        }
    }

    private static List<MetadataSourceColumnTag> getCatalogOnlyMetadataSortOrder() {
        return Collections.singletonList(MetadataSourceColumnTag.CATALOG_NAME);
    }

    private static List<MetadataSourceColumnTag> getCatalogSchemaOnlyMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
        sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getColumnsMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
        sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
        sortOrder.add(MetadataSourceColumnTag.TABLE_NAME);
        sortOrder.add(MetadataSourceColumnTag.ORDINAL_POSITION);
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getColumnPrivilegesMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        if (OrderType.ODBC == orderType) {
            sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
            sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
            sortOrder.add(MetadataSourceColumnTag.TABLE_NAME);
        }
        sortOrder.add(MetadataSourceColumnTag.COLUMN_NAME);
        sortOrder.add(MetadataSourceColumnTag.PRIVILEGE);
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getForeignKeysMetadataSortOrder(List<IFilter> filters) throws ErrorException {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        if (null != filters.get(0)) {
            if (null != filters.get(3)) {
                sortOrder.add(MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME);
                sortOrder.add(MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
                sortOrder.add(MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
                sortOrder.add(MetadataSourceColumnTag.KEY_SEQ);
            } else {
                sortOrder.add(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
                sortOrder.add(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
                sortOrder.add(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
                sortOrder.add(MetadataSourceColumnTag.KEY_SEQ);
            }
        } else if (null != filters.get(3)) {
            sortOrder.add(MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME);
            sortOrder.add(MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
            sortOrder.add(MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
            sortOrder.add(MetadataSourceColumnTag.KEY_SEQ);
        } else {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), MetadataSourceID.FOREIGN_KEYS.toString(), ExceptionType.DEFAULT);
        }
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getFunctionMetadataSortOrder() {
        return MetadataColumnFactory.getProceduresMetadataSortOrder(OrderType.JDBC_4);
    }

    private static List<MetadataSourceColumnTag> getFunctionColumnsMetadataSortOrder() {
        return MetadataColumnFactory.getProcedureColumnsMetadataSortOrder(OrderType.JDBC_4);
    }

    private static int getMaxLength(IConnection in_connection, int in_propKey) throws NumericOverflowException, IncorrectTypeException, BadPropertyKeyException, ErrorException {
        int result = in_connection.getProperty(in_propKey).getInt();
        if (0 == result) {
            return 1024;
        }
        return result;
    }

    private static List<MetadataSourceColumnTag> getPrimaryKeysMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        if (OrderType.ODBC == orderType) {
            sortOrder.add(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
            sortOrder.add(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
            sortOrder.add(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
            sortOrder.add(MetadataSourceColumnTag.KEY_SEQ);
        }
        sortOrder.add(MetadataSourceColumnTag.PRIMARY_KEY_COLUMN_NAME);
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getProcedureColumnsMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        if (OrderType.JDBC_4 == orderType || OrderType.JDBC_41 == orderType || OrderType.JDBC_42 == orderType) {
            sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
            sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
            sortOrder.add(MetadataSourceColumnTag.PROCEDURE_NAME);
            sortOrder.add(MetadataSourceColumnTag.SPECIFIC_NAME);
            sortOrder.add(MetadataSourceColumnTag.PROCEDURE_COLUMN_TYPE);
            sortOrder.add(MetadataSourceColumnTag.ORDINAL_POSITION);
        } else {
            sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
            sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
            sortOrder.add(MetadataSourceColumnTag.PROCEDURE_NAME);
            sortOrder.add(MetadataSourceColumnTag.IS_RESULT_SET);
            sortOrder.add(MetadataSourceColumnTag.ORDINAL_POSITION);
        }
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getProceduresMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        if (OrderType.JDBC_4 == orderType || OrderType.JDBC_41 == orderType || OrderType.JDBC_42 == orderType) {
            sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
            sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
            sortOrder.add(MetadataSourceColumnTag.PROCEDURE_NAME);
            sortOrder.add(MetadataSourceColumnTag.SPECIFIC_NAME);
        } else {
            sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
            sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
            sortOrder.add(MetadataSourceColumnTag.PROCEDURE_NAME);
        }
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getPseudoColumnsMetadataSortOrder() {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
        sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
        sortOrder.add(MetadataSourceColumnTag.TABLE_NAME);
        sortOrder.add(MetadataSourceColumnTag.COLUMN_NAME);
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getSchemasMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        if (OrderType.JDBC_4 == orderType || OrderType.JDBC_41 == orderType || OrderType.JDBC_42 == orderType) {
            sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
        }
        sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getBestRowIdentifierMetadataSortOrder(List<IFilter> filters) throws ErrorException {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        sortOrder.add(MetadataSourceColumnTag.SCOPE);
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getStatisticsMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        if (OrderType.ODBC == orderType) {
            sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
            sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
            sortOrder.add(MetadataSourceColumnTag.TABLE_NAME);
            sortOrder.add(MetadataSourceColumnTag.NON_UNIQUE_INDEX);
            sortOrder.add(MetadataSourceColumnTag.INDEX_TYPE);
            sortOrder.add(MetadataSourceColumnTag.INDEX_QUALIFIER);
            sortOrder.add(MetadataSourceColumnTag.INDEX_NAME);
            sortOrder.add(MetadataSourceColumnTag.ORDINAL_POSITION);
        } else {
            sortOrder.add(MetadataSourceColumnTag.NON_UNIQUE_INDEX);
            sortOrder.add(MetadataSourceColumnTag.INDEX_TYPE);
            sortOrder.add(MetadataSourceColumnTag.INDEX_NAME);
            sortOrder.add(MetadataSourceColumnTag.ORDINAL_POSITION);
        }
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getTablesMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        sortOrder.add(MetadataSourceColumnTag.TABLE_TYPE);
        sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
        sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
        sortOrder.add(MetadataSourceColumnTag.TABLE_NAME);
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getTablePrivilegesMetadataSortOrder(OrderType orderType) {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        sortOrder.add(MetadataSourceColumnTag.CATALOG_NAME);
        sortOrder.add(MetadataSourceColumnTag.SCHEMA_NAME);
        sortOrder.add(MetadataSourceColumnTag.TABLE_NAME);
        sortOrder.add(MetadataSourceColumnTag.PRIVILEGE);
        if (OrderType.ODBC == orderType) {
            sortOrder.add(MetadataSourceColumnTag.GRANTEE);
        }
        return sortOrder;
    }

    private static List<MetadataSourceColumnTag> getTypeInfoMetadataSortOrder() {
        ArrayList<MetadataSourceColumnTag> sortOrder = new ArrayList<MetadataSourceColumnTag>();
        sortOrder.add(MetadataSourceColumnTag.DATA_TYPE);
        sortOrder.add(MetadataSourceColumnTag.DATA_TYPE_NAME);
        return sortOrder;
    }
}

