/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.filters.DSIMetadataFilterFactory;
import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.vertica.dsi.dataengine.impl.DSIMetadataResultSet;
import com.vertica.dsi.dataengine.interfaces.IDataEngine;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IQueryExecutor;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.OrderType;
import com.vertica.dsi.exceptions.ParsingException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DSIDataEngine
implements IDataEngine {
    private final IStatement m_statement;
    private ILogger m_logger;
    private final boolean m_isODBC2;

    protected DSIDataEngine(IStatement statement) {
        LogUtilities.logFunctionEntrance(statement.getLog(), statement);
        this.m_statement = statement;
        this.m_logger = statement.getLog();
        this.m_isODBC2 = this.isODBC2();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    public final boolean getIsODBC2() {
        return this.m_isODBC2;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceId, ArrayList<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier) throws ErrorException {
        return this.makeNewMetadataResult(metadataSourceId, filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, OrderType.NONE);
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceId, ArrayList<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, OrderType orderType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceId, filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier});
        ArrayList<String> mappedFilterValues = new ArrayList<String>(filterValues);
        if (MetadataSourceID.TYPE_INFO == metadataSourceId) {
            this.mapDatetimeTypes(mappedFilterValues);
        }
        IEnvironment env = this.m_statement.getParentConnection().getParentEnvironment();
        ArrayList<IFilter> filters = new ArrayList<IFilter>();
        HashMap<MetadataSourceColumnTag, String> restrictions = new HashMap<MetadataSourceColumnTag, String>();
        DSIMetadataFilterFactory filterFactory = new DSIMetadataFilterFactory(this.shouldPerformFiltering());
        filterFactory.createFilters(metadataSourceId, mappedFilterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, env, filters, restrictions);
        IMetadataSource metadataSource = this.makeNewMetadataSource(metadataSourceId, restrictions, escapeChar, identifierQuoteChar, filterAsIdentifier);
        return this.getMetadataResultImplementation(metadataSourceId, restrictions, metadataSource, filters, orderType);
    }

    @Override
    public abstract IQueryExecutor prepare(String var1) throws ParsingException, ErrorException;

    @Override
    public IQueryExecutor prepareBatch(List<String> queries) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, queries);
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name(), ExceptionType.FEATURE_NOT_IMPLEMENTED);
    }

    @Override
    public void setDirectExecute() {
    }

    @Override
    public void setMetadataNeeded(boolean isNeeded) {
    }

    protected ILogger getLog() {
        return this.m_logger;
    }

    protected IStatement getParentStatement() {
        return this.m_statement;
    }

    protected IWarningListener getWarningListener() {
        return this.getParentStatement().getWarningListener();
    }

    protected abstract IMetadataSource makeNewMetadataSource(MetadataSourceID var1, Map<MetadataSourceColumnTag, String> var2, String var3, String var4, boolean var5) throws ErrorException;

    protected IResultSet getMetadataResultImplementation(MetadataSourceID metadataSourceId, Map<MetadataSourceColumnTag, String> restrictions, IMetadataSource metadataSource, List<IFilter> filters, OrderType orderType) throws ErrorException {
        if (null == metadataSource) {
            return new DSIMetadataResultSet(this.getParentStatement(), metadataSourceId, new DSIEmptyMetadataSource(this.getLog()), filters, orderType);
        }
        switch (metadataSourceId) {
            case TABLES: 
            case PROCEDURES: 
            case COLUMNS: 
            case COLUMN_PRIVILEGES: 
            case PROCEDURE_COLUMNS: 
            case PRIMARY_KEYS: 
            case FOREIGN_KEYS: 
            case FUNCTION_COLUMNS_JDBC4: 
            case FUNCTIONS_JDBC4: 
            case PSEUDO_COLUMNS_JDBC41: 
            case STATISTICS: 
            case TABLE_PRIVILEGES: 
            case TYPE_INFO: 
            case SPECIAL_COLUMNS: 
            case CATALOG_ONLY: 
            case SCHEMA_ONLY: 
            case TABLETYPE_ONLY: 
            case CATALOG_SCHEMA_ONLY: {
                return new DSIMetadataResultSet(this.getParentStatement(), metadataSourceId, metadataSource, filters, orderType, this.m_isODBC2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), metadataSourceId.toString(), ExceptionType.DEFAULT);
    }

    private boolean isODBC2() {
        IEnvironment env = this.m_statement.getParentConnection().getParentEnvironment();
        try {
            if (env.getProperty(4).getInt() == 0) {
                return env.getProperty(3).getInt() == 2;
            }
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void mapDatetimeTypes(List<String> filters) {
        block5: for (int i = 0; i < filters.size(); ++i) {
            String filter = filters.get(i);
            if (null == filter) continue;
            switch (Short.valueOf(filter)) {
                case 9: {
                    filters.set(i, String.valueOf(91));
                    continue block5;
                }
                case 10: {
                    filters.set(i, String.valueOf(92));
                    continue block5;
                }
                case 11: {
                    filters.set(i, String.valueOf(93));
                    continue block5;
                }
            }
        }
    }

    private boolean shouldPerformFiltering() {
        try {
            Variant filterVar = DSIDriverSingleton.getInstance().getProperty(22);
            return 1L == filterVar.getLong();
        }
        catch (Exception e) {
            LogUtilities.logError(e, this.m_logger);
            return true;
        }
    }
}

