/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.text.parser;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPEvalScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenScanner;

public class TPRuleBasedScanner
implements TPCharacterScanner,
TPTokenScanner,
TPEvalScanner {
    private TPRule[] fRules;
    private TPToken fDefaultReturnToken;
    private IDocument fDocument;
    private char[][] fDelimiters;
    private int fOffset;
    private int fRangeEnd;
    private int fTokenOffset;
    private int fColumn;
    private static final int UNDEFINED = -1;
    private boolean evalMode;

    public void setRules(TPRule[] rules) {
        if (rules != null) {
            this.fRules = new TPRule[rules.length];
            System.arraycopy(rules, 0, this.fRules, 0, rules.length);
        } else {
            this.fRules = null;
        }
    }

    public void setDefaultReturnToken(TPToken defaultReturnToken) {
        Assert.isNotNull((Object)defaultReturnToken.getData());
        this.fDefaultReturnToken = defaultReturnToken;
    }

    @Override
    public void setRange(IDocument document, int offset, int length) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        int documentLength = document.getLength();
        while (offset + length > documentLength) {
            --length;
        }
        this.checkRange(offset, length, documentLength);
        this.fDocument = document;
        this.fOffset = offset;
        this.fColumn = -1;
        this.fRangeEnd = offset + length;
        String[] delimiters = this.fDocument.getLegalLineDelimiters();
        this.fDelimiters = new char[delimiters.length][];
        int i = 0;
        while (i < delimiters.length) {
            this.fDelimiters[i] = delimiters[i].toCharArray();
            ++i;
        }
        if (this.fDefaultReturnToken == null) {
            this.fDefaultReturnToken = TPTokenAbstract.UNDEFINED;
        }
    }

    private void checkRange(int offset, int length, int documentLength) {
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
    }

    @Override
    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    @Override
    public int getTokenLength() {
        if (this.fOffset < this.fRangeEnd) {
            return this.fOffset - this.getTokenOffset();
        }
        return this.fRangeEnd - this.getTokenOffset();
    }

    public int getTokenEndOffset() {
        return Math.min(this.fOffset, this.fRangeEnd);
    }

    @Override
    public int getColumn() {
        if (this.fColumn == -1) {
            try {
                int line = this.fDocument.getLineOfOffset(this.fOffset);
                int start = this.fDocument.getLineOffset(line);
                this.fColumn = this.fOffset - start;
            }
            catch (BadLocationException badLocationException) {}
        }
        return this.fColumn;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public char[][] getLegalLineDelimiters() {
        return this.fDelimiters;
    }

    @Override
    public TPToken nextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.fRules != null) {
            TPRule[] tPRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                TPRule fRule = tPRuleArray[n2];
                TPToken token = fRule.evaluate(this);
                if (!token.isUndefined()) {
                    return token;
                }
                ++n2;
            }
        }
        if (this.read() == -1) {
            return TPTokenAbstract.EOF;
        }
        return this.fDefaultReturnToken;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read() {
        try {
            if (this.fOffset < this.fRangeEnd) {
                try {
                    var2_1 = this.fDocument.getChar(this.fOffset);
                    return var2_1;
                }
                catch (BadLocationException v0) {
                    ** try [egrp 2[TRYBLOCK] [2 : 42->43)] { 
                }
            }
lbl8:
            // 3 sources

            return -1;
lbl-1000:
            // 1 sources

            {
                catch (Throwable var1_2) {
                    throw var1_2;
                }
            }
        }
        finally {
            ++this.fOffset;
            this.fColumn = -1;
        }
    }

    @Override
    public void unread() {
        --this.fOffset;
        this.fColumn = -1;
    }

    @Override
    public boolean isEvalMode() {
        return this.evalMode;
    }

    public void startEval() {
        this.evalMode = true;
    }

    public void endEval() {
        this.evalMode = false;
        if (this.fRules != null) {
            TPRule[] tPRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                TPRule rule = tPRuleArray[n2];
                if (rule instanceof SQLDelimiterRule) {
                    ((SQLDelimiterRule)rule).changeDelimiter(null);
                }
                ++n2;
            }
        }
    }
}

