/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.task.DBTTaskController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;

public class LocalTaskController
implements DBTTaskController {
    public String loadTaskConfigurationFile(@NotNull String projectId, @NotNull String filePath) throws DBException {
        Path localPath = this.getMetadataFolder(projectId, false).resolve(filePath);
        if (Files.notExists(localPath, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readString(localPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new DBException("Error reading task configuration file '" + filePath + "'", (Throwable)e);
        }
    }

    public void saveTaskConfigurationFile(@NotNull String projectId, @NotNull String filePath, @Nullable String data) throws DBException {
        Path localPath = this.getMetadataFolder(projectId, true).resolve(filePath);
        if (Files.exists(localPath, new LinkOption[0])) {
            ContentUtils.makeFileBackup((Path)localPath);
        }
        if (data == null && Files.exists(localPath, new LinkOption[0])) {
            try {
                Files.delete(localPath);
            }
            catch (IOException e) {
                throw new DBException("Error deleting task configuration file '" + filePath + "'", (Throwable)e);
            }
            return;
        }
        if (data == null) {
            throw new DBException("Error saving task configuration file '" + filePath + "'");
        }
        try {
            Files.writeString(localPath, (CharSequence)data, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DBException("Error writing task configuration file '" + filePath + "'", (Throwable)e);
        }
    }

    @NotNull
    public Path getMetadataFolder(@NotNull String projectId, boolean create) throws DBException {
        Path parent = DBWorkbench.getPlatform().getWorkspace().getProject(projectId).getMetadataFolder(create);
        this.createFolder(create, parent);
        return parent;
    }

    protected void createFolder(boolean create, Path metadataFolder) throws DBException {
        if (create && Files.notExists(metadataFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(metadataFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DBException("Error creating metadata folder", (Throwable)e);
            }
        }
    }
}

