/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jexl3.JexlExpression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.utils.CommonUtils;

public class DataSourceBindingDescriptor
extends AbstractContextDescriptor {
    private static final Log log = Log.getLog(DataSourceBindingDescriptor.class);
    private List<DataSourceInfo> dataSources = new ArrayList<DataSourceInfo>();

    public DataSourceBindingDescriptor(IConfigurationElement config) {
        super(config);
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("datasource");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dsConfig = iConfigurationElementArray[n2];
            this.dataSources.add(new DataSourceInfo(dsConfig));
            ++n2;
        }
    }

    public boolean isDriverApplicable(DBPDriver driver) {
        if (this.dataSources.isEmpty()) {
            return true;
        }
        for (DataSourceInfo dsi : this.dataSources) {
            if (!dsi.appliesTo(driver, null)) continue;
            return true;
        }
        return false;
    }

    public static class DataSourceInfo {
        private String id;
        private String driver;
        private JexlExpression expression;

        DataSourceInfo(IConfigurationElement cfg) {
            String condition = cfg.getAttribute("if");
            if (!CommonUtils.isEmpty((String)condition)) {
                try {
                    this.expression = DataSourceBindingDescriptor.parseExpression((String)condition);
                }
                catch (DBException ex) {
                    log.warn((Object)("Can't parse auth model datasource expression: " + condition), (Throwable)ex);
                }
            }
            this.id = cfg.getAttribute("id");
            this.driver = cfg.getAttribute("driver");
        }

        public boolean appliesTo(DBPDriver driver, Object context) {
            if (!CommonUtils.isEmpty((String)this.id) && !driver.getProviderDescriptor().matchesId(this.id)) {
                return false;
            }
            if (!CommonUtils.isEmpty((String)this.driver) && !this.driver.equals(driver.getId())) {
                return false;
            }
            if (this.expression != null) {
                try {
                    return CommonUtils.toBoolean((Object)this.expression.evaluate(DataSourceBindingDescriptor.makeContext((Object)driver, (Object)context)));
                }
                catch (Exception e) {
                    log.debug((Object)("Error evaluating expression '" + this.expression + "'"), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }
}

