/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.model;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.dbeaver.db.couchbase.model.CouchbaseBucket;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public class CouchbaseBucketIndex
implements DBSTableConstraint {
    private static final Log log = Log.getLog(CouchbaseBucketIndex.class);
    private static final String CAT_HEALTH = "Health";
    private final CouchbaseBucket bucket;
    private JsonObject nodeDesc;

    public CouchbaseBucketIndex(CouchbaseBucket bucket, JsonObject nodeDesc) {
        this.bucket = bucket;
        this.nodeDesc = nodeDesc;
    }

    @NotNull
    public CouchbaseDataSource getDataSource() {
        return (CouchbaseDataSource)this.bucket.getDataSource();
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.nodeDesc.getString("name");
    }

    @Property(viewable=false, editable=true, order=2)
    public String getIndexID() {
        return this.nodeDesc.getString("id");
    }

    @Property(viewable=true, editable=true, order=3)
    public String getState() {
        return this.nodeDesc.getString("state");
    }

    @Property(viewable=true, editable=true, order=4)
    public String getUsing() {
        return this.nodeDesc.getString("using");
    }

    @Property(viewable=true, editable=true, order=5)
    public String getCondition() {
        return this.nodeDesc.getString("condition");
    }

    @Property(viewable=true, editable=true, order=6)
    public List<String> getKeys() {
        JsonArray indexKey = this.nodeDesc.getArray("index_key");
        ArrayList<String> result = new ArrayList<String>();
        if (indexKey != null) {
            int i = 0;
            while (i < indexKey.size()) {
                result.add(indexKey.getString(i));
                ++i;
            }
        }
        return result;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public CouchbaseBucket getParentObject() {
        return this.bucket;
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.INDEX;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.getName();
    }

    @Nullable
    public List<? extends DBSEntityAttributeRef> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return null;
    }
}

