/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.nio.NIOFileStore;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class NIOFileSystem
extends FileSystem {
    public static final String DBVFS_FS_ID = "dbvfs";
    private static final Log log = Log.getLog(NIOFileSystem.class);

    public IFileStore getStore(URI uri) {
        DBPProject project;
        Path path = null;
        String projectName = uri.getHost();
        String[] vfsPath = CommonUtils.removeTrailingSlash((String)CommonUtils.removeLeadingSlash((String)uri.getPath())).split("/");
        String relPath = uri.getQuery();
        if (!CommonUtils.isEmpty((String)projectName) && vfsPath.length == 3 && !CommonUtils.isEmpty((String)relPath) && (project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName)) != null) {
            DBNFileSystemRoot fsNodeRoot;
            DBNFileSystem fsNode;
            DBNFileSystems fileSystemsNode;
            String fsType = vfsPath[0];
            String fsId = vfsPath[1];
            String fsRootPath = vfsPath[2];
            DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project);
            if (projectNode != null && (fileSystemsNode = projectNode.getExtraNode(DBNFileSystems.class)) != null && (fsNode = fileSystemsNode.getFileSystem(fsType, fsId)) != null && (fsNodeRoot = fsNode.getRoot(fsRootPath)) != null) {
                try {
                    relPath = CommonUtils.removeLeadingSlash((String)relPath);
                    relPath = URLDecoder.decode(relPath, StandardCharsets.UTF_8);
                    path = fsNodeRoot.getPath().resolve(relPath);
                }
                catch (Exception e) {
                    log.debug("Error resolving path", e);
                }
            }
        }
        if (path == null) {
            log.debug("Invalid dbvfs URI: " + uri);
            return EFS.getNullFileSystem().getStore(uri);
        }
        return new NIOFileStore(uri, path);
    }
}

