/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class URIBuilder {
    @Nullable
    private String scheme;
    @Nullable
    private String host;
    @Nullable
    private Integer port;
    @Nullable
    private Collection<String> pathSegments;
    @Nullable
    private Map<String, Object> queryParams;

    URIBuilder() {
    }

    public URIBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public URIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public URIBuilder port(int port) {
        this.port = port;
        return this;
    }

    URIBuilder pathSegment(String pathSegment) {
        if (this.pathSegments == null) {
            this.pathSegments = new ArrayList<String>();
        }
        this.pathSegments.add(pathSegment);
        return this;
    }

    public URIBuilder query(String name, Object value) {
        this.safeQueryParams().put(name, value);
        return this;
    }

    URIBuilder query(Map<String, ?> params) {
        this.safeQueryParams().putAll(params);
        return this;
    }

    @NotNull
    private Map<String, Object> safeQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = new LinkedHashMap<String, Object>();
        }
        return this.queryParams;
    }

    public URI build() {
        assert (this.scheme != null);
        StringBuilder builder = new StringBuilder(this.scheme);
        builder.append(':');
        if (this.host != null || this.port != null) {
            builder.append("//");
        }
        if (this.host != null) {
            builder.append(this.host);
        }
        if (this.port != null) {
            builder.append(':').append(this.port);
        }
        if (this.pathSegments != null) {
            String path = URLEncodedUtils.formatSegments(this.pathSegments, (Charset)StandardCharsets.UTF_8);
            builder.append(path);
        }
        if (this.queryParams != null) {
            builder.append('?');
            Iterable nameValuePairs = this.queryParams.entrySet().stream().map(entry -> new QueryParameter((String)entry.getKey(), String.valueOf(entry.getValue()))).collect(Collectors.toList());
            String query = URLEncodedUtils.format((Iterable)nameValuePairs, (Charset)StandardCharsets.UTF_8);
            builder.append(query);
        }
        try {
            return new URI(builder.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class QueryParameter
    implements NameValuePair {
        private final String name;
        private final String value;

        private QueryParameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

