/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.apache.commons.codec.Charsets;
import org.apache.http.client.methods.HttpGet;
import org.lightcouch.ChangesResult;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbException;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.URIBuilder;

public class Changes {
    private BufferedReader reader;
    private HttpGet httpGet;
    private ChangesResult.Row nextRow;
    private boolean stop;
    private CouchDbClientBase dbc;
    private Gson gson;
    private URIBuilder uriBuilder;

    Changes(CouchDbClientBase dbc) {
        this.dbc = dbc;
        this.gson = dbc.getGson();
        this.uriBuilder = dbc.getDBURIBuilder().pathSegment("_changes");
    }

    public Changes continuousChanges() {
        URI uri = this.uriBuilder.query("feed", "continuous").build();
        this.httpGet = new HttpGet(uri);
        InputStream in = this.dbc.get(this.httpGet);
        InputStreamReader is = new InputStreamReader(in, Charsets.UTF_8);
        this.setReader(new BufferedReader(is));
        return this;
    }

    public boolean hasNext() {
        return this.readNextRow();
    }

    public ChangesResult.Row next() {
        return this.getNextRow();
    }

    public void stop() {
        this.stop = true;
    }

    public ChangesResult getChanges() {
        URI uri = this.uriBuilder.query("feed", "normal").build();
        return this.dbc.get(uri, ChangesResult.class);
    }

    public Changes since(String since) {
        this.uriBuilder.query("since", since);
        return this;
    }

    public Changes limit(int limit) {
        this.uriBuilder.query("limit", limit);
        return this;
    }

    public Changes heartBeat(long heartBeat) {
        this.uriBuilder.query("heartbeat", heartBeat);
        return this;
    }

    public Changes timeout(long timeout) {
        this.uriBuilder.query("timeout", timeout);
        return this;
    }

    public Changes filter(String filter) {
        this.uriBuilder.query("filter", filter);
        return this;
    }

    public Changes includeDocs(boolean includeDocs) {
        this.uriBuilder.query("include_docs", includeDocs);
        return this;
    }

    public Changes style(String style) {
        this.uriBuilder.query("style", style);
        return this;
    }

    private boolean readNextRow() {
        boolean hasNext = false;
        try {
            if (!this.stop) {
                String row = "";
                while ((row = this.getReader().readLine()).length() == 0) {
                }
                if (!row.startsWith("{\"last_seq\":")) {
                    this.setNextRow((ChangesResult.Row)this.gson.fromJson(row, ChangesResult.Row.class));
                    hasNext = true;
                }
            }
        }
        catch (Exception e) {
            this.terminate();
            throw new CouchDbException("Error reading continuous stream.", e);
        }
        if (!hasNext) {
            this.terminate();
        }
        return hasNext;
    }

    private BufferedReader getReader() {
        return this.reader;
    }

    private void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    private ChangesResult.Row getNextRow() {
        return this.nextRow;
    }

    private void setNextRow(ChangesResult.Row nextRow) {
        this.nextRow = nextRow;
    }

    private void terminate() {
        this.httpGet.abort();
        CouchDbUtil.close(this.getReader());
    }
}

