/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search.metadata;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.dbeaver.ui.search.AbstractSearchPage;
import org.jkiss.dbeaver.ui.search.internal.UISearchMessages;
import org.jkiss.dbeaver.ui.search.metadata.SearchMetadataQuery;
import org.jkiss.utils.CommonUtils;

public class SearchMetadataPage
extends AbstractSearchPage {
    private static final String PROP_MASK = "search.metadata.mask";
    private static final String PROP_CASE_SENSITIVE = "search.metadata.case-sensitive";
    private static final String PROP_MAX_RESULT = "search.metadata.max-results";
    private static final String PROP_MATCH_INDEX = "search.metadata.match-index";
    private static final String PROP_HISTORY = "search.metadata.history";
    private static final String PROP_OBJECT_TYPE = "search.metadata.object-type";
    private static final String PROP_SOURCES = "search.metadata.object-source";
    private static final String PROP_SEARCH_IN_COMMENTS = "search.metadata.search-in-comments";
    private static final String PROP_SEARCH_IN_DEFINITIONS = "search.metadata.search-in-definitions";
    private Table typesTable;
    private Combo searchText;
    private DatabaseNavigatorTree dataSourceTree;
    private Button searchInCommentsCheckbox;
    private Button searchInDefinitionsCheckbox;
    private String nameMask;
    private boolean caseSensitive;
    private boolean searchInComments;
    private boolean searchInDefinitions;
    private int maxResults;
    private int matchTypeIndex;
    private Set<DBSObjectType> checkedTypes = new HashSet<DBSObjectType>();
    private Set<String> searchHistory = new LinkedHashSet<String>();
    private Set<String> savedTypeNames = new HashSet<String>();
    private List<DBNNode> sourceNodes = new ArrayList<DBNNode>();
    private DBPProject currentProject = NavigatorUtils.getSelectedProject();

    public SearchMetadataPage() {
        super("Database objects search");
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initializeDialogUnits((Control)parent);
        Composite searchGroup = UIUtils.createComposite((Composite)parent, (int)1);
        searchGroup.setLayoutData((Object)new GridData(1808));
        this.searchText = new Combo(searchGroup, 4);
        this.searchText.setLayoutData((Object)new GridData(768));
        UIUtils.addEmptyTextHint((Control)this.searchText, combo -> UISearchMessages.dialog_search_objects_label_object_name);
        if (this.nameMask != null) {
            this.searchText.setText(this.nameMask);
        }
        for (String history : this.searchHistory) {
            this.searchText.add(history);
        }
        this.searchText.addModifyListener(e -> {
            this.nameMask = this.searchText.getText();
            this.updateEnablement();
        });
        SashForm optionsGroup = new SashForm(parent, 2);
        optionsGroup.setLayoutData((Object)new GridData(1808));
        Group sourceGroup = UIUtils.createControlGroup((Composite)optionsGroup, (String)UISearchMessages.dialog_search_objects_group_objects_source, (int)1, (int)1808, (int)0);
        DBPPlatform platform = DBWorkbench.getPlatform();
        DBNProject projectNode = platform.getNavigatorModel().getRoot().getProjectNode(this.currentProject);
        DBNProjectDatabases rootNode = projectNode == null ? platform.getNavigatorModel().getRoot() : projectNode.getDatabases();
        this.dataSourceTree = new DatabaseNavigatorTree((Composite)sourceGroup, (DBNNode)rootNode, 4);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        this.dataSourceTree.setLayoutData((Object)gd);
        TreeViewer treeViewer = this.dataSourceTree.getViewer();
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TreeNodeSpecial) {
                    return true;
                }
                if (element instanceof DBNNode) {
                    if (element instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder folder = (DBNDatabaseFolder)element;
                        Class folderItemsClass = folder.getChildrenClass();
                        return folderItemsClass != null && DBSObjectContainer.class.isAssignableFrom(folderItemsClass);
                    }
                    if (element instanceof DBNLocalFolder || element instanceof DBNProjectDatabases || element instanceof DBNDataSource || element instanceof DBSWrapper && ((DBSWrapper)element).getObject() instanceof DBSObjectContainer) {
                        return true;
                    }
                }
                return false;
            }
        });
        treeViewer.addSelectionChangedListener(event -> {
            Object object;
            this.fillObjectTypes();
            this.updateEnablement();
            IStructuredSelection structSel = (IStructuredSelection)event.getSelection();
            Object object2 = object = structSel.isEmpty() ? null : structSel.getFirstElement();
            if (object instanceof DBNNode) {
                DBNNode node = (DBNNode)object;
                while (node != null) {
                    if (node instanceof DBNDataSource) {
                        DBNDataSource dsNode = (DBNDataSource)node;
                        try {
                            dsNode.initializeNode(null, status -> {
                                if (status.isOK()) {
                                    UIUtils.asyncExec(() -> {
                                        if (!this.dataSourceTree.isDisposed()) {
                                            this.fillObjectTypes();
                                        }
                                    });
                                }
                            });
                        }
                        catch (DBException e) {
                            log.error((Object)e);
                        }
                        break;
                    }
                    node = node.getParentNode();
                }
            }
        });
        treeViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object node = objectArray[n2];
                if (node instanceof TreeNodeSpecial) {
                    ((TreeNodeSpecial)node).handleDefaultAction(this.dataSourceTree);
                }
                ++n2;
            }
        });
        Group settingsGroup = UIUtils.createControlGroup((Composite)optionsGroup, (String)UISearchMessages.dialog_search_objects_group_settings, (int)2, (int)1808, (int)0);
        UIUtils.createControlLabel((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_label_match_type);
        final Combo matchCombo = new Combo((Composite)settingsGroup, 12);
        matchCombo.add(UISearchMessages.dialog_search_objects_combo_starts_with, 0);
        matchCombo.add(UISearchMessages.dialog_search_objects_combo_contains, 1);
        matchCombo.add(UISearchMessages.dialog_search_objects_combo_like, 2);
        matchCombo.select(0);
        matchCombo.setLayoutData((Object)new GridData(768));
        if (this.matchTypeIndex >= 0) {
            matchCombo.select(this.matchTypeIndex);
        }
        matchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMetadataPage.this.matchTypeIndex = matchCombo.getSelectionIndex();
            }
        });
        matchCombo.setLayoutData((Object)new GridData(32));
        if (this.maxResults <= 0) {
            this.maxResults = 100;
        }
        Spinner maxResultsSpinner = UIUtils.createLabelSpinner((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_spinner_max_results, (int)this.maxResults, (int)1, (int)10000);
        maxResultsSpinner.setLayoutData((Object)new GridData(768));
        maxResultsSpinner.addModifyListener(e -> {
            int n = this.maxResults = maxResultsSpinner.getSelection();
        });
        maxResultsSpinner.setLayoutData((Object)new GridData(32));
        final Button caseCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_case_sensitive, null, (boolean)this.caseSensitive, (int)2);
        caseCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMetadataPage.this.caseSensitive = caseCheckbox.getSelection();
            }
        });
        this.searchInCommentsCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_search_in_comments, null, (boolean)this.searchInComments, (int)2);
        this.searchInCommentsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMetadataPage.this.searchInComments = SearchMetadataPage.this.searchInCommentsCheckbox.getSelection();
            }
        });
        this.searchInCommentsCheckbox.setEnabled(false);
        this.searchInDefinitionsCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_search_in_definitions, null, (boolean)this.searchInDefinitions, (int)2);
        this.searchInDefinitionsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMetadataPage.this.searchInDefinitions = SearchMetadataPage.this.searchInDefinitionsCheckbox.getSelection();
            }
        });
        this.searchInDefinitionsCheckbox.setEnabled(false);
        Label otLabel = UIUtils.createControlLabel((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_group_object_types);
        otLabel.setLayoutData((Object)new GridData(2));
        this.typesTable = new Table((Composite)settingsGroup, 66336);
        this.typesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = SearchMetadataPage.this.typesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    DBSObjectType objectType = (DBSObjectType)item.getData();
                    if (item.getChecked()) {
                        SearchMetadataPage.this.checkedTypes.add(objectType);
                    } else {
                        SearchMetadataPage.this.checkedTypes.remove(objectType);
                    }
                    ++n2;
                }
                SearchMetadataPage.this.updateEnablement();
                SearchMetadataPage.this.updateSearchOptionsCheckboxes();
            }
        });
        this.typesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selection = SearchMetadataPage.this.typesTable.getSelection();
                if (selection.length > 0) {
                    TableItem tableItem;
                    tableItem.setChecked(!(tableItem = selection[0]).getChecked());
                }
            }
        });
        this.typesTable.setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn((Table)this.typesTable, (int)16384, (String)UISearchMessages.dialog_search_objects_column_type);
        UIUtils.createTableColumn((Table)this.typesTable, (int)16384, (String)UISearchMessages.dialog_search_objects_column_description);
        this.setControl((Control)searchGroup);
        UIUtils.asyncExec(this::loadState);
    }

    private void updateSearchOptionsCheckboxes() {
        DBSStructureAssistant structureAssistant = this.getSelectedStructureAssistant();
        boolean enableSearchInCommentsCheckbox = false;
        boolean enableSearchInDefinitionsCheckbox = false;
        for (DBSObjectType objectType : this.checkedTypes) {
            if (!enableSearchInCommentsCheckbox && structureAssistant.supportsSearchInCommentsFor(objectType)) {
                enableSearchInCommentsCheckbox = true;
            }
            if (!enableSearchInDefinitionsCheckbox && structureAssistant.supportsSearchInDefinitionsFor(objectType)) {
                enableSearchInDefinitionsCheckbox = true;
            }
            if (enableSearchInCommentsCheckbox && enableSearchInDefinitionsCheckbox) break;
        }
        this.searchInCommentsCheckbox.setEnabled(enableSearchInCommentsCheckbox);
        if (!enableSearchInCommentsCheckbox) {
            this.searchInCommentsCheckbox.setSelection(false);
            this.searchInComments = false;
        }
        this.searchInDefinitionsCheckbox.setEnabled(enableSearchInDefinitionsCheckbox);
        if (!enableSearchInDefinitionsCheckbox) {
            this.searchInDefinitionsCheckbox.setSelection(false);
            this.searchInDefinitions = false;
        }
    }

    private void loadState() {
        try {
            this.container.getRunnableContext().run(true, true, monitor -> {
                monitor.beginTask("Load database nodes", 1);
                try {
                    monitor.subTask("Load tree state");
                    this.sourceNodes = this.loadTreeState((DBRProgressMonitor)new DefaultProgressMonitor(monitor), this.currentProject, DBWorkbench.getPlatform().getPreferenceStore().getString(PROP_SOURCES));
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Data sources load", "Error loading settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        if (!this.sourceNodes.isEmpty()) {
            this.dataSourceTree.getViewer().setSelection((ISelection)new StructuredSelection(this.sourceNodes));
            DBNDataSource node = DBNDataSource.getDataSourceNode((DBNNode)this.sourceNodes.get(0));
            if (node != null) {
                this.dataSourceTree.getViewer().reveal((Object)node);
            }
        }
        this.updateEnablement();
    }

    @Nullable
    private DBNNode getSelectedNode() {
        Object firstElement;
        IStructuredSelection selection = (IStructuredSelection)this.dataSourceTree.getViewer().getSelection();
        if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof DBNNode) {
            return (DBNNode)firstElement;
        }
        return null;
    }

    private DBPDataSource getSelectedDataSource() {
        DBSObject object;
        DBNNode node = this.getSelectedNode();
        if (node instanceof DBSWrapper && (object = ((DBSWrapper)node).getObject()) != null && object.getDataSource() != null) {
            return object.getDataSource();
        }
        return null;
    }

    private DBSStructureAssistant getSelectedStructureAssistant() {
        return (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)this.getSelectedDataSource());
    }

    private void fillObjectTypes() {
        int n;
        int n2;
        DBSObjectType[] dBSObjectTypeArray;
        DBSStructureAssistant assistant = this.getSelectedStructureAssistant();
        this.typesTable.removeAll();
        if (assistant != null) {
            dBSObjectTypeArray = assistant.getSupportedObjectTypes();
            n2 = dBSObjectTypeArray.length;
            n = 0;
            while (n < n2) {
                DBSObjectType objectType = dBSObjectTypeArray[n];
                TableItem item = new TableItem(this.typesTable, 0);
                item.setText(objectType.getTypeName());
                if (objectType.getImage() != null) {
                    item.setImage(0, DBeaverIcons.getImage((DBPImage)objectType.getImage()));
                }
                if (!CommonUtils.isEmpty((String)objectType.getDescription())) {
                    item.setText(1, objectType.getDescription());
                }
                item.setData((Object)objectType);
                if (this.checkedTypes.contains(objectType)) {
                    item.setChecked(true);
                } else if (this.savedTypeNames.contains(objectType.getTypeName())) {
                    item.setChecked(true);
                    this.checkedTypes.add(objectType);
                    this.savedTypeNames.remove(objectType.getTypeName());
                }
                ++n;
            }
            this.updateSearchOptionsCheckboxes();
        }
        dBSObjectTypeArray = this.typesTable.getColumns();
        n2 = dBSObjectTypeArray.length;
        n = 0;
        while (n < n2) {
            DBSObjectType column = dBSObjectTypeArray[n];
            column.pack();
            ++n;
        }
        this.updateEnablement();
    }

    @Override
    public SearchMetadataQuery createQuery() {
        DBSObject parentObject = null;
        DBNNode node = this.getSelectedNode();
        while (node != null) {
            DBSObject object;
            if (node instanceof DBSWrapper && (object = ((DBSWrapper)node).getObject()) instanceof DBSStructContainer) {
                parentObject = object;
                break;
            }
            node = node.getParentNode();
        }
        DBPDataSource dataSource = this.getSelectedDataSource();
        DBSStructureAssistant assistant = this.getSelectedStructureAssistant();
        if (dataSource == null || assistant == null) {
            throw new IllegalStateException("No active datasource");
        }
        ArrayList<DBSObjectType> objectTypes = new ArrayList<DBSObjectType>();
        TableItem[] tableItemArray = this.typesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                objectTypes.add((DBSObjectType)item.getData());
            }
            ++n2;
        }
        String objectNameMask = this.nameMask;
        if (!this.searchHistory.contains(objectNameMask)) {
            this.searchHistory.add(objectNameMask);
            this.searchText.add(objectNameMask);
        }
        if (this.matchTypeIndex == 0) {
            if (!objectNameMask.endsWith("%")) {
                objectNameMask = String.valueOf(objectNameMask) + "%";
            }
        } else if (this.matchTypeIndex == 1) {
            if (!objectNameMask.startsWith("%")) {
                objectNameMask = "%" + objectNameMask;
            }
            if (!objectNameMask.endsWith("%")) {
                objectNameMask = String.valueOf(objectNameMask) + "%";
            }
        }
        DBSStructureAssistant.ObjectsSearchParams params = new DBSStructureAssistant.ObjectsSearchParams(objectTypes.toArray(new DBSObjectType[0]), objectNameMask);
        params.setParentObject(parentObject);
        params.setCaseSensitive(this.caseSensitive);
        params.setSearchInComments(this.searchInComments);
        params.setMaxResults(this.maxResults);
        params.setSearchInDefinitions(this.searchInDefinitions);
        params.setGlobalSearch(true);
        params.setLikeCondition(this.matchTypeIndex == 2);
        return new SearchMetadataQuery(dataSource, assistant, params);
    }

    @Override
    public void loadState(DBPPreferenceStore store) {
        String history;
        this.nameMask = store.getString(PROP_MASK);
        this.caseSensitive = store.getBoolean(PROP_CASE_SENSITIVE);
        this.searchInComments = store.getBoolean(PROP_SEARCH_IN_COMMENTS);
        this.searchInDefinitions = store.getBoolean(PROP_SEARCH_IN_DEFINITIONS);
        this.maxResults = store.getInt(PROP_MAX_RESULT);
        this.matchTypeIndex = store.getInt(PROP_MATCH_INDEX);
        int i = 0;
        while (!CommonUtils.isEmpty((String)(history = store.getString("search.metadata.history." + i)))) {
            this.searchHistory.add(history);
            ++i;
        }
        String type = store.getString(PROP_OBJECT_TYPE);
        if (!CommonUtils.isEmpty((String)type)) {
            StringTokenizer st = new StringTokenizer(type, "|");
            while (st.hasMoreTokens()) {
                this.savedTypeNames.add(st.nextToken());
            }
        }
    }

    @Override
    public void saveState(DBPPreferenceStore store) {
        store.setValue(PROP_MASK, this.nameMask);
        store.setValue(PROP_CASE_SENSITIVE, this.caseSensitive);
        store.setValue(PROP_SEARCH_IN_COMMENTS, this.searchInComments);
        store.setValue(PROP_SEARCH_IN_DEFINITIONS, this.searchInDefinitions);
        store.setValue(PROP_MAX_RESULT, this.maxResults);
        store.setValue(PROP_MATCH_INDEX, this.matchTypeIndex);
        SearchMetadataPage.saveTreeState(store, PROP_SOURCES, this.dataSourceTree);
        int historyIndex = 0;
        for (String history : this.searchHistory) {
            if (historyIndex >= 20) break;
            store.setValue("search.metadata.history." + historyIndex, history);
            ++historyIndex;
        }
        StringBuilder typesString = new StringBuilder();
        for (DBSObjectType type : this.checkedTypes) {
            if (typesString.length() > 0) {
                typesString.append("|");
            }
            typesString.append(type.getTypeName());
        }
        store.setValue(PROP_OBJECT_TYPE, typesString.toString());
    }

    @Override
    protected void updateEnablement() {
        boolean enabled = false;
        if (this.getSelectedDataSource() != null) {
            boolean bl = enabled = !this.checkedTypes.isEmpty();
        }
        if (CommonUtils.isEmpty((String)this.nameMask)) {
            enabled = false;
        }
        this.container.setPerformActionEnabled(enabled);
    }

    protected static void saveTreeState(DBPPreferenceStore store, String propName, DatabaseNavigatorTree tree) {
        Object[] nodes;
        StringBuilder sourcesString = new StringBuilder();
        Object[] objectArray = nodes = ((IStructuredSelection)tree.getViewer().getSelection()).toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            DBNNode node = (DBNNode)obj;
            if (sourcesString.length() > 0) {
                sourcesString.append("|");
            }
            sourcesString.append(node.getNodeItemPath());
            ++n2;
        }
        store.setValue(propName, sourcesString.toString());
    }
}

