/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.gcp;

import com.dbeaver.net.auth.gcp.AuthModelGCPAbstract;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import com.dbeaver.ui.auth.gcp.AuthModelGCPMessages;
import com.dbeaver.ui.auth.gcp.prefs.PrefPageGCPConfigurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class AuthModelGCPConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Label authTypeLabel;
    private Composite authTypeGroup;
    private Combo authTypeCombo;
    private final List<GCPAuthType> authTypes = new ArrayList<GCPAuthType>();
    private Button gcpIAMCheckbox;
    private Label gcpServiceAccountConfigPathLabel;
    private TextWithOpenFile gcpServiceAccountConfigPath;
    private Link ssoDocsLink;
    private Link ssoPrefLink;
    protected GCPAuthType curConfigType = GCPAuthType.DEFAULT;
    protected boolean isCloudProvided;
    private Label authTypeFiller;
    boolean needsPassword;
    @Nullable
    private DBAAuthModel authModel;

    public boolean isCloudProvided() {
        return this.isCloudProvided;
    }

    public void setCloudProvided(boolean cloudProvided) {
        this.isCloudProvided = cloudProvided;
    }

    protected GCPAuthType[] getSupportedAuthTypes() {
        return new GCPAuthType[]{GCPAuthType.DEFAULT, GCPAuthType.SERVICE_ACCOUNT, GCPAuthType.SSO_OVER_CLI};
    }

    protected boolean isPasswordApplicable() {
        return true;
    }

    protected boolean isSavePasswordLocally() {
        return true;
    }

    public void createControl(@NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        Composite iamGroup = parent;
        this.authModel = object;
        Composite authGroup = UIUtils.createComposite((Composite)iamGroup, (int)4);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        authGroup.setLayoutData((Object)gd);
        this.createIAMAuthControls(authGroup, propertyChangeListener, true);
    }

    public void createIAMAuthControls(Composite iamGroup, final Runnable propertyChangeListener, boolean databaseConfig) {
        GridData gd;
        new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyChangeListener.run();
            }
        };
        boolean isWide = this.isWide(iamGroup);
        this.authTypeLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelGCPMessages.model_iam_auth_type);
        this.authTypeGroup = UIUtils.createComposite((Composite)iamGroup, (int)2);
        this.authTypeGroup.setLayoutData((Object)new GridData(768));
        this.authTypeCombo = new Combo(this.authTypeGroup, 12);
        this.authTypeCombo.setLayoutData((Object)new GridData(32));
        this.authTypeCombo.setToolTipText(AuthModelGCPMessages.model_iam_auth_type_tip);
        this.authTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GCPAuthType ct = AuthModelGCPConfigurator.this.authTypes.get(AuthModelGCPConfigurator.this.authTypeCombo.getSelectionIndex());
                AuthModelGCPConfigurator.this.changeAuthType(ct);
                propertyChangeListener.run();
            }
        });
        Link gcpCredDocsLink = new Link(this.authTypeGroup, 0);
        gcpCredDocsLink.setText("<a>Details</a>");
        gcpCredDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"GCP-Credentials"));
            }
        });
        gcpCredDocsLink.setLayoutData((Object)new GridData(768));
        if (isWide) {
            this.authTypeFiller = new Label(iamGroup, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.authTypeFiller.setLayoutData((Object)gd);
        }
        this.createExtraIAMAuthSelectors(iamGroup, propertyChangeListener, isWide);
        if (databaseConfig) {
            boolean needsUserName = true;
            this.needsPassword = true;
            if (this.authModel != null && this.authModel instanceof AuthModelDatabaseNative) {
                needsUserName = ((AuthModelDatabaseNative)this.authModel).isUserNameApplicable();
                this.needsPassword = ((AuthModelDatabaseNative)this.authModel).isUserPasswordApplicable();
            }
            if (needsUserName) {
                this.usernameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelGCPMessages.model_iam_database_username);
                this.usernameLabel.setLayoutData((Object)new GridData(32));
                this.createUserNameControls(iamGroup, propertyChangeListener);
                gd = new GridData(32);
                gd.widthHint = UIUtils.getFontHeight((Control)this.usernameText) * 20;
                if (this.isWide(iamGroup)) {
                    gd.horizontalSpan = 3;
                }
                this.usernameText.setLayoutData((Object)gd);
                this.usernameText.setToolTipText(AuthModelGCPMessages.model_iam_database_username_tip);
            }
            if (this.needsPassword) {
                this.createPasswordControls(iamGroup, propertyChangeListener);
                if (this.isWide(iamGroup)) {
                    ((GridData)this.passPlaceholder.getLayoutData()).horizontalSpan = 3;
                }
            }
        }
        this.gcpServiceAccountConfigPathLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelGCPMessages.model_iam_config_control_label_configuration);
        this.gcpServiceAccountConfigPath = new TextWithOpenFile(iamGroup, AuthModelGCPMessages.model_iam_config_file_open_title_config, new String[]{"*.json", "*"});
        this.gcpServiceAccountConfigPath.getTextControl().addModifyListener(e -> propertyChangeListener.run());
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 3;
        this.gcpServiceAccountConfigPath.setLayoutData((Object)gd2);
        this.createExtraIAMAuthControls(iamGroup, propertyChangeListener, isWide);
        Composite optionsGroup = UIUtils.createComposite((Composite)iamGroup, (int)2);
        gd = new GridData(768);
        gd.horizontalSpan = isWide ? 4 : 2;
        optionsGroup.setLayoutData((Object)gd);
        if (databaseConfig) {
            this.gcpIAMCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)AuthModelGCPMessages.model_iam_config_checkbox_IAM_label, (String)AuthModelGCPMessages.model_iam_config_checkbox_IAM_tip, (boolean)false, (int)3);
            this.gcpIAMCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AuthModelGCPConfigurator.this.gcpIAMCheckbox.getSelection()) {
                        if (AuthModelGCPConfigurator.this.widgetIsAvailable((Widget)AuthModelGCPConfigurator.this.passwordText)) {
                            AuthModelGCPConfigurator.this.passwordText.setEnabled(false);
                        }
                    } else if (AuthModelGCPConfigurator.this.widgetIsAvailable((Widget)AuthModelGCPConfigurator.this.passwordText) && AuthModelGCPConfigurator.this.widgetIsAvailable((Widget)AuthModelGCPConfigurator.this.savePasswordCheck) && !AuthModelGCPConfigurator.this.passwordText.isEnabled() && AuthModelGCPConfigurator.this.savePasswordCheck.getSelection()) {
                        AuthModelGCPConfigurator.this.passwordText.setEnabled(true);
                    }
                    propertyChangeListener.run();
                }
            });
        }
        if (!databaseConfig) {
            this.ssoDocsLink = new Link(optionsGroup, 0);
            this.ssoDocsLink.setText("<a>Instructions</a>");
            this.ssoDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"GCP-SSO"));
                }
            });
            this.ssoPrefLink = new Link(optionsGroup, 0);
            this.ssoPrefLink.setText("<a>Preferences</a>");
            this.ssoPrefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyPageManager pageManager = new PropertyPageManager();
                    pageManager.addToRoot((IPreferenceNode)new PreferenceNode("gcp", (IPreferencePage)new PrefPageGCPConfigurator()));
                    PropertyDialog pd = new PropertyDialog(UIUtils.getActiveWorkbenchShell(), (PreferenceManager)pageManager, (ISelection)new StructuredSelection());
                    pd.open();
                }
            });
        }
        this.changeAuthType(this.curConfigType);
    }

    public boolean isWide(Composite iamGroup) {
        return ((GridLayout)iamGroup.getLayout()).numColumns > 2;
    }

    protected void createExtraIAMAuthSelectors(Composite iamGroup, Runnable propertyChangeListener, boolean isWide) {
    }

    protected void createExtraIAMAuthControls(Composite iamGroup, Runnable propertyChangeListener, boolean isWide) {
    }

    private void changeAuthType(GCPAuthType ct) {
        this.curConfigType = ct;
        this.updateIAMSettingsVisibility();
    }

    protected void updateIAMSettingsVisibility() {
        boolean ssoVisible;
        UIUtils.setControlVisible((Control)this.authTypeLabel, (!this.isCloudProvided ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.authTypeGroup, (!this.isCloudProvided ? 1 : 0) != 0);
        if (this.authTypeFiller != null) {
            UIUtils.setControlVisible((Control)this.authTypeFiller, (!this.isCloudProvided ? 1 : 0) != 0);
        }
        if (this.passwordLabel != null) {
            boolean isPasswordVisible = this.isPasswordApplicable();
            UIUtils.setControlVisible((Control)this.passwordLabel, (boolean)isPasswordVisible);
            UIUtils.setControlVisible((Control)this.passPlaceholder, (boolean)isPasswordVisible);
        }
        boolean saConfigVisible = this.curConfigType == GCPAuthType.SERVICE_ACCOUNT;
        UIUtils.setControlVisible((Control)this.gcpServiceAccountConfigPathLabel, (boolean)saConfigVisible);
        UIUtils.setControlVisible((Control)this.gcpServiceAccountConfigPath, (boolean)saConfigVisible);
        this.updateExtraIAMSettingsVisibility();
        boolean bl = ssoVisible = !this.isCloudProvided && this.curConfigType == GCPAuthType.SSO_OVER_CLI;
        if (this.ssoDocsLink != null) {
            UIUtils.setControlVisible((Control)this.ssoDocsLink, (boolean)ssoVisible);
        }
        if (this.ssoPrefLink != null) {
            UIUtils.setControlVisible((Control)this.ssoPrefLink, (boolean)ssoVisible);
        }
        UIUtils.asyncExec(() -> {
            this.gcpServiceAccountConfigPath.getShell().layout(true, true);
            UIUtils.resizeShell((Shell)this.gcpServiceAccountConfigPath.getShell());
        });
    }

    public boolean isSSOEnabled() {
        return this.curConfigType == GCPAuthType.SSO_OVER_CLI;
    }

    protected void updateExtraIAMSettingsVisibility() {
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        this.initAuthTypes();
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        this.isCloudProvided = !"local".equals(dataSource.getOrigin().getType());
        DBAAuthModel authModel = configuration.getAuthModel();
        if (!(authModel instanceof AuthModelGCPAbstract && ((AuthModelGCPAbstract)authModel).supportsDatabaseUser() || this.usernameLabel == null)) {
            UIUtils.setControlVisible((Control)this.usernameLabel, (boolean)false);
            UIUtils.setControlVisible((Control)this.usernameText, (boolean)false);
            this.usernameLabel.getParent().getParent().layout(true, true);
        }
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        if (configuration.getAuthProperties() != null) {
            authProperties.putAll(configuration.getAuthProperties());
        }
        this.loadIAMAuthSettings(authProperties);
        this.authTypeCombo.select(this.authTypes.indexOf(this.curConfigType));
        this.updateIAMSettingsVisibility();
        this.authTypeCombo.setEnabled(!this.isCloudProvided);
        if (this.gcpIAMCheckbox != null && !CommonUtils.getBoolean((Object)dataSource.getDriver().getDriverParameter("supportsAutomaticIAM"), (boolean)false)) {
            this.gcpIAMCheckbox.setEnabled(false);
        }
    }

    public void initAuthTypes() {
        this.authTypeCombo.removeAll();
        this.authTypes.clear();
        GCPAuthType[] gCPAuthTypeArray = this.getSupportedAuthTypes();
        int n = gCPAuthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCPAuthType ct = gCPAuthTypeArray[n2];
            this.authTypes.add(ct);
            this.authTypeCombo.add(ct.getTitle());
            ++n2;
        }
    }

    @NotNull
    public static List<String> getPublicRegions() {
        return Collections.emptyList();
    }

    public void loadIAMAuthSettings(Map<String, String> authProperties) {
        this.curConfigType = (GCPAuthType)CommonUtils.valueOf(GCPAuthType.class, (String)authProperties.get("gcp.authType"), (Enum)GCPAuthType.DEFAULT);
        this.gcpServiceAccountConfigPath.setText(CommonUtils.notEmpty((String)authProperties.get("gcp.sa_config_path")));
        if (this.gcpIAMCheckbox != null) {
            this.gcpIAMCheckbox.setSelection(CommonUtils.getBoolean((String)authProperties.get("gcp.iam_auth"), (boolean)Boolean.FALSE));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        this.saveIAMAuthSettings(props);
        configuration.setAuthProperties(props);
        dataSource.setSavePassword(this.isSavePasswordLocally() && (!this.needsPassword || this.savePasswordCheck != null && this.savePasswordCheck.getSelection()) || this.gcpIAMCheckbox != null && this.gcpIAMCheckbox.getSelection());
    }

    public void saveIAMAuthSettings(Map<String, String> props) {
        props.put("gcp.authType", this.curConfigType.name());
        if (this.curConfigType == GCPAuthType.SERVICE_ACCOUNT) {
            props.put("gcp.sa_config_path", this.gcpServiceAccountConfigPath.getText());
        } else if (this.curConfigType == GCPAuthType.SSO_OVER_CLI) {
            props.put("gcp.sso", Boolean.TRUE.toString());
        }
        if (this.gcpIAMCheckbox != null) {
            props.put("gcp.iam_auth", CommonUtils.toString((Object)this.gcpIAMCheckbox.getSelection(), (String)Boolean.FALSE.toString()));
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
    }

    public boolean isComplete() {
        if (GCPAuthType.SSO_OVER_CLI == this.curConfigType) {
            return true;
        }
        if (GCPAuthType.DEFAULT == this.curConfigType) {
            return true;
        }
        if (GCPAuthType.SERVICE_ACCOUNT == this.curConfigType) {
            return !this.gcpServiceAccountConfigPath.getText().isEmpty();
        }
        return false;
    }

    public void updateControls() {
        this.authTypeCombo.select(this.authTypes.indexOf(this.curConfigType));
        this.changeAuthType(this.curConfigType);
    }

    private boolean widgetIsAvailable(Widget widget) {
        return widget != null && !widget.isDisposed();
    }
}

