/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.model;

import com.dbeaver.ee.influxdb2.Influx2Constants;
import com.dbeaver.ee.influxdb2.exec.Influx2ExecutionContext;
import com.dbeaver.ee.influxdb2.exec.Influx2Session;
import com.dbeaver.ee.influxdb2.model.Influx2DataSource;
import com.dbeaver.ee.influxdb2.model.Influx2Database;
import com.dbeaver.ee.influxdb2.model.Influx2Measurement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.DirectObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class Influx2StructureAssistant
implements DBSStructureAssistant<Influx2ExecutionContext> {
    private final Influx2DataSource dataSource;

    public Influx2StructureAssistant(Influx2DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull Influx2ExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        ArrayList<DBSObjectReference> references = new ArrayList<DBSObjectReference>();
        DBSObject parentObject = params.getParentObject();
        Throwable throwable = null;
        Object var7_8 = null;
        try (Influx2Session session = (Influx2Session)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)(parentObject != null ? parentObject : this.dataSource), (String)"Find Influx objects");){
            Influx2Database database = parentObject instanceof Influx2Database ? (Influx2Database)parentObject : executionContext.getDefaultCatalog();
            this.findCollections(session, database, params, references);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return references;
    }

    private void findCollections(Influx2Session session, @NotNull Influx2Database database, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws DBException {
        String colNameMask = params.getMask();
        String likePattern = colNameMask.contains("%") ? colNameMask.replace("%", ".*") : Pattern.quote(colNameMask);
        Pattern pattern = Pattern.compile(likePattern, (params.isCaseSensitive() ? 0 : 2) | 8);
        for (Influx2Measurement table : database.getMeasurements(session.getProgressMonitor())) {
            if (!pattern.matcher(table.getName()).matches()) continue;
            objects.add((DBSObjectReference)new DirectObjectReference((DBSObject)database, Influx2Constants.TYPE_MEASUREMENT, (DBSObject)table));
        }
    }
}

