/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.model;

import com.dbeaver.ee.influxdb2.exec.Influx2ExecutionContext;
import com.dbeaver.ee.influxdb2.model.Influx2DataSource;
import com.dbeaver.ee.influxdb2.model.Influx2DataType;
import com.dbeaver.ee.influxdb2.model.Influx2Measurement;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class Influx2MeasurementTag
implements DBSTableColumn,
DBPRefreshableObject {
    private static final Log log = Log.getLog(Influx2MeasurementTag.class);
    private final Influx2Measurement table;
    private final String name;
    private final int position;
    private List<String> values;

    public Influx2MeasurementTag(Influx2Measurement table, int position, String name) {
        this.table = table;
        this.position = position;
        this.name = name;
    }

    @NotNull
    public Influx2DataSource getDataSource() {
        return this.table.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return true;
    }

    public int getOrdinalPosition() {
        return this.position;
    }

    public int getTypeID() {
        return Influx2DataType.TypeName.STRING.getTypeId();
    }

    public DBPDataKind getDataKind() {
        return Influx2DataType.TypeName.STRING.getDataKind();
    }

    public String getTypeName() {
        return Influx2DataType.TypeName.STRING.getTypeName();
    }

    public String getFullTypeName() {
        return Influx2DataType.TypeName.STRING.getTypeName();
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @NotNull
    public Influx2Measurement getParentObject() {
        return this.table;
    }

    public String getDefaultValue() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Integer getScale() {
        return 0;
    }

    public Integer getPrecision() {
        return 0;
    }

    public long getMaxLength() {
        return 0L;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    public String toString() {
        return this.name;
    }

    @Property(viewable=true, editable=true, order=3)
    @Association
    public List<String> getTagValues(DBRProgressMonitor monitor) throws DBException {
        if (this.values == null) {
            ArrayList<String> resList = new ArrayList<String>();
            InfluxDBClient influxDB = ((Influx2ExecutionContext)this.getDataSource().getDefaultContext(monitor, true)).getClient();
            List dbListResult = influxDB.getQueryApi().query("import \"influxdata/influxdb/schema\" schema.measurementTagValues(bucket: \"" + this.getParentObject().getDatabase().getName() + "\"," + " measurement: \"" + this.getParentObject().getName() + "\"," + " tag: \"" + this.getName() + "\")");
            for (FluxTable result : dbListResult) {
                for (FluxRecord dbObj : CommonUtils.safeList((List)result.getRecords())) {
                    Object fieldName = dbObj.getValue();
                    resList.add(CommonUtils.toString((Object)fieldName));
                }
            }
            this.values = resList;
        }
        return this.values;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.values = null;
        return this;
    }
}

