/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.model;

import com.dbeaver.ee.influxdb2.data.Influx2TimeSeriesDataProvider;
import com.dbeaver.ee.influxdb2.exec.Influx2ExecutionContext;
import com.dbeaver.ee.influxdb2.model.Influx2DataSourceInfo;
import com.dbeaver.ee.influxdb2.model.Influx2DataType;
import com.dbeaver.ee.influxdb2.model.Influx2Database;
import com.dbeaver.ee.influxdb2.model.Influx2SQLDialect;
import com.dbeaver.ee.influxdb2.model.Influx2StructureAssistant;
import com.dbeaver.ee.influxdb2.model.Influx2User;
import com.dbeaver.model.timeseries.TSDataProvider;
import com.dbeaver.model.timeseries.TSDatasource;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.AbstractSimpleDataSource;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.utils.CommonUtils;

public class Influx2DataSource
extends AbstractSimpleDataSource<Influx2ExecutionContext>
implements DBPDataTypeProvider,
DBPTermProvider,
IAdaptable,
TSDatasource {
    private List<Influx2Database> databases;
    private Influx2DataSourceInfo info;
    private final List<Influx2DataType> dataTypes = new ArrayList<Influx2DataType>();
    private final UserCache userCache = new UserCache();

    public Influx2DataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBCException {
        super(container);
        Influx2DataType.TypeName[] typeNameArray = Influx2DataType.TypeName.values();
        int n = typeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Influx2DataType.TypeName typeName = typeNameArray[n2];
            this.dataTypes.add(new Influx2DataType(this, typeName));
            ++n2;
        }
        this.executionContext = new Influx2ExecutionContext(this, "Main Influx Connection", this.getContainer().getActualConnectionConfiguration().getDatabaseName());
        ((Influx2ExecutionContext)this.executionContext).connect(monitor);
    }

    public String getDefaultDatabaseName() {
        return ((Influx2ExecutionContext)this.executionContext).getDefaultDatabase();
    }

    public SQLDialect getSQLDialect() {
        return Influx2SQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new Influx2DataSourceInfo(this);
        this.databases = new ArrayList<Influx2Database>();
        InfluxDBClient influxDB = ((Influx2ExecutionContext)this.getDefaultContext(monitor, true)).getClient();
        this.getDefaultDatabaseName();
        List dbListResult = influxDB.getBucketsApi().findBuckets();
        for (Bucket result : dbListResult) {
            this.databases.add(new Influx2Database(this, CommonUtils.toString((Object)result.getName())));
        }
        this.databases.sort(DBUtils.nameComparator());
    }

    @NotNull
    public Influx2ExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        Influx2ExecutionContext context = new Influx2ExecutionContext(this, purpose, initFrom instanceof Influx2ExecutionContext ? ((Influx2ExecutionContext)initFrom).getDefaultDatabase() : this.getContainer().getActualConnectionConfiguration().getDatabaseName());
        context.connect(monitor);
        return context;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new Influx2StructureAssistant(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        String term = null;
        if ("database".equals(objectType)) {
            term = "Database";
        } else if ("measurement".equals(objectType)) {
            term = "Measurement";
        }
        if (term != null && multiple) {
            term = String.valueOf(term) + "s";
        }
        return term;
    }

    @Association
    public List<Influx2Database> getDatabases() {
        return this.databases;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.databases;
    }

    public Influx2Database getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (Influx2Database)DBUtils.findObject(this.databases, (String)childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return Influx2Database.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        for (Influx2DataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType.getDataKind();
        }
        return DBPDataKind.OBJECT;
    }

    public Influx2DataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.getLocalDataType(typeFullName);
    }

    public List<Influx2DataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public Influx2DataType getLocalDataType(String typeName) {
        for (Influx2DataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType;
        }
        return null;
    }

    public Influx2DataType getLocalDataType(int typeID) {
        for (Influx2DataType dataType : this.dataTypes) {
            if (dataType.getTypeID() != typeID) continue;
            return dataType;
        }
        return null;
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return Influx2DataType.TypeName.STRING.getTypeName();
    }

    @Association
    public List<Influx2User> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, this);
    }

    @NotNull
    public TSDataProvider getTSDataProvider(@NotNull DBSDataContainer container) {
        return new Influx2TimeSeriesDataProvider(container);
    }

    static class UserCache
    extends AbstractObjectCache<Influx2DataSource, Influx2User> {
        UserCache() {
        }

        @NotNull
        public List<Influx2User> getAllObjects(@NotNull DBRProgressMonitor monitor, @NotNull Influx2DataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<Influx2User> users = new ArrayList<Influx2User>();
                InfluxDBClient influxDB = ((Influx2ExecutionContext)dataSource.getDefaultContext(monitor, true)).getClient();
                List dbListResult = influxDB.getUsersApi().findUsers();
                for (User user : CommonUtils.safeList((List)dbListResult)) {
                    String name = user.getName();
                    String id = user.getId();
                    String status = user.getStatus().getValue();
                    String oauthID = user.getOauthID();
                    String self = user.getLinks().getSelf();
                    users.add(new Influx2User(dataSource, name, id, status, oauthID, self));
                }
                users.sort(DBUtils.nameComparator());
                this.setCache(users);
            }
            return this.getCachedObjects();
        }

        public Influx2User getObject(@NotNull DBRProgressMonitor monitor, @NotNull Influx2DataSource dataSource, @NotNull String name) throws DBException {
            return (Influx2User)DBUtils.findObject(this.getAllObjects(monitor, dataSource), (String)name);
        }
    }
}

