/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.krb5.prestodb;

import com.dbeaver.net.auth.krb5.AuthModelKerberos;
import com.dbeaver.net.auth.krb5.AuthModelKerberosCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PrestoSQLAuthModelKerberos
extends AuthModelKerberos {
    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelKerberosCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
        String krb5User = configuration.getUserName();
        String ccPath = credentials.getCacheFilePath();
        String serviceName = credentials.getServiceName();
        String sslJksPath = credentials.getSslJksPath();
        String sslJksPassword = credentials.getSslJksPassword();
        boolean useSslJks = credentials.isUseSslJks();
        System.setProperty("sun.security.krb5.debug", "true");
        connProperties.setProperty("user", krb5User);
        connProperties.setProperty("SSL", "true");
        if (useSslJks) {
            connProperties.setProperty("SSLKeyStorePath", sslJksPath);
            connProperties.setProperty("SSLKeyStorePassword", sslJksPassword);
        }
        connProperties.setProperty("KerberosRemoteServiceName", serviceName);
        connProperties.setProperty("KerberosPrincipal", krb5User);
        connProperties.setProperty("KerberosCredentialCachePath", ccPath);
        connProperties.setProperty("KerberosUseCanonicalHostname", "false");
        return credentials;
    }
}

