/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueDefaultGenerator;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.local.StatResultSet;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.sql.DBSQLException;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DynamicFindReplaceTarget;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TabFolderReorder;
import org.jkiss.dbeaver.ui.controls.ToolbarSeparatorContribution;
import org.jkiss.dbeaver.ui.controls.VerticalButton;
import org.jkiss.dbeaver.ui.controls.VerticalFolder;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshControl;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ActiveStatusMessage;
import org.jkiss.dbeaver.ui.controls.resultset.DataFilterRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.FilterByAttributeAction;
import org.jkiss.dbeaver.ui.controls.resultset.FilterByAttributeType;
import org.jkiss.dbeaver.ui.controls.resultset.FilterResetAttributeAction;
import org.jkiss.dbeaver.ui.controls.resultset.FilterSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.IQueryExecuteController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainerExt;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDisplayFormatProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetFilterManager;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.IStatefulControl;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetContextImpl;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataReceiver;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetExecutionSource;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetFilterPanel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetJobAbstract;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetJobDataRead;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPersister;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetReferenceMenu;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveReport;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetStatListener;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.StatusLabel;
import org.jkiss.dbeaver.ui.controls.resultset.TransformerSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.colors.CustomizeColorsAction;
import org.jkiss.dbeaver.ui.controls.resultset.colors.ResetRowColorAction;
import org.jkiss.dbeaver.ui.controls.resultset.colors.SetRowColorAction;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerCopyAs;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerOpenWith;
import org.jkiss.dbeaver.ui.controls.resultset.handler.SavePreviewDialog;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.FilterValueEditPopup;
import org.jkiss.dbeaver.ui.controls.resultset.view.EmptyPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.view.ErrorPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.view.StatisticsPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.EditVirtualEntityDialog;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.VirtualAttributeAddAction;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.VirtualAttributeDeleteAction;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.VirtualAttributeEditAction;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.VirtualEntityEditAction;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.VirtualForeignKeyEditAction;
import org.jkiss.dbeaver.ui.controls.resultset.virtual.VirtualUniqueKeyEditAction;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetViewer
extends Viewer
implements DBPContextProvider,
IResultSetController,
ISaveablePart2,
IAdaptable,
DBPEventListener {
    private static final Log log = Log.getLog(ResultSetViewer.class);
    private static final String TOOLBAR_GROUP_NAVIGATION = "navigation";
    private static final String TOOLBAR_GROUP_PRESENTATIONS = "presentations";
    private static final String TOOLBAR_GROUP_ADDITIONS = "additions";
    private static final String SETTINGS_SECTION_PRESENTATIONS = "presentations";
    private static final String TOOLBAR_CONTRIBUTION_ID = "toolbar:org.jkiss.dbeaver.ui.controls.resultset.status";
    private static final String CONFIRM_SERVER_SIDE_ORDERING_UNAVAILABLE = "org.jkiss.dbeaver.sql.resultset.serverSideOrderingUnavailable";
    public static final String EMPTY_TRANSFORMER_NAME = "Default";
    public static final String CONTROL_ID = ResultSetViewer.class.getSimpleName();
    public static final String DEFAULT_QUERY_TEXT = "SQL";
    public static final String CUSTOM_FILTER_VALUE_STRING = "..";
    private static final DecimalFormat ROW_COUNT_FORMAT = new DecimalFormat("###,###,###,###,###,##0");
    private static final DateTimeFormatter EXECUTION_TIME_FORMATTER = DateTimeFormatter.ofPattern("MMM dd, HH:mm:ss");
    private static final IResultSetListener[] EMPTY_LISTENERS = new IResultSetListener[0];
    private IResultSetFilterManager filterManager;
    @NotNull
    private final IWorkbenchPartSite site;
    private final Composite mainPanel;
    private final Composite viewerPanel;
    private final IResultSetDecorator decorator;
    @Nullable
    private ResultSetFilterPanel filtersPanel;
    private final SashForm viewerSash;
    private final VerticalFolder panelSwitchFolder;
    private CTabFolder panelFolder;
    private ToolBarManager panelToolBar;
    private final VerticalFolder presentationSwitchFolder;
    private final Composite presentationPanel;
    private final List<ToolBarManager> toolbarList = new ArrayList<ToolBarManager>();
    private Composite statusBar;
    private StatusLabel statusLabel;
    private ActiveStatusMessage rowCountLabel;
    private Text selectionStatLabel;
    private Text resultSetSize;
    private final DynamicFindReplaceTarget findReplaceTarget;
    private IResultSetPresentation activePresentation;
    private ResultSetPresentationDescriptor activePresentationDescriptor;
    private List<ResultSetPresentationDescriptor> availablePresentations;
    private final List<ResultSetPanelDescriptor> availablePanels = new ArrayList<ResultSetPanelDescriptor>();
    private final Map<ResultSetPresentationDescriptor, PresentationSettings> presentationSettings = new HashMap<ResultSetPresentationDescriptor, PresentationSettings>();
    private final Map<String, IResultSetPanel> activePanels = new HashMap<String, IResultSetPanel>();
    @NotNull
    private final IResultSetContainer container;
    @NotNull
    private final ResultSetDataReceiver dataReceiver;
    @NotNull
    private final DBPPreferenceListener dataPropertyListener;
    private long lastPropertyUpdateTime;
    @Nullable
    private ResultSetRow curRow;
    private boolean recordMode;
    private int[] selectedRecords = new int[0];
    private Integer segmentFetchSize;
    private final List<IResultSetListener> listeners = new ArrayList<IResultSetListener>();
    private final List<ResultSetJobAbstract> dataPumpJobQueue = new ArrayList<ResultSetJobAbstract>();
    private final AtomicBoolean dataPumpRunning = new AtomicBoolean();
    private final ResultSetModel model = new ResultSetModel();
    private HistoryStateItem curState = null;
    private final List<HistoryStateItem> stateHistory = new ArrayList<HistoryStateItem>();
    private int historyPosition = -1;
    private final AutoRefreshControl autoRefreshControl;
    private boolean actionsDisabled;
    private volatile boolean isUIUpdateRunning;
    private final Color defaultBackground;
    private final Color defaultForeground;
    private VerticalButton recordModeButton;
    private IPropertyChangeListener themeChangeListener;
    private long lastThemeUpdateTime;
    private volatile boolean nextSegmentReadingBlocked;

    public ResultSetViewer(@NotNull Composite parent, @NotNull IWorkbenchPartSite site, @NotNull IResultSetContainer container) {
        this.site = site;
        this.recordMode = false;
        this.container = container;
        this.decorator = container.createResultSetDecorator();
        this.dataReceiver = new ResultSetDataReceiver(this);
        this.dataPropertyListener = event -> {
            DBPDataSourceContainer dataSourceContainer = null;
            if (event.getSource() instanceof IDataSourceContainerProvider) {
                dataSourceContainer = ((IDataSourceContainerProvider)event.getSource()).getDataSourceContainer();
            }
            this.handleDataPropertyChange(dataSourceContainer, event.getProperty(), event.getOldValue(), event.getNewValue());
        };
        this.filterManager = (IResultSetFilterManager)GeneralUtils.adapt((Object)this, IResultSetFilterManager.class);
        if (this.filterManager == null) {
            this.filterManager = new SimpleFilterManager();
        }
        this.loadPresentationSettings();
        this.defaultBackground = UIStyles.getDefaultTextBackground();
        this.defaultForeground = UIStyles.getDefaultTextForeground();
        long decoratorFeatures = this.decorator.getDecoratorFeatures();
        boolean supportsPanels = (decoratorFeatures & 4L) != 0L;
        this.mainPanel = UIUtils.createPlaceholder((Composite)parent, (int)(supportsPanels ? 3 : 2));
        this.autoRefreshControl = new AutoRefreshControl((Control)this.mainPanel, ResultSetViewer.class.getSimpleName(), monitor -> {
            boolean bl = this.refreshData(null);
        });
        this.autoRefreshControl.setHintSupplier(() -> {
            DBCTransactionManager txnManager;
            DBCExecutionContext executionContext = this.getExecutionContext();
            if (executionContext != null && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)executionContext)) != null) {
                try {
                    if (txnManager.isAutoCommit()) {
                        return "Hint: frequent refresh may cause high server load";
                    }
                    return "Hint: switch to auto-commit to see external changes";
                }
                catch (DBCException e) {
                    log.debug((Object)e);
                }
            }
            return null;
        });
        if ((decoratorFeatures & 1L) != 0L) {
            this.filtersPanel = new ResultSetFilterPanel(this, this.mainPanel);
            GridData gd = new GridData(768);
            gd.horizontalSpan = ((GridLayout)this.mainPanel.getLayout()).numColumns;
            this.filtersPanel.setLayoutData(gd);
        }
        if ((decoratorFeatures & 0x10L) != 0L) {
            this.presentationSwitchFolder = new VerticalFolder(this.mainPanel, 16384);
            this.presentationSwitchFolder.setLayoutData((Object)new GridData(1040));
            CSSUtils.setCSSClass((Widget)this.presentationSwitchFolder, (String)"coloredByConnectionType");
        } else {
            this.presentationSwitchFolder = null;
        }
        this.viewerPanel = UIUtils.createPlaceholder((Composite)this.mainPanel, (int)1);
        this.viewerPanel.setLayoutData((Object)new GridData(1808));
        this.viewerPanel.setData(CONTROL_ID, (Object)this);
        CSSUtils.setCSSClass((Widget)this.viewerPanel, (String)"coloredByConnectionType");
        UIUtils.setHelp((Control)this.viewerPanel, (String)"result-set-viewer");
        this.viewerPanel.setRedraw(false);
        if (supportsPanels) {
            this.panelSwitchFolder = new VerticalFolder(this.mainPanel, 131072);
            this.panelSwitchFolder.setLayoutData((Object)new GridData(1040));
            CSSUtils.setCSSClass((Widget)this.panelSwitchFolder, (String)"coloredByConnectionType");
        } else {
            this.panelSwitchFolder = null;
        }
        try {
            this.findReplaceTarget = new DynamicFindReplaceTarget();
            this.viewerSash = new SashForm(this.viewerPanel, 65792);
            this.viewerSash.setSashWidth(5);
            this.viewerSash.setLayoutData((Object)new GridData(1808));
            this.presentationPanel = UIUtils.createPlaceholder((Composite)this.viewerSash, (int)1);
            this.presentationPanel.setLayoutData((Object)new GridData(1808));
            if (supportsPanels) {
                this.panelFolder = new CTabFolder((Composite)this.viewerSash, 0x800080);
                CSSUtils.setCSSClass((Widget)this.panelFolder, (String)"coloredByConnectionType");
                new TabFolderReorder(this.panelFolder);
                this.panelFolder.marginWidth = 0;
                this.panelFolder.marginHeight = 0;
                this.panelFolder.setMinimizeVisible(true);
                this.panelFolder.setMRUVisible(true);
                this.panelFolder.setLayoutData((Object)new GridData(1808));
                this.panelFolder.addListener(8, event -> {
                    if (event.button != 1) {
                        return;
                    }
                    CTabItem selectedItem = this.panelFolder.getItem(new Point(event.getBounds().x, event.getBounds().y));
                    if (selectedItem != null && selectedItem == this.panelFolder.getSelection()) {
                        this.togglePanelsMaximize();
                    }
                });
                this.panelToolBar = new ToolBarManager(8519936);
                Composite trControl = new Composite((Composite)this.panelFolder, 0);
                trControl.setLayout((Layout)new FillLayout());
                this.panelToolBar.createControl(trControl);
                this.panelFolder.setTopRight((Control)trControl, 131136);
                this.panelFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CTabItem activeTab = ResultSetViewer.this.panelFolder.getSelection();
                        if (activeTab != null) {
                            ResultSetViewer.this.setActivePanel((String)activeTab.getData());
                        }
                    }
                });
                this.panelFolder.addListener(11, event -> {
                    int[] weights;
                    if (!this.viewerSash.isDisposed() && !this.isUIUpdateRunning && (weights = this.viewerSash.getWeights()).length == 2) {
                        this.getPresentationSettings().panelRatio = weights[1];
                    }
                });
                this.panelFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                    public void close(CTabFolderEvent event) {
                        CTabItem item = (CTabItem)event.item;
                        String panelId = (String)item.getData();
                        ResultSetViewer.this.removePanel(panelId);
                    }

                    public void minimize(CTabFolderEvent event) {
                        ResultSetViewer.this.showPanels(false, true, true);
                    }

                    public void maximize(CTabFolderEvent event) {
                    }
                });
                MenuManager panelsMenuManager = new MenuManager();
                panelsMenuManager.setRemoveAllWhenShown(true);
                panelsMenuManager.addMenuListener(manager -> {
                    for (IContributionItem menuItem : this.fillPanelsMenu()) {
                        panelsMenuManager.add(menuItem);
                    }
                });
                Menu panelsMenu = panelsMenuManager.createContextMenu((Control)this.panelFolder);
                this.panelFolder.setMenu(panelsMenu);
                this.panelFolder.addDisposeListener(e -> panelsMenuManager.dispose());
            }
            this.showEmptyPresentation();
            if (this.supportsStatusBar()) {
                this.createStatusBar();
            }
            this.viewerPanel.addDisposeListener(e -> this.dispose());
            this.changeMode(false);
        }
        finally {
            this.viewerPanel.setRedraw(true);
        }
        this.updateFiltersText();
        this.addListener(new ResultSetStatListener(this));
        DBPProject project = container.getProject();
        if (project != null) {
            project.getDataSourceRegistry().addDataSourceListener((DBPEventListener)this);
        }
        this.themeChangeListener = event -> {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().startsWith("org.jkiss.dbeaver.sql.resultset.")) {
                if (this.lastThemeUpdateTime > 0L && System.currentTimeMillis() - this.lastThemeUpdateTime < 500L) {
                    return;
                }
                this.lastThemeUpdateTime = System.currentTimeMillis();
                UIUtils.asyncExec(this::applyCurrentPresentationThemeSettings);
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeChangeListener);
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener(this.dataPropertyListener);
        DBWorkbench.getPlatform().getDataSourceProviderRegistry().getGlobalDataSourcePreferenceStore().addPropertyChangeListener(this.dataPropertyListener);
    }

    private void applyCurrentPresentationThemeSettings() {
        if (this.activePresentation instanceof AbstractPresentation) {
            ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            ((AbstractPresentation)this.activePresentation).applyThemeSettings(currentTheme);
        }
    }

    private void handleDataPropertyChange(@Nullable DBPDataSourceContainer dataSource, @NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        if (this.lastPropertyUpdateTime > 0L && System.currentTimeMillis() - this.lastPropertyUpdateTime < 200L) {
            return;
        }
        this.lastPropertyUpdateTime = System.currentTimeMillis();
        if ("resultset.presentation.active".equals(property)) {
            return;
        }
        UIUtils.asyncExec(() -> {
            if ("resultset.show.colorizeDataTypes".equals(property) && this.activePresentation instanceof AbstractPresentation) {
                ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                ((AbstractPresentation)this.activePresentation).applyThemeSettings(currentTheme);
            }
            this.redrawData(false, false);
        });
    }

    @Override
    @NotNull
    public IResultSetContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public IResultSetDecorator getDecorator() {
        return this.decorator;
    }

    AutoRefreshControl getAutoRefresh() {
        return this.autoRefreshControl;
    }

    private boolean supportsPanels() {
        return (this.decorator.getDecoratorFeatures() & 4L) != 0L && this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsPanels();
    }

    public boolean supportsStatusBar() {
        return (this.decorator.getDecoratorFeatures() & 2L) != 0L;
    }

    public boolean supportsDataFilter() {
        DBSDataContainer dataContainer = this.getDataContainer();
        return dataContainer != null && dataContainer.isFeatureSupported("data.filter");
    }

    public boolean supportsNavigation() {
        return this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsNavigation();
    }

    public boolean supportsEdit() {
        return this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsEdit();
    }

    public void resetDataFilter(boolean refresh) {
        this.setDataFilter(this.model.createDataFilter(), refresh);
    }

    public void clearDataFilter(boolean refresh) {
        Map state;
        DBDDataFilter newFilter = this.model.createDataFilter();
        DBDDataFilter curFilter = this.model.getDataFilter();
        HashMap<String, Map> states = new HashMap<String, Map>();
        for (DBDAttributeConstraint constraint : curFilter.getConstraints()) {
            state = this.saveConstraintVisualState(constraint);
            if (state.isEmpty()) continue;
            states.put(constraint.getFullAttributeName(), state);
        }
        for (DBDAttributeConstraint constraint : newFilter.getConstraints()) {
            state = (Map)states.get(constraint.getFullAttributeName());
            if (state == null) continue;
            this.restoreConstraintVisualState(constraint, state);
        }
        this.setDataFilter(newFilter, refresh);
    }

    private Map<String, Object> saveConstraintVisualState(DBDAttributeConstraint constraint) {
        Hashtable<String, Object> state = new Hashtable<String, Object>();
        state.put("visible", constraint.isVisible());
        if (!ArrayUtils.isEmpty((Object[])constraint.getOptions())) {
            state.put("options", constraint.getOptions());
        }
        return state;
    }

    private void restoreConstraintVisualState(DBDAttributeConstraint constraint, Map<String, Object> state) {
        constraint.setVisible(((Boolean)state.get("visible")).booleanValue());
        if (state.containsKey("options")) {
            constraint.setOptions((Object[])state.get("options"));
        }
    }

    public void showFilterSettingsDialog() {
        new FilterSettingsDialog(this).open();
    }

    public void saveDataFilter() {
        DBCExecutionContext context = this.getExecutionContext();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (context == null || dataContainer == null) {
            log.error((Object)"Can't save data filter with null context");
            return;
        }
        DataFilterRegistry.getInstance().saveDataFilter(dataContainer, this.model.getDataFilter());
        if (this.filtersPanel != null) {
            DBeaverNotifications.showNotification((String)"generalInfo", (String)"Data filter was saved", (String)this.filtersPanel.getFilterText(), (DBPMessageType)DBPMessageType.INFORMATION, null);
        }
    }

    public void switchFilterFocus() {
        if (this.filtersPanel == null) {
            return;
        }
        boolean filterFocused = this.filtersPanel.getEditControl().isFocusControl();
        if (filterFocused) {
            if (this.activePresentation != null) {
                this.activePresentation.getControl().setFocus();
            }
        } else {
            this.filtersPanel.getEditControl().setFocus();
        }
    }

    private void updateFiltersText() {
        this.updateFiltersText(true);
    }

    public void updateFiltersText(boolean resetFilterValue) {
        if (this.filtersPanel == null || this.viewerPanel.isDisposed()) {
            return;
        }
        if (this.resultSetSize != null && !this.resultSetSize.isDisposed()) {
            this.resultSetSize.setEnabled(this.getDataContainer() != null);
        }
        this.viewerPanel.setRedraw(false);
        try {
            boolean enableFilters = false;
            DBCExecutionContext context = this.getExecutionContext();
            if (context != null && !(this.activePresentation instanceof StatisticsPresentation)) {
                StringBuilder where = new StringBuilder();
                SQLUtils.appendConditionString((DBDDataFilter)this.model.getDataFilter(), (DBPDataSource)context.getDataSource(), null, (StringBuilder)where, (boolean)true, (boolean)SQLSemanticProcessor.isForceFilterSubQuery((DBPDataSource)context.getDataSource()));
                if (resetFilterValue) {
                    String whereCondition = where.toString().trim();
                    this.filtersPanel.setFilterValue(whereCondition);
                    if (!whereCondition.isEmpty()) {
                        this.filtersPanel.addFiltersHistory(whereCondition);
                    }
                }
                if (this.container.isReadyToRun() && !this.model.isUpdateInProgress()) {
                    enableFilters = true;
                }
            }
            this.filtersPanel.enableFilters(enableFilters);
            this.getAutoRefresh().enableControls(enableFilters);
        }
        finally {
            this.viewerPanel.setRedraw(true);
        }
    }

    @Override
    public DBDDataFilter getDataFilter() {
        return this.model.getDataFilter();
    }

    @Override
    public void setDataFilter(DBDDataFilter dataFilter, boolean refreshData) {
        if (refreshData) {
            this.refreshWithFilter(dataFilter);
        } else {
            this.model.setDataFilter(dataFilter);
            this.activePresentation.refreshData(true, false, true);
            this.updateFiltersText();
        }
    }

    @Override
    public void setSegmentFetchSize(Integer segmentFetchSize) {
        this.segmentFetchSize = segmentFetchSize;
    }

    @Override
    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        DBCExecutionContext context = this.getExecutionContext();
        if (context != null) {
            return context.getDataSource().getContainer().getPreferenceStore();
        }
        return DBWorkbench.getPlatform().getPreferenceStore();
    }

    @Override
    @NotNull
    public Color getDefaultBackground() {
        if (this.filtersPanel == null) {
            return this.defaultBackground;
        }
        return UIStyles.getDefaultTextBackground();
    }

    @Override
    @NotNull
    public Color getDefaultForeground() {
        if (this.filtersPanel == null) {
            return this.defaultForeground;
        }
        return UIStyles.getDefaultTextForeground();
    }

    public void persistConfig() {
        DBCExecutionContext context = this.getExecutionContext();
        if (context != null) {
            context.getDataSource().getContainer().persistConfiguration();
        }
    }

    @NotNull
    public List<ResultSetPresentationDescriptor> getAvailablePresentations() {
        return this.availablePresentations != null ? this.availablePresentations : Collections.emptyList();
    }

    @Override
    @NotNull
    public IResultSetPresentation getActivePresentation() {
        return this.activePresentation;
    }

    @Override
    public void showEmptyPresentation() {
        this.activePresentationDescriptor = null;
        this.setActivePresentation(new EmptyPresentation());
        this.updatePresentationInToolbar();
    }

    private void showErrorPresentation(String sqlText, String message, Throwable error) {
        this.activePresentationDescriptor = null;
        this.setActivePresentation(new ErrorPresentation(sqlText, GeneralUtils.makeErrorStatus((String)message, (Throwable)error), this.container instanceof IResultSetContainerExt ? (IResultSetContainerExt)((Object)this.container) : null));
        this.updatePresentationInToolbar();
        this.fireQueryExecuted(sqlText, null, error.getMessage());
    }

    void updatePresentation(DBCResultSet resultSet, boolean metadataChanged) {
        if (this.getControl().isDisposed()) {
            return;
        }
        boolean changed = false;
        try {
            this.isUIUpdateRunning = true;
            if (resultSet instanceof StatResultSet) {
                if (this.filtersPanel != null) {
                    this.filtersPanel.setVisible(false);
                }
                this.availablePresentations = Collections.emptyList();
                this.setActivePresentation(new StatisticsPresentation());
                this.activePresentationDescriptor = null;
                changed = true;
            } else {
                List<ResultSetPresentationDescriptor> newPresentations;
                if (this.filtersPanel != null) {
                    this.filtersPanel.setVisible(true);
                }
                ResultSetContextImpl context = new ResultSetContextImpl(this, resultSet);
                String preferredPresentationId = this.getDecorator().getPreferredPresentation();
                if (CommonUtils.isEmpty((String)preferredPresentationId)) {
                    newPresentations = ResultSetPresentationRegistry.getInstance().getAvailablePresentations(resultSet, context);
                } else {
                    ResultSetPresentationDescriptor preferredPresentation = ResultSetPresentationRegistry.getInstance().getPresentation(preferredPresentationId);
                    if (preferredPresentation != null) {
                        newPresentations = Collections.singletonList(preferredPresentation);
                    } else {
                        log.error((Object)("Presentation '" + preferredPresentationId + "' not found"));
                        newPresentations = Collections.emptyList();
                    }
                }
                changed = CommonUtils.isEmpty(this.availablePresentations) || !newPresentations.equals(this.availablePresentations);
                this.availablePresentations = newPresentations;
                if (!this.availablePresentations.isEmpty()) {
                    if (this.activePresentationDescriptor != null && (!metadataChanged || this.activePresentationDescriptor.getPresentationType().isPersistent()) && this.availablePresentations.contains((Object)this.activePresentationDescriptor)) {
                        this.fireResultSetModelPrepared();
                        return;
                    }
                    String defaultPresentationId = this.getPreferenceStore().getString("resultset.presentation.active");
                    ResultSetPresentationDescriptor newPresentation = null;
                    if (!CommonUtils.isEmpty((String)defaultPresentationId)) {
                        for (ResultSetPresentationDescriptor pd : this.availablePresentations) {
                            if (!pd.getId().equals(defaultPresentationId)) continue;
                            newPresentation = pd;
                            break;
                        }
                    }
                    changed = true;
                    if (newPresentation == null) {
                        newPresentation = this.availablePresentations.get(0);
                    }
                    try {
                        IResultSetPresentation instance = newPresentation.createInstance();
                        this.activePresentationDescriptor = newPresentation;
                        this.setActivePresentation(instance);
                    }
                    catch (Throwable e) {
                        DBWorkbench.getPlatformUI().showError("Presentation activate", "Can't instantiate data view '" + newPresentation.getLabel() + "'", e);
                    }
                } else {
                    log.debug((Object)("No presentations for result set [" + resultSet.getClass().getSimpleName() + "]"));
                    this.showEmptyPresentation();
                }
                this.fireResultSetModelPrepared();
            }
        }
        finally {
            if (changed && this.presentationSwitchFolder != null) {
                this.updatePresentationInToolbar();
            }
            this.isUIUpdateRunning = false;
        }
    }

    private void updatePresentationInToolbar() {
        if (this.presentationSwitchFolder == null) {
            return;
        }
        this.mainPanel.setRedraw(false);
        try {
            try {
                boolean pVisible = this.activePresentationDescriptor != null;
                ((GridData)this.presentationSwitchFolder.getLayoutData()).exclude = !pVisible;
                this.presentationSwitchFolder.setVisible(pVisible);
                if (!pVisible) {
                    this.presentationSwitchFolder.setEnabled(false);
                } else {
                    this.presentationSwitchFolder.setEnabled(true);
                    Control[] controlArray = this.presentationSwitchFolder.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control item = controlArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    for (ResultSetPresentationDescriptor pd : this.availablePresentations) {
                        VerticalButton item = new VerticalButton(this.presentationSwitchFolder, 16400);
                        item.setImage(DBeaverIcons.getImage((DBPImage)pd.getIcon()));
                        item.setText(pd.getLabel());
                        item.setToolTipText(pd.getDescription());
                        item.setData((Object)pd);
                        if (pd == this.activePresentationDescriptor) {
                            this.presentationSwitchFolder.setSelection(item);
                        }
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (e.widget != null && e.widget.getData() != null) {
                                    ResultSetViewer.this.switchPresentation((ResultSetPresentationDescriptor)((Object)e.widget.getData()));
                                }
                            }
                        });
                    }
                    UIUtils.createEmptyLabel((Composite)this.presentationSwitchFolder, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
                    this.recordModeButton = new VerticalButton(this.presentationSwitchFolder, 16416);
                    this.recordModeButton.setAction((IAction)new ToggleModeAction(), true);
                    if (this.statusBar != null) {
                        ((GridLayout)this.presentationSwitchFolder.getLayout()).marginBottom = this.statusBar.getSize().y;
                    }
                }
                this.mainPanel.layout(true, true);
            }
            catch (Exception e) {
                log.debug((Object)"Error updating presentation toolbar", (Throwable)e);
                this.mainPanel.setRedraw(true);
            }
        }
        finally {
            this.mainPanel.setRedraw(true);
        }
    }

    private void setActivePresentation(@NotNull IResultSetPresentation presentation) {
        boolean focusInPresentation = UIUtils.isParent((Control)this.presentationPanel, (Control)this.viewerPanel.getDisplay().getFocusControl());
        if (this.activePresentation != null) {
            this.activePresentation.dispose();
        }
        UIUtils.disposeChildControls((Composite)this.presentationPanel);
        if (this.panelFolder != null) {
            CTabItem curItem = this.panelFolder.getSelection();
            CTabItem[] cTabItemArray = this.panelFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem panelItem = cTabItemArray[n2];
                if (panelItem != curItem) {
                    panelItem.dispose();
                }
                ++n2;
            }
            if (curItem != null) {
                curItem.dispose();
            }
        }
        this.activePresentation = presentation;
        this.availablePanels.clear();
        this.activePanels.clear();
        ResultSetContextImpl context = new ResultSetContextImpl(this, null);
        if (this.activePresentationDescriptor != null) {
            this.availablePanels.addAll(ResultSetPresentationRegistry.getInstance().getSupportedPanels(context, this.getDataSource(), this.activePresentationDescriptor.getId(), this.activePresentationDescriptor.getPresentationType()));
        } else if (this.activePresentation instanceof StatisticsPresentation) {
            this.availablePanels.addAll(ResultSetPresentationRegistry.getInstance().getSupportedPanels(context, this.getDataSource(), null, IResultSetPresentation.PresentationType.COLUMNS));
        }
        this.activePresentation.createPresentation(this, this.presentationPanel);
        if (this.panelSwitchFolder != null) {
            UIUtils.disposeChildControls((Composite)this.panelSwitchFolder);
        }
        if (this.supportsPanels()) {
            boolean panelsVisible = false;
            boolean verticalLayout = false;
            int[] panelWeights = new int[]{700, 300};
            if (this.activePresentationDescriptor != null) {
                PresentationSettings settings = this.getPresentationSettings();
                panelsVisible = settings.panelsVisible;
                verticalLayout = settings.verticalLayout;
                if (settings.panelRatio > 0) {
                    panelWeights = new int[]{1000 - settings.panelRatio, settings.panelRatio};
                }
                this.activateDefaultPanels(settings);
            }
            this.viewerSash.setOrientation(verticalLayout ? 512 : 256);
            this.viewerSash.setWeights(panelWeights);
            this.showPanels(panelsVisible, false, false);
            if (!this.availablePanels.isEmpty()) {
                final VerticalButton panelsButton = new VerticalButton(this.panelSwitchFolder, 131104);
                panelsButton.setText(ResultSetMessages.controls_resultset_config_panels);
                panelsButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.PANEL_CUSTOMIZE));
                panelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ResultSetViewer.this.showPanels(!ResultSetViewer.this.isPanelsVisible(), true, true);
                        panelsButton.setChecked(ResultSetViewer.this.isPanelsVisible());
                        ResultSetViewer.this.updatePanelsButtons();
                    }
                });
                String toolTip = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview", (IServiceLocator)this.getSite(), (boolean)false);
                if (!CommonUtils.isEmpty((String)toolTip)) {
                    panelsButton.setToolTipText(toolTip);
                }
                panelsButton.setChecked(panelsVisible);
                for (final ResultSetPanelDescriptor panel : this.availablePanels) {
                    final VerticalButton panelButton = new VerticalButton(this.panelSwitchFolder, 131104);
                    GridData gd = new GridData(2);
                    gd.verticalIndent = 2;
                    gd.horizontalIndent = 1;
                    panelButton.setLayoutData((Object)gd);
                    panelButton.setData((Object)panel);
                    panelButton.setImage(DBeaverIcons.getImage((DBPImage)panel.getIcon()));
                    panelButton.setToolTipText(panel.getLabel());
                    String toolTip2 = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.core.resultset.grid.togglePanel", (IServiceLocator)this.getSite(), (boolean)true, (String)"panelId", (String)panel.getId());
                    if (!CommonUtils.isEmpty((String)toolTip2)) {
                        panelButton.setToolTipText(String.valueOf(panel.getLabel()) + " (" + toolTip2 + ")");
                    }
                    panelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            boolean isPanelVisible;
                            boolean bl = isPanelVisible = ResultSetViewer.this.isPanelsVisible() && ResultSetViewer.this.isPanelVisible(panel.getId());
                            if (isPanelVisible) {
                                ResultSetViewer.this.closePanel(panel.getId());
                            } else {
                                ResultSetViewer.this.activatePanel(panel.getId(), true, true);
                            }
                            panelButton.setChecked(!isPanelVisible);
                            panelsButton.setChecked(ResultSetViewer.this.isPanelsVisible());
                            if (ResultSetViewer.this.panelSwitchFolder != null) {
                                ResultSetViewer.this.panelSwitchFolder.redraw();
                            }
                        }
                    });
                    panelButton.setChecked(panelsVisible && this.isPanelVisible(panel.getId()));
                }
                UIUtils.createEmptyLabel((Composite)this.panelSwitchFolder, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
                VerticalButton.create((VerticalFolder)this.panelSwitchFolder, (int)131104, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.toggleLayout", (boolean)false);
            }
        } else if (this.viewerSash != null) {
            this.viewerSash.setMaximizedControl(this.viewerSash.getChildren()[0]);
        }
        this.mainPanel.layout(true, true);
        if (this.recordModeButton != null) {
            this.recordModeButton.setVisible(this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsRecordMode());
        }
        IFindReplaceTarget nested = null;
        if (presentation instanceof IAdaptable) {
            nested = (IFindReplaceTarget)((IAdaptable)presentation).getAdapter(IFindReplaceTarget.class);
        }
        this.findReplaceTarget.setTarget(nested);
        if (!this.toolbarList.isEmpty()) {
            for (ToolBarManager tb : this.toolbarList) {
                tb.update(true);
            }
        }
        if (presentation instanceof ISelectionProvider) {
            ((ISelectionProvider)presentation).addSelectionChangedListener(this::fireResultSetSelectionChange);
        }
        if (focusInPresentation) {
            UIUtils.asyncExec(() -> {
                Control control = this.activePresentation.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setFocus();
                }
            });
        }
    }

    private void updatePanelsButtons() {
        boolean panelsVisible = this.isPanelsVisible();
        Control[] controlArray = this.panelSwitchFolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof VerticalButton && child.getData() instanceof ResultSetPanelDescriptor) {
                boolean newChecked;
                boolean bl = newChecked = panelsVisible && this.isPanelVisible(((ResultSetPanelDescriptor)((Object)child.getData())).getId());
                if (((VerticalButton)child).isChecked() != newChecked) {
                    ((VerticalButton)child).setChecked(newChecked);
                    child.redraw();
                }
            }
            ++n2;
        }
    }

    public void switchPresentation() {
        if (this.availablePresentations.size() < 2) {
            return;
        }
        int index = this.availablePresentations.indexOf((Object)this.activePresentationDescriptor);
        index = index < this.availablePresentations.size() - 1 ? ++index : 0;
        this.switchPresentation(this.availablePresentations.get(index));
    }

    public void switchPresentation(ResultSetPresentationDescriptor selectedPresentation) {
        if (selectedPresentation == this.activePresentationDescriptor) {
            return;
        }
        try {
            IResultSetPresentation instance = selectedPresentation.createInstance();
            this.activePresentationDescriptor = selectedPresentation;
            this.setActivePresentation(instance);
            instance.refreshData(true, false, false);
            if (this.presentationSwitchFolder != null) {
                VerticalButton[] verticalButtonArray = this.presentationSwitchFolder.getItems();
                int n = verticalButtonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VerticalButton item = verticalButtonArray[n2];
                    if (item.getData() == this.activePresentationDescriptor) {
                        this.presentationSwitchFolder.setSelection(item);
                        break;
                    }
                    ++n2;
                }
            }
            if (this.activePresentationDescriptor.getPresentationType().isPersistent()) {
                DBWorkbench.getPlatform().getPreferenceStore().setValue("resultset.presentation.active", this.activePresentationDescriptor.getId());
            }
            this.savePresentationSettings();
        }
        catch (Throwable e1) {
            DBWorkbench.getPlatformUI().showError("Presentation switch", "Can't switch presentation", e1);
        }
    }

    private void loadPresentationSettings() {
        IDialogSettings pSections = ResultSetUtils.getViewerSettings("presentations");
        for (IDialogSettings pSection : ArrayUtils.safeArray((Object[])pSections.getSections())) {
            String pId = pSection.getName();
            ResultSetPresentationDescriptor presentation = ResultSetPresentationRegistry.getInstance().getPresentation(pId);
            if (presentation == null) {
                log.warn((Object)("Presentation '" + pId + "' not found. "));
                continue;
            }
            PresentationSettings settings = new PresentationSettings();
            String panelIdList = pSection.get("enabledPanelIds");
            if (panelIdList != null) {
                Collections.addAll(settings.enabledPanelIds, panelIdList.split(","));
            }
            settings.activePanelId = pSection.get("activePanelId");
            settings.panelRatio = pSection.getInt("panelRatio");
            settings.panelsVisible = pSection.getBoolean("panelsVisible");
            settings.verticalLayout = pSection.getBoolean("verticalLayout");
            this.presentationSettings.put(presentation, settings);
        }
    }

    private PresentationSettings getPresentationSettings() {
        PresentationSettings settings = this.presentationSettings.get((Object)this.activePresentationDescriptor);
        if (settings == null) {
            settings = new PresentationSettings();
            settings.panelsVisible = this.activePresentationDescriptor != null && this.activePresentationDescriptor.getPresentationType() == IResultSetPresentation.PresentationType.COLUMNS;
            this.presentationSettings.put(this.activePresentationDescriptor, settings);
        }
        return settings;
    }

    private void savePresentationSettings() {
        if ((this.decorator.getDecoratorFeatures() & 4L) != 0L) {
            IDialogSettings pSections = ResultSetUtils.getViewerSettings("presentations");
            for (Map.Entry<ResultSetPresentationDescriptor, PresentationSettings> pEntry : this.presentationSettings.entrySet()) {
                if (pEntry.getKey() == null) continue;
                String pId = pEntry.getKey().getId();
                PresentationSettings settings = pEntry.getValue();
                IDialogSettings pSection = UIUtils.getSettingsSection((IDialogSettings)pSections, (String)pId);
                pSection.put("enabledPanelIds", CommonUtils.joinStrings((String)",", settings.enabledPanelIds));
                pSection.put("activePanelId", settings.activePanelId);
                pSection.put("panelRatio", settings.panelRatio);
                pSection.put("panelsVisible", settings.panelsVisible);
                pSection.put("verticalLayout", settings.verticalLayout);
            }
        }
    }

    @Override
    public IResultSetPanel getVisiblePanel() {
        return this.isPanelsVisible() ? this.activePanels.get(this.getPresentationSettings().activePanelId) : null;
    }

    @Override
    public IResultSetPanel[] getActivePanels() {
        return this.activePanels.values().toArray(new IResultSetPanel[0]);
    }

    @Override
    public boolean activatePanel(String id, boolean setActive, boolean showPanels) {
        ResultSetPanelDescriptor panelDescriptor;
        if (!this.supportsPanels()) {
            return false;
        }
        if (showPanels && !this.isPanelsVisible()) {
            this.showPanels(true, false, false);
        }
        PresentationSettings presentationSettings = this.getPresentationSettings();
        IResultSetPanel panel = this.activePanels.get(id);
        if (panel != null) {
            CTabItem panelTab = this.getPanelTab(id);
            if (panelTab != null) {
                if (setActive) {
                    this.panelFolder.setSelection(panelTab);
                    presentationSettings.activePanelId = id;
                    if (showPanels) {
                        panel.setFocus();
                    }
                }
                return true;
            }
            log.debug((Object)("Panel '" + id + "' tab not found"));
        }
        if ((panelDescriptor = this.getPanelDescriptor(id)) == null) {
            log.debug((Object)("Panel '" + id + "' not found"));
            return false;
        }
        try {
            panel = panelDescriptor.createInstance();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Can't show panel", "Can't create panel '" + id + "'", (Throwable)e);
            return false;
        }
        this.activePanels.put(id, panel);
        this.panelFolder.setRedraw(false);
        try {
            Control panelControl = panel.createContents(this.activePresentation, (Composite)this.panelFolder);
            boolean firstPanel = this.panelFolder.getItemCount() == 0;
            CTabItem panelTab = new CTabItem(this.panelFolder, 64);
            panelTab.setData((Object)id);
            panelTab.setText(panelDescriptor.getLabel());
            panelTab.setImage(DBeaverIcons.getImage((DBPImage)panelDescriptor.getIcon()));
            panelTab.setToolTipText(panelDescriptor.getDescription());
            panelTab.setControl(panelControl);
            UIUtils.disposeControlOnItemDispose((CTabItem)panelTab);
            if (setActive || firstPanel) {
                this.panelFolder.setSelection(panelTab);
            }
            if (showPanels) {
                panel.setFocus();
            }
        }
        finally {
            this.panelFolder.setRedraw(true);
        }
        presentationSettings.enabledPanelIds.add(id);
        if (setActive) {
            this.setActivePanel(id);
        }
        this.updatePanelsButtons();
        return true;
    }

    private void activateDefaultPanels(PresentationSettings settings) {
        settings.enabledPanelIds.removeIf(CommonUtils::isEmpty);
        if (settings.enabledPanelIds.isEmpty()) {
            for (ResultSetPanelDescriptor pd : this.availablePanels) {
                if (!pd.isShowByDefault()) continue;
                settings.enabledPanelIds.add(pd.getId());
            }
        }
        if (!settings.enabledPanelIds.contains(settings.activePanelId)) {
            settings.activePanelId = null;
        }
        if (!settings.enabledPanelIds.isEmpty()) {
            if (settings.activePanelId == null) {
                settings.activePanelId = settings.enabledPanelIds.iterator().next();
            }
            for (String panelId : new ArrayList<String>(settings.enabledPanelIds)) {
                if (CommonUtils.isEmpty((String)panelId) || this.activatePanel(panelId, panelId.equals(settings.activePanelId), false)) continue;
                settings.enabledPanelIds.remove(panelId);
            }
        }
    }

    private void setActivePanel(String panelId) {
        PresentationSettings settings = this.getPresentationSettings();
        settings.activePanelId = panelId;
        IResultSetPanel panel = this.activePanels.get(panelId);
        if (panel != null) {
            panel.activatePanel();
            this.updatePanelActions();
            this.savePresentationSettings();
        }
    }

    private void removePanel(String panelId) {
        IResultSetPanel panel = this.activePanels.remove(panelId);
        if (panel != null) {
            panel.deactivatePanel();
        }
        this.getPresentationSettings().enabledPanelIds.remove(panelId);
        if (this.activePanels.isEmpty()) {
            this.showPanels(false, true, true);
        }
        this.updatePanelsButtons();
    }

    private ResultSetPanelDescriptor getPanelDescriptor(String id) {
        for (ResultSetPanelDescriptor panel : this.availablePanels) {
            if (!panel.getId().equals(id)) continue;
            return panel;
        }
        return null;
    }

    private CTabItem getPanelTab(String panelId) {
        if (this.panelFolder != null) {
            CTabItem[] cTabItemArray = this.panelFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tab = cTabItemArray[n2];
                if (CommonUtils.equalObjects((Object)tab.getData(), (Object)panelId)) {
                    return tab;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public boolean isPanelsVisible() {
        return this.viewerSash != null && this.viewerSash.getMaximizedControl() == null;
    }

    public void showPanels(boolean show, boolean showDefaults, boolean saveSettings) {
        if (!this.supportsPanels() || show == this.isPanelsVisible()) {
            return;
        }
        CTabItem activePanelTab = this.panelFolder.getSelection();
        if (!show) {
            this.viewerSash.setMaximizedControl(this.viewerSash.getChildren()[0]);
            if (activePanelTab != null && !activePanelTab.getControl().isDisposed() && UIUtils.hasFocus((Control)activePanelTab.getControl())) {
                this.activePresentation.getControl().setFocus();
            }
        } else {
            DBDAttributeBinding currentAttribute;
            if (showDefaults) {
                this.activateDefaultPanels(this.getPresentationSettings());
            }
            this.viewerSash.setMaximizedControl(null);
            this.updatePanelActions();
            if (showDefaults) {
                this.updatePanelsContent(false);
            }
            this.activePresentation.updateValueView();
            if (activePanelTab != null && !activePanelTab.getControl().isDisposed() && UIUtils.hasFocus((Control)this.activePresentation.getControl())) {
                activePanelTab.getControl().setFocus();
            }
            if ((currentAttribute = this.getActivePresentation().getCurrentAttribute()) != null) {
                this.getActivePresentation().showAttribute(currentAttribute);
            }
        }
        this.getPresentationSettings().panelsVisible = show;
        if (saveSettings) {
            this.savePresentationSettings();
        }
        this.updatePanelsButtons();
    }

    public void togglePanelsFocus() {
        CTabItem activePanelTab;
        boolean panelsActive = UIUtils.hasFocus((Control)this.panelFolder);
        if (panelsActive) {
            this.presentationPanel.setFocus();
        } else if (this.panelFolder != null && (activePanelTab = this.panelFolder.getSelection()) != null && activePanelTab.getControl() != null) {
            activePanelTab.getControl().setFocus();
        }
    }

    public boolean isPanelVisible(String panelId) {
        return this.getPresentationSettings().enabledPanelIds.contains(panelId);
    }

    public void closePanel(String panelId) {
        CTabItem panelTab = this.getPanelTab(panelId);
        if (panelTab != null) {
            panelTab.dispose();
            this.removePanel(panelId);
        }
    }

    public void toggleVerticalLayout() {
        PresentationSettings settings = this.getPresentationSettings();
        settings.verticalLayout = !settings.verticalLayout;
        this.viewerSash.setOrientation(settings.verticalLayout ? 512 : 256);
        this.savePresentationSettings();
    }

    public void togglePanelsMaximize() {
        if (this.viewerSash.getMaximizedControl() == null) {
            this.viewerSash.setMaximizedControl((Control)this.panelFolder);
        } else {
            this.viewerSash.setMaximizedControl(null);
        }
    }

    private List<IContributionItem> fillPanelsMenu() {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (ResultSetPanelDescriptor panel : this.availablePanels) {
            CommandContributionItemParameter params = new CommandContributionItemParameter((IServiceLocator)this.site, panel.getId(), "org.jkiss.dbeaver.core.resultset.grid.togglePanel", 32);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("panelId", panel.getId());
            params.parameters = parameters;
            items.add((IContributionItem)new CommandContributionItem(params));
        }
        items.add((IContributionItem)new Separator());
        items.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.togglePanelMaximize"));
        items.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.activatePreview"));
        return items;
    }

    private void addDefaultPanelActions() {
        this.panelToolBar.add((IAction)new Action(ResultSetMessages.result_set_view_menu_text, WorkbenchImages.getImageDescriptor((String)"IMG_LCL_VIEW_MENU")){

            public void run() {
                ToolBar tb = ResultSetViewer.this.panelToolBar.getControl();
                ToolItem[] toolItemArray = tb.getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem item = toolItemArray[n2];
                    if (item.getData() instanceof ActionContributionItem && ((ActionContributionItem)item.getData()).getAction() == this) {
                        MenuManager panelMenu = new MenuManager();
                        for (IContributionItem menuItem : ResultSetViewer.this.fillPanelsMenu()) {
                            panelMenu.add(menuItem);
                        }
                        Menu swtMenu = panelMenu.createContextMenu((Control)ResultSetViewer.this.panelToolBar.getControl());
                        Rectangle ib = item.getBounds();
                        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
                        swtMenu.setLocation(displayAt);
                        swtMenu.setVisible(true);
                        tb.addDisposeListener(e -> panelMenu.dispose());
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    public boolean isActionsDisabled() {
        return this.actionsDisabled;
    }

    @Override
    public void lockActionsByControl(Control lockedBy) {
        if (this.checkDoubleLock(lockedBy)) {
            return;
        }
        this.actionsDisabled = true;
        lockedBy.addDisposeListener(e -> {
            boolean bl = this.actionsDisabled = false;
        });
    }

    @Override
    public void lockActionsByFocus(final Control lockedBy) {
        lockedBy.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ResultSetViewer.this.checkDoubleLock(lockedBy);
                ResultSetViewer.this.actionsDisabled = true;
            }

            public void focusLost(FocusEvent e) {
                ResultSetViewer.this.actionsDisabled = false;
            }
        });
        lockedBy.addDisposeListener(e -> {
            boolean bl = this.actionsDisabled = false;
        });
    }

    public boolean isPresentationInFocus() {
        Control activeControl = this.getActivePresentation().getControl();
        return !activeControl.isDisposed() && activeControl.isFocusControl();
    }

    private boolean checkDoubleLock(Control lockedBy) {
        if (this.actionsDisabled) {
            log.debug((Object)("Internal error: actions double-lock by [" + lockedBy + "]"));
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (UIUtils.isUIThread()) {
            Object adapted;
            IResultSetPanel visiblePanel;
            if (UIUtils.hasFocus((Control)this.filtersPanel)) {
                T result = this.filtersPanel.getAdapter(adapter);
                if (result != null) {
                    return result;
                }
            } else if (UIUtils.hasFocus((Control)this.panelFolder) && (visiblePanel = this.getVisiblePanel()) instanceof IAdaptable && (adapted = ((IAdaptable)visiblePanel).getAdapter(adapter)) != null) {
                return (T)adapted;
            }
        }
        if (this.activePresentation != null) {
            Object adapted;
            if (adapter.isAssignableFrom(this.activePresentation.getClass())) {
                return adapter.cast(this.activePresentation);
            }
            if (this.activePresentation instanceof IAdaptable && (adapted = ((IAdaptable)this.activePresentation).getAdapter(adapter)) != null) {
                return (T)adapted;
            }
        }
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(this.findReplaceTarget);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IResultSetListener listener) {
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IResultSetListener listener) {
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDirtyFlag() {
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            for (IResultSetListener listener : this.listeners) {
                listener.handleResultSetChange();
            }
        }
    }

    @Override
    public void updateEditControls() {
        this.fireResultSetChange();
        this.updateToolbar();
        if (this.presentationSwitchFolder != null) {
            VerticalButton[] verticalButtonArray = this.presentationSwitchFolder.getItems();
            int n = verticalButtonArray.length;
            int n2 = 0;
            while (n2 < n) {
                VerticalButton pb = verticalButtonArray[n2];
                if (pb.getData() instanceof ResultSetPresentationDescriptor) {
                    pb.setVisible(!this.recordMode || ((ResultSetPresentationDescriptor)((Object)pb.getData())).supportsRecordMode());
                }
                ++n2;
            }
        }
    }

    @Override
    public void updateToolbar() {
        if (this.statusBar != null) {
            this.statusBar.setRedraw(false);
        }
        try {
            for (ToolBarManager tb : this.toolbarList) {
                UIUtils.updateContributionItems((IContributionManager)tb);
            }
            if (this.panelToolBar != null) {
                UIUtils.updateContributionItems((IContributionManager)this.panelToolBar);
            }
            if (this.statusBar != null) {
                this.statusBar.layout(true, true);
            }
        }
        finally {
            if (this.statusBar != null) {
                this.statusBar.setRedraw(true);
            }
        }
    }

    @Override
    public void redrawData(boolean attributesChanged, boolean rowsChanged) {
        if (this.viewerPanel.isDisposed()) {
            return;
        }
        if (rowsChanged) {
            int rowCount = this.model.getRowCount();
            if (this.curRow == null || this.curRow.getVisualNumber() >= rowCount) {
                int[] nArray;
                ResultSetRow resultSetRow = this.curRow = rowCount == 0 ? null : this.model.getRow(rowCount - 1);
                if (this.curRow == null) {
                    nArray = new int[]{};
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = this.curRow.getVisualNumber();
                }
                this.selectedRecords = nArray;
            }
            if (!this.recordMode) {
                this.updateFiltersText();
            }
        }
        this.model.refreshValueHandlersConfiguration();
        this.activePresentation.refreshData(attributesChanged || rowsChanged && this.recordMode, false, true);
    }

    private void createStatusBar() {
        Composite statusComposite = UIUtils.createPlaceholder((Composite)this.viewerPanel, (int)3);
        statusComposite.setLayoutData((Object)new GridData(768));
        this.statusBar = new Composite(statusComposite, 0);
        this.statusBar.setBackgroundMode(2);
        this.statusBar.setLayoutData((Object)new GridData(768));
        CSSUtils.setCSSClass((Widget)this.statusBar, (String)"coloredByConnectionType");
        RowLayout toolbarsLayout = new RowLayout(256);
        toolbarsLayout.marginTop = 0;
        toolbarsLayout.marginBottom = 0;
        toolbarsLayout.center = true;
        toolbarsLayout.wrap = true;
        toolbarsLayout.pack = true;
        this.statusBar.setLayout((Layout)toolbarsLayout);
        ToolBar rsToolbar = new ToolBar(this.statusBar, 8519936);
        this.getAutoRefresh().populateRefreshButton(rsToolbar, ActionUtils.findCommandName((String)"org.eclipse.ui.file.refresh"), String.valueOf(ResultSetMessages.controls_resultset_viewer_action_refresh) + " (" + ActionUtils.findCommandDescription((String)"org.eclipse.ui.file.refresh", (IServiceLocator)this.getSite(), (boolean)true) + ")", (DBPImage)UIIcon.REFRESH, () -> {
            if (!this.isRefreshInProgress()) {
                this.refreshData(null);
            }
        });
        this.getAutoRefresh().enableControls(false);
        ToolBarManager editToolBarManager = new ToolBarManager(8519936);
        editToolBarManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        CommandContributionItem saveItem = ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.applyChanges", (int)4, (String)ResultSetMessages.controls_resultset_edit_save, null, null, (boolean)true, null);
        saveItem.setId("org.jkiss.dbeaver.resultset.save.pulldown");
        editToolBarManager.add((IContributionItem)saveItem);
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.rejectChanges", (String)ResultSetMessages.controls_resultset_edit_cancel, null, null, (boolean)true));
        editToolBarManager.add((IContributionItem)new Separator());
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.edit"));
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.add"));
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.copy"));
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.delete"));
        ToolBar editorToolBar = editToolBarManager.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)editorToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(editToolBarManager);
        ToolBarManager navToolBarManager = new ToolBarManager(8519936);
        navToolBarManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.first"));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.previous"));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.next"));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.last"));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.all"));
        navToolBarManager.add((IContributionItem)new Separator(TOOLBAR_GROUP_NAVIGATION));
        ToolBar navToolBar = navToolBarManager.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)navToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(navToolBarManager);
        ToolBarManager configToolBarManager = new ToolBarManager(8519936);
        configToolBarManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        ToolBar configToolBar = configToolBarManager.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)configToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(configToolBarManager);
        ToolBarManager addToolbBarManagerar = new ToolBarManager(8519936);
        saveItem = ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.export", (int)4, null, null, null, (boolean)true, Map.of("exportWithParameter", Boolean.TRUE.toString()));
        saveItem.setId("org.jkiss.dbeaver.resultset.export.pulldown");
        addToolbBarManagerar.add((IContributionItem)saveItem);
        addToolbBarManagerar.add((IContributionItem)new GroupMarker("presentations"));
        addToolbBarManagerar.add((IContributionItem)new Separator(TOOLBAR_GROUP_ADDITIONS));
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)addToolbBarManagerar, TOOLBAR_CONTRIBUTION_ID);
        }
        ToolBar addToolBar = addToolbBarManagerar.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)addToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(addToolbBarManagerar);
        configToolBarManager = new ToolBarManager(8519936);
        configToolBarManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        configToolBarManager.add((IAction)new ConfigAction());
        configToolBarManager.update(true);
        configToolBar = configToolBarManager.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)configToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(configToolBarManager);
        int fontHeight = UIUtils.getFontHeight((Control)this.statusBar);
        this.resultSetSize = new Text(this.statusBar, 2048);
        this.resultSetSize.setLayoutData((Object)new RowData(5 * fontHeight, -1));
        this.resultSetSize.setBackground(UIStyles.getDefaultTextBackground());
        this.resultSetSize.setToolTipText(DataEditorsMessages.resultset_segment_size);
        this.resultSetSize.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String realValue = String.valueOf(ResultSetViewer.this.getSegmentMaxRows());
                if (!realValue.equals(ResultSetViewer.this.resultSetSize.getText())) {
                    ResultSetViewer.this.resultSetSize.setText(realValue);
                }
            }
        });
        this.resultSetSize.addModifyListener(e -> {
            DBPPreferenceStore store;
            int oldFetchSize;
            DBSDataContainer dataContainer = this.getDataContainer();
            int fetchSize = CommonUtils.toInt((Object)this.resultSetSize.getText());
            if (fetchSize > 0 && fetchSize < 1) {
                fetchSize = 1;
            }
            if (dataContainer != null && dataContainer.getDataSource() != null && (oldFetchSize = (store = dataContainer.getDataSource().getContainer().getPreferenceStore()).getInt("resultset.maxrows")) != fetchSize) {
                store.setValue("resultset.maxrows", fetchSize);
                PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
            }
        });
        UIUtils.addDefaultEditActionsSupport((IServiceLocator)this.site, (Control)this.resultSetSize);
        this.rowCountLabel = new ActiveStatusMessage(this.statusBar, DBeaverIcons.getImage((DBPImage)UIIcon.COMPILE), ResultSetMessages.controls_resultset_viewer_calculate_row_count, this){

            @Override
            protected boolean isActionEnabled() {
                return ResultSetViewer.this.hasData();
            }

            @Override
            protected ILoadService<String> createLoadService() {
                return new DatabaseLoadService<String>("Load row count", ResultSetViewer.this.getExecutionContext()){

                    public String evaluate(DBRProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            long rowCount = ResultSetViewer.this.readRowCount(monitor);
                            return ROW_COUNT_FORMAT.format(rowCount);
                        }
                        catch (DBException e) {
                            log.error((Object)e);
                            throw new InvocationTargetException(e);
                        }
                    }
                };
            }
        };
        CSSUtils.setCSSClass((Widget)this.rowCountLabel, (String)"coloredByConnectionType");
        this.rowCountLabel.setMessage("Row Count");
        this.rowCountLabel.setToolTipText("Calculates total row count in the current dataset");
        UIUtils.createToolBarSeparator((Composite)this.statusBar, (int)512);
        this.selectionStatLabel = new Text(this.statusBar, 8);
        this.selectionStatLabel.setToolTipText(ResultSetMessages.result_set_viewer_selection_stat_tooltip);
        CSSUtils.setCSSClass((Widget)this.selectionStatLabel, (String)"coloredByConnectionType");
        this.selectionStatLabel.setText(" ");
        this.statusLabel = new StatusLabel(this.statusBar, 0, this);
        RowData rd = new RowData();
        rd.width = 50 * fontHeight;
        this.statusLabel.setLayoutData(rd);
        CSSUtils.setCSSClass((Widget)this.statusLabel, (String)"coloredByConnectionType");
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.getDataContainer() == null ? null : this.getDataContainer().getDataSource();
    }

    @Override
    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.curState != null ? this.curState.dataContainer : this.container.getDataContainer();
    }

    public void setDataContainer(DBSDataContainer targetEntity, DBDDataFilter newFilter) {
        if (this.curState == null) {
            this.setNewState(targetEntity, this.model.getDataFilter());
        }
        this.runDataPump(targetEntity, newFilter, 0, this.getSegmentMaxRows(), -1, true, false, false, null);
    }

    @Override
    public boolean isRecordMode() {
        return this.recordMode;
    }

    @Override
    public int[] getSelectedRecords() {
        return this.selectedRecords;
    }

    @Override
    public void setSelectedRecords(int[] indexes) {
        this.selectedRecords = indexes;
    }

    @Override
    public boolean isAllAttributesReadOnly() {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null && (executionContext.getDataSource().getContainer().isConnectionReadOnly() || executionContext.getDataSource().getInfo().isReadOnlyData())) {
            return true;
        }
        if (this.model.getAttributes().length == 0) {
            return false;
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = this.model.getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            if (!DBExecUtils.isAttributeReadOnly((DBDAttributeBinding)attr)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void toggleMode() {
        this.changeMode(!this.recordMode);
        if (this.recordModeButton != null) {
            this.recordModeButton.redraw();
        }
        this.updateEditControls();
    }

    private void changeMode(boolean recordMode) {
        List<ResultSetRow> selectedRows = this.getSelection().getSelectedRows();
        if (selectedRows.isEmpty() && this.model.getRowCount() > 0) {
            selectedRows = Collections.singletonList(this.model.getRow(0));
        }
        this.selectedRecords = new int[selectedRows.size()];
        int i = 0;
        while (i < selectedRows.size()) {
            this.selectedRecords[i] = selectedRows.get(i).getVisualNumber();
            ++i;
        }
        this.curRow = this.selectedRecords.length > 0 && this.selectedRecords[0] < this.model.getRowCount() ? this.model.getRow(this.selectedRecords[0]) : null;
        this.recordMode = recordMode;
        this.activePresentation.refreshData(true, false, false);
        this.activePresentation.changeMode(recordMode);
        this.updateStatusMessage();
    }

    private void dispose() {
        DBPProject project;
        if (this.themeChangeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeChangeListener);
            this.themeChangeListener = null;
        }
        DBWorkbench.getPlatform().getDataSourceProviderRegistry().getGlobalDataSourcePreferenceStore().removePropertyChangeListener(this.dataPropertyListener);
        DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener(this.dataPropertyListener);
        if (this.activePresentation != null) {
            this.activePresentation.dispose();
        }
        if ((project = this.container.getProject()) != null) {
            project.getDataSourceRegistry().removeDataSourceListener((DBPEventListener)this);
        }
        this.savePresentationSettings();
        this.clearData(true);
        for (ToolBarManager tb : this.toolbarList) {
            try {
                tb.dispose();
            }
            catch (Throwable e) {
                log.debug((Object)("Error disposing toolbar " + tb), e);
            }
        }
        this.toolbarList.clear();
        this.autoRefreshControl.enableAutoRefresh(false);
    }

    @Override
    public String getAttributeReadOnlyStatus(DBDAttributeBinding attr) {
        boolean newRow;
        String dataStatus = this.getReadOnlyStatus();
        if (dataStatus != null) {
            return dataStatus;
        }
        boolean bl = newRow = this.curRow != null && this.curRow.getState() == 2;
        if (!newRow) {
            return DBExecUtils.getAttributeReadOnlyStatus((DBDAttributeBinding)attr);
        }
        return null;
    }

    private Object savePresentationState() {
        Object[] state = new Object[1];
        if (this.activePresentation instanceof IStatefulControl) {
            UIUtils.syncExec(() -> {
                Object object = ((IStatefulControl)((Object)this.activePresentation)).saveState();
            });
        }
        return state[0];
    }

    private boolean restorePresentationState(Object state) {
        if (this.activePresentation instanceof IStatefulControl) {
            UIUtils.syncExec(() -> ((IStatefulControl)((Object)this.activePresentation)).restoreState(state));
            return true;
        }
        return false;
    }

    List<HistoryStateItem> getStateHistory() {
        return this.stateHistory;
    }

    private void setNewState(DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter) {
        dataFilter = new DBDDataFilter(dataFilter == null ? this.model.getDataFilter() : dataFilter);
        int i = 0;
        while (i < this.stateHistory.size()) {
            HistoryStateItem item = this.stateHistory.get(i);
            if (item.dataContainer == dataContainer && item.filter != null && item.filter.equalFilters(dataFilter, false)) {
                item.filter = dataFilter;
                this.curState = item;
                this.historyPosition = i;
                return;
            }
            ++i;
        }
        while (this.historyPosition < this.stateHistory.size() - 1) {
            this.stateHistory.remove(this.stateHistory.size() - 1);
        }
        this.curState = new HistoryStateItem(dataContainer, dataFilter, this.curRow == null ? -1 : this.curRow.getVisualNumber());
        this.stateHistory.add(this.curState);
        this.historyPosition = this.stateHistory.size() - 1;
    }

    public void resetHistory() {
        this.curState = null;
        this.stateHistory.clear();
        this.historyPosition = -1;
    }

    @Override
    @Nullable
    public ResultSetRow getCurrentRow() {
        return this.curRow;
    }

    @Override
    public void setCurrentRow(@Nullable ResultSetRow newRow) {
        int rowShift = 0;
        if (this.curRow != null && newRow != null) {
            rowShift = newRow.getVisualNumber() - this.curRow.getVisualNumber();
        }
        this.curRow = newRow;
        if (this.curState != null && newRow != null) {
            this.curState.rowNumber = newRow.getVisualNumber();
        }
        if (this.recordMode && rowShift != 0 && this.selectedRecords.length > 0) {
            if (!ArrayUtils.contains((int[])this.selectedRecords, (int)this.curRow.getVisualNumber())) {
                int firstSelRecord = this.selectedRecords[0];
                if ((firstSelRecord += rowShift) < 0) {
                    firstSelRecord = 0;
                }
                if (firstSelRecord > this.model.getRowCount() - this.selectedRecords.length) {
                    firstSelRecord = this.model.getRowCount() - this.selectedRecords.length;
                }
                int i = 0;
                while (i < this.selectedRecords.length) {
                    this.selectedRecords[i] = firstSelRecord + i;
                    ++i;
                }
            }
        } else {
            this.selectedRecords = new int[0];
        }
    }

    public void setStatus(String status) {
        this.setStatus(status, DBPMessageType.INFORMATION);
    }

    @Override
    public void setStatus(String status, DBPMessageType messageType) {
        if (this.statusLabel == null || this.statusLabel.isDisposed()) {
            return;
        }
        if (this.statusLabel.getMessageType() == messageType && CommonUtils.equalObjects((Object)this.statusLabel.getMessage(), (Object)status)) {
            return;
        }
        this.statusLabel.setStatus(status, messageType);
        ((RowData)this.statusLabel.getLayoutData()).width = this.statusLabel.computeSize((int)-1, (int)-1).x;
        this.rowCountLabel.updateActionState();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null && dataContainer.getDataSource() != null) {
            this.resultSetSize.setText(String.valueOf(this.getSegmentMaxRows()));
        }
    }

    private void setStatusTooltip(String message) {
        if (this.statusLabel == null || this.statusLabel.isDisposed()) {
            return;
        }
        this.statusLabel.setStatusTooltip(message);
    }

    @Override
    public void updateStatusMessage() {
        this.updateStatusInfo(false);
        this.updateStatusInfo(true);
        if (this.rowCountLabel != null && !this.rowCountLabel.isDisposed()) {
            String rcMessage = !this.hasData() ? "No Data" : (!this.isHasMoreData() ? ROW_COUNT_FORMAT.format(this.model.getRowCount()) : (this.model.getTotalRowCount() == null ? String.valueOf(ROW_COUNT_FORMAT.format(this.model.getRowCount())) + "+" : ROW_COUNT_FORMAT.format(this.model.getTotalRowCount())));
            if (!CommonUtils.equalObjects((Object)this.rowCountLabel.getMessage(), (Object)rcMessage)) {
                this.rowCountLabel.setMessage(rcMessage);
                this.rowCountLabel.updateActionState();
                this.statusBar.layout(true, true);
            }
        }
    }

    private void updateStatusInfo(boolean isTooltip) {
        DBPDataSource dataSource;
        DBSDataContainer dataContainer;
        boolean hasWarnings;
        String statusMessage;
        if (this.model.getRowCount() == 0) {
            statusMessage = this.model.getVisibleAttributeCount() == 0 ? String.valueOf(ResultSetMessages.controls_resultset_viewer_status_empty) + this.getExecutionTimeMessage(isTooltip) : String.valueOf(ResultSetMessages.controls_resultset_viewer_status_no_data) + this.getExecutionTimeMessage(isTooltip);
        } else if (this.recordMode) {
            statusMessage = String.valueOf(ResultSetMessages.controls_resultset_viewer_status_row) + (this.curRow == null ? 0 : this.curRow.getVisualNumber() + 1) + "/" + this.model.getRowCount() + (this.curRow == null ? this.getExecutionTimeMessage(isTooltip) : "");
        } else {
            long rowsFetched;
            long rowsUpdated = -1L;
            DBCStatistics stats = this.getModel().getStatistics();
            if (stats == null || stats.isEmpty()) {
                rowsFetched = this.getModel().getRowCount();
            } else {
                rowsFetched = stats.getRowsFetched();
                rowsUpdated = stats.getRowsUpdated();
            }
            statusMessage = rowsFetched < 0L && rowsUpdated >= 0L ? NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_updated, (Object)ResultSetUtils.formatRowCount(rowsUpdated), (Object)this.getExecutionTimeMessage(isTooltip)) : NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_fetched, (Object)ResultSetUtils.formatRowCount(rowsFetched), (Object)this.getExecutionTimeMessage(isTooltip));
        }
        boolean bl = hasWarnings = !this.dataReceiver.getErrorList().isEmpty();
        if (hasWarnings) {
            statusMessage = String.valueOf(statusMessage) + " - " + this.dataReceiver.getErrorList().size() + " warning(s)";
        } else if (this.model.getStatistics() != null) {
            boolean bl2 = hasWarnings = this.model.getStatistics().getError() != null;
            if (hasWarnings) {
                statusMessage = String.valueOf(statusMessage) + " - finished with error";
            }
        }
        if (this.getPreferenceStore().getBoolean("resultset.show.connectionName") && (dataContainer = this.getDataContainer()) != null && (dataSource = dataContainer.getDataSource()) != null) {
            statusMessage = String.valueOf(statusMessage) + " [" + dataSource.getContainer().getName() + "]";
        }
        if (isTooltip) {
            this.setStatusTooltip(statusMessage);
        } else {
            this.setStatus(statusMessage, hasWarnings ? DBPMessageType.WARNING : DBPMessageType.INFORMATION);
        }
    }

    private String getExecutionTimeMessage(boolean extended) {
        DBCStatistics statistics = this.model.getStatistics();
        if (statistics == null || statistics.isEmpty()) {
            return "";
        }
        long fetchTime = statistics.getFetchTime();
        long totalTime = statistics.getTotalTime();
        Object endTime = extended ? LocalDateTime.ofInstant(Instant.ofEpochMilli(statistics.getEndTime()), TimeZone.getDefault().toZoneId()).format(EXECUTION_TIME_FORMATTER) : LocalDateTime.ofInstant(Instant.ofEpochMilli(statistics.getEndTime()), TimeZone.getDefault().toZoneId()).truncatedTo(ChronoUnit.SECONDS);
        if (fetchTime <= 0L) {
            if (endTime instanceof LocalDateTime) {
                return NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_time, (Object[])new Object[]{RuntimeUtils.formatExecutionTime((long)totalTime), DateTimeFormatter.ISO_DATE.format((LocalDateTime)endTime), DateTimeFormatter.ISO_TIME.format((LocalDateTime)endTime)});
            }
            return NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_time_long, (Object[])new Object[]{RuntimeUtils.formatExecutionTime((long)totalTime), endTime});
        }
        if (endTime instanceof LocalDateTime) {
            return NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_time_fetch, (Object[])new Object[]{RuntimeUtils.formatExecutionTime((long)totalTime), RuntimeUtils.formatExecutionTime((long)fetchTime), DateTimeFormatter.ISO_DATE.format((LocalDateTime)endTime), DateTimeFormatter.ISO_TIME.format((LocalDateTime)endTime)});
        }
        return NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_time_fetch_long, (Object[])new Object[]{RuntimeUtils.formatExecutionTime((long)totalTime), RuntimeUtils.formatExecutionTime((long)fetchTime), endTime});
    }

    @Override
    public void toggleSortOrder(@NotNull DBDAttributeBinding columnElement, @Nullable IResultSetController.ColumnOrder forceOrder) {
        boolean serverSideOrdering;
        DBDDataFilter dataFilter = this.getModel().getDataFilter();
        DBDAttributeConstraint constraint = dataFilter.getConstraint(columnElement);
        assert (constraint != null);
        ResultSetUtils.OrderingMode orderingMode = ResultSetUtils.getOrderingMode(this);
        if (CommonUtils.isNotEmpty((String)this.model.getDataFilter().getOrder())) {
            orderingMode = ResultSetUtils.OrderingMode.SERVER_SIDE;
        }
        if (constraint.getOrderPosition() == 0 && forceOrder != IResultSetController.ColumnOrder.NONE) {
            if (orderingMode == ResultSetUtils.OrderingMode.SERVER_SIDE && this.supportsDataFilter() && ConfirmationDialog.showConfirmDialogNoToggle((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)this.viewerPanel.getShell(), (String)"order_resultset", (int)3, (int)4, (Object[])new Object[]{columnElement.getName()}) != 2) {
                return;
            }
            constraint.setOrderPosition(dataFilter.getMaxOrderingPosition() + 1);
            constraint.setOrderDescending(forceOrder == IResultSetController.ColumnOrder.DESC);
        } else if (!constraint.isOrderDescending() && forceOrder != IResultSetController.ColumnOrder.NONE) {
            constraint.setOrderDescending(true);
        } else {
            for (DBDAttributeConstraint con2 : dataFilter.getConstraints()) {
                if (con2.getOrderPosition() <= constraint.getOrderPosition()) continue;
                con2.setOrderPosition(con2.getOrderPosition() - 1);
            }
            constraint.setOrderPosition(0);
            constraint.setOrderDescending(false);
        }
        dataFilter.setOrder(null);
        if (!this.checkForChanges()) {
            return;
        }
        switch (orderingMode) {
            case CLIENT_SIDE: {
                serverSideOrdering = false;
                break;
            }
            case SERVER_SIDE: {
                serverSideOrdering = true;
                break;
            }
            default: {
                serverSideOrdering = this.isHasMoreData();
            }
        }
        if (serverSideOrdering && this.getDataSource() != null && !this.getDataSource().getInfo().supportsResultSetOrdering()) {
            ConfirmationDialog.confirmAction((Shell)this.getControl().getShell(), (String)CONFIRM_SERVER_SIDE_ORDERING_UNAVAILABLE, (int)4, (Object[])new Object[0]);
            serverSideOrdering = false;
        }
        if (serverSideOrdering) {
            this.refreshData(null);
        } else {
            this.reorderLocally();
        }
    }

    private void reorderLocally() {
        this.rejectChanges();
        this.getModel().resetOrdering();
        this.getActivePresentation().refreshData(false, false, true);
        this.updateFiltersText();
    }

    void setMetaData(@NotNull DBCResultSet resultSet, @NotNull DBDAttributeBinding[] attributes) {
        this.model.setMetaData(resultSet, attributes);
        this.activePresentation.clearMetaData();
    }

    void setData(List<Object[]> rows, int focusRow) {
        Boolean autoRecordMode;
        if (this.viewerPanel.isDisposed()) {
            return;
        }
        this.curRow = null;
        this.model.setData(rows);
        ResultSetRow resultSetRow = this.curRow = this.model.getRowCount() > 0 ? this.model.getRow(0) : null;
        if (focusRow > 0 && focusRow < this.model.getRowCount()) {
            this.curRow = this.model.getRow(focusRow);
        }
        if (this.selectedRecords.length > 1) {
            this.selectedRecords = Arrays.stream(this.selectedRecords).filter(value -> value < rows.size()).toArray();
            if (this.selectedRecords.length == 0) {
                int[] nArray;
                if (this.curRow == null) {
                    nArray = new int[]{};
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = this.curRow.getVisualNumber();
                }
                this.selectedRecords = nArray;
            }
        } else {
            int[] nArray;
            if (this.curRow == null) {
                nArray = new int[]{};
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = this.curRow.getVisualNumber();
            }
            this.selectedRecords = nArray;
        }
        if ((autoRecordMode = this.getDecorator().getAutoRecordMode()) != null || this.model.isMetadataChanged() && this.getPreferenceStore().getBoolean("resultset.behavior.autoSwitchMode")) {
            boolean newRecordMode;
            if (autoRecordMode != null) {
                newRecordMode = rows.size() <= 1 ? autoRecordMode : false;
            } else {
                boolean bl = newRecordMode = rows.size() <= 1;
            }
            if (newRecordMode != this.recordMode) {
                UIUtils.asyncExec(this::toggleMode);
            }
        }
    }

    void appendData(List<Object[]> rows, boolean resetOldRows) {
        this.model.appendData(rows, resetOldRows);
        UIUtils.asyncExec(() -> {
            String message = String.valueOf(NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_size, (Object)this.model.getRowCount(), (Object)rows.size())) + this.getExecutionTimeMessage(false);
            String tooltip = String.valueOf(NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_size, (Object)this.model.getRowCount(), (Object)rows.size())) + this.getExecutionTimeMessage(true);
            this.setStatus(message, DBPMessageType.INFORMATION);
            this.setStatusTooltip(tooltip);
            this.updateEditControls();
        });
    }

    public int promptToSaveOnClose() {
        if (!this.isDirty()) {
            return 0;
        }
        int result = ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)this.viewerPanel.getShell(), (String)"close_resultset_edit", (int)6, (Object[])new Object[0]);
        if (result == 2) {
            return 0;
        }
        if (result == 3) {
            this.rejectChanges();
            return 1;
        }
        return 2;
    }

    public void doSave(IProgressMonitor monitor) {
        this.doSave(RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
    }

    public void doSave(DBRProgressMonitor monitor) {
        this.applyChanges(monitor, new ResultSetSaveSettings());
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.model.isDirty() || this.activePresentation != null && this.activePresentation.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    @Override
    public boolean hasData() {
        return this.model.hasData();
    }

    @Override
    public boolean isHasMoreData() {
        return this.getExecutionContext() != null && this.dataReceiver.isHasMoreData();
    }

    @Override
    public boolean isReadOnly() {
        if (this.model.isUpdateInProgress() || !(this.activePresentation instanceof IResultSetEditor) || (this.decorator.getDecoratorFeatures() & 8L) == 0L) {
            return true;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        return executionContext == null || !executionContext.isConnected() || !executionContext.getDataSource().getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_DATA) || executionContext.getDataSource().getInfo().isReadOnlyData();
    }

    @Override
    public String getReadOnlyStatus() {
        if (this.model.isUpdateInProgress()) {
            return "Update in progress";
        }
        if (!(this.activePresentation instanceof IResultSetEditor) || (this.decorator.getDecoratorFeatures() & 8L) == 0L) {
            return "Active presentation doesn't support data edit";
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null || !executionContext.isConnected()) {
            return "No connection to database";
        }
        if (!executionContext.getDataSource().getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_DATA)) {
            return "Data edit restricted";
        }
        if (executionContext.getDataSource().getInfo().isReadOnlyData()) {
            return "Read-only data container";
        }
        if (executionContext.getDataSource().getContainer().isConnectionReadOnly()) {
            return "Connection is in read-only state";
        }
        return null;
    }

    public boolean isInsertable() {
        return this.getReadOnlyStatus() == null && this.model.getSingleSource() instanceof DBSDataManipulator && this.model.getVisibleAttributeCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRefreshInProgress() {
        List<ResultSetJobAbstract> list = this.dataPumpJobQueue;
        synchronized (list) {
            return this.dataPumpRunning.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobs() {
        ArrayList<ResultSetJobAbstract> dpjCopy;
        List<ResultSetJobAbstract> list = this.dataPumpJobQueue;
        synchronized (list) {
            dpjCopy = new ArrayList<ResultSetJobAbstract>(this.dataPumpJobQueue);
            this.dataPumpJobQueue.clear();
        }
        for (ResultSetJobAbstract dpj : dpjCopy) {
            if (!dpj.isActiveTask()) continue;
            dpj.cancel();
        }
        DataSourceJob updateJob = this.model.getUpdateJob();
        if (updateJob != null) {
            updateJob.cancel();
        }
    }

    @NotNull
    IResultSetFilterManager getFilterManager() {
        return this.filterManager;
    }

    public void showFiltersMenu() {
        DBDAttributeBinding curAttribute = this.getActivePresentation().getCurrentAttribute();
        if (curAttribute == null) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        this.fillFiltersMenu((IMenuManager)menuManager, curAttribute, this.getCurrentRow());
        this.showContextMenuAtCursor(menuManager);
        this.viewerPanel.addDisposeListener(e -> menuManager.dispose());
    }

    @Override
    public void showDistinctFilter(DBDAttributeBinding curAttribute) {
        this.showFiltersDistinctMenu(curAttribute, false);
    }

    public void showFiltersDistinctMenu(DBDAttributeBinding curAttribute, boolean atKeyboardCursor) {
        boolean isExpensiveFilter = true;
        DBSEntityReferrer descReferrer = ResultSetUtils.getEnumerableConstraint(curAttribute);
        if (descReferrer instanceof DBSEntityAssociation) {
            isExpensiveFilter = false;
        }
        if (isExpensiveFilter && ConfirmationDialog.showConfirmDialogNoToggle((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)this.viewerPanel.getShell(), (String)"filter_resultset", (int)3, (int)4, (Object[])new Object[]{curAttribute.getName()}) != 2) {
            return;
        }
        List<ResultSetRow> selectedRows = this.getSelection().getSelectedRows();
        ResultSetRow[] rows = selectedRows.toArray(new ResultSetRow[0]);
        FilterValueEditPopup popup = new FilterValueEditPopup(this.getSite().getShell(), this, curAttribute, rows);
        Point location = atKeyboardCursor ? this.getKeyboardCursorLocation() : this.getSite().getWorkbenchWindow().getWorkbench().getDisplay().getCursorLocation();
        if (location != null) {
            popup.setLocation(location);
        }
        popup.setModeless(true);
        if (popup.open() == 0) {
            Object value = popup.getValue();
            DBDDataFilter filter = new DBDDataFilter(this.model.getDataFilter());
            DBDAttributeConstraint constraint = filter.getConstraint(curAttribute);
            Object[] supportedOperators = curAttribute.getValueHandler().getSupportedOperators((DBSTypedObject)curAttribute);
            if (constraint != null) {
                if (!ArrayUtils.isEmpty((Object[])((Object[])value))) {
                    if (this.getDataSource() != null && !ArrayUtils.contains((Object[])supportedOperators, (Object)DBCLogicalOperator.IN)) {
                        constraint.setOperator(DBCLogicalOperator.EQUALS);
                    } else {
                        constraint.setOperator(DBCLogicalOperator.IN);
                    }
                    constraint.setValue(value);
                } else {
                    constraint.setOperator(null);
                    constraint.setValue(null);
                }
                this.setDataFilter(filter, true);
            }
        }
    }

    public void showReferencesMenu(boolean openInNewWindow) {
        MenuManager[] menuManager = new MenuManager[1];
        try {
            UIUtils.runInProgressService(monitor -> {
                MenuManager menuManager = this.createRefTablesMenu(monitor, openInNewWindow);
            });
        }
        catch (InvocationTargetException e2) {
            log.error((Object)e2.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        if (menuManager[0] != null) {
            this.showContextMenuAtCursor(menuManager[0]);
            this.viewerPanel.addDisposeListener(e -> menuManager[0].dispose());
        }
    }

    private void showContextMenuAtCursor(MenuManager menuManager) {
        Point location = this.getKeyboardCursorLocation();
        if (location != null) {
            Menu contextMenu = menuManager.createContextMenu(this.getActivePresentation().getControl());
            contextMenu.setLocation(location);
            contextMenu.setVisible(true);
        }
    }

    @Nullable
    private Point getKeyboardCursorLocation() {
        Control control = this.getActivePresentation().getControl();
        Point cursorLocation = this.getActivePresentation().getCursorLocation();
        if (cursorLocation == null) {
            return null;
        }
        return control.getDisplay().map(control, null, cursorLocation);
    }

    @Override
    public void fillContextMenu(@NotNull IMenuManager manager, @Nullable DBDAttributeBinding attr, @Nullable ResultSetRow row, int[] rowIndexes) {
        MenuManager viewMenu;
        ResultSetValueController valueController = attr != null && row != null ? new ResultSetValueController(this, new ResultSetCellLocation(attr, row, rowIndexes), IValueController.EditType.NONE, null) : null;
        long decoratorFeatures = this.getDecorator().getDecoratorFeatures();
        if (attr == null && row != null) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyRowNames"));
        } else if (attr != null && row == null) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyColumnNames", (int)8, null, null, null, (boolean)false, Collections.singletonMap("columns", attr.getName())));
        } else {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.copy"));
        }
        if (row != null) {
            MenuManager extCopyMenu = new MenuManager(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.edit.copy.special"));
            extCopyMenu.setRemoveAllWhenShown(true);
            extCopyMenu.addMenuListener(manager1 -> ResultSetHandlerCopyAs.fillCopyAsMenu(this, (IContributionManager)manager1));
            manager.add((IContributionItem)extCopyMenu);
        }
        if (row != null) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.paste"));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.edit.paste.special"));
        }
        manager.add((IContributionItem)new Separator());
        if ((decoratorFeatures & 1L) != 0L) {
            MenuManager filtersMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_filter, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILTER), "filters");
            filtersMenu.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.filterMenu");
            filtersMenu.setRemoveAllWhenShown(true);
            filtersMenu.addMenuListener(manager1 -> this.fillFiltersMenu(manager1, attr, row));
            manager.add((IContributionItem)filtersMenu);
        }
        MenuManager orderMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_order, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SORT), "orderings");
        orderMenu.setRemoveAllWhenShown(true);
        orderMenu.addMenuListener(manager1 -> this.fillOrderingsMenu(manager1, attr, row));
        manager.add((IContributionItem)orderMenu);
        MenuManager navigateMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_navigate, null, "navigate");
        this.fillNavigateMenu((IMenuManager)navigateMenu);
        manager.add((IContributionItem)navigateMenu);
        MenuManager editMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_edit, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_EDIT), "edit");
        if (row != null) {
            this.fillEditMenu((IMenuManager)editMenu, attr, row, valueController);
        }
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.add"));
        editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.copy"));
        editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.delete"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.copy.from.above"));
        editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.copy.from.below"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)editMenu);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("edit"));
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource != null && attr != null && this.model.getVisibleAttributeCount() > 0 && !this.model.isUpdateInProgress()) {
            viewMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_view_format, null, "view");
            viewMenu.setRemoveAllWhenShown(true);
            viewMenu.addMenuListener(manager1 -> this.fillColumnViewMenu(manager1, attr, row, valueController));
            manager.add((IContributionItem)viewMenu);
        }
        if (dataSource != null && !dataSource.getContainer().getNavigatorSettings().isHideVirtualModel()) {
            viewMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_logical_structure, null, "virtual_model");
            viewMenu.setRemoveAllWhenShown(true);
            viewMenu.addMenuListener(manager1 -> this.fillVirtualModelMenu(manager1, attr, row, valueController));
            manager.add((IContributionItem)viewMenu);
        }
        if ((decoratorFeatures & 4L) != 0L || (decoratorFeatures & 0x10L) != 0L) {
            MenuManager layoutMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_layout, null, "layout");
            this.fillLayoutMenu((IMenuManager)layoutMenu);
            manager.add((IContributionItem)layoutMenu);
        }
        manager.add((IContributionItem)new Separator());
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.export"));
            MenuManager openWithMenu = new MenuManager(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.resultset.openWith"));
            openWithMenu.setRemoveAllWhenShown(true);
            openWithMenu.addMenuListener(manager1 -> ResultSetHandlerOpenWith.fillOpenWithMenu(this, (IContributionManager)manager1));
            manager.add((IContributionItem)openWithMenu);
            manager.add((IContributionItem)new GroupMarker("tools"));
            manager.add((IContributionItem)new GroupMarker("results_export"));
        }
        manager.add((IContributionItem)new Separator("results_additions"));
        if (dataContainer != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.file.refresh"));
        }
        this.decorator.fillContributions((IContributionManager)manager);
        if (this.activePresentation != null) {
            this.activePresentation.fillMenu(manager);
        }
    }

    private void fillColumnViewMenu(IMenuManager viewMenu, @NotNull DBDAttributeBinding attr, @Nullable ResultSetRow row, ResultSetValueController valueController) {
        List transformers;
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return;
        }
        if (this.activePresentation instanceof IResultSetDisplayFormatProvider) {
            DBDDisplayFormat defaultDisplayFormat = ((IResultSetDisplayFormatProvider)((Object)this.activePresentation)).getDefaultDisplayFormat();
            MenuManager formatsMenu = new MenuManager(DTUIMessages.value_format_selector_value);
            DBDDisplayFormat[] dBDDisplayFormatArray = DBDDisplayFormat.values();
            int n = dBDDisplayFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                String formatName;
                final DBDDisplayFormat displayFormat = dBDDisplayFormatArray[n2];
                switch (displayFormat) {
                    case UI: {
                        formatName = DTUIMessages.value_format_selector_display;
                        break;
                    }
                    case EDIT: {
                        formatName = DTUIMessages.value_format_selector_editable;
                        break;
                    }
                    default: {
                        formatName = DTUIMessages.value_format_selector_database_native;
                    }
                }
                Action action = new Action(formatName, 8){

                    public void run() {
                        ((IResultSetDisplayFormatProvider)((Object)ResultSetViewer.this.activePresentation)).setDefaultDisplayFormat(displayFormat);
                    }
                };
                action.setChecked(displayFormat == defaultDisplayFormat);
                formatsMenu.add((IAction)action);
                ++n2;
            }
            viewMenu.add((IContributionItem)formatsMenu);
            viewMenu.add((IContributionItem)new Separator());
        }
        if (!CommonUtils.isEmpty((Collection)(transformers = DBWorkbench.getPlatform().getValueHandlerRegistry().findTransformers(dataSource, (DBSTypedObject)attr, null)))) {
            MenuManager transformersMenu = new MenuManager(NLS.bind((String)ResultSetMessages.controls_resultset_viewer_action_view_column_type, (Object)attr.getName()));
            transformersMenu.setRemoveAllWhenShown(true);
            transformersMenu.addMenuListener(manager12 -> this.fillAttributeTransformersMenu(manager12, attr));
            viewMenu.add((IContributionItem)transformersMenu);
        }
        if (this.model.isSingleSource()) {
            viewMenu.add((IAction)new TransformerSettingsAction());
        }
        viewMenu.add((IAction)new TransformComplexTypesToggleAction());
        if (attr.getDataKind() == DBPDataKind.BINARY || attr.getDataKind() == DBPDataKind.CONTENT) {
            MenuManager binaryFormatMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_binary_format);
            binaryFormatMenu.setRemoveAllWhenShown(true);
            binaryFormatMenu.addMenuListener(manager12 -> this.fillBinaryFormatMenu(manager12, attr));
            viewMenu.add((IContributionItem)binaryFormatMenu);
        }
        viewMenu.add((IContributionItem)new Separator());
        if (this.model.getDocumentAttribute() == null) {
            if (valueController != null) {
                viewMenu.add((IAction)new SetRowColorAction(this, attr, valueController.getValue()));
                for (DBVColorOverride mapping : this.getColorOverrides(attr, valueController.getValue())) {
                    viewMenu.add((IAction)new ResetRowColorAction(this, mapping, valueController.getValue()));
                }
            }
            viewMenu.add((IAction)new CustomizeColorsAction(this, attr, row));
        }
        viewMenu.add((IAction)new ColorizeDataTypesToggleAction());
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)new DataFormatsPreferencesAction());
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)new ToggleSelectionStatAction("resultset.show.selected.rows", "Show selected row count"));
        viewMenu.add((IAction)new ToggleSelectionStatAction("resultset.show.selected.columns", "Show selected column count"));
        viewMenu.add((IAction)new ToggleSelectionStatAction("resultset.show.selected.cells", "Show selected cell count"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.text.zoomIn"));
        viewMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.text.zoomOut"));
    }

    private void fillVirtualModelMenu(@NotNull IMenuManager vmMenu, @Nullable DBDAttributeBinding attr, @Nullable ResultSetRow row, ResultSetValueController valueController) {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return;
        }
        ArrayList<Action> possibleActions = new ArrayList<Action>();
        possibleActions.add(new VirtualAttributeAddAction(this));
        if (attr != null) {
            possibleActions.add(new VirtualAttributeEditAction(this, attr));
            possibleActions.add(new VirtualAttributeDeleteAction(this, attr));
        }
        if (dataSource.getInfo().supportsReferentialIntegrity()) {
            possibleActions.add(new VirtualForeignKeyEditAction(this));
            possibleActions.add(new VirtualUniqueKeyEditAction(this, true));
            possibleActions.add(new VirtualUniqueKeyEditAction(this, false));
        }
        for (IAction iAction : possibleActions) {
            if (!iAction.isEnabled()) continue;
            vmMenu.add(iAction);
        }
        vmMenu.add((IContributionItem)new Separator());
        vmMenu.add((IAction)new VirtualEntityEditAction(this));
    }

    private void fillEditMenu(IMenuManager editMenu, @Nullable DBDAttributeBinding attr, @NotNull ResultSetRow row, ResultSetValueController valueController) {
        if (valueController != null) {
            Object value = valueController.getValue();
            if (!valueController.isReadOnly()) {
                editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.edit"));
                editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.edit.inline"));
                if (!DBUtils.isNullValue((Object)value) && attr != null && !attr.isRequired()) {
                    editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.cell.setNull"));
                }
                if (valueController.getValueHandler() instanceof DBDValueDefaultGenerator) {
                    String commandName = String.valueOf(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.resultset.cell.setDefault")) + " (" + ((DBDValueDefaultGenerator)valueController.getValueHandler()).getDefaultValueLabel() + ")";
                    DBPImage image = DBValueFormatting.getObjectImage((DBPObject)attr);
                    editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.cell.setDefault", (String)commandName, (DBPImage)image));
                }
            }
            if (row.getState() == 3 || row.changes != null && row.changes.containsKey(attr)) {
                editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.cell.reset"));
            }
            try {
                valueController.getValueManager().contributeActions((IContributionManager)editMenu, valueController, null);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private void fillLayoutMenu(IMenuManager layoutMenu) {
        if (this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsRecordMode()) {
            layoutMenu.add((IAction)new ToggleModeAction());
        }
        if ((this.getDecorator().getDecoratorFeatures() & 4L) != 0L) {
            layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview"));
            layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.activatePreview"));
            layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.toggleLayout"));
        }
        if ((this.getDecorator().getDecoratorFeatures() & 0x10L) != 0L) {
            layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.switchPresentation"));
        }
        if ((this.getDecorator().getDecoratorFeatures() & 4L) != 0L) {
            MenuManager panelsMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_panels, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PANEL_CUSTOMIZE), "result_panels");
            layoutMenu.add((IContributionItem)panelsMenu);
            for (IContributionItem item : this.fillPanelsMenu()) {
                panelsMenu.add(item);
            }
        }
        if ((this.getDecorator().getDecoratorFeatures() & 0x10L) != 0L) {
            layoutMenu.add((IContributionItem)new Separator());
            for (ResultSetPresentationDescriptor pd : this.getAvailablePresentations()) {
                Action psAction = new Action(pd.getLabel(), 2, pd){
                    final ResultSetPresentationDescriptor presentation;
                    {
                        this.presentation = resultSetPresentationDescriptor;
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)this.presentation.getIcon()));
                    }

                    public boolean isChecked() {
                        return ResultSetViewer.this.activePresentationDescriptor == this.presentation;
                    }

                    public void run() {
                        ResultSetViewer.this.switchPresentation(this.presentation);
                    }
                };
                layoutMenu.add((IAction)psAction);
            }
        }
    }

    private void fillNavigateMenu(IMenuManager navigateMenu) {
        MenuManager refTablesMenu;
        boolean hasNavTables = false;
        if (ActionUtils.isCommandEnabled((String)"org.jkiss.dbeaver.core.resultset.navigateLink", (IServiceLocator)this.site)) {
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.navigateLink"));
            hasNavTables = true;
        }
        if (this.model.isSingleSource() && (refTablesMenu = this.createRefTablesMenu(null, false)) != null) {
            navigateMenu.add((IContributionItem)refTablesMenu);
            hasNavTables = true;
        }
        if (hasNavTables) {
            navigateMenu.add((IContributionItem)new Separator());
        }
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.focus.filter"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.text.goto.line"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.first"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.previous"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.next"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.last"));
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.page"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.all"));
        if (this.isHasMoreData() && this.getDataContainer() != null && this.getDataContainer().isFeatureSupported("data.count")) {
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.count"));
        }
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IAction)new ToggleRefreshOnScrollingAction());
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.navigate.backwardHistory", (int)8, (DBPImage)UIIcon.RS_BACK));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.navigate.forwardHistory", (int)8, (DBPImage)UIIcon.RS_FORWARD));
    }

    @Nullable
    private MenuManager createRefTablesMenu(@Nullable DBRProgressMonitor monitor, boolean openInNewWindow) {
        DBSEntity singleSource = this.model.getSingleSource();
        if (singleSource == null) {
            return null;
        }
        String menuName = ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.resultset.referencesMenu");
        MenuManager refTablesMenu = new MenuManager(menuName, null, "ref-tables");
        refTablesMenu.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.referencesMenu");
        refTablesMenu.add((IAction)ResultSetReferenceMenu.NOREFS_ACTION);
        if (monitor != null) {
            ResultSetReferenceMenu.fillRefTablesActions(monitor, this, this.getSelection().getSelectedRows(), singleSource, (IMenuManager)refTablesMenu, openInNewWindow);
        } else {
            refTablesMenu.addMenuListener(manager -> ResultSetReferenceMenu.fillRefTablesActions(null, this, this.getSelection().getSelectedRows(), singleSource, manager, openInNewWindow));
        }
        return refTablesMenu;
    }

    @NotNull
    private List<DBVColorOverride> getColorOverrides(@NotNull DBDAttributeBinding binding, @Nullable Object value) {
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer == null) {
            return Collections.emptyList();
        }
        DBVEntity virtualEntity = DBVUtils.getVirtualEntity((DBSDataContainer)dataContainer, (boolean)false);
        if (virtualEntity == null) {
            return Collections.emptyList();
        }
        return virtualEntity.getColorOverrides().stream().filter(override -> binding.getName().equals(override.getAttributeName())).filter(override -> override.getOperator() == DBCLogicalOperator.EQUALS).filter(override -> override.getOperator().evaluate(value, override.getAttributeValues())).collect(Collectors.toList());
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (event.getObject() instanceof DBVEntity && event.getData() instanceof DBVEntityForeignKey && event.getObject() == this.model.getVirtualEntity(false)) {
            this.refreshData(null);
        }
    }

    private void fillAttributeTransformersMenu(IMenuManager manager, final DBDAttributeBinding attr) {
        List applicableTransformers;
        List customTransformers;
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer == null) {
            return;
        }
        DBPDataSource dataSource = dataContainer.getDataSource();
        DBDRegistry registry = DBWorkbench.getPlatform().getValueHandlerRegistry();
        DBVTransformSettings transformSettings = DBVUtils.getTransformSettings((DBDAttributeBinding)attr, (boolean)false);
        DBDAttributeTransformerDescriptor customTransformer = null;
        if (transformSettings != null && transformSettings.getCustomTransformer() != null) {
            customTransformer = registry.getTransformer(transformSettings.getCustomTransformer());
        }
        if ((customTransformers = registry.findTransformers(dataSource, (DBSTypedObject)attr, Boolean.valueOf(true))) != null && !customTransformers.isEmpty()) {
            manager.add((IAction)new TransformerAction(this, attr, EMPTY_TRANSFORMER_NAME, 8, transformSettings == null || CommonUtils.isEmpty((String)transformSettings.getCustomTransformer())){

                public void run() {
                    if (this.isChecked()) {
                        this.getTransformSettings().setCustomTransformer(null);
                        this.saveTransformerSettings();
                    }
                }
            });
            for (final DBDAttributeTransformerDescriptor descriptor : customTransformers) {
                TransformerAction action = new TransformerAction(this, attr, descriptor.getName(), 8, transformSettings != null && descriptor.getId().equals(transformSettings.getCustomTransformer())){

                    public void run() {
                        try {
                            if (this.isChecked()) {
                                DBVTransformSettings settings = this.getTransformSettings();
                                String oldCustomTransformer = settings.getCustomTransformer();
                                settings.setCustomTransformer(descriptor.getId());
                                TransformerSettingsDialog settingsDialog = new TransformerSettingsDialog(this, attr, false);
                                if (settingsDialog.open() == 0) {
                                    this.saveTransformerSettings();
                                } else {
                                    settings.setCustomTransformer(oldCustomTransformer);
                                }
                            }
                        }
                        catch (Exception e) {
                            DBWorkbench.getPlatformUI().showError("Transform error", "Error transforming column", (Throwable)e);
                        }
                    }
                };
                manager.add((IAction)action);
            }
        }
        if (customTransformer != null && !CommonUtils.isEmpty((Collection)customTransformer.getProperties())) {
            manager.add((IAction)new TransformerAction(this, attr, "Settings ...", 0, false){

                public void run() {
                    TransformerSettingsDialog settingsDialog = new TransformerSettingsDialog(this, attr, false);
                    if (settingsDialog.open() == 0) {
                        this.saveTransformerSettings();
                    }
                }
            });
        }
        if ((applicableTransformers = registry.findTransformers(dataSource, (DBSTypedObject)attr, Boolean.valueOf(false))) != null) {
            manager.add((IContributionItem)new Separator());
            for (final DBDAttributeTransformerDescriptor descriptor : applicableTransformers) {
                boolean checked = transformSettings != null ? (descriptor.isApplicableByDefault() ? !transformSettings.isExcluded(descriptor.getId()) : transformSettings.isIncluded(descriptor.getId())) : descriptor.isApplicableByDefault();
                manager.add((IAction)new TransformerAction(this, attr, descriptor.getName(), 2, checked){

                    public void run() {
                        this.getTransformSettings().enableTransformer(descriptor, !this.isChecked());
                        this.saveTransformerSettings();
                    }
                });
            }
        }
    }

    private void fillBinaryFormatMenu(@NotNull IMenuManager manager, @Nullable DBDAttributeBinding attribute) {
        if (attribute != null) {
            manager.add((IContributionItem)new Separator());
            DBDBinaryFormatter[] dBDBinaryFormatterArray = DBConstants.BINARY_FORMATS;
            int n = DBConstants.BINARY_FORMATS.length;
            int n2 = 0;
            while (n2 < n) {
                DBDBinaryFormatter formatter = dBDBinaryFormatterArray[n2];
                manager.add((IAction)new BinaryFormatAction(formatter, attribute));
                ++n2;
            }
        }
    }

    private void fillFiltersMenu(@NotNull IMenuManager filtersMenu, @Nullable DBDAttributeBinding attribute, @Nullable ResultSetRow row) {
        if (attribute != null && this.supportsDataFilter()) {
            if (row != null) {
                filtersMenu.add((IContributionItem)new Separator());
                DBCLogicalOperator[] operators = attribute.getValueHandler().getSupportedOperators((DBSTypedObject)attribute);
                FilterByAttributeType[] filterByAttributeTypeArray = FilterByAttributeType.values();
                int n = filterByAttributeTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FilterByAttributeType type = filterByAttributeTypeArray[n2];
                    if (type != FilterByAttributeType.NONE) {
                        MenuManager subMenu = null;
                        if (type.getValue(this, attribute, DBCLogicalOperator.EQUALS, true) != null) {
                            DBCLogicalOperator[] dBCLogicalOperatorArray = operators;
                            int n3 = operators.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                DBCLogicalOperator operator = dBCLogicalOperatorArray[n4];
                                if (operator.getArgumentCount() > 0) {
                                    if (subMenu == null) {
                                        subMenu = new MenuManager(type.title, type.icon, type.name());
                                    }
                                    subMenu.add((IAction)new FilterByAttributeAction(this, operator, type, attribute));
                                }
                                ++n4;
                            }
                            if (subMenu != null) {
                                filtersMenu.add(subMenu);
                            }
                        }
                    }
                    ++n2;
                }
                filtersMenu.add((IContributionItem)new Separator());
                filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterMenu.distinct"));
                filterByAttributeTypeArray = operators;
                n = operators.length;
                n2 = 0;
                while (n2 < n) {
                    FilterByAttributeType operator = filterByAttributeTypeArray[n2];
                    if (operator.getArgumentCount() == 0) {
                        filtersMenu.add((IAction)new FilterByAttributeAction(this, (DBCLogicalOperator)operator, FilterByAttributeType.NONE, attribute));
                    }
                    ++n2;
                }
            }
            filtersMenu.add((IContributionItem)new Separator());
            DBDAttributeConstraint constraint = this.model.getDataFilter().getConstraint(attribute);
            if (constraint != null && constraint.hasCondition()) {
                filtersMenu.add((IAction)new FilterResetAttributeAction(this, attribute));
            }
        }
        filtersMenu.add((IContributionItem)new Separator());
        filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterSave"));
        filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterClear"));
        filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterSettings"));
    }

    private void fillOrderingsMenu(@NotNull IMenuManager filtersMenu, @Nullable DBDAttributeBinding attribute, @Nullable ResultSetRow row) {
        if (attribute != null) {
            filtersMenu.add((IContributionItem)new Separator());
            filtersMenu.add((IAction)new OrderByAttributeAction(attribute, IResultSetController.ColumnOrder.ASC));
            filtersMenu.add((IAction)new OrderByAttributeAction(attribute, IResultSetController.ColumnOrder.DESC));
            DBDAttributeConstraint constraint = this.getModel().getDataFilter().getConstraint(attribute);
            if (constraint != null && constraint.getOrderPosition() > 0) {
                filtersMenu.add((IAction)new OrderByAttributeAction(attribute, IResultSetController.ColumnOrder.NONE));
            }
        }
    }

    @Override
    public void navigateAssociation(@NotNull DBRProgressMonitor monitor, @NotNull ResultSetModel bindingsModel, @NotNull DBSEntityAssociation association, @NotNull List<ResultSetRow> rows, boolean newWindow) throws DBException {
        if (!this.confirmProceed()) {
            return;
        }
        if (!newWindow && !this.confirmPanelsReset()) {
            return;
        }
        if (this.getExecutionContext() == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        DBSEntityConstraint refConstraint = association.getReferencedConstraint();
        if (refConstraint == null) {
            throw new DBException("Broken association (referenced constraint missing)");
        }
        if (!(refConstraint instanceof DBSEntityReferrer)) {
            throw new DBException("Referenced constraint [" + refConstraint + "] is not a referrer");
        }
        DBSEntity targetEntity = refConstraint.getParentObject();
        if (!((targetEntity = DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)targetEntity)) instanceof DBSDataContainer)) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] is not a data container");
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        List ownAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)association).getAttributeReferences(monitor));
        List refAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)refConstraint).getAttributeReferences(monitor));
        if (ownAttrs.size() != refAttrs.size()) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] association [" + association.getName() + "] columns differs from referenced constraint [" + refConstraint.getName() + "] (" + ownAttrs.size() + "<>" + refAttrs.size() + ")");
        }
        int i = 0;
        while (i < ownAttrs.size()) {
            DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownAttrs.get(i);
            DBSEntityAttributeRef refAttr = (DBSEntityAttributeRef)refAttrs.get(i);
            DBDAttributeBinding ownBinding = bindingsModel.getAttributeBinding((DBSAttributeBase)ownAttr.getAttribute());
            if (ownBinding == null) {
                DBWorkbench.getPlatformUI().showError("Cannot navigate", "Attribute " + ownAttr.getAttribute() + " is missing in result set");
                return;
            }
            DBSEntityAttribute attribute = refAttr.getAttribute();
            if (attribute != null) {
                DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)attribute, DBDAttributeConstraint.NULL_VISUAL_POSITION);
                constraint.setVisible(true);
                constraints.add(constraint);
                this.createFilterConstraint(rows, ownBinding, constraint);
            }
            ++i;
        }
        if (this.curState == null) {
            this.setNewState((DBSDataContainer)targetEntity, this.model.getDataFilter());
        }
        this.curState.filter = new DBDDataFilter(bindingsModel.getDataFilter());
        this.navigateEntity(monitor, newWindow, targetEntity, constraints);
    }

    @Override
    public void navigateReference(@NotNull DBRProgressMonitor monitor, @NotNull ResultSetModel bindingsModel, @NotNull DBSEntityAssociation association, @NotNull List<ResultSetRow> rows, boolean newWindow) throws DBException {
        if (!this.confirmProceed()) {
            return;
        }
        if (this.getExecutionContext() == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        DBSEntity targetEntity = association.getParentObject();
        if (!((targetEntity = DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)targetEntity)) instanceof DBSDataContainer)) {
            throw new DBException("Referencing entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] is not a data container");
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        DBSEntityConstraint refConstraint = association.getReferencedConstraint();
        if (refConstraint == null) {
            throw new DBException("Can't obtain association '" + DBUtils.getQuotedIdentifier((DBSObject)association) + "' target constraint (table " + (association.getAssociatedEntity() == null ? "???" : DBUtils.getQuotedIdentifier((DBSObject)association.getAssociatedEntity())) + ")");
        }
        List ownAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)association).getAttributeReferences(monitor));
        List refAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)refConstraint).getAttributeReferences(monitor));
        if (ownAttrs.size() != refAttrs.size()) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] association [" + association.getName() + "] columns differ from referenced constraint [" + refConstraint.getName() + "] (" + ownAttrs.size() + "<>" + refAttrs.size() + ")");
        }
        if (ownAttrs.isEmpty()) {
            throw new DBException("Association '" + DBUtils.getQuotedIdentifier((DBSObject)association) + "' has empty column list");
        }
        int i = 0;
        while (i < refAttrs.size()) {
            DBSEntityAttributeRef refAttr = (DBSEntityAttributeRef)refAttrs.get(i);
            DBDAttributeBinding attrBinding = bindingsModel.getAttributeBinding((DBSAttributeBase)refAttr.getAttribute());
            if (attrBinding == null) {
                log.error((Object)("Can't find attribute binding for ref attribute '" + refAttr.getAttribute().getName() + "'"));
            } else {
                DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownAttrs.get(i);
                DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)ownAttr.getAttribute(), DBDAttributeConstraint.NULL_VISUAL_POSITION);
                constraint.setVisible(true);
                constraints.add(constraint);
                this.createFilterConstraint(rows, attrBinding, constraint);
            }
            ++i;
        }
        this.navigateEntity(monitor, newWindow, targetEntity, constraints);
    }

    private void createFilterConstraint(@NotNull List<ResultSetRow> rows, DBDAttributeBinding attrBinding, DBDAttributeConstraint constraint) {
        if (rows.size() == 1) {
            Object keyValue = this.model.getCellValue(new ResultSetCellLocation(attrBinding, rows.get(0)));
            constraint.setOperator(DBCLogicalOperator.EQUALS);
            constraint.setValue(keyValue);
        } else {
            Object[] keyValues = new Object[rows.size()];
            int k = 0;
            while (k < rows.size()) {
                keyValues[k] = this.model.getCellValue(new ResultSetCellLocation(attrBinding, rows.get(k)));
                ++k;
            }
            Object[] supportedOperators = attrBinding.getValueHandler().getSupportedOperators((DBSTypedObject)attrBinding);
            if (ArrayUtils.contains((Object[])supportedOperators, (Object)DBCLogicalOperator.IN)) {
                constraint.setOperator(DBCLogicalOperator.IN);
            } else {
                constraint.setOperator(DBCLogicalOperator.EQUALS);
            }
            constraint.setValue((Object)keyValues);
        }
    }

    private void navigateEntity(@NotNull DBRProgressMonitor monitor, boolean newWindow, DBSEntity targetEntity, List<DBDAttributeConstraint> constraints) {
        DBDDataFilter newFilter = new DBDDataFilter(constraints);
        if (newWindow) {
            this.openResultsInNewWindow(monitor, targetEntity, newFilter);
        } else {
            this.setDataContainer((DBSDataContainer)targetEntity, newFilter);
        }
    }

    private boolean confirmProceed() {
        return new UIConfirmation(){

            public Boolean runTask() {
                return ResultSetViewer.this.checkForChanges();
            }
        }.confirm();
    }

    private boolean confirmPanelsReset() {
        return new UIConfirmation(){

            public Boolean runTask() {
                boolean panelsDirty = false;
                IResultSetPanel[] iResultSetPanelArray = ResultSetViewer.this.getActivePanels();
                int n = iResultSetPanelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResultSetPanel panel = iResultSetPanelArray[n2];
                    if (panel.isDirty()) {
                        panelsDirty = true;
                        break;
                    }
                    ++n2;
                }
                if (panelsDirty) {
                    int result = ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)ResultSetViewer.this.viewerPanel.getShell(), (String)"reset_panels_content", (int)5, (Object[])new Object[0]);
                    if (result != 1) {
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }.confirm();
    }

    private void openResultsInNewWindow(DBRProgressMonitor monitor, DBSEntity targetEntity, DBDDataFilter newFilter) {
        if (targetEntity instanceof DBSDataContainer) {
            this.getContainer().openNewContainer(monitor, (DBSDataContainer)targetEntity, newFilter);
        } else {
            UIUtils.showMessageBox(null, (String)"Open link", (String)("Target entity '" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' - is not a data container"), (int)1);
        }
    }

    @Override
    public int getHistoryPosition() {
        return this.historyPosition;
    }

    @Override
    public int getHistorySize() {
        return this.stateHistory.size();
    }

    @Override
    public void navigateHistory(int position) {
        if (position < 0 || position >= this.stateHistory.size()) {
            log.debug((Object)("Wrong history position: " + position));
            return;
        }
        HistoryStateItem state = this.stateHistory.get(position);
        int segmentSize = this.getSegmentMaxRows();
        if (state.rowNumber >= 0 && state.rowNumber >= segmentSize && segmentSize > 0) {
            segmentSize = (state.rowNumber / segmentSize + 1) * segmentSize;
        }
        this.runDataPump(state.dataContainer, state.filter, 0, segmentSize, state.rowNumber, true, false, false, null);
    }

    @Override
    public void updatePanelsContent(boolean forceRefresh) {
        this.updateEditControls();
        IResultSetPanel visiblePanel = this.getVisiblePanel();
        if (visiblePanel != null) {
            visiblePanel.refresh(forceRefresh);
        }
    }

    @Override
    public void updatePanelActions() {
        ToolBar toolBar = this.panelToolBar.getControl();
        toolBar.setRedraw(false);
        IResultSetPanel visiblePanel = this.getVisiblePanel();
        this.panelToolBar.removeAll();
        if (visiblePanel != null) {
            visiblePanel.contributeActions((IContributionManager)this.panelToolBar);
        }
        this.addDefaultPanelActions();
        this.panelToolBar.update(false);
        if (this.panelFolder != null) {
            Point toolBarSize = toolBar.getParent().computeSize(-1, -1);
            this.panelFolder.setTabHeight(toolBarSize.y);
        }
        toolBar.setRedraw(true);
    }

    @Override
    public Composite getControl() {
        return this.mainPanel;
    }

    public Composite getViewerPanel() {
        return this.viewerPanel;
    }

    @Override
    @NotNull
    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    @Override
    @NotNull
    public ResultSetModel getModel() {
        return this.model;
    }

    public ResultSetModel getInput() {
        return this.model;
    }

    public void setInput(Object input) {
        throw new IllegalArgumentException("ResultSet model can't be changed");
    }

    @Override
    @NotNull
    public IResultSetSelection getSelection() {
        if (this.activePresentation instanceof ISelectionProvider) {
            ISelection selection = ((ISelectionProvider)this.activePresentation).getSelection();
            if (selection.isEmpty()) {
                return new EmptySelection();
            }
            if (selection instanceof IResultSetSelection) {
                return (IResultSetSelection)selection;
            }
            log.debug((Object)("Bad selection type (" + selection + ") in presentation " + this.activePresentation));
        }
        return new EmptySelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.activePresentation instanceof ISelectionProvider) {
            ((ISelectionProvider)this.activePresentation).setSelection(selection);
        }
    }

    @Override
    @NotNull
    public ResultSetDataReceiver getDataReceiver() {
        return this.dataReceiver;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.container.getExecutionContext();
    }

    @Override
    public boolean checkForChanges() {
        if (this.isDirty()) {
            int checkResult = (Integer)new UITask<Integer>(){

                protected Integer runTask() {
                    return ResultSetViewer.this.promptToSaveOnClose();
                }
            }.execute();
            switch (checkResult) {
                case 2: {
                    UIUtils.asyncExec(() -> this.updatePanelsContent(true));
                    return false;
                }
                case 0: {
                    this.saveChanges(null, new ResultSetSaveSettings(), success -> {
                        if (success) {
                            UIUtils.asyncExec(() -> {
                                boolean bl = this.refreshData(null);
                            });
                        }
                    });
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public void refresh() {
        if (!this.checkForChanges()) {
            return;
        }
        this.autoRefreshControl.enableAutoRefresh(false);
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            DBDDataFilter dataFilter = this.restoreDataFilter(dataContainer);
            int segmentSize = this.getSegmentMaxRows();
            Runnable finalizer = () -> {
                if (this.activePresentation.getControl() != null && !this.activePresentation.getControl().isDisposed()) {
                    this.activePresentation.formatData(true);
                }
            };
            this.dataReceiver.setNextSegmentRead(false);
            this.runDataPump(dataContainer, dataFilter, 0, segmentSize, 0, true, false, false, finalizer);
        } else {
            DBWorkbench.getPlatformUI().showError("Error executing query", "Viewer detached from data source");
        }
    }

    private DBDDataFilter restoreDataFilter(DBSDataContainer dataContainer) {
        DataFilterRegistry.SavedDataFilter savedConfig = DataFilterRegistry.getInstance().getSavedConfig(dataContainer);
        if (savedConfig != null) {
            DBDDataFilter dataFilter = new DBDDataFilter();
            DBRRunnableWithProgress restoreTask = monitor -> {
                try {
                    savedConfig.restoreDataFilter(monitor, dataContainer, dataFilter);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            };
            RuntimeUtils.runTask((DBRRunnableWithProgress)restoreTask, (String)"Restore data filter", (long)10000L);
            if (dataFilter.hasFilters()) {
                return dataFilter;
            }
        }
        return null;
    }

    public void refreshWithFilter(DBDDataFilter filter) {
        if (!this.checkForChanges()) {
            return;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            this.dataReceiver.setNextSegmentRead(false);
            this.runDataPump(dataContainer, filter, 0, this.getSegmentMaxRows(), this.curRow == null ? -1 : this.curRow.getRowNumber(), true, false, true, null);
        }
    }

    @Override
    public boolean refreshData(@Nullable Runnable onSuccess) {
        if (!this.verifyQuerySafety() || !this.checkForChanges()) {
            this.autoRefreshControl.scheduleAutoRefresh(false);
            return false;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            int segmentSize = this.getSegmentMaxRows();
            if (this.curRow != null && this.curRow.getVisualNumber() >= segmentSize && segmentSize > 0) {
                segmentSize = (this.curRow.getVisualNumber() / segmentSize + 1) * segmentSize;
            }
            this.dataReceiver.setNextSegmentRead(false);
            return this.runDataPump(dataContainer, null, 0, segmentSize, this.curRow == null ? 0 : this.curRow.getRowNumber(), false, false, true, onSuccess);
        }
        return false;
    }

    public boolean refreshMetaData() {
        DBPDataSource dataSource = this.getDataSource();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataSource == null || dataContainer == null) {
            log.error((Object)"Can't refresh metadata on disconnected data viewer");
            return false;
        }
        DBDAttributeBinding[] curAttributes = this.model.getRealAttributes();
        DBDAttributeBinding[] newAttributes = DBUtils.injectAndFilterAttributeBindings((DBPDataSource)dataSource, (DBSDataContainer)dataContainer, (DBDAttributeBinding[])curAttributes, (boolean)false);
        if (newAttributes.length > curAttributes.length) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)dataContainer, (String)"Bind custom attributes");){
                    int rowCount = this.model.getRowCount();
                    ArrayList<Object[]> rows = new ArrayList<Object[]>(rowCount);
                    int i = 0;
                    while (i < rowCount) {
                        rows.add(this.model.getRowData(i));
                        ++i;
                    }
                    DBDAttributeBinding[] dBDAttributeBindingArray = newAttributes;
                    int n = newAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                        if (attr instanceof DBDAttributeBindingCustom) {
                            attr.lateBinding(session, rows);
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error binding custom attributes", (Throwable)e);
            }
        }
        this.model.updateMetaData(newAttributes);
        this.model.updateDataFilter();
        this.redrawData(true, false);
        this.updatePanelsContent(true);
        return true;
    }

    @Override
    public void readNextSegment() {
        if (!this.verifyQuerySafety()) {
            return;
        }
        if (!this.dataReceiver.isHasMoreData()) {
            return;
        }
        if (this.nextSegmentReadingBlocked) {
            return;
        }
        this.nextSegmentReadingBlocked = true;
        UIUtils.asyncExec(() -> {
            if (this.isRefreshInProgress() || !this.checkForChanges()) {
                this.nextSegmentReadingBlocked = false;
                return;
            }
            DBSDataContainer dataContainer = this.getDataContainer();
            if (dataContainer != null && !this.model.isUpdateInProgress()) {
                this.dataReceiver.setHasMoreData(false);
                this.dataReceiver.setNextSegmentRead(true);
                this.runDataPump(dataContainer, this.model.getDataFilter(), this.model.getRowCount(), this.getSegmentMaxRows(), -1, false, true, true, () -> {
                    boolean bl = this.nextSegmentReadingBlocked = false;
                });
            }
        });
    }

    private boolean verifyQuerySafety() {
        if (this.container.getDataContainer() == null || !this.container.getDataContainer().isFeatureSupported("data.modifying")) {
            return true;
        }
        return UIUtils.confirmAction(null, (String)ResultSetMessages.confirm_modifying_query_title, (String)ResultSetMessages.confirm_modifying_query_message, (DBPImage)DBIcon.STATUS_WARNING);
    }

    @Override
    public void readAllData() {
        if (!this.verifyQuerySafety()) {
            return;
        }
        if (!this.dataReceiver.isHasMoreData()) {
            return;
        }
        if (ConfirmationDialog.showConfirmDialogEx((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)this.viewerPanel.getShell(), (String)"fetch_all_rows", (int)3, (int)4, (Object[])new Object[0]) != 2) {
            return;
        }
        if (!this.checkForChanges()) {
            return;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null && !this.model.isUpdateInProgress()) {
            this.dataReceiver.setHasMoreData(false);
            this.dataReceiver.setNextSegmentRead(true);
            this.runDataPump(dataContainer, this.model.getDataFilter(), this.model.getRowCount(), -1, this.curRow == null ? -1 : this.curRow.getRowNumber(), false, true, true, null);
        }
    }

    public void updateRowCount() {
        this.rowCountLabel.executeAction();
    }

    public void setSelectionStatistics(String stats) {
        if (this.selectionStatLabel == null || this.selectionStatLabel.isDisposed()) {
            return;
        }
        if (stats.equals(this.selectionStatLabel.getText())) {
            return;
        }
        if (CommonUtils.isEmptyTrimmed((String)stats)) {
            this.selectionStatLabel.setText(" ");
        } else {
            this.selectionStatLabel.setText(stats);
        }
        this.statusBar.layout(true, true);
    }

    private long readRowCount(DBRProgressMonitor monitor) throws DBException {
        DBCExecutionContext executionContext = this.getExecutionContext();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (executionContext == null || dataContainer == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        long[] result = new long[1];
        DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)executionContext.getDataSource(), param -> {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.USER, "Read total row count");){
                    long rowCount = dataContainer.countData((DBCExecutionSource)new AbstractExecutionSource(dataContainer, executionContext, (Object)this), session, this.model.getDataFilter(), 0L);
                    this.model.setTotalRowCount(rowCount);
                    lArray[0] = rowCount;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBCException e) {
                throw new InvocationTargetException(e);
            }
        });
        return result[0];
    }

    public int getSegmentMaxRows() {
        if (this.getDataContainer() == null) {
            return 0;
        }
        int size = this.segmentFetchSize != null && this.segmentFetchSize > 0 ? this.segmentFetchSize.intValue() : this.getPreferenceStore().getInt("resultset.maxrows");
        if (size > 0 && size < 1) {
            size = 1;
        }
        return size;
    }

    @NotNull
    public String getActiveQueryText() {
        String queryText;
        DBCStatistics statistics = this.getModel().getStatistics();
        String string = queryText = statistics == null ? null : statistics.getQueryText();
        if (queryText == null || queryText.isEmpty()) {
            DBSDataContainer dataContainer = this.getDataContainer();
            if (dataContainer != null) {
                SQLScriptElement query;
                if (dataContainer instanceof SQLQueryContainer && (query = ((SQLQueryContainer)dataContainer).getQuery()) != null) {
                    return query.getText();
                }
                return dataContainer.getName();
            }
            queryText = DEFAULT_QUERY_TEXT;
        }
        return queryText;
    }

    private boolean runDataPump(@NotNull DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter, int offset, int maxRows, int focusRow, boolean saveHistory, boolean scroll, boolean refresh, @Nullable Runnable finalizer) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null || dataContainer.getDataSource() != executionContext.getDataSource()) {
            executionContext = DBUtils.getDefaultContext((DBSObject)dataContainer, (boolean)false);
        }
        if (executionContext == null) {
            if (finalizer != null) {
                finalizer.run();
            }
            UIUtils.showMessageBox((Shell)this.viewerPanel.getShell(), (String)"Data read", (String)"Can't read data - no active connection", (int)8);
            return false;
        }
        this.autoRefreshControl.cancelRefresh();
        Composite progressControl = this.viewerPanel;
        if (this.activePresentation.getControl() instanceof Composite) {
            progressControl = (Composite)this.activePresentation.getControl();
        }
        ResultSetDataPumpJob dataPumpJob = new ResultSetDataPumpJob(dataContainer, new ResultSetExecutionSource(dataContainer, this, this, dataFilter), executionContext, progressControl, focusRow, saveHistory, scroll, finalizer);
        dataPumpJob.setOffset(offset);
        dataPumpJob.setMaxRows(maxRows);
        dataPumpJob.setRefresh(refresh);
        this.queueDataPump(dataPumpJob);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueDataPump(ResultSetJobAbstract dataPumpJob) {
        List<ResultSetJobAbstract> list = this.dataPumpJobQueue;
        synchronized (list) {
            this.dataPumpJobQueue.clear();
            this.dataPumpJobQueue.add(dataPumpJob);
        }
        new AbstractJob("Initiate data read"){
            {
                this.setUser(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(DBRProgressMonitor monitor) {
                if (ResultSetViewer.this.dataPumpRunning.get()) {
                    this.schedule(50L);
                } else {
                    List<ResultSetJobAbstract> list = ResultSetViewer.this.dataPumpJobQueue;
                    synchronized (list) {
                        if (ResultSetViewer.this.dataPumpRunning.get()) {
                            this.schedule(50L);
                        } else if (!ResultSetViewer.this.dataPumpJobQueue.isEmpty()) {
                            ResultSetJobAbstract curJob = ResultSetViewer.this.dataPumpJobQueue.get(0);
                            ResultSetViewer.this.dataPumpJobQueue.remove((Object)curJob);
                            curJob.schedule();
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDataPump(ResultSetJobAbstract dataPumpJob) {
        List<ResultSetJobAbstract> list = this.dataPumpJobQueue;
        synchronized (list) {
            this.dataPumpJobQueue.remove((Object)dataPumpJob);
            if (!this.dataPumpRunning.get()) {
                log.debug((Object)"Internal error: data read status is empty");
            }
            this.dataPumpRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseDataReadLock() {
        List<ResultSetJobAbstract> list = this.dataPumpJobQueue;
        synchronized (list) {
            if (!this.dataPumpRunning.get()) {
                log.debug((Object)"Internal error: data read status is empty");
            }
            this.dataPumpRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean acquireDataReadLock() {
        List<ResultSetJobAbstract> list = this.dataPumpJobQueue;
        synchronized (list) {
            block4: {
                if (!this.dataPumpRunning.get()) break block4;
                log.debug((Object)("Internal error: multiple data reads started (" + this.dataPumpJobQueue + ")"));
                return false;
            }
            this.dataPumpRunning.set(true);
        }
        return true;
    }

    public void clearData(boolean clearMetaData) {
        this.model.releaseAllData();
        this.model.clearData();
        this.curRow = null;
        this.selectedRecords = new int[0];
        this.activePresentation.clearMetaData();
        if (clearMetaData) {
            this.model.resetMetaData();
        }
    }

    @Override
    public boolean applyChanges(@Nullable DBRProgressMonitor monitor, @NotNull ResultSetSaveSettings settings) {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return false;
        }
        if (this.getPreferenceStore().getBoolean("resultset.confirm.beforeSave") || dataSource.getContainer().getConnectionConfiguration().getConnectionType().isConfirmDataChange()) {
            ResultSetSaveReport saveReport = this.generateChangesReport();
            if (saveReport == null) {
                return false;
            }
            settings = (ResultSetSaveSettings)UITask.run(() -> {
                SavePreviewDialog spd = new SavePreviewDialog(this, saveReport.isHasReferences() && saveReport.getDeletes() > 0, saveReport);
                if (spd.open() == 0) {
                    return spd.getSaveSettings();
                }
                return null;
            });
            if (settings == null) {
                return false;
            }
        }
        return this.saveChanges(monitor, settings, null);
    }

    private boolean saveChanges(@Nullable DBRProgressMonitor monitor, @NotNull ResultSetSaveSettings settings, @Nullable ResultSetPersister.DataUpdateListener listener) {
        UIUtils.syncExec(() -> this.getActivePresentation().applyChanges());
        try {
            ResultSetPersister persister = this.createDataPersister(false);
            ResultSetPersister.DataUpdateListener applyListener = success -> {
                if (listener != null) {
                    listener.onUpdate(success);
                }
                this.fireResultSetSelectionChange(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection()));
                if (success && this.getPreferenceStore().getBoolean("resultset.edit.refreshAfterUpdate")) {
                    try {
                        persister.refreshInsertedRows();
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error refreshing rows after update", e);
                    }
                }
                UIUtils.syncExec(() -> this.autoRefreshControl.scheduleAutoRefresh(!success));
            };
            return persister.applyChanges(monitor, false, settings, applyListener);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Apply changes error", "Error saving changes in database", (Throwable)e);
            return false;
        }
    }

    @Override
    public void rejectChanges() {
        if (!this.isDirty()) {
            return;
        }
        UIUtils.syncExec(() -> this.getActivePresentation().rejectChanges());
        this.fireResultSetSelectionChange(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection()));
        try {
            this.createDataPersister(true).rejectChanges();
            if (this.model.getAllRows().isEmpty()) {
                this.curRow = null;
                this.selectedRecords = new int[0];
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
    }

    @Override
    @Nullable
    public ResultSetSaveReport generateChangesReport() {
        try {
            return this.createDataPersister(false).generateReport();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Report error", "Error generating changes report", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<DBEPersistAction> generateChangesScript(@NotNull DBRProgressMonitor monitor, @NotNull ResultSetSaveSettings settings) {
        try {
            ResultSetPersister persister = this.createDataPersister(false);
            persister.applyChanges(monitor, true, settings, null);
            return persister.getScript();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("SQL script generate error", "Error saving changes in database", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private ResultSetPersister createDataPersister(boolean skipKeySearch) throws DBException {
        boolean needPK = false;
        if (!skipKeySearch) {
            for (ResultSetRow row : this.model.getAllRows()) {
                if (row.getState() != 3 && (row.getState() != 1 || !row.isChanged())) continue;
                needPK = true;
                break;
            }
        }
        ResultSetPersister persister = new ResultSetPersister(this);
        if (needPK) {
            persister.checkEntityIdentifiers();
        }
        return persister;
    }

    @Override
    @NotNull
    public ResultSetRow addNewRow(boolean copyCurrent, boolean afterCurrent, boolean updatePresentation) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            throw new IllegalStateException("Can't add/copy rows in disconnected results");
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (DBCSession session = executionContext.openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, ResultSetMessages.controls_resultset_viewer_add_new_row_context_name);){
            DBDAttributeBinding docAttribute = this.model.getDocumentAttribute();
            DBDAttributeBinding[] attributes = this.model.getAttributes();
            List<ResultSetRow> selectedRows = this.getSelection().getSelectedRows();
            Object partitionedSelectedRows = selectedRows.isEmpty() ? (Object)new int[][]{new int[2]} : ResultSetViewer.groupConsecutiveRows(selectedRows.stream().mapToInt(ResultSetRow::getVisualNumber).toArray());
            int partitionOffset = 0;
            Object object = partitionedSelectedRows;
            int n = ((int[][])partitionedSelectedRows).length;
            int n2 = 0;
            while (n2 < n) {
                int[] partitionRange = object[n2];
                int partitionStart = partitionRange[0];
                int partitionEnd = partitionRange[1];
                int partitionLength = partitionEnd - partitionStart + 1;
                int srcRowIndex = partitionOffset + partitionStart;
                int newRowIndex = partitionOffset + partitionStart;
                if (afterCurrent) {
                    newRowIndex += partitionLength;
                }
                if (newRowIndex > this.model.getRowCount()) {
                    newRowIndex = this.model.getRowCount();
                }
                int partitionIndex = partitionStart;
                while (partitionIndex <= partitionEnd) {
                    Object[] cells;
                    if (docAttribute != null) {
                        cells = new Object[1];
                        if (copyCurrent && srcRowIndex >= 0 && srcRowIndex < this.model.getRowCount()) {
                            Object[] origRow = this.model.getRowData(srcRowIndex);
                            try {
                                cells[0] = docAttribute.getValueHandler().getValueFromObject(session, (DBSTypedObject)docAttribute, origRow[0], true, false);
                            }
                            catch (DBCException e) {
                                log.warn((Object)e);
                            }
                        }
                        if (cells[0] == null) {
                            try {
                                cells[0] = DBUtils.makeNullValue((DBCSession)session, (DBDValueHandler)docAttribute.getValueHandler(), (DBSTypedObject)docAttribute.getAttribute());
                            }
                            catch (DBCException e) {
                                log.warn((Object)e);
                            }
                        }
                    } else {
                        cells = new Object[attributes.length];
                        if (copyCurrent && srcRowIndex >= 0 && srcRowIndex < this.model.getRowCount()) {
                            Object[] origRow = this.model.getRowData(srcRowIndex);
                            int index = 0;
                            while (index < attributes.length) {
                                DBDAttributeBinding metaAttr = attributes[index];
                                if (!metaAttr.isPseudoAttribute() && !metaAttr.isAutoGenerated()) {
                                    DBSAttributeBase attribute = metaAttr.getAttribute();
                                    try {
                                        cells[index] = metaAttr.getValueHandler().getValueFromObject(session, (DBSTypedObject)attribute, origRow[index], true, false);
                                    }
                                    catch (DBCException e) {
                                        log.warn((Object)e);
                                    }
                                }
                                ++index;
                            }
                        }
                        int index = 0;
                        while (index < attributes.length) {
                            DBDAttributeBinding metaAttr = attributes[index];
                            if (cells[index] == null && !metaAttr.isPseudoAttribute() && !metaAttr.isAutoGenerated()) {
                                DBSAttributeBase attribute = metaAttr.getAttribute();
                                try {
                                    cells[index] = DBUtils.makeNullValue((DBCSession)session, (DBDValueHandler)metaAttr.getValueHandler(), (DBSTypedObject)attribute);
                                }
                                catch (DBCException e1) {
                                    log.warn((Object)e1);
                                }
                            }
                            ++index;
                        }
                    }
                    this.curRow = this.model.addNewRow(newRowIndex, cells);
                    this.selectedRecords = ArrayUtils.add((int[])this.selectedRecords, (int)(this.selectedRecords.length == 0 ? newRowIndex : this.selectedRecords[this.selectedRecords.length - 1] + 1));
                    ++newRowIndex;
                    ++srcRowIndex;
                    if (!afterCurrent) {
                        ++srcRowIndex;
                    }
                    ++partitionIndex;
                }
                partitionOffset += partitionLength;
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (updatePresentation) {
            this.redrawData(false, true);
            this.updateEditControls();
        }
        this.activePresentation.scrollToRow(IResultSetPresentation.RowPosition.CURRENT);
        return this.curRow;
    }

    @Override
    public void copyRowValues(boolean fromRowAbove, boolean updatePresentation) {
        DBCExecutionContext context = this.getExecutionContext();
        if (context == null) {
            throw new IllegalStateException("Can't fill rows in disconnected results");
        }
        DBDAttributeBinding docAttribute = this.model.getDocumentAttribute();
        List<ResultSetRow> selectedRows = this.getSelection().getSelectedRows();
        List<DBDAttributeBinding> selectedAttributes = this.getSelection().getSelectedAttributes();
        int[][] partitionedSelectedRows = ResultSetViewer.groupConsecutiveRows(selectedRows.stream().mapToInt(ResultSetRow::getVisualNumber).toArray());
        Throwable throwable = null;
        Object var9_10 = null;
        try (DBCSession session = context.openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, ResultSetMessages.controls_resultset_viewer_add_new_row_context_name);){
            int[][] nArray = partitionedSelectedRows;
            int n = partitionedSelectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int sourceRowIndex;
                int[] partitionRange = nArray[n2];
                int partitionStart = partitionRange[0];
                int partitionEnd = partitionRange[1];
                if (partitionStart == partitionEnd) {
                    sourceRowIndex = partitionStart + (fromRowAbove ? -1 : 1);
                } else {
                    int n3 = sourceRowIndex = fromRowAbove ? partitionStart : partitionEnd;
                }
                if (sourceRowIndex < 0) break;
                if (sourceRowIndex >= this.model.getRowCount()) {
                    break;
                }
                ResultSetRow sourceRow = this.model.getRow(sourceRowIndex);
                int partitionIndex = partitionStart;
                while (partitionIndex <= partitionEnd) {
                    if (partitionIndex != sourceRowIndex) {
                        ResultSetRow targetRow = this.model.getRow(partitionIndex);
                        if (docAttribute != null) {
                            try {
                                Object cellValue = this.model.getCellValue(new ResultSetCellLocation(docAttribute, sourceRow));
                                Object sourceValue = docAttribute.getValueHandler().getValueFromObject(session, (DBSTypedObject)docAttribute, cellValue, true, false);
                                ResultSetValueController controller = new ResultSetValueController(this, new ResultSetCellLocation(docAttribute, targetRow, null), IValueController.EditType.NONE, null);
                                controller.updateValue(sourceValue, false);
                            }
                            catch (DBCException e) {
                                log.error((Object)"Can't extract document value", (Throwable)e);
                            }
                        } else {
                            for (DBDAttributeBinding metaAttr : selectedAttributes) {
                                if (metaAttr.isPseudoAttribute() || metaAttr.isAutoGenerated()) continue;
                                DBSAttributeBase attribute = metaAttr.getAttribute();
                                try {
                                    Object cellValue = this.model.getCellValue(new ResultSetCellLocation(metaAttr, sourceRow));
                                    Object sourceValue = metaAttr.getValueHandler().getValueFromObject(session, (DBSTypedObject)attribute, cellValue, true, false);
                                    ResultSetValueController controller = new ResultSetValueController(this, new ResultSetCellLocation(metaAttr, sourceRow), IValueController.EditType.NONE, null);
                                    controller.updateValue(sourceValue, false);
                                }
                                catch (DBCException e) {
                                    log.error((Object)"Can't extract cell value", (Throwable)e);
                                }
                            }
                        }
                    }
                    ++partitionIndex;
                }
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (updatePresentation) {
            this.redrawData(false, true);
            this.updateEditControls();
        }
    }

    @NotNull
    private static int[][] groupConsecutiveRows(@NotNull int[] indexes) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        int index = 1;
        int start = 0;
        int length = indexes.length;
        while (index <= length) {
            if (index == length || indexes[index - 1] != indexes[index] - 1) {
                ranges.add(new int[]{indexes[start], indexes[index - 1]});
                start = index;
            }
            ++index;
        }
        return (int[][])ranges.toArray((T[])new int[0][]);
    }

    public void deleteSelectedRows() {
        LinkedHashSet<ResultSetRow> rowsToDelete = new LinkedHashSet<ResultSetRow>();
        if (this.recordMode) {
            rowsToDelete.add(this.curRow);
        } else {
            IResultSetSelection selection = this.getSelection();
            if (!selection.isEmpty()) {
                rowsToDelete.addAll(selection.getSelectedRows());
            }
        }
        if (rowsToDelete.isEmpty()) {
            return;
        }
        int rowsRemoved = 0;
        int lastRowNum = -1;
        for (ResultSetRow row : rowsToDelete) {
            if (this.model.deleteRow(row)) {
                ++rowsRemoved;
            }
            lastRowNum = row.getVisualNumber();
        }
        this.redrawData(false, rowsRemoved > 0);
        if (!this.recordMode && lastRowNum < this.model.getRowCount() - 1 && rowsRemoved == 0) {
            this.activePresentation.scrollToRow(IResultSetPresentation.RowPosition.NEXT);
        } else {
            this.activePresentation.scrollToRow(IResultSetPresentation.RowPosition.CURRENT);
        }
    }

    @Nullable
    public DBDRowIdentifier getVirtualEntityIdentifier() {
        DBSEntityConstraint identifier;
        if (this.model.getVisibleAttributeCount() == 0) {
            return null;
        }
        DBDRowIdentifier rowIdentifier = this.model.getVisibleAttribute(0).getRowIdentifier();
        DBSEntityConstraint dBSEntityConstraint = identifier = rowIdentifier == null ? null : rowIdentifier.getUniqueKey();
        if (identifier instanceof DBVEntityConstraint) {
            return rowIdentifier;
        }
        return null;
    }

    public boolean editEntityIdentifier() {
        EditVirtualEntityDialog dialog = new EditVirtualEntityDialog(this, this.model.getSingleSource(), this.model.getVirtualEntity(true));
        dialog.setInitPage(EditVirtualEntityDialog.InitPage.UNIQUE_KEY);
        if (dialog.open() == 0) {
            DBDRowIdentifier virtualID = this.getVirtualEntityIdentifier();
            if (virtualID != null) {
                try {
                    virtualID.reloadAttributes((DBRProgressMonitor)new VoidProgressMonitor(), this.getModel().getAttributes());
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
            this.persistConfig();
            return true;
        }
        return false;
    }

    public void clearEntityIdentifier() {
        DBVEntity vEntity = this.model.getVirtualEntity(false);
        if (vEntity != null) {
            DBDAttributeBinding firstAttribute;
            DBDRowIdentifier rowIdentifier;
            DBVEntityConstraint vConstraint = vEntity.getBestIdentifier();
            if (vConstraint != null) {
                vConstraint.setAttributes(Collections.emptyList());
            }
            if ((rowIdentifier = (firstAttribute = this.model.getVisibleAttribute(0)).getRowIdentifier()) != null && rowIdentifier.getUniqueKey() == vConstraint) {
                rowIdentifier.clearAttributes();
            }
            this.persistConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private IResultSetListener[] getListenersCopy() {
        IResultSetListener[] listenersCopy;
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return EMPTY_LISTENERS;
            }
            listenersCopy = this.listeners.toArray(new IResultSetListener[0]);
        }
        return listenersCopy;
    }

    void fireResultSetChange() {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetChange();
            ++n2;
        }
    }

    private void fireResultSetLoad() {
        this.applyCurrentPresentationThemeSettings();
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetLoad();
            ++n2;
        }
    }

    private void fireResultSetSelectionChange(SelectionChangedEvent event) {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetSelectionChange(event);
            ++n2;
        }
    }

    private void fireResultSetModelPrepared() {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.onModelPrepared();
            ++n2;
        }
    }

    private void fireQueryExecuted(String query, StatResultSet statistics, String errorMessage) {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.onQueryExecuted(query, statistics, errorMessage);
            ++n2;
        }
    }

    private class BinaryFormatAction
    extends Action {
        private final String prefValue;
        private final DBDAttributeBinding attribute;

        BinaryFormatAction(DBDBinaryFormatter formatter, DBDAttributeBinding attr) {
            super(formatter.getTitle(), 8);
            this.prefValue = formatter.getTitle();
            this.attribute = attr;
        }

        public boolean isChecked() {
            return ResultSetViewer.this.getPreferenceStore().getString("resultset.binary.representation").equalsIgnoreCase(this.prefValue);
        }

        public void run() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            DBPPreferenceStore preferenceStore = this.getActionPreferenceStore();
            String prefId = "resultset.binary.representation";
            preferenceStore.setValue(prefId, this.prefValue.toLowerCase());
            this.getTransformSettings().setCustomTransformer(prefId);
            dataSource.getContainer().persistConfiguration();
            ResultSetViewer.this.refreshData(null);
        }

        @NotNull
        DBVTransformSettings getTransformSettings() {
            DBVTransformSettings settings = DBVUtils.getTransformSettings((DBDAttributeBinding)this.attribute, (boolean)true);
            if (settings == null) {
                throw new IllegalStateException("Can't get/create transformer settings for '" + this.attribute.getFullyQualifiedName(DBPEvaluationContext.UI) + "'");
            }
            return settings;
        }

        DBPPreferenceStore getActionPreferenceStore() {
            return ResultSetViewer.this.getPreferenceStore();
        }
    }

    private class ColorizeDataTypesToggleAction
    extends Action {
        ColorizeDataTypesToggleAction() {
            super(ResultSetMessages.actions_name_colorize_data_types, 2);
            this.setToolTipText("Set different foreground color for data types");
        }

        public boolean isChecked() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.show.colorizeDataTypes");
        }

        public void run() {
            DBPPreferenceStore dsStore;
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            boolean curValue = (dsStore = dataSource.getContainer().getPreferenceStore()).getBoolean("resultset.show.colorizeDataTypes");
            dsStore.setValue("resultset.show.colorizeDataTypes", !curValue);
            dataSource.getContainer().persistConfiguration();
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class ConfigAction
    extends Action {
        ConfigAction() {
            super(ResultSetMessages.controls_resultset_viewer_action_options);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        }

        public void runWithEvent(Event event) {
            UIUtils.showPreferencesFor((Shell)ResultSetViewer.this.getControl().getShell(), (Object)ResultSetViewer.this, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.resultset"});
        }
    }

    private class DataFormatsPreferencesAction
    extends Action {
        DataFormatsPreferencesAction() {
            super(ResultSetMessages.controls_resultset_viewer_action_data_formats);
        }

        public void run() {
            UIUtils.showPreferencesFor((Shell)ResultSetViewer.this.getControl().getShell(), (Object)ResultSetViewer.this, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.dataformat"});
        }
    }

    private class EmptySelection
    extends StructuredSelection
    implements IResultSetSelection {
        private EmptySelection() {
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return ResultSetViewer.this;
        }

        @Override
        @NotNull
        public List<DBDAttributeBinding> getSelectedAttributes() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<ResultSetRow> getSelectedRows() {
            return Collections.emptyList();
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            return null;
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            return null;
        }
    }

    class HistoryStateItem {
        DBSDataContainer dataContainer;
        DBDDataFilter filter;
        int rowNumber;

        HistoryStateItem(@Nullable DBSDataContainer dataContainer, DBDDataFilter filter, int rowNumber) {
            this.dataContainer = dataContainer;
            this.filter = filter;
            this.rowNumber = rowNumber;
        }

        String describeState() {
            DBCExecutionContext context = ResultSetViewer.this.getExecutionContext();
            String desc = this.dataContainer.getName();
            if (context != null && this.filter != null && this.filter.hasConditions()) {
                StringBuilder condBuffer = new StringBuilder();
                SQLUtils.appendConditionString((DBDDataFilter)this.filter, (DBPDataSource)context.getDataSource(), null, (StringBuilder)condBuffer, (boolean)true);
                desc = String.valueOf(desc) + " [" + condBuffer + "]";
            }
            return desc;
        }
    }

    private class OrderByAttributeAction
    extends Action {
        private final DBDAttributeBinding attribute;
        private final IResultSetController.ColumnOrder order;

        OrderByAttributeAction(DBDAttributeBinding attribute, IResultSetController.ColumnOrder order) {
            super(order == IResultSetController.ColumnOrder.NONE ? "Disable order by " + attribute.getName() : "Order by " + attribute.getName() + " " + order.name(), 2);
            this.attribute = attribute;
            this.order = order;
        }

        public boolean isChecked() {
            if (this.order == IResultSetController.ColumnOrder.NONE) {
                return false;
            }
            DBDDataFilter dataFilter = ResultSetViewer.this.getModel().getDataFilter();
            DBDAttributeConstraint constraint = dataFilter.getConstraint(this.attribute);
            if (constraint == null || constraint.getOrderPosition() <= 0) {
                return false;
            }
            boolean forceAsc = this.order == IResultSetController.ColumnOrder.ASC;
            return constraint.isOrderDescending() ^ forceAsc;
        }

        public void run() {
            ResultSetViewer.this.toggleSortOrder(this.attribute, this.order);
        }
    }

    public static class PanelsMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart());
            if (rsv == null) {
                return new IContributionItem[0];
            }
            List<IContributionItem> items = rsv.fillPanelsMenu();
            return items.toArray(new IContributionItem[0]);
        }
    }

    static class PresentationSettings {
        final Set<String> enabledPanelIds = new LinkedHashSet<String>();
        String activePanelId;
        int panelRatio;
        boolean panelsVisible;
        boolean verticalLayout;

        PresentationSettings() {
        }
    }

    private class ResultSetDataPumpJob
    extends ResultSetJobDataRead {
        private final int focusRow;
        private final boolean saveHistory;
        private final boolean scroll;
        private final Object presentationState;
        private final Runnable finalizer;

        ResultSetDataPumpJob(@NotNull DBSDataContainer dataContainer, @NotNull ResultSetExecutionSource executionSource, @NotNull DBCExecutionContext executionContext, Composite progressControl, int focusRow, boolean saveHistory, @Nullable boolean scroll, Runnable finalizer) {
            super(dataContainer, executionSource, executionContext, progressControl);
            this.focusRow = focusRow;
            this.saveHistory = saveHistory;
            this.scroll = scroll;
            this.finalizer = finalizer;
            this.presentationState = ResultSetViewer.this.savePresentationState();
        }

        @Override
        protected IStatus run(DBRProgressMonitor monitor) {
            if (!ResultSetViewer.this.acquireDataReadLock()) {
                if (this.finalizer != null) {
                    this.finalizer.run();
                }
                return Status.CANCEL_STATUS;
            }
            this.beforeDataRead();
            try {
                IStatus iStatus = super.run(monitor);
                return iStatus;
            }
            finally {
                this.afterDataRead();
                ResultSetViewer.this.releaseDataReadLock();
            }
        }

        @Override
        public void forceDataReadCancel(Throwable error) {
            this.setError(error);
            this.afterDataRead();
            DBSDataContainer dataContainer = this.executionSource.getDataContainer();
            if (dataContainer instanceof IQueryExecuteController) {
                ((IQueryExecuteController)dataContainer).forceDataReadCancel(error);
            }
        }

        private void beforeDataRead() {
            ResultSetViewer.this.dataReceiver.setFocusRow(this.focusRow);
            ResultSetViewer.this.dataReceiver.setTargetDataContainer(this.executionSource.getDataContainer());
            ResultSetViewer.this.model.setUpdateInProgress(this);
            ResultSetViewer.this.model.setStatistics(null);
            if (ResultSetViewer.this.filtersPanel != null) {
                UIUtils.asyncExec(() -> {
                    ResultSetViewer.this.filtersPanel.enableFilters(false);
                    ResultSetViewer.this.getAutoRefresh().enableControls(false);
                });
            }
        }

        private void afterDataRead() {
            Throwable error = this.getError();
            if (this.getStatistics() != null) {
                ResultSetViewer.this.model.setStatistics(this.getStatistics());
            }
            UIUtils.syncExec(() -> {
                try {
                    DBDDataFilter dataFilter;
                    boolean metadataChanged;
                    DBSDataContainer dataContainer = this.executionSource.getDataContainer();
                    Composite control1 = ResultSetViewer.this.getControl();
                    if (control1.isDisposed()) {
                        return;
                    }
                    ResultSetViewer.this.model.setUpdateInProgress(null);
                    if (this.saveHistory && error == null) {
                        ResultSetViewer.this.setNewState(dataContainer, this.executionSource.getUseDataFilter());
                    }
                    boolean panelUpdated = false;
                    boolean bl = metadataChanged = !this.scroll && ResultSetViewer.this.model.isMetadataChanged();
                    if (error != null) {
                        String extraErrorMessage;
                        String errorMessage = error.getMessage();
                        ResultSetViewer.this.setStatus(errorMessage, DBPMessageType.ERROR);
                        SQLScriptElement query = null;
                        if (dataContainer instanceof SQLQueryContainer) {
                            query = ((SQLQueryContainer)dataContainer).getQuery();
                        }
                        String sqlText = error instanceof DBSQLException ? ((DBSQLException)error).getSqlQuery() : (query != null ? query.getText() : ResultSetViewer.this.getActiveQueryText());
                        if (CommonUtils.isNotEmpty((String)errorMessage) && query instanceof SQLQuery && CommonUtils.isNotEmpty((String)(extraErrorMessage = ((SQLQuery)query).getExtraErrorMessage()))) {
                            errorMessage = String.valueOf(errorMessage) + System.getProperty("line.separator") + extraErrorMessage;
                        }
                        if (ResultSetViewer.this.getPreferenceStore().getBoolean("resultset.show.errorDialog")) {
                            DBWorkbench.getPlatformUI().showError("Error executing query", "Query execution failed", error);
                        } else {
                            if (CommonUtils.isEmpty((String)errorMessage)) {
                                errorMessage = error.getCause() instanceof InterruptedException ? "Query execution was interrupted" : "Error executing query";
                            }
                            ResultSetViewer.this.showErrorPresentation(sqlText, errorMessage, error);
                            log.error((Object)errorMessage, error);
                        }
                    } else {
                        if (!metadataChanged) {
                            ResultSetViewer.this.restorePresentationState(this.presentationState);
                        }
                        if (this.focusRow >= 0 && (this.focusRow < ResultSetViewer.this.model.getRowCount() || ResultSetViewer.this.model.getRowCount() == 0) && ResultSetViewer.this.model.getVisibleAttributeCount() > 0) {
                            if (ResultSetViewer.this.getCurrentRow() == null && ResultSetViewer.this.model.getRowCount() > 0) {
                                ResultSetViewer.this.setCurrentRow(ResultSetViewer.this.getModel().getRow(this.focusRow));
                            }
                            if (ResultSetViewer.this.getActivePresentation().getCurrentAttribute() == null || ResultSetViewer.this.model.getRowCount() == 0) {
                                ResultSetViewer.this.getActivePresentation().setCurrentAttribute(ResultSetViewer.this.model.getVisibleAttribute(0));
                                panelUpdated = true;
                            }
                        }
                    }
                    ResultSetViewer.this.activePresentation.updateValueView();
                    if (!this.scroll && (dataFilter = this.executionSource.getDataFilter()) != null) {
                        boolean visibilityChanged = !ResultSetViewer.this.model.getDataFilter().equalVisibility(dataFilter);
                        ResultSetViewer.this.model.updateDataFilter(dataFilter, true);
                        ResultSetViewer.this.redrawData(visibilityChanged, false);
                    }
                    if (!panelUpdated) {
                        ResultSetViewer.this.updatePanelsContent(true);
                    }
                    if (this.getStatistics() == null || !this.getStatistics().isEmpty()) {
                        if (error == null) {
                            ResultSetViewer.this.updateStatusMessage();
                        }
                        try {
                            ResultSetViewer.this.fireResultSetLoad();
                        }
                        catch (Throwable e) {
                            log.debug((Object)"Error handling resulset load", e);
                        }
                    }
                    UIUtils.asyncExec(() -> {
                        ResultSetViewer.this.updateFiltersText(true);
                        ResultSetViewer.this.updateToolbar();
                    });
                    ResultSetViewer.this.autoRefreshControl.scheduleAutoRefresh(error != null);
                }
                finally {
                    if (this.finalizer != null) {
                        try {
                            this.finalizer.run();
                        }
                        catch (Throwable e) {
                            log.error((Object)e);
                        }
                    }
                }
            });
        }
    }

    private static class SimpleFilterManager
    implements IResultSetFilterManager {
        private final Map<String, List<String>> filterHistory = new HashMap<String, List<String>>();

        private SimpleFilterManager() {
        }

        @NotNull
        public List<String> getQueryFilterHistory(@NotNull String query) {
            List<String> filters = this.filterHistory.get(query);
            if (filters != null) {
                return filters;
            }
            return Collections.emptyList();
        }

        @Override
        public void saveQueryFilterValue(@NotNull String query, @NotNull String filterValue) {
            List filters = this.filterHistory.computeIfAbsent(query, k -> new ArrayList());
            filters.add(filterValue);
        }

        @Override
        public void deleteQueryFilterValue(@NotNull String query, String filterValue) {
            List<String> filters = this.filterHistory.get(query);
            if (filters != null) {
                filters.add(filterValue);
            }
        }
    }

    private abstract class ToggleConnectionPreferenceAction
    extends Action {
        private final String prefId;

        ToggleConnectionPreferenceAction(String prefId, String title) {
            super(title);
            this.prefId = prefId;
        }

        public int getStyle() {
            return 2;
        }

        public boolean isChecked() {
            return this.getActionPreferenceStore().getBoolean(this.prefId);
        }

        public void run() {
            DBPPreferenceStore preferenceStore;
            preferenceStore.setValue(this.prefId, !(preferenceStore = this.getActionPreferenceStore()).getBoolean(this.prefId));
        }

        DBPPreferenceStore getActionPreferenceStore() {
            return ResultSetViewer.this.getPreferenceStore();
        }
    }

    private class ToggleModeAction
    extends Action {
        ToggleModeAction() {
            super(ResultSetMessages.dialog_text_check_box_record, 2);
            this.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.toggleMode");
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.RS_DETAILS));
            String toolTip = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.core.resultset.toggleMode", (IServiceLocator)ResultSetViewer.this.getSite(), (boolean)false);
            if (!CommonUtils.isEmpty((String)toolTip)) {
                this.setToolTipText(toolTip);
            }
        }

        public boolean isChecked() {
            return ResultSetViewer.this.isRecordMode();
        }

        public void run() {
            ResultSetViewer.this.toggleMode();
        }
    }

    private class ToggleRefreshOnScrollingAction
    extends ToggleConnectionPreferenceAction {
        ToggleRefreshOnScrollingAction() {
            super("resultset.reread.on.scroll", ResultSetMessages.pref_page_database_resultsets_label_reread_on_scrolling);
        }
    }

    private class ToggleSelectionStatAction
    extends ToggleConnectionPreferenceAction {
        ToggleSelectionStatAction(String prefId, String title) {
            super(prefId, title);
        }

        @Override
        public void run() {
            super.run();
            ResultSetViewer.this.fireResultSetSelectionChange(new SelectionChangedEvent((ISelectionProvider)ResultSetViewer.this, (ISelection)ResultSetViewer.this.getSelection()));
        }

        @Override
        DBPPreferenceStore getActionPreferenceStore() {
            return DBWorkbench.getPlatform().getPreferenceStore();
        }
    }

    private class TransformComplexTypesToggleAction
    extends Action {
        TransformComplexTypesToggleAction() {
            super(ResultSetMessages.actions_name_structurize_complex_types, 2);
            this.setToolTipText("Visualize complex types (arrays, structures, maps) in results grid as separate columns");
        }

        public boolean isChecked() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type");
        }

        public void run() {
            DBPPreferenceStore preferenceStore;
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            boolean curValue = (preferenceStore = dataSource.getContainer().getPreferenceStore()).getBoolean("resultset.transform.complex.type");
            preferenceStore.setValue("resultset.transform.complex.type", !curValue);
            dataSource.getContainer().persistConfiguration();
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class TransformerAction
    extends Action {
        private final DBDAttributeBinding attribute;

        TransformerAction(DBDAttributeBinding attr, String text, int style, boolean checked) {
            super(text, style);
            this.attribute = attr;
            this.setChecked(checked);
        }

        @NotNull
        DBVTransformSettings getTransformSettings() {
            DBVTransformSettings settings = DBVUtils.getTransformSettings((DBDAttributeBinding)this.attribute, (boolean)true);
            if (settings == null) {
                throw new IllegalStateException("Can't get/create transformer settings for '" + this.attribute.getFullyQualifiedName(DBPEvaluationContext.UI) + "'");
            }
            return settings;
        }

        void saveTransformerSettings() {
            this.attribute.getDataSource().getContainer().persistConfiguration();
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class TransformerSettingsAction
    extends Action {
        TransformerSettingsAction() {
            super(ResultSetMessages.controls_resultset_viewer_action_view_column_types);
        }

        public void run() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataSource();
            if (dataSource == null) {
                return;
            }
            TransformerSettingsDialog settingsDialog = new TransformerSettingsDialog(ResultSetViewer.this, null, true);
            if (settingsDialog.open() == 0) {
                dataSource.getContainer().persistConfiguration();
                ResultSetViewer.this.refreshData(null);
            }
        }
    }
}

