/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.data.MGDocument;
import com.dbeaver.db.mongodb.exec.MGBaseStatement;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.sql.MongoSQLUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;

public class MGUpdateStatement
extends MGBaseStatement {
    private DBSAttributeBase[] keyAttributes;
    private DBSAttributeBase[] valueAttributes;
    private final List<Object[]> rowValues = new ArrayList<Object[]>();

    public MGUpdateStatement(MGSession session, MGCollection mongoCollection, DBSAttributeBase[] updateAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, MGUpdateStatement.makeQuery(mongoCollection, updateAttributes, keyAttributes, rowValues));
        this.collection = mongoCollection;
        this.keyAttributes = keyAttributes;
        this.valueAttributes = updateAttributes;
    }

    public void addRowValues(Object[] rowValues) {
        this.rowValues.add(rowValues);
    }

    @Override
    public void addToBatch() throws DBCException {
    }

    @Override
    public int[] executeStatementBatch() throws DBCException {
        this.executeStatement();
        return new int[this.rowValues.size()];
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            boolean docUpdate = this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT;
            for (Object[] row : this.rowValues) {
                if (docUpdate) {
                    Document o = (Document)((MGDocument)((Object)row[0])).getRawValue();
                    MongoSQLUtils.normalizeMongoValue(((MGSession)this.getSession()).getDataSource(), o);
                    Object docId = o.get((Object)"_id");
                    if (docId instanceof String && ObjectId.isValid((String)((String)docId))) {
                        try {
                            docId = new ObjectId((String)docId);
                            o.put("_id", docId);
                        }
                        catch (Exception exception) {}
                    }
                    Document filter = new Document("_id", docId);
                    this.updateRowCount = this.collection.getMongoCollection((MGSession)this.getSession()).replaceOne((Bson)filter, (Object)o, new ReplaceOptions()).getModifiedCount();
                    if (this.updateRowCount != 0L) continue;
                    throw new DBCException("Document wasn't updated");
                }
                Document q = new Document();
                int i = 0;
                while (i < this.keyAttributes.length) {
                    Object keyValue = row[this.valueAttributes.length + i];
                    if (keyValue instanceof MGDocument) {
                        q.put("_id", ((MGDocument)((Object)keyValue)).getDocumentId());
                    } else if (keyValue != null) {
                        if (!(keyValue instanceof ObjectId) && ObjectId.isValid((String)CommonUtils.toString((Object)keyValue))) {
                            keyValue = new ObjectId(keyValue.toString());
                        }
                        q.put("_id", keyValue);
                    } else {
                        throw new DBCException("Null document ID specified");
                    }
                    ++i;
                }
                Document o = new Document();
                int i2 = 0;
                while (i2 < this.valueAttributes.length) {
                    BasicDBObject setMap = (BasicDBObject)o.get((Object)"$set");
                    if (setMap == null) {
                        setMap = new BasicDBObject();
                        o.put("$set", (Object)setMap);
                    }
                    setMap.put((Object)this.collection.getAttributeName(this.valueAttributes[i2]), MGUtils.unwrapMongoValue(((MGSession)this.getSession()).getDataSource(), this.valueAttributes[i2], row[i2]));
                    ++i2;
                }
                MongoSQLUtils.normalizeMongoValue(((MGSession)this.getSession()).getDataSource(), o);
                this.updateRowCount = this.collection.getMongoCollection((MGSession)this.getSession()).updateOne((Bson)q, (Bson)o, new UpdateOptions()).getModifiedCount();
                if (this.updateRowCount != 0L) continue;
                throw new DBCException("Document wasn't updated");
            }
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
            this.rowValues.clear();
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] updateAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML)).append("\nSET ");
        int i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeName(updateAttributes[i])).append("=").append(collection.getAttributeValue(updateAttributes[i], rowValues[i]));
            ++i;
        }
        if (keyAttributes.length > 0) {
            sql.append("\nWHERE ");
            i = 0;
            while (i < keyAttributes.length) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append(collection.getAttributeName(keyAttributes[i])).append("=").append(collection.getAttributeValue(keyAttributes[i], rowValues[keyAttributes.length + i]));
                ++i;
            }
        }
        return sql.toString();
    }
}

