/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.krb5;

import com.dbeaver.net.auth.krb5.AuthModelKerberosCredentials;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class AuthModelKerberos
extends AuthModelDatabaseNative<AuthModelKerberosCredentials> {
    private static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    private static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private static final String JAVA_SECURITY_KRB5_REALM = "java.security.krb5.realm";
    private static final String JAVA_SECURITY_KRB5_KDC = "java.security.krb5.kdc";
    private static final String JAVA_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    private static final String JAVA_SECURITY_AUTH_USESUBJECTCREDSONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final Log log = Log.getLog(AuthModelKerberos.class);

    @NotNull
    public AuthModelKerberosCredentials createCredentials() {
        return new AuthModelKerberosCredentials();
    }

    @NotNull
    public AuthModelKerberosCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        String krbUserName;
        AuthModelKerberosCredentials credentials = (AuthModelKerberosCredentials)super.loadCredentials(dataSource, configuration);
        String realmName = CommonUtils.toString((Object)configuration.getAuthProperty("krb5.realm"));
        credentials.setKdcServer(CommonUtils.toString((Object)configuration.getAuthProperty("krb5.kdc_server")));
        credentials.setKrbUserName(CommonUtils.toString((Object)configuration.getAuthProperty("krb5.user")));
        if (CommonUtils.isEmpty((String)credentials.getKrbUserName())) {
            credentials.setKrbUserName(configuration.getUserName());
        }
        if (CommonUtils.isEmpty((String)configuration.getUserName())) {
            credentials.setUserName(credentials.getKrbUserName());
        }
        if (!CommonUtils.isEmpty((String)(krbUserName = credentials.getKrbUserName()))) {
            String userName = credentials.getUserName();
            if (CommonUtils.isEmpty((String)realmName)) {
                if (krbUserName.contains("@")) {
                    realmName = krbUserName.substring(krbUserName.lastIndexOf(64) + 1);
                } else if (userName.contains("@")) {
                    realmName = userName.substring(userName.lastIndexOf(64) + 1);
                }
            } else if (!krbUserName.contains("@")) {
                krbUserName = String.valueOf(krbUserName) + "@" + realmName;
                credentials.setKrbUserName(krbUserName);
            }
        }
        credentials.setKrbRealmName(realmName);
        credentials.setUseKeytab(CommonUtils.getBoolean((String)configuration.getAuthProperty("krb5.use_keytab"), (boolean)Boolean.FALSE));
        credentials.setForceTcp(CommonUtils.getBoolean((String)configuration.getAuthProperty("krb5.kdc_over_tcp"), (boolean)Boolean.FALSE));
        credentials.setKeytabPath(GeneralUtils.replaceVariables((String)CommonUtils.toString((Object)configuration.getAuthProperty("krb5.keytab_path")), (IVariableResolver)new DataSourceVariableResolver(dataSource, configuration)));
        credentials.setUseKinit(CommonUtils.getBoolean((String)configuration.getAuthProperty("krb5.use_kinit"), (boolean)Boolean.FALSE));
        credentials.setServiceName(configuration.getAuthProperty("SERVICE_NAME"));
        credentials.setUseSslJks(CommonUtils.getBoolean((String)configuration.getAuthProperty("USE_SSL_JKS"), (boolean)Boolean.FALSE));
        credentials.setSslJksPath(configuration.getAuthProperty("SSL_JKS_PATH"));
        credentials.setSslJksPassword(configuration.getAuthProperty("SSL_JKS_PASSWORD"));
        credentials.setShowDebugInfo(CommonUtils.getBoolean((String)configuration.getAuthProperty("krb5.debug")));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelKerberosCredentials credentials) {
        configuration.setAuthProperty("krb5.kdc_server", credentials.getKdcServer());
        configuration.setAuthProperty("krb5.user", credentials.getKrbUserName());
        configuration.setAuthProperty("krb5.realm", credentials.getKrbRealmName());
        configuration.setAuthProperty("krb5.use_keytab", String.valueOf(credentials.isUseKeytab()));
        configuration.setAuthProperty("krb5.kdc_over_tcp", String.valueOf(credentials.isForceTcp()));
        configuration.setAuthProperty("krb5.keytab_path", credentials.getKeytabPath());
        configuration.setAuthProperty("krb5.use_kinit", String.valueOf(credentials.isUseKinit()));
        configuration.setAuthProperty("SERVICE_NAME", credentials.getServiceName());
        configuration.setAuthProperty("USE_SSL_JKS", String.valueOf(credentials.isUseSslJks()));
        configuration.setAuthProperty("SSL_JKS_PATH", credentials.getSslJksPath());
        configuration.setAuthProperty("SSL_JKS_PASSWORD", credentials.getSslJksPassword());
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelKerberosCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        try {
            this.initKerberos(monitor, dataSource, credentials);
        }
        catch (IOException e) {
            throw new DBCException("IO error", (Throwable)e);
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    protected boolean isUserNameNeeded(@NotNull DBPDataSource dataSource) {
        return CommonUtils.getBoolean((Object)dataSource.getContainer().getDriver().getDriverParameter("krb5.sendUserNameToDatabase"), (boolean)true);
    }

    protected boolean isUserPasswordNeeded(@NotNull DBPDataSource dataSource) {
        return CommonUtils.getBoolean((Object)dataSource.getContainer().getDriver().getDriverParameter("krb5.sendPasswordToDatabase"), (boolean)true);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        System.clearProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
        System.clearProperty(JAVA_SECURITY_KRB5_REALM);
        System.clearProperty(JAVA_SECURITY_KRB5_KDC);
        System.clearProperty(JAVA_SECURITY_KRB5_CONF);
        super.endAuthentication(dataSource, configuration, connProperties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initKerberos(DBRProgressMonitor monitor, DBPDataSource dataSource, AuthModelKerberosCredentials credentials) throws IOException, DBCException {
        if (CommonUtils.isEmpty((String)credentials.getKrbUserName())) {
            throw new DBCException("Can't determine Kerberos user");
        }
        if (CommonUtils.isEmpty((String)credentials.getKrbRealmName())) {
            throw new DBCException("Realm must be specified or provided with Kerberos username");
        }
        monitor.subTask("Initialize Kerberos configuration");
        String username = credentials.getUserName();
        Path tempDir = DBWorkbench.getPlatform().getTempFolder(monitor, "krb5");
        Path credentialCacheFile = Files.createTempFile(tempDir, "krb5-", ".ccache", new FileAttribute[0]);
        credentialCacheFile.toFile().deleteOnExit();
        if (CommonUtils.isEmpty((String)username)) {
            throw new DBCException("Empty user name");
        }
        String realm = credentials.getKrbRealmName();
        String kdcServer = credentials.getKdcServer();
        String krb5User = credentials.getKrbUserName();
        boolean emptyRealm = CommonUtils.isEmpty((String)realm);
        boolean emptyKrb5User = CommonUtils.isEmpty((String)krb5User);
        boolean emptyUsername = CommonUtils.isEmpty((String)username);
        if (emptyKrb5User) {
            krb5User = username;
        }
        if (emptyUsername) {
            username = krb5User;
        }
        if (emptyUsername && emptyKrb5User) {
            throw new DBCException("Username and/or Kerberos username must be specified");
        }
        if (emptyRealm) {
            if (krb5User.contains("@")) {
                realm = krb5User.substring(krb5User.lastIndexOf(64) + 1);
            } else {
                if (!username.contains("@")) throw new DBCException("Realm must be specified or provided with Kerberos username");
                realm = username.substring(username.lastIndexOf(64) + 1);
            }
        } else if (!krb5User.contains("@")) {
            krb5User = String.valueOf(username) + "@" + realm;
        }
        boolean emptyKdc = CommonUtils.isEmpty((String)kdcServer);
        if (emptyKdc) {
            throw new DBCException("KDC Server must be specified");
        }
        System.setProperty(JAVA_SECURITY_KRB5_KDC, kdcServer);
        boolean keytab = credentials.isUseKeytab();
        String keytabPath = credentials.getKeytabPath();
        boolean emptyKeytabPath = CommonUtils.isEmpty((String)keytabPath);
        if (keytab && emptyKeytabPath) {
            throw new DBCException("Keytab must be provided.");
        }
        System.setProperty(JAVA_SECURITY_KRB5_REALM, realm);
        System.setProperty(JAVA_SECURITY_KRB5_DEBUG, String.valueOf(credentials.isShowDebugInfo()));
        System.setProperty(JAVA_SECURITY_AUTH_USESUBJECTCREDSONLY, String.valueOf(false));
        log.debug((Object)"KRB5: Setting kerberos properties");
        boolean forceTcp = credentials.isForceTcp();
        boolean kinit = credentials.isUseKinit();
        if (!kinit) {
            this.callKinit(kdcServer, forceTcp, realm, krb5User, credentials.getUserPassword(), keytab, keytabPath, credentialCacheFile);
        }
        Path jaasFile = this.createJaasFile(tempDir, dataSource, credentials, credentialCacheFile, krb5User, realm);
        jaasFile.toFile().deleteOnExit();
        String jaasConfigPath = jaasFile.toAbsolutePath().toString();
        System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, jaasConfigPath);
        credentials.setCacheFilePath(credentialCacheFile.toAbsolutePath().toString());
        Configuration config = Configuration.getConfiguration();
        config.refresh();
    }

    private void callKinit(String kdcServer, Boolean forceTcp, String realm, String krb5User, String password, Boolean keytab, String keytabPath, Path credentialCacheFile) throws DBCException {
        KrbClient client;
        log.debug((Object)"KRB5: Bootstraping kinit");
        try {
            client = new KrbClient();
        }
        catch (Exception e) {
            log.warn((Object)"Kerberos config was ignored, using empty config", (Throwable)e);
            client = new KrbClient(new KrbConfig());
        }
        try {
            client.setKdcRealm(realm);
            client.setKdcHost(kdcServer);
            if (forceTcp.booleanValue()) {
                client.setAllowUdp(false);
                client.setAllowTcp(true);
            }
            client.init();
            TgtTicket tgt = keytab != false ? client.requestTgt(krb5User, new File(keytabPath)) : client.requestTgt(krb5User, password);
            client.storeTicket(tgt, credentialCacheFile.toFile());
        }
        catch (KrbException e) {
            throw new DBCException("KerberosException", (Throwable)e);
        }
    }

    private Path createJaasFile(Path tempDir, DBPDataSource dataSource, AuthModelKerberosCredentials credentials, Path credentialCacheFile, String krb5User, String realm) throws IOException {
        log.debug((Object)"KRB5: Creating JAAS file for kerberos");
        boolean krb5Debug = credentials.isShowDebugInfo();
        boolean forceTcp = credentials.isForceTcp();
        boolean kinit = credentials.isUseKinit();
        String loginModuleName = this.getLoginModuleName(dataSource, credentials);
        if (forceTcp) {
            File krb5ConfPath = File.createTempFile("dbeaver.krb5-", ".conf");
            FileWriter fw = new FileWriter(krb5ConfPath);
            fw.write("[libdefaults]\n");
            fw.write("  udp_preference_limit=1\n");
            fw.close();
            System.setProperty(JAVA_SECURITY_KRB5_CONF, krb5ConfPath.getAbsolutePath());
        }
        Path jaasFile = Files.createTempFile(tempDir, "jaas-", "conf", new FileAttribute[0]);
        Throwable throwable = null;
        Object var13_14 = null;
        try (BufferedWriter fw = Files.newBufferedWriter(jaasFile, new OpenOption[0]);){
            fw.write(loginModuleName);
            fw.write(" {\n");
            fw.write("  com.sun.security.auth.module.Krb5LoginModule required\n");
            fw.write("  doNotPrompt=true\n");
            fw.write("  useTicketCache=true\n");
            fw.write("  renewTGT=true\n");
            fw.write(String.format("  principal=\"%s\"\n", krb5User));
            fw.write(String.format("  realm=\"%s\"\n", realm));
            if (!kinit) {
                fw.write(String.format("  ticketCache=\"%s\"\n", credentialCacheFile.toAbsolutePath().toString().replace("\\", "\\\\")));
            }
            fw.write("  debug=" + krb5Debug + ";\n");
            fw.write("};\n");
            ((Writer)fw).flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return jaasFile;
    }

    protected String getLoginModuleName(DBPDataSource dataSource, AuthModelKerberosCredentials credentials) {
        return CommonUtils.toString((Object)dataSource.getContainer().getDriver().getDriverParameter("krb5.loginModule"), (String)"Krb5ConnectorContext");
    }
}

