/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import org.eclipse.draw2dl.IFigure;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.editpolicies.GraphicalEditPolicy;
import org.eclipse.graphiti.platform.ga.IVisualState;
import org.eclipse.graphiti.platform.ga.IVisualStateHolder;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;

public class ShapeHighlightEditPolicy
extends GraphicalEditPolicy {
    private IConfigurationProvider _configurationProvider;

    protected ShapeHighlightEditPolicy(IConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    protected final IConfigurationProvider getConfigurationProvider() {
        return this._configurationProvider;
    }

    public EditPart getTargetEditPart(Request request) {
        return request.getType().equals("selection hover") ? this.getHost() : null;
    }

    public void eraseTargetFeedback(Request request) {
        IFigure containerFigure = ((GraphicalEditPart)this.getHost()).getFigure();
        if (containerFigure instanceof IVisualStateHolder) {
            IVisualStateHolder feedbackRenderer = (IVisualStateHolder)containerFigure;
            IVisualState vs = feedbackRenderer.getVisualState();
            vs.setActionTargetFeedback(0);
        }
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("connection start") || request.getType().equals("connection end") || request.getType().equals("Reconnection target") || request.getType().equals("Reconnection source") || request.getType().equals("create child") || request.getType().equals("add children")) {
            Command command = this.getHost().getCommand(request);
            this.showHighlight(command != null && command.canExecute());
        }
    }

    private void showHighlight(boolean canExecute) {
        IFigure containerFigure = ((GraphicalEditPart)this.getHost()).getFigure();
        if (containerFigure instanceof IVisualStateHolder) {
            IVisualStateHolder feedbackRenderer = (IVisualStateHolder)containerFigure;
            IVisualState vs = feedbackRenderer.getVisualState();
            if (canExecute) {
                vs.setActionTargetFeedback(1);
            } else {
                vs.setActionTargetFeedback(2);
            }
        }
    }
}

