/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2dl.AbstractLocator;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.RotatableDecoration;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.PrecisionPoint;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.ui.internal.figures.GFText;

public class FlexibleRotatableLocator
extends AbstractLocator {
    private Connection connection;
    private boolean distanceToStart;
    private double relativeDistance;
    private int absoluteDistance;
    private double rotateDegrees;

    public FlexibleRotatableLocator(Connection connection, boolean distanceToStart, double relativeDistance, int absoluteDistance, double rotateDegrees) {
        assert (connection != null);
        this.connection = connection;
        this.setDistanceToStart(distanceToStart);
        this.setRelativeDistance(relativeDistance);
        this.setAbsoluteDistance(absoluteDistance);
        this.setRotateDegrees(rotateDegrees);
    }

    protected final Connection getConnection() {
        return this.connection;
    }

    public final boolean getDistanceToStart() {
        return this.distanceToStart;
    }

    public final void setDistanceToStart(boolean distanceToStart) {
        this.distanceToStart = distanceToStart;
    }

    public final double getRelativeDistance() {
        return this.relativeDistance;
    }

    public final void setRelativeDistance(double relativeDistance) {
        this.relativeDistance = relativeDistance;
    }

    public final int getAbsoluteDistance() {
        return this.absoluteDistance;
    }

    public final void setAbsoluteDistance(int absoluteDistance) {
        this.absoluteDistance = absoluteDistance;
    }

    public final double getRotateDegrees() {
        return this.rotateDegrees;
    }

    public final void setRotateDegrees(double rotateDegrees) {
        this.rotateDegrees = rotateDegrees;
    }

    protected CalculationResult calculateLocation() {
        PointList pointList = this.getConnection().getPoints();
        assert (pointList.size() >= 2);
        CalculationResult result = new CalculationResult();
        Point[] allPoints = new Point[pointList.size()];
        int i = 0;
        while (i < allPoints.length) {
            if (this.getDistanceToStart()) {
                allPoints[i] = pointList.getPoint(i);
            } else {
                allPoints[allPoints.length - 1 - i] = pointList.getPoint(i);
            }
            ++i;
        }
        if (this.getAbsoluteDistance() == 0 && this.getRelativeDistance() == 0.0) {
            result.segmentStart = allPoints[0];
            result.segmentEnd = allPoints[1];
            result.location = result.segmentStart;
            return result;
        }
        if (this.getAbsoluteDistance() == 0 && this.getRelativeDistance() == 1.0) {
            result.segmentStart = allPoints[allPoints.length - 2];
            result.segmentEnd = allPoints[allPoints.length - 1];
            result.location = result.segmentEnd;
            return result;
        }
        double totalLength = 0.0;
        double[] segmentLength = new double[allPoints.length - 1];
        int i2 = 0;
        while (i2 < segmentLength.length) {
            segmentLength[i2] = allPoints[i2].getDistance(allPoints[i2 + 1]);
            totalLength += segmentLength[i2];
            ++i2;
        }
        double totalDistance = totalLength * this.getRelativeDistance() + (double)this.getAbsoluteDistance();
        int targetIndex = 0;
        double lengthBeforeTargetSegment = 0.0;
        targetIndex = 0;
        while (targetIndex < segmentLength.length - 1) {
            if (!(lengthBeforeTargetSegment + segmentLength[targetIndex] < totalDistance)) break;
            lengthBeforeTargetSegment += segmentLength[targetIndex];
            ++targetIndex;
        }
        result.segmentStart = allPoints[targetIndex];
        result.segmentEnd = allPoints[targetIndex + 1];
        if (segmentLength[targetIndex] == 0.0) {
            result.location = result.segmentStart;
        } else {
            double absoluteDistanceInSegment = totalDistance - lengthBeforeTargetSegment;
            double relativeDistanceInSegment = absoluteDistanceInSegment / segmentLength[targetIndex];
            double locationX = (double)((CalculationResult)result).segmentStart.x + (double)(((CalculationResult)result).segmentEnd.x - ((CalculationResult)result).segmentStart.x) * relativeDistanceInSegment;
            double locationY = (double)((CalculationResult)result).segmentStart.y + (double)(((CalculationResult)result).segmentEnd.y - ((CalculationResult)result).segmentStart.y) * relativeDistanceInSegment;
            result.location = (Point)new PrecisionPoint(locationX, locationY);
        }
        return result;
    }

    protected Point getReferencePoint() {
        CalculationResult calculationResult = this.calculateLocation();
        this.getConnection().translateToAbsolute((Translatable)calculationResult.location);
        return calculationResult.location;
    }

    public void relocate(IFigure target) {
        if (target instanceof RotatableDecoration) {
            Point reference;
            CalculationResult calculationResult = this.calculateLocation();
            RotatableDecoration rotatable = (RotatableDecoration)target;
            if (rotatable instanceof GFText) {
                GFText text = (GFText)rotatable;
                GraphicsAlgorithm ga = text.getGraphicsAlgorithm();
                Point textLocation = calculationResult.location.getCopy().translate(ga.getX(), ga.getY());
                rotatable.setLocation(textLocation);
            } else {
                rotatable.setLocation(calculationResult.location);
            }
            Point p1 = calculationResult.segmentStart;
            Point p2 = calculationResult.segmentEnd;
            if (p1.equals((Object)p2)) {
                reference = calculationResult.location.getCopy().translate(-10, 0);
            } else {
                reference = new Point();
                reference.x = p2.x + (p2.x - p1.x);
                reference.y = p2.y + (p2.y - p1.y);
                this.rotatePoint(calculationResult.location, reference, this.getRotateDegrees());
            }
            rotatable.setReferencePoint(reference);
        } else {
            super.relocate(target);
        }
    }

    protected void rotatePoint(Point center, Point rotate, double degrees) {
        if (degrees != 0.0) {
            double radians = Math.toRadians(degrees);
            double sin = Math.sin(radians);
            double cos = Math.cos(radians);
            Point v = new Point(rotate.x - center.x, rotate.y - center.y);
            rotate.x = center.x + (int)(cos * (double)v.x - sin * (double)v.y);
            rotate.y = center.y + (int)(sin * (double)v.x + cos * (double)v.y);
        }
    }

    private class CalculationResult {
        private Point location;
        private Point segmentStart;
        private Point segmentEnd;

        private CalculationResult() {
        }
    }
}

