/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.validate;

import com.dbeaver.lm.validate.LMPublicAPI;
import com.dbeaver.lm.validate.LicenseCheckResult;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseStatus;
import org.jkiss.lm.LMLicenseValidator;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMStatusDetails;
import org.jkiss.lm.LMSubscription;
import org.jkiss.lm.LMUtils;
import org.jkiss.lm.LMValidateException;

public class PublicLicenseValidator
implements LMLicenseValidator {
    public static final LMLicenseValidator PUBLIC_LICENSE_VALIDATOR = new PublicLicenseValidator();
    private static final Log log = Log.getLog(LMPublicAPI.class);
    private final Map<String, LicenseCheckResult> validateCache = new HashMap<String, LicenseCheckResult>();

    public void validateLicense(LMLicenseManager licenseManager, String clientId, LMProduct product, LMLicense license) throws LMValidateException {
        LicenseCheckResult result = this.validateCache.get(license.getLicenseId());
        if (result == null || license.isSubscription() && result.getSubscription() == null) {
            try {
                result = LMPublicAPI.checkLicenseStatus(clientId, licenseManager, license, product);
            }
            finally {
                if (result != null) {
                    this.validateCache.put(license.getLicenseId(), result);
                }
            }
        }
        if (result == null) {
            log.error((Object)"Internal error - NULL validation result");
            return;
        }
        if (result.getLicenseStatus() != LMLicenseStatus.VALID) {
            throw new LMValidateException(license, result.getLicenseStatus(), result.getCheckStatus().getMessage(), result.getCheckStatus().getException());
        }
        if (license.isSubscription()) {
            LMSubscription subscriptionInfo = result.getSubscription();
            if (subscriptionInfo == null) {
                subscriptionInfo = licenseManager.getSubscriptionInfo(license);
            } else {
                try {
                    licenseManager.updateSubscription(product, subscriptionInfo);
                }
                catch (LMException e) {
                    log.error((Object)"Can't update subscription information in the local database", (Throwable)e);
                }
            }
            String noInternetWarning = "Note: you need internet access to use subscription licenses.\nCheck your internet connection and/or firewall settings and restart application.";
            if (subscriptionInfo == null) {
                LMStatusDetails remoteStatus = new LMStatusDetails("Invalid subscription", "Can't find subscription information for license '" + license.getLicenseId() + "'.\n" + noInternetWarning, false);
                license.setRemoteStatus(remoteStatus);
                throw new LMValidateException(license, LMLicenseStatus.INVALID, remoteStatus.getMessage());
            }
            if (subscriptionInfo.isExpired()) {
                LMStatusDetails remoteStatus = new LMStatusDetails("Expired", "License '" + license.getLicenseId() + "' subscription has been expired (" + LMUtils.HR_DATE_FORMAT.format(subscriptionInfo.getExpirationDate()) + ").\n" + noInternetWarning, false);
                license.setRemoteStatus(remoteStatus);
                throw new LMValidateException(license, LMLicenseStatus.EXPIRED, remoteStatus.getMessage());
            }
        }
    }

    public void clearLicenseCache(String id) {
        this.validateCache.remove(id);
    }

    public void clearLicenseCache() {
        this.validateCache.clear();
    }

    public String getLicenseValidationStatus(LMLicense license) {
        LicenseCheckResult checkResult = this.validateCache.get(license.getLicenseId());
        return checkResult == null || checkResult.getLicenseStatus() == LMLicenseStatus.VALID ? null : checkResult.getCheckStatus().getMessage();
    }
}

