/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.embedded;

import com.dbeaver.lm.app.DBPApplicationLicensed;
import com.dbeaver.lm.app.LMAppUtils;
import com.dbeaver.lm.validate.LMPublicAPI;
import com.dbeaver.lm.validate.LicenseRequest;
import com.dbeaver.lm.validate.PublicLicenseValidator;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.Key;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMEnvironment;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMKeyProvider;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMService;
import org.jkiss.lm.LMSubscription;
import org.jkiss.lm.LMUtils;
import org.jkiss.lm.LMValidateException;
import org.jkiss.utils.CommonUtils;

public class LicenseServiceEmbedded
implements LMService {
    private static final Log log;
    public static final String LICENSE_FILE_NAME = ".lm";
    private static final LMLicenseManager licenseManager;
    private static final LMEnvironment lmEnvironment;

    static {
        String pathToLicenseFile;
        log = Log.getLog(LicenseServiceEmbedded.class);
        lmEnvironment = new LMEnvironment();
        lmEnvironment.setProductPurchaseURL(Platform.getProduct().getProperty("productPurchaseURL"));
        lmEnvironment.setArchiveURL(Platform.getProduct().getProperty("archiveURL"));
        licenseManager = new LMLicenseManager(lmEnvironment, (LMKeyProvider)new LicenseKeyProvider(), PublicLicenseValidator.PUBLIC_LICENSE_VALIDATOR);
        IProduct product = Platform.getProduct();
        if (product != null && !CommonUtils.isEmpty((String)(pathToLicenseFile = product.getProperty("productLicense")))) {
            try {
                URL url = FileLocator.toFileURL((URL)new URL(pathToLicenseFile));
                File localFile = new File(url.getFile());
                LMLicenseManager.setLicenseCustomPath((String)localFile.getAbsolutePath());
            }
            catch (Throwable e) {
                log.warn((Object)"Error opening product license", e);
            }
        }
    }

    public LicenseServiceEmbedded() {
        this(false);
    }

    public LicenseServiceEmbedded(boolean workspaceStorage) {
        log.debug((Object)("\tInitialize license manager for " + LMAppUtils.getActiveProduct().getId()));
        if (workspaceStorage) {
            licenseManager.setConfigPath(DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(LICENSE_FILE_NAME).toFile());
        }
    }

    public LMLicense getActiveProductLicense(boolean validate) {
        try {
            return licenseManager.getValidProductLicense(validate ? this.getClientId() : null, LMAppUtils.getActiveProduct());
        }
        catch (LMValidateException e) {
            log.error((Object)"Internal error while checking active license", (Throwable)e);
            return null;
        }
    }

    public LMLicense[] getAllProductLicenses() {
        return licenseManager.getProductLicenses(DBPApplicationLicensed.getLicensedApplication().getLicenseProduct());
    }

    public LMLicense importProductLicense(String licenseText) throws LMException {
        try {
            byte[] licenseData = LMUtils.readEncryptedString((Reader)new StringReader(licenseText.trim()));
            return licenseManager.importLicense(DBPApplicationLicensed.getLicensedApplication().getLicenseProduct(), licenseData);
        }
        catch (Exception e) {
            throw new LMException("Error importing license", (Throwable)e);
        }
    }

    public boolean invalidateActiveLicense(boolean forceRefresh) throws LMException {
        if (forceRefresh) {
            licenseManager.clearLicenseCache();
        }
        try {
            LMLicense license = licenseManager.getValidProductLicense(this.getClientId(), LMAppUtils.getActiveProduct());
            if (license == null) {
                log.error((Object)("No license found for " + LMAppUtils.getActiveProduct().getName()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new LMException("Error reading valid license info", (Throwable)e);
        }
    }

    @NotNull
    private String getClientId() {
        return DBWorkbench.getPlatform().getWorkspace().getWorkspaceId();
    }

    public void validateLicense(LMLicense license) throws LMValidateException {
        licenseManager.validateLicense(this.getClientId(), LMAppUtils.getActiveProduct(), license);
    }

    public String getLicenseStatus(LMLicense license) throws LMException {
        return licenseManager.getLicenseValidationStatus(LMAppUtils.getActiveProduct(), license);
    }

    public LMProduct getActiveProduct() {
        return DBPApplicationLicensed.getLicensedApplication().getLicenseProduct();
    }

    public LMSubscription getSubscriptionInfo(LMLicense license) throws LMException {
        return licenseManager.getSubscriptionInfo(license);
    }

    public void deleteLicense(LMLicense license) throws LMException {
        licenseManager.deleteLicense(LMAppUtils.getActiveProduct(), license);
    }

    public LMLicense findTrialLicense() throws LMException {
        return licenseManager.findTrialLicense(this.getClientId(), LMAppUtils.getActiveProduct());
    }

    public IStatus requestTrialLicense(@NotNull DBRProgressMonitor monitor, @NotNull LicenseRequest request) {
        return LMPublicAPI.requestTrialLicense(monitor, this.getClientId(), LMAppUtils.getActiveProduct(), request);
    }

    private static class LicenseKeyProvider
    implements LMKeyProvider {
        LicenseKeyProvider() {
        }

        public Key getEncryptionKey(LMProduct product) {
            return null;
        }

        public Key getDecryptionKey(LMProduct product) {
            String id = product.getId();
            String resourceName = "keys/" + id + "-public.key";
            URL keyURL = ApplicationRegistry.getInstance().getApplication().getContributorBundle().getResource(resourceName);
            if (keyURL != null) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream keyStream = keyURL.openStream();){
                        byte[] keyData = LMUtils.readEncryptedString((InputStream)keyStream);
                        return LMEncryption.generatePublicKey((byte[])keyData);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    return null;
                }
            }
            log.error((Object)("Public key file not found for product " + id));
            return null;
        }
    }
}

