/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.QSYSObjectPathName;
import java.util.Calendar;
import java.util.Date;

public class SpooledFileListItem {
    public static final String ASSIGNED_SPECIFIC = "1";
    public static final String ASSIGNED_MULTIPLE = "2";
    public static final String ASSIGNED_NONE = "3";
    public static final String DEVICE_TYPE_DISKETTE = "DISKETTE";
    public static final String DEVICE_TYPE_PRINTER = "PRINTER";
    public static final String SCHEDULE_IMMEDIATE = "1";
    public static final String SCHEDULE_FILE_END = "2";
    public static final String SCHEDULE_JOB_END = "3";
    public static final String STATUS_READY = "*READY";
    public static final String STATUS_OPEN = "*OPEN";
    public static final String STATUS_CLOSED = "*CLOSED";
    public static final String STATUS_SAVED = "*SAVED";
    public static final String STATUS_WRITING = "*WRITING";
    public static final String STATUS_HELD = "*HELD";
    public static final String STATUS_MESSAGE_WAIT = "*MESSAGE";
    public static final String STATUS_PENDING = "*PENDING";
    public static final String STATUS_PRINTING = "*PRINTER";
    public static final String STATUS_FINISHED = "*FINISHED";
    public static final String STATUS_SENDING = "*SENDING";
    public static final String STATUS_DEFERRED = "*DEFERRED";
    private String jobName_;
    private String jobUser_;
    private String jobNumber_;
    private String name_;
    private int number_;
    private String status_;
    private String dateOpened_;
    private String timeOpened_;
    private String schedule_;
    private String jobSystemName_;
    private String userData_;
    private String formType_;
    private String outputQueueName_;
    private String outputQueueLibrary_;
    private int asp_;
    private int size_;
    private int sizeMultiplier_;
    private int totalPages_;
    private int copiesLeftToPrint_;
    private String priority_;
    private int ippJobIdentifier_;
    private byte[] internalJobIdentifier_;
    private byte[] internalSpooledFileIdentifier_;
    private int currentPage_;
    private String deviceType_;
    private String printerAssignment_;
    private String printerName_;
    private String format_;

    SpooledFileListItem(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, String string5, String string6, String string7, String string8, String string9, String string10, byte[] byArray, byte[] byArray2, String string11, String string12, String string13, String string14) {
        this.name_ = string;
        this.jobName_ = string2;
        this.jobUser_ = string3;
        this.jobNumber_ = string4;
        this.number_ = n;
        this.totalPages_ = n2;
        this.currentPage_ = n3;
        this.copiesLeftToPrint_ = n4;
        this.outputQueueName_ = string5;
        this.outputQueueLibrary_ = string6;
        this.userData_ = string7;
        this.status_ = string8;
        this.formType_ = string9;
        this.priority_ = string10;
        this.internalJobIdentifier_ = byArray;
        this.internalSpooledFileIdentifier_ = byArray2;
        this.deviceType_ = string11;
        this.jobSystemName_ = string12;
        this.dateOpened_ = string13;
        this.timeOpened_ = string14;
        this.format_ = "OSPL0100";
    }

    SpooledFileListItem(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, String string5, String string6, String string7, String string8, String string9, String string10, byte[] byArray, byte[] byArray2, String string11, String string12, String string13, String string14, String string15, String string16) {
        this(string, string2, string3, string4, n, n2, n3, n4, string5, string6, string7, string8, string9, string10, byArray, byArray2, string11, string12, string13, string14);
        this.printerAssignment_ = string15;
        this.printerName_ = string16;
        this.format_ = "OSPL0200";
    }

    SpooledFileListItem(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, int n3, int n4, int n5, int n6, int n7, String string13, int n8) {
        this.jobName_ = string;
        this.jobUser_ = string2;
        this.jobNumber_ = string3;
        this.name_ = string4;
        this.number_ = n;
        this.status_ = SpooledFileListItem.mapStatus(n2);
        this.dateOpened_ = string5;
        this.timeOpened_ = string6;
        this.schedule_ = string7;
        this.jobSystemName_ = string8;
        this.userData_ = string9;
        this.formType_ = string10;
        this.outputQueueName_ = string11;
        this.outputQueueLibrary_ = string12;
        this.asp_ = n3;
        this.size_ = n4;
        this.sizeMultiplier_ = n5;
        this.totalPages_ = n6;
        this.copiesLeftToPrint_ = n7;
        this.priority_ = string13;
        this.ippJobIdentifier_ = n8;
        this.format_ = "OSPL0300";
    }

    public int getASP() {
        return this.asp_;
    }

    public int getCopiesLeftToPrint() {
        return this.copiesLeftToPrint_;
    }

    public Date getCreationDate() {
        if (this.dateOpened_ == null) {
            return null;
        }
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.clear();
        calendar.set(Integer.parseInt(this.dateOpened_.substring(0, 3)) + 1900, Integer.parseInt(this.dateOpened_.substring(3, 5)) - 1, Integer.parseInt(this.dateOpened_.substring(5, 7)), Integer.parseInt(this.timeOpened_.substring(0, 2)), Integer.parseInt(this.timeOpened_.substring(2, 4)), Integer.parseInt(this.timeOpened_.substring(4, 6)));
        return calendar.getTime();
    }

    public int getCurrentPage() {
        return this.currentPage_;
    }

    public String getDateOpened() {
        return this.dateOpened_;
    }

    public String getDeviceType() {
        if (this.deviceType_ == null) {
            return null;
        }
        if (this.deviceType_.equals(DEVICE_TYPE_PRINTER)) {
            return DEVICE_TYPE_PRINTER;
        }
        if (this.deviceType_.equals(DEVICE_TYPE_DISKETTE)) {
            return DEVICE_TYPE_DISKETTE;
        }
        return this.deviceType_;
    }

    public String getFormat() {
        return this.format_;
    }

    public String getFormType() {
        return this.formType_;
    }

    public byte[] getInternalJobIdentifier() {
        return this.internalJobIdentifier_;
    }

    public byte[] getInternalSpooledFileIdentifier() {
        return this.internalSpooledFileIdentifier_;
    }

    public int getIPPJobIdentifier() {
        return this.ippJobIdentifier_;
    }

    public String getJobName() {
        return this.jobName_;
    }

    public String getJobNumber() {
        return this.jobNumber_;
    }

    public String getJobSystemName() {
        return this.jobSystemName_;
    }

    public String getJobUser() {
        return this.jobUser_;
    }

    public String getName() {
        return this.name_;
    }

    public int getNumber() {
        return this.number_;
    }

    public String getOutputQueue() {
        return QSYSObjectPathName.toPath(this.outputQueueLibrary_, this.outputQueueName_, "OUTQ");
    }

    public String getOutputQueueLibrary() {
        return this.outputQueueLibrary_;
    }

    public String getOutputQueueName() {
        return this.outputQueueName_;
    }

    public String getPrinterAssignment() {
        if (this.printerAssignment_ == null) {
            return null;
        }
        if (this.printerAssignment_.equals("1")) {
            return "1";
        }
        if (this.printerAssignment_.equals("2")) {
            return "2";
        }
        if (this.printerAssignment_.equals("3")) {
            return "3";
        }
        return this.printerAssignment_;
    }

    public String getPrinterName() {
        return this.printerName_;
    }

    public String getPriority() {
        return this.priority_;
    }

    public String getSchedule() {
        if (this.schedule_ == null) {
            return null;
        }
        if (this.schedule_.equals("1")) {
            return "1";
        }
        if (this.schedule_.equals("2")) {
            return "2";
        }
        if (this.schedule_.equals("3")) {
            return "3";
        }
        return this.schedule_;
    }

    public long getSize() {
        if (this.sizeMultiplier_ > 0) {
            return (long)this.size_ * (long)this.sizeMultiplier_;
        }
        return this.size_;
    }

    public String getStatus() {
        if (this.status_ == null) {
            return null;
        }
        if (this.status_.equals(STATUS_READY)) {
            return STATUS_READY;
        }
        if (this.status_.equals(STATUS_OPEN)) {
            return STATUS_OPEN;
        }
        if (this.status_.equals(STATUS_CLOSED)) {
            return STATUS_CLOSED;
        }
        if (this.status_.equals(STATUS_SAVED)) {
            return STATUS_SAVED;
        }
        if (this.status_.equals(STATUS_WRITING)) {
            return STATUS_WRITING;
        }
        if (this.status_.equals(STATUS_HELD)) {
            return STATUS_HELD;
        }
        if (this.status_.equals(STATUS_MESSAGE_WAIT)) {
            return STATUS_MESSAGE_WAIT;
        }
        if (this.status_.equals(STATUS_PENDING)) {
            return STATUS_PENDING;
        }
        if (this.status_.equals(STATUS_PRINTING)) {
            return STATUS_PRINTING;
        }
        if (this.status_.equals(STATUS_FINISHED)) {
            return STATUS_FINISHED;
        }
        if (this.status_.equals(STATUS_SENDING)) {
            return STATUS_SENDING;
        }
        if (this.status_.equals(STATUS_DEFERRED)) {
            return STATUS_DEFERRED;
        }
        return this.status_;
    }

    public String getTimeOpened() {
        return this.timeOpened_;
    }

    public int getTotalPages() {
        return this.totalPages_;
    }

    public String getUserData() {
        return this.userData_;
    }

    private static final String mapStatus(int n) {
        switch (n) {
            case 1: {
                return STATUS_READY;
            }
            case 2: {
                return STATUS_OPEN;
            }
            case 3: {
                return STATUS_CLOSED;
            }
            case 4: {
                return STATUS_SAVED;
            }
            case 5: {
                return STATUS_WRITING;
            }
            case 6: {
                return STATUS_HELD;
            }
            case 7: {
                return STATUS_MESSAGE_WAIT;
            }
            case 8: {
                return STATUS_PENDING;
            }
            case 9: {
                return STATUS_PRINTING;
            }
            case 10: {
                return STATUS_FINISHED;
            }
            case 11: {
                return STATUS_SENDING;
            }
            case 12: {
                return STATUS_DEFERRED;
            }
        }
        return "";
    }
}

