/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SystemValueEvent;
import com.ibm.as400.access.SystemValueInfo;
import com.ibm.as400.access.SystemValueList;
import com.ibm.as400.access.SystemValueListener;
import com.ibm.as400.access.SystemValueUtility;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class SystemValue
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_ = null;
    SystemValueInfo info_ = null;
    Object value_ = null;
    private String groupName_ = null;
    private String groupDescription_ = null;
    private String localeDescription_ = null;
    private transient boolean cached_ = false;
    private transient boolean connected_ = false;
    private transient Vector systemValueListeners_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public SystemValue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValue object.");
        }
    }

    public SystemValue(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValue object, system: " + aS400 + ", name: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (string.length() == 0) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 1);
        }
        this.system_ = aS400;
        this.info_ = SystemValueList.lookup(string.toUpperCase());
        this.localeDescription_ = SystemValueList.lookupDescription(this.info_, aS400.getLocale());
    }

    SystemValue(AS400 aS400, SystemValueInfo systemValueInfo, Object object, String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValue object, system: " + aS400 + ", group name: " + string);
        }
        this.system_ = aS400;
        this.info_ = systemValueInfo;
        this.value_ = object;
        this.groupName_ = string;
        this.groupDescription_ = string2;
        this.localeDescription_ = SystemValueList.lookupDescription(this.info_, aS400.getLocale());
        this.cached_ = true;
        this.connected_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemValueListener(SystemValueListener systemValueListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding system value listener.");
        }
        if (systemValueListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValue systemValue = this;
        synchronized (systemValue) {
            if (this.systemValueListeners_ == null) {
                this.systemValueListeners_ = new Vector();
            }
            this.systemValueListeners_.addElement(systemValueListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValue systemValue = this;
        synchronized (systemValue) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValue systemValue = this;
        synchronized (systemValue) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void clear() {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing system value from cache.");
        }
        this.cached_ = false;
    }

    private void connect() throws AS400SecurityException, IOException, RequestNotSupportedException {
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot connect before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.info_.release_ > this.system_.getVRM() && this.info_.release_ != 262656) {
            byte[] byArray = BinaryConverter.intToByteArray(this.info_.release_);
            Trace.log(2, "System not at correct release for system value, name: " + this.info_.name_ + ", release:", byArray);
            throw new RequestNotSupportedException(this.info_.name_, 1);
        }
        this.connected_ = true;
    }

    private void fireChangedEvent(Object object, Object object2) {
        Vector vector = (Vector)this.systemValueListeners_.clone();
        SystemValueEvent systemValueEvent = new SystemValueEvent(this, object, object2);
        for (int i = 0; i < vector.size(); ++i) {
            SystemValueListener systemValueListener = (SystemValueListener)vector.elementAt(i);
            systemValueListener.systemValueChanged(systemValueEvent);
        }
    }

    public String getDescription() {
        String string;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value description.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot get description before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        String string2 = string = this.localeDescription_ == null ? this.info_.description_ : this.localeDescription_;
        if (Trace.traceOn_) {
            Trace.log(1, "Description: " + string);
        }
        return string;
    }

    public int getGroup() {
        int n;
        block6: {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting system value group.");
            }
            if (this.info_ == null) {
                Trace.log(2, "Cannot get group before system value name is set.");
                throw new ExtendedIllegalStateException("name", 4);
            }
            n = this.info_.group_;
            try {
                if (this.system_ != null && this.info_.name_.equals("QFRCCVNRST") && this.system_.getVRM() <= 327936) {
                    n = 7;
                }
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block6;
                Trace.log(4, "Couldn't retrieve VRM for system value:", (Throwable)exception);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Group:", n);
        }
        return n;
    }

    public String getGroupDescription() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group description: " + this.groupDescription_);
        }
        return this.groupDescription_;
    }

    public String getGroupName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group name: " + this.groupName_);
        }
        return this.groupName_;
    }

    public String getName() {
        String string;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value name.");
        }
        String string2 = string = this.info_ == null ? null : this.info_.name_;
        if (Trace.traceOn_) {
            Trace.log(1, "Name: " + string);
        }
        return string;
    }

    public int getRelease() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value release.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot get release before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (Trace.traceOn_) {
            byte[] byArray = BinaryConverter.intToByteArray(this.info_.release_);
            Trace.log(1, "Release:", byArray);
        }
        return this.info_.release_;
    }

    public int getSize() {
        int n;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value size.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot get size before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        int n2 = n = this.info_.type_ == 4 ? this.info_.size_ * this.info_.arraySize_ : this.info_.size_;
        if (Trace.traceOn_) {
            Trace.log(1, "Size:", n);
        }
        return n;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public int getType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value type.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot get type before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Type:", this.info_.type_);
        }
        return this.info_.type_;
    }

    public Object getValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value value.");
        }
        if (!this.connected_) {
            this.connect();
        }
        if (!this.cached_) {
            this.value_ = SystemValueUtility.retrieve(this.system_, this.info_);
            this.cached_ = true;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Value: " + this.value_);
        }
        return this.value_;
    }

    public boolean isReadOnly() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if system value is read only.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot determine read only before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Read only:", this.info_.readOnly_);
        }
        return this.info_.readOnly_;
    }

    public void removeSystemValueListener(SystemValueListener systemValueListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing system value listener.");
        }
        if (systemValueListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.systemValueListeners_ != null) {
            this.systemValueListeners_.removeElement(systemValueListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system value name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'name' after connect.");
            throw new ExtendedIllegalStateException("name", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.info_ = SystemValueList.lookup(string.toUpperCase());
            this.localeDescription_ = this.system_ != null ? SystemValueList.lookupDescription(this.info_, this.system_.getLocale()) : null;
        } else {
            String string2 = this.info_ != null ? this.info_.name_ : null;
            SystemValueInfo systemValueInfo = SystemValueList.lookup(string.toUpperCase());
            String string3 = systemValueInfo.name_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("name", string2, string3);
            }
            this.info_ = systemValueInfo;
            String string4 = this.localeDescription_ = this.system_ != null ? SystemValueList.lookupDescription(this.info_, this.system_.getLocale()) : null;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("name", string2, string3);
            }
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
            this.localeDescription_ = this.info_ != null ? SystemValueList.lookupDescription(this.info_, this.system_.getLocale()) : null;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            String string = this.localeDescription_ = this.info_ != null ? SystemValueList.lookupDescription(this.info_, this.system_.getLocale()) : null;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    public void setValue(Object object) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system value value: " + object);
        }
        if (object == null) {
            Trace.log(2, "Parameter 'value' is null.");
            throw new NullPointerException("value");
        }
        if (!this.connected_) {
            this.connect();
        }
        SystemValueUtility.set(this.system_, this.info_, object);
        this.value_ = object;
        this.cached_ = true;
        if (this.systemValueListeners_ != null) {
            this.fireChangedEvent(this.value_, object);
        }
    }
}

