/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatabase;
import com.dbeaver.db.teradata.model.TeradataDatasource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.teradata.model.TeradataMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class TeradataMetaModelExt
extends TeradataMetaModel {
    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new TeradataDatasource(monitor, container, (GenericMetaModel)this);
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog genericCatalog) throws DBException {
        String statement = "WITH RECURSIVE HIERARCHY(DatabaseName, OwnerName, DBKind, LEVEL) AS (\nSELECT level0.DatabaseName, level0.OwnerName, level0.DBKind, 0 AS level0\nFROM DBC.DatabasesV AS level0\nWHERE level0.DatabaseName = 'DBC'\nUNION ALL\nSELECT down1.DatabaseName, down1.OwnerName, down1.DBKind, here.LEVEL + 1\nFROM hierarchy AS here, DBC.DatabasesV AS down1\nWHERE here.DatabaseName = down1.OwnerName AND down1.DatabaseName NOT = 'DBC')\nSELECT LEVEL, DatabaseName, OwnerName, DBKind FROM HIERARCHY ORDER BY LEVEL, DatabaseName";
        boolean catalogsReadFailed = false;
        ArrayList<GenericSchema> resultList = new ArrayList<GenericSchema>();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(statement);){
                    while (dbResult != null && dbResult.next()) {
                        GenericSchema parentCatalog;
                        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DatabaseName");
                        if (CommonUtils.isEmpty((String)name)) continue;
                        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DBKind");
                        String ownerName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OwnerName");
                        long level = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"LEVEL");
                        boolean isUser = false;
                        if ("U".equalsIgnoreCase(type)) {
                            isUser = true;
                        }
                        TeradataDatabase database = new TeradataDatabase(dataSource, name, isUser);
                        resultList.add(database);
                        if (!"DBC".equalsIgnoreCase(name) && (parentCatalog = (GenericSchema)resultList.stream().filter(catalog -> catalog.getName().equals(ownerName)).findFirst().orElse(null)) instanceof TeradataDatabase) {
                            ((TeradataDatabase)parentCatalog).addChildDatabase(database);
                        }
                        if (level != 0L && level != 1L || !(dataSource instanceof TeradataDatasource)) continue;
                        ((TeradataDatasource)dataSource).addDatabaseToFirstLevel(database);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (dataSource.discoverErrorType((Throwable)e) == DBPErrorAssistant.ErrorType.CONNECTION_LOST) {
                throw new DBException((Throwable)e, (DBPDataSource)dataSource);
            }
            catalogsReadFailed = true;
        }
        if (catalogsReadFailed) {
            return super.loadSchemas(session, dataSource, null);
        }
        return resultList;
    }
}

