/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.teradata.model.TeradataSQLDialect;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceWithOptionalElements;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class TeradataDatasource
extends GenericDataSource
implements DBPDataSourceWithOptionalElements {
    private List<TeradataDatabase> topLevelDatabases = new ArrayList<TeradataDatabase>();

    public TeradataDatasource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new TeradataSQLDialect());
    }

    void addDatabaseToFirstLevel(@NotNull TeradataDatabase database) {
        this.topLevelDatabases.add(database);
    }

    @Association
    public List<? extends GenericSchema> getCatalogsList() {
        if (this.showDatabasesHierarchically() && !CommonUtils.isEmpty(this.topLevelDatabases)) {
            return this.topLevelDatabases;
        }
        List catalogs = this.getSchemas();
        if (!CommonUtils.isEmpty((Collection)catalogs)) {
            catalogs.sort(DBUtils.nameComparatorIgnoreCase());
        }
        return catalogs;
    }

    boolean showDatabasesHierarchically() {
        return CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("show-db-hierarchically@"));
    }

    public boolean hasOptionalFolders() {
        return !this.showDatabasesHierarchically();
    }
}

