/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.TraceInputStream;
import com.sybase.jdbc4.jdbc.TraceOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Capture
implements com.sybase.jdbcx.Capture {
    public static final int OFFLINE = 0;
    public static final int PAUSE = 1;
    public static final int RECORD = 2;
    public static final int TDS_DUMP_VSN_0 = 0;
    public static final int TDS_DUMP_VSN_1 = 1;
    public static final String PROGRAM_NAME = "Capture";
    public static final String CLIENT_NAME = "jConnect Application";
    public static final String SERVER_NAME = "Application Server";
    public static final int NAME_LENGTH = 256;
    public static final int REQUEST = 1;
    public static final int RESPONSE = 2;
    private boolean _resumed = false;
    private DataOutputStream _captureStream;
    private TraceOutputStream _out;
    private TraceInputStream _in;
    private String _programName;

    public Capture(OutputStream outputStream) throws IOException {
        this(outputStream, PROGRAM_NAME);
    }

    public Capture(OutputStream outputStream, String string) throws IOException {
        this._programName = string;
        this._captureStream = new DataOutputStream(outputStream);
        this.writeStreamHeader();
    }

    @Override
    public void resume() {
        if (this._in != null && this._out != null) {
            this._in.setState(2);
            this._out.setState(2);
            this.setResumed(true);
        }
    }

    @Override
    public void pause() {
        if (this._in != null && this._out != null) {
            this._in.setState(1);
            this._out.setState(1);
            this.setResumed(false);
        }
    }

    public InputStream getInputStream(InputStream inputStream) {
        if (this._in == null) {
            this._in = new TraceInputStream(this, inputStream, 2);
        }
        return this._in;
    }

    public OutputStream getOutputStream(OutputStream outputStream) {
        if (this._out == null) {
            this._out = new TraceOutputStream(this, outputStream, 2);
        }
        return this._out;
    }

    public synchronized void writeBuffer(int n, byte[] byArray, int n2, int n3) throws IOException {
        this._captureStream.writeInt(n);
        this._captureStream.writeInt(n3);
        this._captureStream.write(byArray, n2, n3);
        this._captureStream.flush();
    }

    private void writeStreamHeader() throws IOException {
        this._captureStream.writeInt(1);
        this._captureStream.writeInt(885842144);
        this._captureStream.write(this.getNameByteArray(this._programName), 0, 256);
        this._captureStream.writeInt(0);
        this._captureStream.writeInt(0);
        this._captureStream.write(this.getNameByteArray(CLIENT_NAME), 0, 256);
        this._captureStream.write(this.getNameByteArray(SERVER_NAME), 0, 256);
        this._captureStream.flush();
    }

    private byte[] getNameByteArray(String string) {
        byte[] byArray = new byte[256];
        int n = string.length() < 256 ? string.length() : 256;
        System.arraycopy(string.getBytes(), 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public void setResumed(boolean bl) {
        this._resumed = bl;
    }

    @Override
    public boolean isResumed() {
        return this._resumed;
    }
}

