/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.timestream.ui.views;

import com.dbeaver.ui.auth.aws.AuthModelAWSConfigurator;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class AWSTimestreamConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private final Image logoImage = this.createImage("icons/timestream_logo.png");
    private Combo regionCombo;

    public Image getImage() {
        return this.logoImage;
    }

    public void createControl(Composite parent) {
        ModifyListener textListener = e -> {};
        Composite configGroup = new Composite(parent, 0);
        configGroup.setLayout((Layout)new GridLayout(1, false));
        configGroup.setLayoutData((Object)new GridData(1808));
        Group settingsGroup = UIUtils.createControlGroup((Composite)configGroup, (String)"Settings", (int)4, (int)768, (int)0);
        this.regionCombo = UIUtils.createLabelCombo((Composite)settingsGroup, (String)"AWS Region", (int)2052);
        this.regionCombo.setLayoutData((Object)new GridData(32));
        this.regionCombo.addModifyListener(textListener);
        for (String region : AuthModelAWSConfigurator.getPublicRegions()) {
            this.regionCombo.add(region);
        }
        this.regionCombo.setText(Region.US_EAST_1.id());
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.regionCombo.setLayoutData((Object)gd);
        this.createAuthPanel(configGroup, 1);
        this.createDriverPanel(configGroup);
        this.setControl((Control)configGroup);
    }

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.logoImage);
    }

    public boolean isComplete() {
        return super.isComplete() && !this.regionCombo.getText().isEmpty();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (this.regionCombo != null) {
            String region = this.regionCombo.getText().trim();
            dataSource.getConnectionConfiguration().setHostName(region);
        }
    }

    public void loadSettings() {
        super.loadSettings();
        this.regionCombo.setText(CommonUtils.notEmpty((String)this.site.getActiveDataSource().getConnectionConfiguration().getHostName()));
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

